/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;

public class FrameCloser
extends WindowAdapter {
    private Commands currentCommands;
    GUIFactory currentGUI;
    PdfDecoder decode_pdf;
    private Printer currentPrinter;
    GUIThumbnailPanel thumbnails;
    Values commonValues;

    public FrameCloser(Commands commands, GUIFactory gUIFactory, PdfDecoder pdfDecoder, Printer printer, GUIThumbnailPanel gUIThumbnailPanel, Values values) {
        this.currentCommands = commands;
        this.currentGUI = gUIFactory;
        this.decode_pdf = pdfDecoder;
        this.currentPrinter = printer;
        this.thumbnails = gUIThumbnailPanel;
        this.commonValues = values;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.currentCommands.flush();
        if (this.currentPrinter.isPrinting()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerBusyPrinting.message"));
        }
        if (!this.commonValues.isProcessing()) {
            this.thumbnails.terminateDrawing();
            int n = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerCloseing.message"), null, 0);
            if (n == 0) {
                this.currentCommands.handleUnsaveForms();
                this.decode_pdf.closePdfFile();
                System.exit(0);
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }
}

