/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUIMouseHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.Messages;

public class SwingMouseHandler
implements GUIMouseHandler {
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;
    private String message = "";
    private Rectangle[] boxes = new Rectangle[8];
    private int handlesGap = 5;
    private int oldX = -1;
    private int oldY = -1;
    private boolean dragAltering = false;
    private int boxContained = -1;
    private boolean drawingCursorBox = false;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    private int x;
    private int y;
    private int cx;
    private int cy;

    public SwingMouseHandler(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
    }

    public void checkLinks(boolean bl) {
        this.message = "";
        Rectangle[] rectangleArray = this.decode_pdf.getPageHotspots();
        if (rectangleArray != null) {
            int n = rectangleArray.length;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                if (rectangleArray[i] == null || !rectangleArray[i].contains(this.cx, this.cy)) continue;
                n2 = i;
                i = n;
            }
            if (n2 != -1) {
                if (bl) {
                    PdfAnnots pdfAnnots = this.commonValues.getPageAnnotations();
                    Map map = pdfAnnots.getAnnotRawData(n2);
                    Map map2 = this.decode_pdf.resolveToMapOrString("A", map);
                    String string = pdfAnnots.getAnnotSubType(n2);
                    if (string.equals("Link") && map2 != null) {
                        Iterator iterator = map2.keySet().iterator();
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 1));
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            jPanel.add(new JLabel(string2 + " : " + this.decode_pdf.resolveToMapOrString(string2, map)));
                        }
                        JOptionPane.showMessageDialog(this.currentGUI.getFrame(), jPanel, Messages.getMessage("PdfViewerTitle.annots"), -1);
                    } else if (string.equals("Text")) {
                        String string3;
                        String string4 = pdfAnnots.getField(n2, "T");
                        if (string4 == null) {
                            string4 = Messages.getMessage("PdfViewerAnnots.notitle");
                        }
                        if ((string3 = pdfAnnots.getField(n2, "Contents")) == null) {
                            string3 = Messages.getMessage("PdfViewerAnnots.nocont");
                        }
                        JOptionPane.showMessageDialog(this.currentGUI.getFrame(), new TextArea(string3), string4, -1);
                    } else if (string.equals("FileAttachment")) {
                        Map map3 = this.decode_pdf.resolveToMapOrString("FS", map);
                        if (map3 != null) {
                            map3 = (Map)map3.get("EF");
                        }
                        if (map3 != null) {
                            map3 = (Map)map3.get("F");
                        }
                        if (map3 != null) {
                            byte[] byArray = (byte[])map3.get("DecodedStream");
                            String string5 = (String)map3.get("CachedStream");
                            if (byArray == null && string5 == null) {
                                JOptionPane.showMessageDialog(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerAnnots.nofile"));
                            } else {
                                JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
                                jFileChooser.setFileSelectionMode(0);
                                int n3 = jFileChooser.showSaveDialog(this.currentGUI.getFrame());
                                if (n3 == 0) {
                                    File file = jFileChooser.getSelectedFile();
                                    if (byArray != null) {
                                        try {
                                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                                            fileOutputStream.write(byArray);
                                            fileOutputStream.close();
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    } else if (string5 != null) {
                                        ObjectStore.copy(string5, file.toString());
                                    }
                                }
                            }
                        }
                    } else {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 1));
                        Iterator iterator = map.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string6 = (String)iterator.next();
                            jPanel.add(new JLabel(string6 + " : " + this.decode_pdf.resolveToMapOrString(string6, map)));
                        }
                        this.currentGUI.showMessageDialog(jPanel, Messages.getMessage("PdfViewerAnnots.nosubtype") + " " + string, -1);
                    }
                } else {
                    this.message = Messages.getMessage("PdfViewerAnnots.entered") + " " + n2;
                }
            }
        }
    }

    public void setupExtractor() {
        this.decode_pdf.addMouseMotionListener(new Extractor_mouse_mover());
        this.decode_pdf.addMouseListener(new Extractor_mouse_clicker());
    }

    protected void scrollAndUpdateCoords(MouseEvent mouseEvent) {
        int n = this.decode_pdf.getScrollInterval();
        Rectangle rectangle = new Rectangle(this.currentGUI.AdjustForAlignment(mouseEvent.getX()), mouseEvent.getY(), n, n);
        if (this.currentGUI.allowScrolling() && !this.decode_pdf.getVisibleRect().contains(rectangle)) {
            this.decode_pdf.scrollRectToVisible(rectangle);
        }
        this.updateCords(mouseEvent);
    }

    public void updateCords(MouseEvent mouseEvent) {
        int n;
        float f = this.currentGUI.getScaling();
        int n2 = this.currentGUI.getPDFDisplayInset();
        int n3 = this.currentGUI.getRotation();
        int n4 = this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n2;
        int n5 = mouseEvent.getY() - n2;
        if (this.commonValues.maxViewY != 0) {
            n4 = (int)((double)((float)n4 - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            n5 = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)n5 / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        this.cx = (int)((float)n4 / f);
        this.cy = (int)((float)n5 / f);
        if (this.decode_pdf.getDisplayView() != 1) {
            this.cx = 0;
            this.cy = 0;
        } else if (n3 == 90) {
            n = this.cx + this.currentGUI.cropY;
            this.cx = this.cy + this.currentGUI.cropX;
            this.cy = n;
        } else if (n3 == 180) {
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cx;
            this.cy += this.currentGUI.cropY;
        } else if (n3 == 270) {
            n = this.currentGUI.cropH + this.currentGUI.cropY - this.cx;
            this.cx = this.currentGUI.cropW + this.currentGUI.cropX - this.cy;
            this.cy = n;
        } else {
            this.cx += this.currentGUI.cropX;
            this.cy = this.currentGUI.cropH + this.currentGUI.cropY - this.cy;
        }
        if (this.commonValues.isProcessing() | this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else {
            this.currentGUI.setCoordText("  X: " + this.cx + " Y: " + this.cy + " " + " " + this.message);
        }
        if (this.currentGUI.allowScrolling() && !mouseEvent.isShiftDown()) {
            n = this.decode_pdf.getScrollInterval() * 2;
            Rectangle rectangle = new Rectangle(this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n, mouseEvent.getY() - n, n * 2, n * 2);
            if (!this.decode_pdf.getVisibleRect().contains(rectangle)) {
                this.decode_pdf.scrollRectToVisible(rectangle);
            }
        }
    }

    public void updateRectangle() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.currentGUI.getRectangle();
        if (rectangle2 != null && (rectangle = this.decode_pdf.getCombinedAreas(rectangle2, false)) != null) {
            this.commonValues.m_x1 = rectangle.x;
            this.commonValues.m_y2 = rectangle.y;
            this.commonValues.m_x2 = rectangle.x + rectangle.width;
            this.commonValues.m_y1 = rectangle.y + rectangle.height;
            rectangle2 = rectangle;
            this.decode_pdf.updateCursorBoxOnScreen(rectangle2, Color.blue);
            this.decode_pdf.repaint();
        }
    }

    public void setupMouse() {
        this.decode_pdf.addMouseMotionListener(new mouse_mover());
        this.decode_pdf.addMouseListener(new mouse_clicker());
    }

    protected int[] updateXY(MouseEvent mouseEvent) {
        float f = this.currentGUI.getScaling();
        int n = this.currentGUI.getPDFDisplayInset();
        int n2 = this.currentGUI.getRotation();
        this.x = (int)((float)(this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n) / f);
        this.y = (int)((float)(mouseEvent.getY() - n) / f);
        if (this.commonValues.maxViewY != 0) {
            this.x = (int)((double)((float)this.x - (float)this.commonValues.dx * f) / this.commonValues.viewportScale);
            this.y = (int)(((double)this.currentGUI.mediaH - (double)((float)this.currentGUI.mediaH - (float)this.y / f - (float)this.commonValues.dy) / this.commonValues.viewportScale) * (double)f);
        }
        int[] nArray = new int[2];
        if (n2 == 90) {
            nArray[1] = this.x + this.currentGUI.cropY;
            nArray[0] = this.y + this.currentGUI.cropX;
        } else if (n2 == 180) {
            nArray[0] = this.currentGUI.mediaW - (this.x + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
            nArray[1] = this.y + this.currentGUI.cropY;
        } else if (n2 == 270) {
            nArray[1] = this.currentGUI.mediaH - (this.x + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
            nArray[0] = this.currentGUI.mediaW - (this.y + this.currentGUI.mediaW - this.currentGUI.cropW - this.currentGUI.cropX);
        } else {
            nArray[0] = this.x + this.currentGUI.cropX;
            nArray[1] = this.currentGUI.mediaH - (this.y + this.currentGUI.mediaH - this.currentGUI.cropH - this.currentGUI.cropY);
        }
        return nArray;
    }

    static /* synthetic */ Rectangle[] access$1102(SwingMouseHandler swingMouseHandler, Rectangle[] rectangleArray) {
        swingMouseHandler.boxes = rectangleArray;
        return rectangleArray;
    }

    protected class Extractor_mouse_mover
    extends mouse_mover {
        private boolean inRect;
        private boolean handleChange;

        protected Extractor_mouse_mover() {
            this.inRect = false;
            this.handleChange = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Rectangle rectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (rectangle == null || SwingMouseHandler.this.drawingCursorBox) {
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                super.mouseDragged(mouseEvent);
                SwingMouseHandler.this.boxContained = -1;
                return;
            }
            int[] nArray = SwingMouseHandler.this.updateXY(mouseEvent);
            SwingMouseHandler.access$1102(SwingMouseHandler.this, this.createNewRectangles(rectangle));
            if (SwingMouseHandler.this.boxContained == -1) {
                for (n = 0; n < SwingMouseHandler.this.boxes.length; ++n) {
                    if (!SwingMouseHandler.this.boxes[n].contains(SwingMouseHandler.this.oldX, SwingMouseHandler.this.oldY)) continue;
                    SwingMouseHandler.this.boxContained = n;
                    break;
                }
            }
            if (SwingMouseHandler.this.boxContained != -1 || SwingMouseHandler.this.dragAltering) {
                SwingMouseHandler.this.drawingCursorBox = false;
                n = SwingMouseHandler.this.boxContained;
                int n2 = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterX();
                int n3 = (int)SwingMouseHandler.this.boxes[SwingMouseHandler.this.boxContained].getCenterY();
                if (rectangle.x == n2) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = nArray[0];
                } else if (rectangle.x + rectangle.width == n2) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = nArray[0];
                }
                if (rectangle.y == n3) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = nArray[1];
                } else if (rectangle.y + rectangle.height == n3) {
                    ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = nArray[1];
                }
                boolean bl = false;
                boolean bl2 = false;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    bl = true;
                }
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1) {
                    bl2 = true;
                }
                if (bl || bl2) {
                    switch (n) {
                        case 0: {
                            if (!bl) break;
                            n = 3;
                            break;
                        }
                        case 1: {
                            if (!bl2) break;
                            n = 2;
                            break;
                        }
                        case 2: {
                            if (!bl2) break;
                            n = 1;
                            break;
                        }
                        case 3: {
                            if (!bl) break;
                            n = 0;
                            break;
                        }
                        case 4: {
                            if (bl) {
                                n = 6;
                            } else if (bl2) {
                                n = 5;
                            }
                            if (!bl || !bl2) break;
                            n = 7;
                            break;
                        }
                        case 5: {
                            if (bl) {
                                n = 7;
                            } else if (bl2) {
                                n = 4;
                            }
                            if (!bl || !bl2) break;
                            n = 6;
                            break;
                        }
                        case 6: {
                            if (bl) {
                                n = 4;
                            } else if (bl2) {
                                n = 7;
                            }
                            if (!bl || !bl2) break;
                            n = 5;
                            break;
                        }
                        case 7: {
                            if (bl) {
                                n = 5;
                            } else if (bl2) {
                                n = 6;
                            }
                            if (!bl || !bl2) break;
                            n = 4;
                        }
                    }
                }
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, n, Color.red);
                SwingMouseHandler.this.scrollAndUpdateCoords(mouseEvent);
                this.generateNewCursorBox();
                SwingMouseHandler.this.dragAltering = true;
                SwingMouseHandler.this.oldX = nArray[0];
                SwingMouseHandler.this.oldY = nArray[1];
            } else {
                SwingMouseHandler.this.drawingCursorBox = true;
                SwingMouseHandler.this.boxContained = -1;
                SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = SwingMouseHandler.this.oldX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = SwingMouseHandler.this.oldY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = nArray[0];
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = nArray[1];
                SwingMouseHandler.this.scrollAndUpdateCoords(mouseEvent);
                this.generateNewCursorBox();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Rectangle rectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            SwingMouseHandler.access$1102(SwingMouseHandler.this, this.createNewRectangles(rectangle));
            if (SwingMouseHandler.this.boxes != null) {
                int n = SwingMouseHandler.this.boxContained;
                SwingMouseHandler.this.boxContained = -1;
                for (int i = 0; i < SwingMouseHandler.this.boxes.length; ++i) {
                    if (!SwingMouseHandler.this.boxes[i].contains(SwingMouseHandler.this.cx, SwingMouseHandler.this.cy)) continue;
                    SwingMouseHandler.this.boxContained = i;
                    break;
                }
                if (SwingMouseHandler.this.boxContained != n) {
                    this.handleChange = true;
                }
            }
            if (rectangle != null) {
                if (rectangle.x - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cx && rectangle.x + rectangle.width + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cx && rectangle.y - SwingMouseHandler.this.handlesGap < SwingMouseHandler.this.cy && rectangle.y + rectangle.height + SwingMouseHandler.this.handlesGap > SwingMouseHandler.this.cy) {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(true, SwingMouseHandler.this.boxContained, Color.red);
                    if (!this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = true;
                    }
                } else {
                    SwingMouseHandler.this.decode_pdf.setDrawCrossHairs(false, SwingMouseHandler.this.boxContained, Color.red);
                    if (this.inRect || this.handleChange) {
                        SwingMouseHandler.this.decode_pdf.repaint();
                        this.handleChange = false;
                        this.inRect = false;
                    }
                }
            }
        }

        private Rectangle[] createNewRectangles(Rectangle rectangle) {
            if (rectangle != null) {
                int n = rectangle.x;
                int n2 = rectangle.y;
                int n3 = n + rectangle.width;
                int n4 = n2 + rectangle.height;
                Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n - SwingMouseHandler.this.handlesGap, n2 + Math.abs(n4 - n2) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n + Math.abs(n3 - n) / 2 - SwingMouseHandler.this.handlesGap, n2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n + Math.abs(n3 - n) / 2 - SwingMouseHandler.this.handlesGap, n4 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n3 - SwingMouseHandler.this.handlesGap, n2 + Math.abs(n4 - n2) / 2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n - SwingMouseHandler.this.handlesGap, n2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n - SwingMouseHandler.this.handlesGap, n4 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n3 - SwingMouseHandler.this.handlesGap, n2 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2), new Rectangle(n3 - SwingMouseHandler.this.handlesGap, n4 - SwingMouseHandler.this.handlesGap, SwingMouseHandler.this.handlesGap * 2, SwingMouseHandler.this.handlesGap * 2)};
                return rectangleArray;
            }
            return null;
        }
    }

    protected class Extractor_mouse_clicker
    extends mouse_clicker {
        protected Extractor_mouse_clicker() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = SwingMouseHandler.this.currentGUI.getRectangle();
            if (rectangle == null) {
                super.mousePressed(mouseEvent);
                SwingMouseHandler.this.drawingCursorBox = true;
            } else {
                int[] nArray = SwingMouseHandler.this.updateXY(mouseEvent);
                SwingMouseHandler.this.oldX = nArray[0];
                SwingMouseHandler.this.oldY = nArray[1];
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            SwingMouseHandler.this.drawingCursorBox = false;
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCords(mouseEvent);
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = n;
            }
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 < ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = n;
            }
            SwingMouseHandler.this.decode_pdf.repaint();
            SwingMouseHandler.this.dragAltering = false;
        }
    }

    protected class mouse_mover
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            int[] nArray = SwingMouseHandler.this.updateXY(mouseEvent);
            ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 = nArray[0];
            ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 = nArray[1];
            SwingMouseHandler.this.scrollAndUpdateCoords(mouseEvent);
            if (SwingMouseHandler.this.commonValues.isPDF()) {
                this.generateNewCursorBox();
            }
            if (!((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.showAnnotations) {
                SwingMouseHandler.this.checkLinks(false);
            }
        }

        protected void generateNewCursorBox() {
            if (SwingMouseHandler.this.old_m_x2 != -1 | SwingMouseHandler.this.old_m_y2 != -1 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - SwingMouseHandler.this.old_m_x2) > 5 | Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - SwingMouseHandler.this.old_m_y2) > 5) {
                int n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2) {
                    n = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                }
                int n2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1;
                if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 > ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2) {
                    n2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
                }
                int n3 = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1);
                int n4 = Math.abs(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1);
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                SwingMouseHandler.this.currentGUI.setRectangle(rectangle);
                SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(rectangle, Color.blue);
                Rectangle[] rectangleArray = new Rectangle[2];
                rectangleArray[0] = rectangle;
                SwingMouseHandler.this.decode_pdf.setHighlightedAreas(rectangleArray);
                SwingMouseHandler.this.old_m_x2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2;
                SwingMouseHandler.this.old_m_y2 = ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SwingMouseHandler.this.updateCords(mouseEvent);
            if (!((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.showAnnotations) {
                SwingMouseHandler.this.checkLinks(false);
            }
        }
    }

    protected class mouse_clicker
    extends MouseAdapter {
        protected mouse_clicker() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            float f = SwingMouseHandler.this.currentGUI.getScaling();
            int n = SwingMouseHandler.this.currentGUI.getPDFDisplayInset();
            int n2 = SwingMouseHandler.this.currentGUI.getRotation();
            int n3 = (int)((float)(SwingMouseHandler.this.currentGUI.AdjustForAlignment(mouseEvent.getX()) - n) / f);
            int n4 = (int)((float)(mouseEvent.getY() - n) / f);
            if (((SwingMouseHandler)SwingMouseHandler.this).commonValues.maxViewY != 0) {
                n3 = (int)((double)((float)n3 - (float)((SwingMouseHandler)SwingMouseHandler.this).commonValues.dx * f) / ((SwingMouseHandler)SwingMouseHandler.this).commonValues.viewportScale);
                n4 = (int)(((double)((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (double)((float)((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (float)n4 / f - (float)((SwingMouseHandler)SwingMouseHandler.this).commonValues.dy) / ((SwingMouseHandler)SwingMouseHandler.this).commonValues.viewportScale) * (double)f);
            }
            if (n2 == 90) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = n3 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = n4 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX;
            } else if (n2 == 180) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - (n3 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = n4 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY;
            } else if (n2 == 270) {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (n3 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY);
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - (n4 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropW - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX);
            } else {
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 = n3 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX;
                ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 = ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - (n4 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropH - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY);
            }
            SwingMouseHandler.this.updateCords(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!((SwingMouseHandler)SwingMouseHandler.this).decode_pdf.showAnnotations) {
                SwingMouseHandler.this.checkLinks(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SwingMouseHandler.this.old_m_x2 = -1;
            SwingMouseHandler.this.old_m_y2 = -1;
            SwingMouseHandler.this.updateCords(mouseEvent);
            if (SwingMouseHandler.this.commonValues.isPDF() && mouseEvent.isShiftDown()) {
                if (SwingMouseHandler.this.commonValues.isExtractImageOnSelection()) {
                    if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                        SwingMouseHandler.this.currentCommands.extractSelectedScreenAsImage();
                    } else {
                        JOptionPane.showMessageDialog(SwingMouseHandler.this.currentGUI.getFrame(), "Image Extraction is only avalible in single page display mode");
                    }
                } else if (SwingMouseHandler.this.decode_pdf.getDisplayView() == 1) {
                    SwingMouseHandler.this.currentCommands.extractSelectedText();
                } else {
                    JOptionPane.showMessageDialog(SwingMouseHandler.this.currentGUI.getFrame(), "Text Extraction is only avalible in single page display mode");
                }
            }
            SwingMouseHandler.this.decode_pdf.updateCursorBoxOnScreen(null, null);
            SwingMouseHandler.this.decode_pdf.setHighlightedAreas(null);
            SwingMouseHandler.this.decode_pdf.repaintArea(new Rectangle(((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 - ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x2 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_x1 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropX, ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y1 - ((SwingMouseHandler)SwingMouseHandler.this).commonValues.m_y2 + ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.cropY), ((SwingMouseHandler)SwingMouseHandler.this).currentGUI.mediaH);
            SwingMouseHandler.this.decode_pdf.repaint();
        }
    }
}

