/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;

public class Type1C
extends Type1 {
    final boolean debugFont = false;
    final boolean debugDictionary = false;
    int ROS = -1;
    int CIDFontVersion = 0;
    int CIDFontRevision = 0;
    int CIDFontType = 0;
    int CIDcount = 0;
    int UIDBase = -1;
    int FDArray = -1;
    int FDSelect = -1;
    final String[] OneByteCCFDict = new String[]{"version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "Escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "shortint", "longint", "BCD", "-reserved-"};
    final String[] TwoByteCCFDict = new String[]{"Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", "-reserved-", "-reserved-", "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "-reserved-", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"};
    private int top = 0;
    private int charset = 0;
    private int enc = 0;
    private int charstrings = 0;
    private int stringIdx;
    private int stringStart;
    private int stringOffSize;
    private int privateDict = -1;
    private int privateDictOffset = -1;
    private static final int[] ExpertSubCharset = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    private static final String[] type1CStdStrings = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    private static final int[] ISOAdobeCharset = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final int[] ExpertCharset = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};

    public Type1C() {
    }

    public Type1C(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new T1Glyphs(false);
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    protected void readEmbeddedFont(Map map, Map map2) throws Exception {
        block13: {
            if (this.substituteFont != null) {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.loader.getResourceAsStream(this.substituteFont));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[65535];
                while ((n = bufferedInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                bufferedInputStream.close();
                try {
                    if (this.substituteFont.indexOf("/t1/") != -1) {
                        this.readType1FontFile(byteArrayOutputStream.toByteArray());
                        break block13;
                    }
                    this.readType1CFontFile(byteArrayOutputStream.toByteArray());
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF]Substitute font=" + this.substituteFont + "Type 1 exception=" + exception);
                }
            } else {
                String string = (String)map2.get("FontFile");
                if (string != null) {
                    try {
                        this.readType1FontFile(this.currentPdfFile.readStream(string, true));
                    }
                    catch (Exception exception) {
                        System.out.println("Type 1 exception=" + exception);
                    }
                } else {
                    Object v = map2.get("FontFile3");
                    try {
                        byte[] byArray;
                        if (v != null && (byArray = v instanceof String ? this.currentPdfFile.readStream((String)v, true) : (byte[])((Map)v).get("DecodedStream")) != null) {
                            this.readType1CFontFile(byArray);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Map createFont(Map map, String string, boolean bl, Map map2, ObjectStore objectStore) throws Exception {
        LogWriter.writeMethod("{readType1Font}" + map, 0);
        this.fontTypes = 1;
        Map map3 = super.createFont(map, string, bl, map2, objectStore);
        if (map3 != null) {
            this.readEmbeddedFont(map, map3);
        }
        this.readWidths(map);
        if (this.embeddedFontName != null && this.is1C() && (this.cleanupFonts || PdfStreamDecoder.runningStoryPad)) {
            this.embeddedFontName = this.cleanupFontName(this.embeddedFontName);
            this.setBaseFontName(this.embeddedFontName);
            this.setFontName(this.embeddedFontName);
        }
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
        return map3;
    }

    public final void readType1CFontFile(byte[] byArray) throws Exception {
        LogWriter.writeMethod("{readType1CFontFile}", 0);
        LogWriter.writeLog("Embedded Type1C font used");
        this.glyphs.setis1C(true);
        int n = 2;
        byte by = byArray[0];
        byte by2 = byArray[1];
        if (by != 1 | by2 != 0) {
            LogWriter.writeLog("1C  format " + by + ":" + by2 + " not fully supported");
        }
        this.top = byArray[2];
        int n2 = this.getWord(byArray, this.top, n);
        byte by3 = byArray[this.top + n];
        this.top += n + 1;
        int n3 = this.top + (n2 + 1) * by3 - 1;
        this.top = n3 + this.getWord(byArray, this.top + n2 * by3, by3);
        n2 = this.getWord(byArray, this.top, n);
        by3 = byArray[this.top + n];
        this.top += n + 1;
        n3 = this.top + (n2 + 1) * by3 - 1;
        int n4 = n3 + this.getWord(byArray, this.top, by3);
        int n5 = n3 + this.getWord(byArray, this.top + by3, by3);
        String[] stringArray = this.readStringIndex(byArray, n3, by3, n2);
        this.readGlobalSubRoutines(byArray);
        this.decodeDictionary(byArray, n4, n5, stringArray);
        if (this.FDSelect != -1) {
            try {
                int n6 = this.FDArray;
                n2 = this.getWord(byArray, n6, n);
                by3 = byArray[n6 + n];
                n3 = (n6 += n + 1) + (n2 + 1) * by3 - 1;
                n4 = n3 + this.getWord(byArray, n6, by3);
                n5 = n3 + this.getWord(byArray, n6 + by3, by3);
                this.decodeDictionary(byArray, n4, n5, stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        this.top = this.charstrings;
        int n7 = this.getWord(byArray, this.top, n);
        int[] nArray = this.readCharset(this.charset, n7, this.charstrings, byArray);
        this.setEncoding(byArray, n7, nArray);
        this.top = this.charstrings;
        this.readGlyphs(byArray, n7, nArray);
        if (this.privateDict != -1) {
            try {
                int n8;
                this.top = this.privateDict + this.privateDictOffset;
                if (this.top + 2 < byArray.length && (n8 = this.getWord(byArray, this.top, n)) > 0) {
                    this.readSubrs(byArray, n8);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.isFontEmbedded = true;
    }

    private final void setEncoding(byte[] byArray, int n, int[] nArray) {
        LogWriter.writeMethod("{setEncoding}", 0);
        if (this.enc == 0) {
            this.embeddedEnc = 1;
            if (this.fontEnc == -1) {
                this.putFontEncoding(1);
            }
        } else if (this.enc == 1) {
            this.embeddedEnc = 3;
            if (this.fontEnc == -1) {
                this.putFontEncoding(3);
            }
        } else {
            int n2;
            String string;
            int n3;
            int n4;
            int n5;
            int n6;
            this.top = this.enc;
            if (((n6 = byArray[this.top++] & 0xFF) & 0x7F) == 0) {
                if ((n5 = 1 + (byArray[this.top++] & 0xFF)) > n) {
                    n5 = n;
                }
                for (n4 = 1; n4 < n5; ++n4) {
                    n3 = byArray[this.top++] & 0xFF;
                    string = this.getString(byArray, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putChar(n3, string);
                }
            } else if ((n6 & 0x7F) == 1) {
                n5 = byArray[this.top++] & 0xFF;
                n4 = 1;
                for (n2 = 0; n2 < n5; ++n2) {
                    n3 = byArray[this.top++] & 0xFF;
                    int n7 = byArray[this.top++] & 0xFF;
                    for (int i = 0; i <= n7 && n4 < n; ++i) {
                        string = this.getString(byArray, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                        this.putChar(n3, string);
                        ++n4;
                        ++n3;
                    }
                }
            }
            if ((n6 & 0x80) != 0) {
                n5 = byArray[this.top++] & 0xFF;
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = byArray[this.top++] & 0xFF;
                    n2 = this.getWord(byArray, this.top, 2);
                    this.top += 2;
                    string = this.getString(byArray, n2, this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putChar(n3, string);
                }
            }
        }
    }

    private final void readSubrs(byte[] byArray, int n) throws Exception {
        int n2;
        byte by = byArray[this.top + 2];
        this.top += 3;
        int n3 = this.top;
        int n4 = this.top + (n + 1) * by - 1;
        this.top = n4 + this.getWord(byArray, this.top + n * by, by);
        int[] nArray = new int[n + 2];
        int n5 = n3;
        for (n2 = 0; n2 < n + 1; ++n2) {
            nArray[n2] = n4 + this.getWord(byArray, n5, by);
            n5 += by;
        }
        nArray[n + 1] = this.top;
        this.glyphs.setLocalBias(this.calculateSubroutineBias(n));
        n2 = nArray[0];
        for (int i = 1; i < n + 1; ++i) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int j = n2; j < nArray[i]; ++j) {
                byteArrayOutputStream.write(byArray[j]);
            }
            byteArrayOutputStream.close();
            this.glyphs.setCharString("subrs" + (i - 1), byteArrayOutputStream.toByteArray());
            n2 = nArray[i];
        }
    }

    private final void readGlyphs(byte[] byArray, int n, int[] nArray) throws Exception {
        LogWriter.writeMethod("{readGlyphs}" + n, 0);
        try {
            int n2;
            byte by = byArray[this.top + 2];
            this.top += 3;
            int n3 = this.top;
            int n4 = this.top + (n + 1) * by - 1;
            this.top = n4 + this.getWord(byArray, this.top + n * by, by);
            int[] nArray2 = new int[n + 2];
            int n5 = n3;
            for (n2 = 0; n2 < n + 1; ++n2) {
                nArray2[n2] = n4 + this.getWord(byArray, n5, by);
                n5 += by;
            }
            nArray2[n + 1] = this.top;
            n2 = nArray2[0];
            for (int i = 1; i < n + 1; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int j = n2; j < nArray2[i]; ++j) {
                    byteArrayOutputStream.write(byArray[j]);
                }
                byteArrayOutputStream.close();
                if (this.isCID) {
                    this.glyphs.setCharString("" + nArray[i - 1], byteArrayOutputStream.toByteArray());
                } else {
                    String string = this.getString(byArray, nArray[i - 1], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.glyphs.setCharString(string, byteArrayOutputStream.toByteArray());
                }
                n2 = nArray2[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final int calculateSubroutineBias(int n) {
        int n2 = n < 1240 ? 107 : (n < 33900 ? 1131 : 32768);
        return n2;
    }

    private final void readGlobalSubRoutines(byte[] byArray) throws Exception {
        LogWriter.writeMethod("{readGlobalSubRoutines}", 0);
        int n = byArray[this.top + 2] & 0xFF;
        int n2 = this.getWord(byArray, this.top, 2);
        this.top += 3;
        if (n2 > 0) {
            int n3;
            int n4 = this.top;
            int n5 = this.top + (n2 + 1) * n - 1;
            this.top = n5 + this.getWord(byArray, this.top + n2 * n, n);
            int[] nArray = new int[n2 + 2];
            int n6 = n4;
            for (n3 = 0; n3 < n2 + 1; ++n3) {
                nArray[n3] = n5 + this.getWord(byArray, n6, n);
                n6 += n;
            }
            nArray[n2 + 1] = this.top;
            this.glyphs.setGlobalBias(this.calculateSubroutineBias(n2));
            n3 = nArray[0];
            for (int i = 1; i < n2 + 1; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int j = n3; j < nArray[i]; ++j) {
                    byteArrayOutputStream.write(byArray[j]);
                }
                byteArrayOutputStream.close();
                this.glyphs.setCharString("global" + (i - 1), byteArrayOutputStream.toByteArray());
                n3 = nArray[i];
            }
        }
    }

    private void decodeDictionary(byte[] byArray, int n, int n2, String[] stringArray) {
        boolean bl = false;
        LogWriter.writeMethod("{decodeDictionary}", 0);
        int n3 = n;
        int n4 = 0;
        double[] dArray = new double[48];
        while (n3 < n2) {
            int n5 = byArray[n3] & 0xFF;
            if (n5 <= 27 || n5 == 31) {
                int n6;
                int n7 = n5;
                ++n3;
                if (n7 == 12) {
                    n7 = byArray[n3] & 0xFF;
                    ++n3;
                    if (n7 == 36 || n7 == 37 || this.FDSelect == -1) {
                        if (n7 == 2) {
                            this.italicAngle = (int)dArray[0];
                        } else if (n7 == 7) {
                            System.arraycopy(dArray, 0, this.FontMatrix, 0, 6);
                        } else if (n7 == 30) {
                            this.ROS = (int)dArray[0];
                            this.isCID = true;
                        } else if (n7 == 31) {
                            this.CIDFontVersion = (int)dArray[0];
                        } else if (n7 == 32) {
                            this.CIDFontRevision = (int)dArray[0];
                        } else if (n7 == 33) {
                            this.CIDFontType = (int)dArray[0];
                        } else if (n7 == 34) {
                            this.CIDcount = (int)dArray[0];
                        } else if (n7 == 35) {
                            this.UIDBase = (int)dArray[0];
                        } else if (n7 == 36) {
                            this.FDArray = (int)dArray[0];
                        } else if (n7 == 37) {
                            this.FDSelect = (int)dArray[0];
                            bl = true;
                        } else if (n7 == 0) {
                            n6 = (int)dArray[0];
                            if (n6 > 390) {
                                n6 -= 390;
                            }
                            this.copyright = stringArray[n6];
                        } else if (n7 == 21) {
                            n6 = (int)dArray[0];
                            if (n6 > 390) {
                                n6 -= 390;
                            }
                        } else if (n7 == 22) {
                            n6 = (int)dArray[0];
                            if (n6 > 390) {
                                n6 -= 390;
                            }
                        } else if (n7 == 38 && (n6 = (int)dArray[0]) > 390) {
                            n6 -= 390;
                        }
                    }
                } else if (n7 == 2) {
                    n6 = (int)dArray[0];
                    if (n6 > 390) {
                        n6 -= 390;
                    }
                    this.embeddedFontName = stringArray[n6];
                } else if (n7 == 3) {
                    n6 = (int)dArray[0];
                    if (n6 > 390) {
                        n6 -= 390;
                    }
                } else if (n7 != 5) {
                    if (n7 == 15) {
                        this.charset = (int)dArray[0];
                    } else if (n7 == 16) {
                        this.enc = (int)dArray[0];
                    } else if (n7 == 17) {
                        this.charstrings = (int)dArray[0];
                    } else if (n7 == 18 && this.glyphs.is1C()) {
                        this.privateDict = (int)dArray[1];
                        this.privateDictOffset = (int)dArray[0];
                    }
                }
                n4 = 0;
                continue;
            }
            n3 = this.glyphs.getNumber(byArray, n3, dArray, n4, false);
            ++n4;
        }
        if (!bl) {
            this.FDSelect = -1;
        }
    }

    private String[] readStringIndex(byte[] byArray, int n, int n2, int n3) {
        int n4;
        LogWriter.writeMethod("{readStringIndex}", 0);
        this.top = n + this.getWord(byArray, this.top + n3 * n2, n2);
        int n5 = this.getWord(byArray, this.top, 2);
        this.stringOffSize = byArray[this.top + 2];
        this.top += 3;
        this.stringIdx = this.top;
        this.stringStart = this.top + (n5 + 1) * this.stringOffSize - 1;
        this.top = this.stringStart + this.getWord(byArray, this.top + n5 * this.stringOffSize, this.stringOffSize);
        int[] nArray = new int[n5 + 2];
        String[] stringArray = new String[n5 + 2];
        int n6 = this.stringIdx;
        for (n4 = 0; n4 < n5 + 1; ++n4) {
            nArray[n4] = this.getWord(byArray, n6, this.stringOffSize);
            n6 += this.stringOffSize;
        }
        nArray[n5 + 1] = this.top - this.stringStart;
        n4 = 0;
        for (int i = 0; i < n5 + 1; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = n4; j < nArray[i]; ++j) {
                stringBuffer.append((char)byArray[this.stringStart + j]);
            }
            stringArray[i] = stringBuffer.toString();
            n4 = nArray[i];
        }
        return stringArray;
    }

    private final String getString(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = null;
        if (n < 391) {
            string = type1CStdStrings[n];
        } else {
            int n5 = n3 + this.getWord(byArray, n2 + (n -= 391) * n4, n4);
            int n6 = n3 + this.getWord(byArray, n2 + (n + 1) * n4, n4);
            int n7 = n6 - n5;
            if (n7 > 255) {
                n7 = 255;
            }
            string = new String(byArray, n5, n7);
        }
        return string;
    }

    private final int[] readCharset(int n, int n2, int n3, byte[] byArray) {
        int[] nArray;
        block6: {
            int n4;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                LogWriter.writeMethod("{get1CCharset}+" + n + " glyphs=" + n2, 0);
                                nArray = null;
                                if (n != 0) break block5;
                                nArray = ISOAdobeCharset;
                                break block6;
                            }
                            if (n != 1) break block7;
                            nArray = ExpertCharset;
                            break block6;
                        }
                        if (n != 2) break block8;
                        nArray = ExpertSubCharset;
                        break block6;
                    }
                    nArray = new int[n2];
                    nArray[0] = 0;
                    n3 = n;
                    if ((n4 = byArray[n3++] & 0xFF) != 0) break block9;
                    for (int i = 1; i < n2; ++i) {
                        nArray[i] = this.getWord(byArray, n3, 2);
                        n3 += 2;
                    }
                    break block6;
                }
                if (n4 != 1) break block10;
                int n5 = 1;
                while (n5 < n2) {
                    int n6 = this.getWord(byArray, n3, 2);
                    n3 += 2;
                    int n7 = byArray[n3++] & 0xFF;
                    for (int i = 0; i <= n7; ++i) {
                        nArray[n5++] = n6++;
                    }
                }
                break block6;
            }
            if (n4 != 2) break block6;
            int n8 = 1;
            while (n8 < n2) {
                int n9 = this.getWord(byArray, n3, 2);
                int n10 = this.getWord(byArray, n3 += 2, 2);
                n3 += 2;
                for (int i = 0; i <= n10; ++i) {
                    nArray[n8++] = n9++;
                }
            }
        }
        return nArray;
    }

    private final int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }
}

