/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.jclipboardhelper;

import com.github.fracpete.jclipboardhelper.TransferableImage;
import com.github.fracpete.jclipboardhelper.TransferableString;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;

public class ClipboardHelper {
    public static void copyToClipboard(Transferable t) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(t, null);
    }

    public static void copyToClipboard(String s) {
        ClipboardHelper.copyToClipboard(new TransferableString(s));
    }

    public static void copyToClipboard(BufferedImage img) {
        ClipboardHelper.copyToClipboard(new TransferableImage(img));
    }

    public static void copyToClipboard(JComponent comp) {
        BufferedImage img = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
        Graphics g = img.getGraphics();
        g.setPaintMode();
        g.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        comp.printAll(g);
        ClipboardHelper.copyToClipboard(img);
    }

    public static void copyToClipboard(JTable table) {
        Action copy = table.getActionMap().get("copy");
        ActionEvent event = new ActionEvent(table, 1001, "");
        copy.actionPerformed(event);
    }

    public static boolean canPasteFromClipboard(DataFlavor flavor) {
        boolean result;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            result = clipboard.isDataFlavorAvailable(flavor);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean canPasteStringFromClipboard() {
        return ClipboardHelper.canPasteFromClipboard(DataFlavor.stringFlavor);
    }

    public static boolean canPasteImageFromClipboard() {
        return ClipboardHelper.canPasteFromClipboard(DataFlavor.imageFlavor);
    }

    public static Object pasteFromClipboard(DataFlavor flavor) {
        Object result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content != null && content.isDataFlavorSupported(flavor)) {
                result = content.getTransferData(flavor);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String pasteStringFromClipboard() {
        String result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content != null && content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                result = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static BufferedImage pasteImageFromClipboard() {
        BufferedImage result = null;
        Image img = (Image)ClipboardHelper.pasteFromClipboard(DataFlavor.imageFlavor);
        if (img != null) {
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            result = new BufferedImage(width, height, 1);
            Graphics2D g = result.createGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
        }
        return result;
    }
}

