/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodAdapter;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.transformer.TransformerTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassLiteralVisitor
extends ClassAdapter {
    private static final Map<Integer, Integer> primitiveTypes = ClassLiteralVisitor.getPrimitiveTypes();
    private Set<String> currentFieldNames = new HashSet<String>();
    private Set<String> syntheticFieldNames = new HashSet<String>();
    private String currentClassName;
    private boolean isInterface;
    static /* synthetic */ Class class$java$lang$Class;

    public ClassLiteralVisitor(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentClassName = name;
        this.isInterface = (access & 0x200) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitEnd() {
        for (String fieldName : this.syntheticFieldNames) {
            if (this.currentFieldNames.contains(fieldName)) continue;
            Class<?> clazz = class$java$lang$Class;
            if (clazz == null) {
                clazz = new Class[0].getClass().getComponentType();
            }
            this.cv.visitField(4104, fieldName, Type.getDescriptor(clazz), null, null).visitEnd();
        }
        super.visitEnd();
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.currentFieldNames.add(name);
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return visitor == null ? null : new MethodAdapter(visitor){
            static /* synthetic */ Class class$java$lang$Class;
            static /* synthetic */ Class class$java$lang$Object;

            public void visitLdcInsn(Object cst) {
                if (cst instanceof Type) {
                    this.visitClassLiteral((Type)cst);
                } else {
                    super.visitLdcInsn(cst);
                }
            }

            private void visitClassLiteral(Type type) {
                if (ClassLiteralVisitor.this.isInterface) {
                    this.loadClassLiteral(type);
                    return;
                }
                String fieldName = ClassLiteralVisitor.getFieldName(type);
                ClassLiteralVisitor.this.syntheticFieldNames.add(fieldName);
                String string = ClassLiteralVisitor.this.currentClassName;
                Class<?> clazz = class$java$lang$Class;
                if (clazz == null) {
                    clazz = class$java$lang$Class = new Class[0].getClass().getComponentType();
                }
                this.mv.visitFieldInsn(178, string, fieldName, Type.getDescriptor(clazz));
                this.mv.visitInsn(89);
                Label label = new Label();
                this.visitJumpInsn(199, label);
                this.mv.visitInsn(87);
                this.loadClassLiteral(type);
                this.mv.visitInsn(89);
                String string2 = ClassLiteralVisitor.this.currentClassName;
                Class<?> clazz2 = class$java$lang$Class;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Class = new Class[0].getClass().getComponentType();
                }
                this.visitFieldInsn(179, string2, fieldName, Type.getDescriptor(clazz2));
                this.visitLabel(label);
            }

            private void loadClassLiteral(Type type) {
                this.mv.visitInsn(3);
                this.visitNewArray(type);
                Class<?> clazz = class$java$lang$Object;
                if (clazz == null) {
                    clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
                }
                String string = Type.getInternalName(clazz);
                Class<?> clazz2 = class$java$lang$Class;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Class = new Class[0].getClass().getComponentType();
                }
                this.mv.visitMethodInsn(182, string, "getClass", TransformerTools.descriptor(clazz2, new Class[0]));
                if (type.getSort() != 9) {
                    Class<?> clazz3 = class$java$lang$Class;
                    if (clazz3 == null) {
                        clazz3 = class$java$lang$Class = new Class[0].getClass().getComponentType();
                    }
                    String string2 = Type.getInternalName(clazz3);
                    Class<?> clazz4 = class$java$lang$Class;
                    if (clazz4 == null) {
                        clazz4 = class$java$lang$Class = new Class[0].getClass().getComponentType();
                    }
                    this.mv.visitMethodInsn(182, string2, "getComponentType", TransformerTools.descriptor(clazz4, new Class[0]));
                }
            }

            private void visitNewArray(Type type) {
                if (type.getSort() != 9) {
                    this.mv.visitTypeInsn(189, type.getInternalName());
                } else if (type.getDimensions() != 1) {
                    this.mv.visitTypeInsn(189, type.toString().substring(1));
                } else {
                    Type elementType = type.getElementType();
                    if (elementType.getSort() == 10) {
                        this.mv.visitTypeInsn(189, elementType.getInternalName());
                    } else {
                        this.mv.visitIntInsn(188, (Integer)primitiveTypes.get(_Integer.valueOf(elementType.getSort())));
                    }
                }
            }
        };
    }

    private static String getFieldName(Type type) {
        String var = type.getDescriptor();
        if (var.startsWith("L")) {
            var = new StringBuffer().append("class$").append(var.substring(1)).toString();
        } else if (var.startsWith("[")) {
            var = new StringBuffer().append("array$").append(var.substring(1)).toString();
        }
        if (var.endsWith(";")) {
            var = var.substring(0, var.length() - 1);
        }
        return var.replace('[', '$').replace('/', '$');
    }

    private static Map<Integer, Integer> getPrimitiveTypes() {
        HashMap<Integer, Integer> types = new HashMap<Integer, Integer>();
        types.put(_Integer.valueOf(1), _Integer.valueOf(4));
        types.put(_Integer.valueOf(2), _Integer.valueOf(5));
        types.put(_Integer.valueOf(6), _Integer.valueOf(6));
        types.put(_Integer.valueOf(8), _Integer.valueOf(7));
        types.put(_Integer.valueOf(3), _Integer.valueOf(8));
        types.put(_Integer.valueOf(4), _Integer.valueOf(9));
        types.put(_Integer.valueOf(5), _Integer.valueOf(10));
        types.put(_Integer.valueOf(7), _Integer.valueOf(11));
        return types;
    }
}

