/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.impl.AnnotatedElementDescriptor;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.MethodDescriptor;
import net.sf.retrotranslator.runtime.java.lang.TypeNotPresentException_;
import net.sf.retrotranslator.transformer.Backport;
import net.sf.retrotranslator.transformer.ClassBackport;
import net.sf.retrotranslator.transformer.ClassReplacement;
import net.sf.retrotranslator.transformer.ConstructorReplacement;
import net.sf.retrotranslator.transformer.MemberBackport;
import net.sf.retrotranslator.transformer.MemberKey;
import net.sf.retrotranslator.transformer.MemberReplacement;
import net.sf.retrotranslator.transformer.NameTranslator;
import net.sf.retrotranslator.transformer.OperationMode;
import net.sf.retrotranslator.transformer.PackageBackport;
import net.sf.retrotranslator.transformer.SmartReplacementVisitor;
import net.sf.retrotranslator.transformer.TargetEnvironment;
import net.sf.retrotranslator.transformer.TransformerTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplacementLocator {
    private static final ClassReplacement NULL = new ClassReplacement();
    private final OperationMode mode;
    private final List<Backport> backports;
    private final TargetEnvironment environment;
    private final Map<String, ClassReplacement> replacements = new Hashtable<String, ClassReplacement>();
    private final Set<String> unsupportedBackports = new HashSet<String>();
    static /* synthetic */ Class class$net$sf$retrotranslator$transformer$ReplacementLocator;
    static /* synthetic */ Class class$java$lang$Object;

    public ReplacementLocator(OperationMode mode, List<Backport> backports, TargetEnvironment environment) {
        this.mode = mode;
        this.backports = backports;
        this.environment = environment;
        for (String entry : environment.readRegistry("advanced", mode.getTarget())) {
            String[] pair = entry.split(":");
            if (pair.length != 2) {
                throw new IllegalArgumentException(entry);
            }
            if (!this.isTotallyUnsupported(pair[1].split(","))) continue;
            this.unsupportedBackports.add(pair[0]);
        }
    }

    public TargetEnvironment getEnvironment() {
        return this.environment;
    }

    private boolean isTotallyUnsupported(String[] features) {
        for (String feature : features) {
            if (!this.mode.isSupportedFeature(feature)) continue;
            return false;
        }
        return true;
    }

    public ClassReplacement getReplacement(String className) {
        if (className == null || className.length() == 0 || className.charAt(0) == '[') {
            return null;
        }
        ClassReplacement replacement = this.replacements.get(className);
        if (replacement != null) {
            return replacement == NULL ? null : replacement;
        }
        replacement = this.buildReplacement(className);
        this.replacements.put(className, replacement);
        if (this.mode.isSmart()) {
            this.addInheritedMembers(replacement);
        }
        if (replacement.isEmpty(className)) {
            this.replacements.put(className, NULL);
            return null;
        }
        return replacement;
    }

    private void addInheritedMembers(ClassReplacement replacement) {
        ClassReader classReader = this.environment.findClassReader(replacement.getUniqueTypeName());
        if (classReader != null) {
            SmartReplacementVisitor visitor = new SmartReplacementVisitor(this);
            classReader.accept(visitor, true);
            visitor.addInheritedMembers(replacement);
        }
    }

    private ClassReplacement buildReplacement(String originalName) {
        ClassReplacement replacement = new ClassReplacement();
        for (Backport backport : this.backports) {
            if (backport instanceof ClassBackport) {
                this.buildForClass(originalName, replacement, (ClassBackport)backport);
                continue;
            }
            if (backport instanceof MemberBackport) {
                this.buildForMember(originalName, replacement, (MemberBackport)backport);
                continue;
            }
            if (backport instanceof PackageBackport) {
                this.buildForPackage(originalName, replacement, (PackageBackport)backport);
                continue;
            }
            throw new IllegalStateException();
        }
        this.completeReplacement(replacement, originalName);
        return replacement;
    }

    private void buildForClass(String originalName, ClassReplacement replacement, ClassBackport backport) {
        if (replacement.getUniqueTypeName() == null && originalName.equals(backport.getOriginalName())) {
            replacement.setUniqueTypeName(backport.getReplacementName());
        }
    }

    private void buildForMember(String originalName, ClassReplacement replacement, final MemberBackport backport) {
        if (!originalName.equals(backport.getOriginalClassName())) {
            return;
        }
        ClassDescriptor classDescriptor = this.getClassDescriptor(backport.getReplacementClassName());
        if (classDescriptor == null) {
            return;
        }
        this.loadAllMembers(replacement, classDescriptor, new KeyProvider(){

            public MemberKey getKey(String name, String desc) {
                if (name.equals(backport.getReplacementMemberName())) {
                    return new MemberKey(true, backport.getOriginalMemberName(), desc);
                }
                return null;
            }
        });
    }

    private void buildForPackage(String originalName, ClassReplacement replacement, PackageBackport backport) {
        String originalPrefix = backport.getOriginalPrefix();
        String suffix = originalName;
        if (originalPrefix.length() > 0) {
            if (originalName.startsWith(originalPrefix)) {
                suffix = originalName.substring(originalPrefix.length());
            } else {
                return;
            }
        }
        String prefix = backport.getReplacementPrefix();
        if (replacement.getUniqueTypeName() == null) {
            replacement.setUniqueTypeName(this.findUniqueName(prefix, suffix));
        }
        int index = suffix.lastIndexOf(47);
        String memberBackportName = new StringBuffer().append(prefix).append(suffix.substring(0, index + 1)).append('_').append(suffix.substring(index + 1).replace('$', '_')).toString();
        ClassDescriptor classDescriptor = this.getClassDescriptor(memberBackportName);
        if (classDescriptor != null) {
            this.loadAllMembers(replacement, classDescriptor, new KeyProvider(){

                public MemberKey getKey(String name, String desc) {
                    return new MemberKey(true, name, desc);
                }
            });
        }
    }

    private String findUniqueName(String prefix, String suffix) {
        String uniqueName = new StringBuffer().append(prefix).append(suffix).append("_").toString();
        if (this.isClassAvailable(uniqueName)) {
            return uniqueName;
        }
        int index = suffix.indexOf(36);
        if (index >= 0) {
            uniqueName = new StringBuffer().append(prefix).append(ReplacementLocator.replaceChar(suffix, index, "_$")).toString();
            if (this.isClassAvailable(uniqueName)) {
                return uniqueName;
            }
            uniqueName = new StringBuffer().append(prefix).append(ReplacementLocator.replaceChar(suffix, index, "_")).append("_").toString();
            if (this.isClassAvailable(uniqueName)) {
                return uniqueName;
            }
        }
        if (this.isClassAvailable(uniqueName = new StringBuffer().append(prefix).append(suffix).toString())) {
            return uniqueName;
        }
        return null;
    }

    private static String replaceChar(String s, int index, String replacement) {
        return new StringBuffer().append(s.substring(0, index)).append(replacement).append(s.substring(index + 1)).toString();
    }

    private void loadAllMembers(ClassReplacement replacement, ClassDescriptor descriptor, KeyProvider keyProvider) {
        String owner = descriptor.getName();
        this.loadMembers(owner, descriptor.getFieldDescriptors(), keyProvider, replacement.getFieldReplacements());
        this.loadMembers(owner, descriptor.getMethodDescriptors(), keyProvider, replacement.getMethodReplacements());
    }

    private <T extends AnnotatedElementDescriptor> void loadMembers(String owner, Collection<T> members, KeyProvider keyProvider, Map<MemberKey, MemberReplacement> replacements) {
        for (AnnotatedElementDescriptor member : members) {
            MemberKey key;
            if (!member.isAccess(1) || !member.isAccess(8) || !this.isSupportedBackport(member) || (key = keyProvider.getKey(member.getName(), member.getDesc())) == null || replacements.containsKey(key)) continue;
            replacements.put(key, new MemberReplacement(owner, member.getName(), member.getDesc()));
        }
    }

    private void completeReplacement(ClassReplacement replacement, String originalName) {
        if (replacement.getUniqueTypeName() == null) {
            replacement.setUniqueTypeName(originalName);
        }
        Map<MemberKey, MemberReplacement> replacements = replacement.getMethodReplacements();
        replacement.setCheckCastReplacement(this.findCheckCastReplacement(replacements.values()));
        replacement.setInstanceOfReplacement(this.findInstanceOfReplacement(replacements.values()));
        replacement.setReferenceTypeName(replacement.getCheckCastReplacement() != null ? Type.getReturnType(replacement.getCheckCastReplacement().getDesc()).getInternalName() : replacement.getUniqueTypeName());
        for (Map.Entry<MemberKey, MemberReplacement> entry : new HashMap<MemberKey, MemberReplacement>(replacements).entrySet()) {
            this.processMethod(replacement, entry.getKey().getName(), entry.getValue());
        }
    }

    private MemberReplacement findCheckCastReplacement(Collection<MemberReplacement> replacements) {
        for (MemberReplacement replacement : replacements) {
            Type[] types;
            if (!replacement.getName().equals("executeCheckCastInstruction") || (types = Type.getArgumentTypes(replacement.getDesc())).length != 1) continue;
            Type type = types[0];
            Class<?> clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = new Object[0].getClass().getComponentType();
            }
            if (!type.equals(Type.getType(clazz))) continue;
            return replacement;
        }
        return null;
    }

    private MemberReplacement findInstanceOfReplacement(Collection<MemberReplacement> replacements) {
        for (MemberReplacement replacement : replacements) {
            if (!replacement.getName().equals("executeInstanceOfInstruction")) continue;
            String string = replacement.getDesc();
            Class[] classArray = new Class[1];
            Class clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = classArray[0] = new Object[0].getClass().getComponentType();
            }
            if (!string.equals(TransformerTools.descriptor(Boolean.TYPE, classArray))) continue;
            return replacement;
        }
        return null;
    }

    private void processMethod(ClassReplacement classReplacement, String methodName, MemberReplacement replacement) {
        Type[] types = Type.getArgumentTypes(replacement.getDesc());
        if (types.length > 0 && types[0].equals(TransformerTools.getTypeByInternalName(classReplacement.getReferenceTypeName()))) {
            String descriptor = Type.getMethodDescriptor(Type.getReturnType(replacement.getDesc()), ReplacementLocator.deleteFirst(types));
            MemberKey key = new MemberKey(false, methodName, descriptor);
            ReplacementLocator.putIfAbsent(classReplacement.getMethodReplacements(), key, replacement);
        }
        if (methodName.equals("convertConstructorArguments")) {
            ReplacementLocator.putForConstructor(classReplacement.getConverterReplacements(), replacement);
        } else if (methodName.equals("createNewInstance")) {
            ReplacementLocator.putForConstructor(classReplacement.getInstantiationReplacements(), replacement);
        } else if (methodName.equals("createInstanceBuilder")) {
            this.loadConstructor(classReplacement, replacement);
        }
    }

    private static Type[] deleteFirst(Type[] types) {
        Type[] result = new Type[types.length - 1];
        System.arraycopy(types, 1, result, 0, result.length);
        return result;
    }

    private static void putForConstructor(Map<String, MemberReplacement> map, MemberReplacement replacement) {
        ReplacementLocator.putIfAbsent(map, ReplacementLocator.getConstructorDesc(replacement.getDesc()), replacement);
    }

    private static String getConstructorDesc(String desc) {
        return Type.getMethodDescriptor(Type.VOID_TYPE, Type.getArgumentTypes(desc));
    }

    private void loadConstructor(ClassReplacement classReplacement, MemberReplacement replacement) {
        String constructorDesc;
        Map<String, ConstructorReplacement> replacements = classReplacement.getConstructorReplacements();
        if (replacements.containsKey(constructorDesc = ReplacementLocator.getConstructorDesc(replacement.getDesc()))) {
            return;
        }
        String owner = Type.getReturnType(replacement.getDesc()).getInternalName();
        ClassDescriptor classDescriptor = this.getClassDescriptor(owner);
        if (classDescriptor == null) {
            throw new TypeNotPresentException_(owner, null);
        }
        ArrayList<MemberReplacement> arguments = new ArrayList<MemberReplacement>();
        MemberReplacement initializer = null;
        for (MethodDescriptor descriptor : classDescriptor.getMethodDescriptors()) {
            if (ReplacementLocator.isArgument(descriptor)) {
                arguments.add(new MemberReplacement(owner, descriptor.getName(), descriptor.getDesc()));
                continue;
            }
            if (!ReplacementLocator.isInitializer(descriptor, classReplacement.getReferenceTypeName())) continue;
            initializer = new MemberReplacement(owner, descriptor.getName(), descriptor.getDesc());
        }
        Collections.sort(arguments, new Comparator<MemberReplacement>(){

            @Override
            public int compare(MemberReplacement o1, MemberReplacement o2) {
                return o1.getName().compareTo(o2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((MemberReplacement)x0, (MemberReplacement)x1);
            }
        });
        ArrayList<Type> types = new ArrayList<Type>();
        for (MemberReplacement argument : arguments) {
            types.add(Type.getReturnType(argument.getDesc()));
        }
        String newConstructorDesc = Type.getMethodDescriptor(Type.VOID_TYPE, types.toArray(new Type[0]));
        replacements.put(constructorDesc, new ConstructorReplacement(replacement, arguments.toArray(new MemberReplacement[0]), newConstructorDesc, initializer));
    }

    private static boolean isArgument(MethodDescriptor descriptor) {
        if (!descriptor.getName().startsWith("argument")) {
            return false;
        }
        if (Type.getReturnType(descriptor.getDesc()) == Type.VOID_TYPE) {
            return false;
        }
        if (Type.getArgumentTypes(descriptor.getDesc()).length > 0) {
            return false;
        }
        return descriptor.isAccess(1) && !descriptor.isAccess(8);
    }

    private static boolean isInitializer(MethodDescriptor descriptor, String referenceTypeName) {
        if (!descriptor.getName().equals("initialize")) {
            return false;
        }
        if (Type.getReturnType(descriptor.getDesc()) != Type.VOID_TYPE) {
            return false;
        }
        Type[] types = Type.getArgumentTypes(descriptor.getDesc());
        if (types.length != 1) {
            return false;
        }
        if (!types[0].getInternalName().equals(referenceTypeName)) {
            return false;
        }
        return descriptor.isAccess(1) && !descriptor.isAccess(8);
    }

    private boolean isClassAvailable(String internalName) {
        return this.getClassDescriptor(internalName) != null;
    }

    private ClassDescriptor getClassDescriptor(String internalName) {
        ClassDescriptor descriptor;
        byte[] content = this.environment.getClassContent(internalName);
        if (content == null) {
            return null;
        }
        Class<?> clazz = class$net$sf$retrotranslator$transformer$ReplacementLocator;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$transformer$ReplacementLocator = new ReplacementLocator[0].getClass().getComponentType();
        }
        return this.isSupportedBackport(descriptor = new ClassDescriptor(clazz, content)) ? descriptor : null;
    }

    private boolean isSupportedBackport(AnnotatedElementDescriptor descriptor) {
        return !this.unsupportedBackports.contains(descriptor.getInfo());
    }

    public String getUniqueTypeName(String className) {
        ClassReplacement replacement = this.getReplacement(className);
        return this.mode.fixName(replacement != null ? replacement.getUniqueTypeName() : className);
    }

    public String getReferenceTypeName(String className) {
        ClassReplacement replacement = this.getReplacement(className);
        return this.mode.fixName(replacement != null ? replacement.getReferenceTypeName() : className);
    }

    private static <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    public NameTranslator getTranslator() {
        return new NameTranslator(){

            protected String identifier(String s) {
                return 4.fixIdentifier(s);
            }

            protected String typeName(String s) {
                return ReplacementLocator.this.getReferenceTypeName(s);
            }
        };
    }

    static interface KeyProvider {
        public MemberKey getKey(String var1, String var2);
    }
}

