/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.blas;

import java.math.BigDecimal;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.blas.BLAS1;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.PrimitiveFunction;

public abstract class AMAX
implements BLAS1 {
    public static <N extends Number> long invoke(BasicArray<N> data, long first, long limit, long step) {
        long retVal = first;
        double tmpLargest = 0.0;
        for (long i = first; i < limit; i += step) {
            double tmpValue = PrimitiveFunction.ABS.invoke(data.doubleValue(i));
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    public static int invoke(BigDecimal[] data, int first, int limit, int step) {
        int retVal = first;
        BigDecimal tmpLargest = BigMath.ZERO;
        for (int i = first; i < limit; i += step) {
            BigDecimal tmpValue = BigFunction.ABS.invoke(data[i]);
            if (tmpValue.compareTo(tmpLargest) <= 0) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    public static int invoke(double[] data, int first, int limit, int step) {
        int retVal = first;
        double largest = 0.0;
        for (int i = first; i < limit; i += step) {
            double candidate = PrimitiveFunction.ABS.invoke(data[i]);
            if (!(candidate > largest)) continue;
            largest = candidate;
            retVal = i;
        }
        return retVal;
    }

    public static int invoke(float[] data, int first, int limit, int step) {
        int retVal = first;
        float tmpLargest = 0.0f;
        for (int i = first; i < limit; i += step) {
            float tmpValue = Math.abs(data[i]);
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    public static <N extends Number> int invoke(N[] data, int first, int limit, int step) {
        int retVal = first;
        double tmpLargest = 0.0;
        for (int i = first; i < limit; i += step) {
            double tmpValue = ((NormedVectorSpace)data[i]).norm();
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }
}

