/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.decomposition.HessenbergDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.type.context.NumberContext;

public interface Hessenberg<N extends Number>
extends MatrixDecomposition<N> {
    public static final Factory<BigDecimal> BIG = typical -> new HessenbergDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new HessenbergDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> new HessenbergDecomposition.Primitive();
    public static final Factory<Quaternion> QUATERNION = typical -> new HessenbergDecomposition.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new HessenbergDecomposition.Rational();

    public static <N extends Number> Hessenberg<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (Hessenberg)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (Hessenberg)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (Hessenberg)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Hessenberg<N> decomposition, NumberContext context) {
        MatrixStore<N> tmpH = decomposition.getH();
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        MatrixStore<MatrixStore<N>> tmpStore1 = matrix.multiply(tmpQ);
        MatrixStore<MatrixStore<N>> tmpStore2 = tmpQ.multiply(tmpH);
        return Access2D.equals(tmpStore1, tmpStore2, context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(Hessenberg<N> decomposition) {
        MatrixStore<MatrixStore<N>> tmpQ = decomposition.getQ();
        MatrixStore<N> tmpH = decomposition.getH();
        return tmpQ.multiply(tmpH).multiply((MatrixStore<ElementsSupplier>)tmpQ.transpose());
    }

    public boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, boolean var2);

    public MatrixStore<N> getH();

    public MatrixStore<N> getQ();

    public boolean isUpper();

    @Override
    default public MatrixStore<N> reconstruct() {
        return Hessenberg.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<Hessenberg<N>> {
    }
}

