/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class ApplyLDU
extends MatrixOperation {
    public static final ApplyLDU SETUP = new ApplyLDU();
    public static int THRESHOLD = 256;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers, int iterationPoint, boolean hermitian) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            BigDecimal tmpScalar = hermitian ? multipliers[j] : data[iterationPoint + j * structure];
            int tmpFirstRow = hermitian ? j : iterationPoint + 1;
            AXPY.invoke(data, j * structure, tmpScalar.negate(), multipliers, 0, tmpFirstRow, structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers, int iterationPoint, boolean hermitian) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            double tmpScalar = hermitian ? multipliers[j] : data[iterationPoint + j * structure];
            int tmpFirstRow = hermitian ? j : iterationPoint + 1;
            AXPY.invoke(data, j * structure, -tmpScalar, multipliers, 0, tmpFirstRow, structure);
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int firstColumn, int columnLimit, N[] multipliers, int iterationPoint, boolean hermitian) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            Scalar tmpScalar = hermitian ? (Scalar)((VectorSpace)multipliers[j]).conjugate() : (Scalar)data[iterationPoint + j * structure];
            int tmpFirstRow = hermitian ? j : iterationPoint + 1;
            AXPY.invoke(data, (int)(j * structure), ((Scalar)tmpScalar.negate()).get(), multipliers, (int)0, (int)tmpFirstRow, (int)structure);
        }
    }

    private ApplyLDU() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

