/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.AbstractModel;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Presolvers;
import org.ojalgo.optimisation.SpecialOrderedSet;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.integer.IntegerSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.type.context.NumberContext;

public final class ExpressionsBasedModel
extends AbstractModel<GenericSolver> {
    private static final ConvexSolver.ModelIntegration CONVEX_INTEGRATION = new ConvexSolver.ModelIntegration();
    private static final IntegerSolver.ModelIntegration INTEGER_INTEGRATION = new IntegerSolver.ModelIntegration();
    private static final List<Integration<?>> INTEGRATIONS = new ArrayList();
    private static final LinearSolver.ModelIntegration LINEAR_INTEGRATION = new LinearSolver.ModelIntegration();
    private static final String NEW_LINE = "\n";
    private static final String OBJ_FUNC_AS_CONSTR_KEY = UUID.randomUUID().toString();
    private static final String OBJECTIVE = "Generated/Aggregated Objective";
    private static final TreeSet<Presolver> PRESOLVERS = new TreeSet();
    private static final String START_END = "############################################\n";
    private final HashMap<String, Expression> myExpressions = new HashMap();
    private final HashSet<Structure1D.IntIndex> myFixedVariables = new HashSet();
    private transient int[] myFreeIndices = null;
    private final List<Variable> myFreeVariables = new ArrayList<Variable>();
    private transient int[] myIntegerIndices = null;
    private final List<Variable> myIntegerVariables = new ArrayList<Variable>();
    private transient int[] myNegativeIndices = null;
    private final List<Variable> myNegativeVariables = new ArrayList<Variable>();
    private transient int[] myPositiveIndices = null;
    private final List<Variable> myPositiveVariables = new ArrayList<Variable>();
    private final ArrayList<Variable> myVariables = new ArrayList();
    private final boolean myWorkCopy;

    public static boolean addIntegration(Integration<?> integration) {
        return INTEGRATIONS.add(integration);
    }

    public static boolean addPresolver(Presolver presolver) {
        return PRESOLVERS.add(presolver);
    }

    public static void clearIntegrations() {
        INTEGRATIONS.clear();
    }

    public static void clearPresolvers() {
        PRESOLVERS.clear();
    }

    public static boolean removeIntegration(Integration<?> integration) {
        return INTEGRATIONS.remove(integration);
    }

    public static boolean removePresolver(Presolver presolver) {
        return PRESOLVERS.remove(presolver);
    }

    public ExpressionsBasedModel() {
        this.myWorkCopy = false;
    }

    public ExpressionsBasedModel(Collection<? extends Variable> variables) {
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
        this.myWorkCopy = false;
    }

    public ExpressionsBasedModel(Optimisation.Options someOptions) {
        super(someOptions);
        this.myWorkCopy = false;
    }

    public ExpressionsBasedModel(Variable ... variables) {
        for (Variable tmpVariable : variables) {
            this.addVariable(tmpVariable);
        }
        this.myWorkCopy = false;
    }

    ExpressionsBasedModel(ExpressionsBasedModel modelToCopy, boolean workCopy, boolean allEntities) {
        super(modelToCopy.options);
        this.setMinimisation(modelToCopy.isMinimisation());
        for (Variable tmpVariable : modelToCopy.getVariables()) {
            this.addVariable(tmpVariable.copy());
        }
        for (Expression tmpExpression : modelToCopy.getExpressions()) {
            if (!allEntities && !tmpExpression.isObjective() && (!tmpExpression.isConstraint() || tmpExpression.isRedundant())) continue;
            this.myExpressions.put(tmpExpression.getName(), tmpExpression.copy(this, !workCopy));
        }
        this.myWorkCopy = workCopy;
    }

    public Expression addExpression() {
        return this.addExpression("EXPR" + this.myExpressions.size());
    }

    public Expression addExpression(String name) {
        Expression retVal = new Expression(name, this);
        this.myExpressions.put(name, retVal);
        return retVal;
    }

    public void addSpecialOrderedSet(Collection<Variable> orderedSet, int type, Expression linkedTo) {
        if (type <= 0) {
            throw new ProgrammingError("Invalid SOS type!");
        }
        if (!linkedTo.isConstraint()) {
            throw new ProgrammingError("The linked to expression needs to be a constraint!");
        }
        Structure1D.IntIndex[] sequence = new Structure1D.IntIndex[orderedSet.size()];
        int index = 0;
        for (Variable variable : orderedSet) {
            if (variable == null || variable.getIndex() == null) {
                throw new ProgrammingError("Variables must be already inserted in the model!");
            }
            sequence[index++] = variable.getIndex();
        }
        ExpressionsBasedModel.addPresolver(new SpecialOrderedSet(sequence, type, linkedTo));
    }

    public void addSpecialOrderedSet(Collection<Variable> orderedSet, int min, int max) {
        if (max <= 0 || min > max) {
            throw new ProgrammingError("Invalid min/max number of ON variables!");
        }
        String name = "SOS" + max + "-" + orderedSet.toString();
        Expression expression = this.addExpression(name);
        for (Variable variable : orderedSet) {
            if (variable == null || variable.getIndex() == null || !variable.isBinary()) {
                throw new ProgrammingError("Variables must be binary and already inserted in the model!");
            }
            expression.set(variable.getIndex(), (Number)BigMath.ONE);
        }
        expression.upper(BigDecimal.valueOf(max));
        if (min > 0) {
            expression.lower(BigDecimal.valueOf(min));
        }
        this.addSpecialOrderedSet(orderedSet, max, expression);
    }

    public Variable addVariable() {
        return this.addVariable("X" + this.myVariables.size());
    }

    public Variable addVariable(String name) {
        Variable retVal = new Variable(name);
        this.addVariable(retVal);
        return retVal;
    }

    public void addVariable(Variable variable) {
        if (this.myWorkCopy) {
            throw new IllegalStateException("This model is a work copy - its set of variables cannot be modified!");
        }
        this.myVariables.add(variable);
        variable.setIndex(new Structure1D.IntIndex(this.myVariables.size() - 1));
    }

    public void addVariables(Collection<? extends Variable> variables) {
        for (Variable variable : variables) {
            this.addVariable(variable);
        }
    }

    public void addVariables(Variable[] variables) {
        for (Variable tmpVariable : variables) {
            this.addVariable(tmpVariable);
        }
    }

    public Stream<Variable> bounds() {
        return this.variables().filter(v -> v.isConstraint());
    }

    public Stream<Expression> constraints() {
        return this.myExpressions.values().stream().filter(c -> c.isConstraint() && !c.isRedundant());
    }

    public ExpressionsBasedModel copy() {
        return new ExpressionsBasedModel(this, false, true);
    }

    public int countExpressions() {
        return this.myExpressions.size();
    }

    public int countVariables() {
        return this.myVariables.size();
    }

    @Override
    public void dispose() {
        for (Expression tmpExprerssion : this.myExpressions.values()) {
            tmpExprerssion.destroy();
        }
        this.myExpressions.clear();
        for (Variable tmpVariable : this.myVariables) {
            tmpVariable.destroy();
        }
        this.myVariables.clear();
        this.myFixedVariables.clear();
        this.myFreeVariables.clear();
        this.myFreeIndices = null;
        this.myPositiveVariables.clear();
        this.myPositiveIndices = null;
        this.myNegativeVariables.clear();
        this.myNegativeIndices = null;
        this.myIntegerVariables.clear();
        this.myIntegerIndices = null;
    }

    public Expression generateCut(Expression constraint, Optimisation.Result solution) {
        return null;
    }

    public Expression getExpression(String name) {
        return this.myExpressions.get(name);
    }

    public Collection<Expression> getExpressions() {
        return Collections.unmodifiableCollection(this.myExpressions.values());
    }

    public Set<Structure1D.IntIndex> getFixedVariables() {
        this.myFixedVariables.clear();
        for (Variable tmpVar : this.myVariables) {
            if (!tmpVar.isFixed()) continue;
            this.myFixedVariables.add(tmpVar.getIndex());
        }
        return Collections.unmodifiableSet(this.myFixedVariables);
    }

    public List<Variable> getFreeVariables() {
        if (this.myFreeIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myFreeVariables);
    }

    public List<Variable> getIntegerVariables() {
        if (this.myIntegerIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myIntegerVariables);
    }

    public List<Variable> getNegativeVariables() {
        if (this.myNegativeIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myNegativeVariables);
    }

    public List<Variable> getPositiveVariables() {
        if (this.myPositiveIndices == null) {
            this.categoriseVariables();
        }
        return Collections.unmodifiableList(this.myPositiveVariables);
    }

    public Variable getVariable(int index) {
        return this.myVariables.get(index);
    }

    public Variable getVariable(Structure1D.IntIndex index) {
        return this.myVariables.get(index.index);
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.myVariables);
    }

    public Optimisation.Result getVariableValues() {
        return this.getVariableValues(this.options.feasibility);
    }

    public Optimisation.Result getVariableValues(NumberContext validationContext) {
        int tmpNumberOfVariables = this.myVariables.size();
        Optimisation.State retState = Optimisation.State.UNEXPLORED;
        double retValue = Double.NaN;
        Structure1D retSolution = Array1D.BIG.makeZero(tmpNumberOfVariables);
        boolean tmpAllVarsSomeInfo = true;
        for (int i = 0; i < tmpNumberOfVariables; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.getValue() != null) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getValue());
                continue;
            }
            if (tmpVariable.isEqualityConstraint()) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getLowerLimit());
                continue;
            }
            if (tmpVariable.isLowerLimitSet() && tmpVariable.isUpperLimitSet()) {
                ((Array1D)retSolution).set(i, (Object)BigFunction.DIVIDE.invoke(tmpVariable.getLowerLimit().add(tmpVariable.getUpperLimit()), BigMath.TWO));
                continue;
            }
            if (tmpVariable.isLowerLimitSet()) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getLowerLimit());
                continue;
            }
            if (tmpVariable.isUpperLimitSet()) {
                ((Array1D)retSolution).set(i, (Object)tmpVariable.getUpperLimit());
                continue;
            }
            ((Array1D)retSolution).set(i, (Object)BigMath.ZERO);
            tmpAllVarsSomeInfo = false;
        }
        if (tmpAllVarsSomeInfo) {
            if (this.validate((Access1D<BigDecimal>)retSolution, validationContext)) {
                retState = Optimisation.State.FEASIBLE;
                retValue = this.objective().evaluate((Access1D<BigDecimal>)retSolution).doubleValue();
            } else {
                retState = Optimisation.State.APPROXIMATE;
            }
        } else {
            retState = Optimisation.State.INFEASIBLE;
        }
        return new Optimisation.Result(retState, retValue, (Access1D<?>)retSolution);
    }

    public int indexOf(Variable variable) {
        return variable.getIndex().index;
    }

    public int indexOfFreeVariable(int globalIndex) {
        return this.myFreeIndices[globalIndex];
    }

    public int indexOfFreeVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfFreeVariable(variableIndex.index);
    }

    public int indexOfFreeVariable(Variable variable) {
        return this.indexOfFreeVariable(this.indexOf(variable));
    }

    public int indexOfIntegerVariable(int globalIndex) {
        return this.myIntegerIndices[globalIndex];
    }

    public int indexOfIntegerVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfIntegerVariable(variableIndex.index);
    }

    public int indexOfIntegerVariable(Variable variable) {
        return this.indexOfIntegerVariable(variable.getIndex().index);
    }

    public int indexOfNegativeVariable(int globalIndex) {
        return this.myNegativeIndices[globalIndex];
    }

    public int indexOfNegativeVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfNegativeVariable(variableIndex.index);
    }

    public int indexOfNegativeVariable(Variable variable) {
        return this.indexOfNegativeVariable(this.indexOf(variable));
    }

    public int indexOfPositiveVariable(int globalIndex) {
        return this.myPositiveIndices[globalIndex];
    }

    public int indexOfPositiveVariable(Structure1D.IntIndex variableIndex) {
        return this.indexOfPositiveVariable(variableIndex.index);
    }

    public int indexOfPositiveVariable(Variable variable) {
        return this.indexOfPositiveVariable(this.indexOf(variable));
    }

    public boolean isAnyConstraintQuadratic() {
        boolean retVal = false;
        for (Expression value : this.myExpressions.values()) {
            retVal |= value.isAnyQuadraticFactorNonZero() && value.isConstraint() && !value.isRedundant();
        }
        return retVal;
    }

    @Deprecated
    public boolean isAnyExpressionQuadratic() {
        boolean retVal = false;
        for (Expression value : this.myExpressions.values()) {
            retVal |= value.isAnyQuadraticFactorNonZero() && (value.isConstraint() || value.isObjective());
        }
        return retVal;
    }

    public boolean isAnyObjectiveQuadratic() {
        boolean retVal = false;
        for (Expression value : this.myExpressions.values()) {
            retVal |= value.isAnyQuadraticFactorNonZero() && value.isObjective();
        }
        return retVal;
    }

    public boolean isAnyVariableFixed() {
        return this.myVariables.stream().anyMatch(v -> v.isFixed());
    }

    public boolean isAnyVariableInteger() {
        boolean retVal = false;
        int tmpLength = this.myVariables.size();
        for (int i = 0; !retVal && i < tmpLength; retVal |= this.myVariables.get(i).isInteger(), ++i) {
        }
        return retVal;
    }

    public boolean isWorkCopy() {
        return this.myWorkCopy;
    }

    public void limitObjective(BigDecimal lower, BigDecimal upper) {
        Expression objExpr;
        Expression constrExpr = this.myExpressions.get(OBJ_FUNC_AS_CONSTR_KEY);
        if (constrExpr == null && !(objExpr = this.objective()).isAnyQuadraticFactorNonZero()) {
            constrExpr = objExpr.copy(this, false);
            this.myExpressions.put(OBJ_FUNC_AS_CONSTR_KEY, constrExpr);
        }
        if (constrExpr != null) {
            ((Expression)constrExpr.lower(lower)).upper(upper);
        }
    }

    @Override
    public Optimisation.Result maximise() {
        this.setMaximisation();
        return this.optimise();
    }

    @Override
    public Optimisation.Result minimise() {
        this.setMinimisation();
        return this.optimise();
    }

    public Expression objective() {
        Expression retVal = new Expression(OBJECTIVE, this);
        for (int i = 0; i < this.myVariables.size(); ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (!tmpVariable.isObjective()) continue;
            retVal.set(i, (Number)tmpVariable.getContributionWeight());
        }
        BigDecimal tmpOldVal = null;
        BigDecimal tmpDiff = null;
        BigDecimal tmpNewVal = null;
        for (Expression tmpExpression : this.myExpressions.values()) {
            BigDecimal value;
            boolean tmpNotOne;
            if (!tmpExpression.isObjective()) continue;
            BigDecimal tmpContributionWeight = tmpExpression.getContributionWeight();
            boolean bl = tmpNotOne = tmpContributionWeight.compareTo(BigMath.ONE) != 0;
            if (tmpExpression.isAnyLinearFactorNonZero()) {
                for (Structure1D.IntIndex intIndex : tmpExpression.getLinearKeySet()) {
                    tmpOldVal = retVal.get(intIndex);
                    tmpDiff = tmpExpression.get(intIndex);
                    value = tmpNewVal = tmpOldVal.add(tmpNotOne ? tmpContributionWeight.multiply(tmpDiff) : tmpDiff);
                    retVal.set(intIndex, (Number)value);
                }
            }
            if (!tmpExpression.isAnyQuadraticFactorNonZero()) continue;
            for (Structure2D.IntRowColumn intRowColumn : tmpExpression.getQuadraticKeySet()) {
                tmpOldVal = retVal.get(intRowColumn);
                tmpDiff = tmpExpression.get(intRowColumn);
                value = tmpNewVal = tmpOldVal.add(tmpNotOne ? tmpContributionWeight.multiply(tmpDiff) : tmpDiff);
                retVal.set(intRowColumn, (Number)value);
            }
        }
        return retVal;
    }

    public ExpressionsBasedModel relax(boolean inPlace) {
        ExpressionsBasedModel retVal = inPlace ? this : new ExpressionsBasedModel(this, true, true);
        for (Variable tmpVariable : retVal.getVariables()) {
            tmpVariable.relax();
        }
        return retVal;
    }

    public ExpressionsBasedModel simplify() {
        this.scanEntities();
        this.presolve();
        ExpressionsBasedModel retVal = new ExpressionsBasedModel(this, true, false);
        return retVal;
    }

    public Optimisation.Result solve(Optimisation.Result candidate) {
        this.presolve();
        if (this.isInfeasible()) {
            Optimisation.Result solution = candidate != null ? candidate : this.getVariableValues();
            return new Optimisation.Result(Optimisation.State.INFEASIBLE, solution);
        }
        if (this.isUnbounded()) {
            if (candidate != null && this.validate(candidate)) {
                return new Optimisation.Result(Optimisation.State.UNBOUNDED, candidate);
            }
            Optimisation.Result derivedSolution = this.getVariableValues();
            if (derivedSolution.getState().isFeasible()) {
                return new Optimisation.Result(Optimisation.State.UNBOUNDED, derivedSolution);
            }
        } else if (this.isFixed()) {
            Optimisation.Result derivedSolution = this.getVariableValues();
            if (derivedSolution.getState().isFeasible()) {
                return new Optimisation.Result(Optimisation.State.DISTINCT, derivedSolution);
            }
            return new Optimisation.Result(Optimisation.State.INVALID, derivedSolution);
        }
        Integration<?> tmpIntegration = this.getIntegration();
        Object tmpSolver = tmpIntegration.build(this);
        Optimisation.Result retVal = tmpIntegration.toSolverState(candidate != null ? candidate : this.getVariableValues(), this);
        retVal = tmpSolver.solve(retVal);
        retVal = tmpIntegration.toModelState(retVal, this);
        tmpSolver.dispose();
        return retVal;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder(START_END);
        for (Variable tmpVariable : this.myVariables) {
            tmpVariable.appendToString(retVal);
            retVal.append(NEW_LINE);
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            tmpExpression.appendToString(retVal, this.getVariableValues());
            retVal.append(NEW_LINE);
        }
        return retVal.append(START_END).toString();
    }

    @Override
    public boolean validate() {
        BasicLogger.Printer appender = this.options.logger_detailed ? this.options.logger_appender : BasicLogger.NULL;
        boolean retVal = true;
        for (Variable tmpVariable : this.myVariables) {
            retVal &= tmpVariable.validate(appender);
        }
        for (Expression tmpExpression : this.myExpressions.values()) {
            retVal &= tmpExpression.validate(appender);
        }
        return retVal;
    }

    public boolean validate(Access1D<BigDecimal> solution) {
        NumberContext context = this.options.feasibility;
        BasicLogger.Printer appender = this.options.logger_detailed && this.options.logger_appender != null ? this.options.logger_appender : BasicLogger.NULL;
        return this.validate(solution, context, appender);
    }

    public boolean validate(Access1D<BigDecimal> solution, NumberContext context) {
        BasicLogger.Printer appender = this.options.logger_detailed && this.options.logger_appender != null ? this.options.logger_appender : BasicLogger.NULL;
        return this.validate(solution, context, appender);
    }

    public boolean validate(Access1D<BigDecimal> solution, NumberContext context, BasicLogger.Printer appender) {
        BigDecimal value;
        Variable tmpVariable;
        ProgrammingError.throwIfNull(solution, (Object)context, (Object)appender);
        int size = this.myVariables.size();
        boolean retVal = (long)size == solution.count();
        for (int i = 0; retVal && i < size; retVal &= tmpVariable.validate(value, context, appender), ++i) {
            tmpVariable = this.myVariables.get(i);
            value = solution.get(i);
        }
        if (retVal) {
            for (Expression tmpExpression : this.myExpressions.values()) {
                value = tmpExpression.evaluate(solution);
                retVal &= tmpExpression.validate(value, context, appender);
            }
        }
        return retVal;
    }

    public boolean validate(Access1D<BigDecimal> solution, BasicLogger.Printer appender) {
        NumberContext context = this.options.feasibility;
        return this.validate(solution, context, appender);
    }

    public boolean validate(NumberContext context) {
        Optimisation.Result solution = this.getVariableValues(context);
        BasicLogger.Printer appender = this.options.logger_detailed && this.options.logger_appender != null ? this.options.logger_appender : BasicLogger.NULL;
        return this.validate(solution, context, appender);
    }

    public boolean validate(NumberContext context, BasicLogger.Printer appender) {
        Optimisation.Result solution = this.getVariableValues(context);
        return this.validate(solution, context, appender);
    }

    public boolean validate(BasicLogger.Printer appender) {
        NumberContext context = this.options.feasibility;
        Optimisation.Result solution = this.getVariableValues(context);
        return this.validate(solution, context, appender);
    }

    public Stream<Variable> variables() {
        return this.myVariables.stream().filter(v -> !v.isEqualityConstraint());
    }

    private void categoriseVariables() {
        int tmpLength = this.myVariables.size();
        this.myFreeVariables.clear();
        this.myFreeIndices = new int[tmpLength];
        Arrays.fill(this.myFreeIndices, -1);
        this.myPositiveVariables.clear();
        this.myPositiveIndices = new int[tmpLength];
        Arrays.fill(this.myPositiveIndices, -1);
        this.myNegativeVariables.clear();
        this.myNegativeIndices = new int[tmpLength];
        Arrays.fill(this.myNegativeIndices, -1);
        this.myIntegerVariables.clear();
        this.myIntegerIndices = new int[tmpLength];
        Arrays.fill(this.myIntegerIndices, -1);
        for (int i = 0; i < tmpLength; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.isFixed()) continue;
            this.myFreeVariables.add(tmpVariable);
            this.myFreeIndices[i] = this.myFreeVariables.size() - 1;
            if (!tmpVariable.isUpperLimitSet() || tmpVariable.getUpperLimit().signum() == 1) {
                this.myPositiveVariables.add(tmpVariable);
                this.myPositiveIndices[i] = this.myPositiveVariables.size() - 1;
            }
            if (!tmpVariable.isLowerLimitSet() || tmpVariable.getLowerLimit().signum() == -1) {
                this.myNegativeVariables.add(tmpVariable);
                this.myNegativeIndices[i] = this.myNegativeVariables.size() - 1;
            }
            if (!tmpVariable.isInteger()) continue;
            this.myIntegerVariables.add(tmpVariable);
            this.myIntegerIndices[i] = this.myIntegerVariables.size() - 1;
        }
    }

    private void generateCuts(Set<Expression> constraints) {
        if (constraints != null && constraints.size() > 0) {
            ArrayList<Variable> posBinVar = new ArrayList<Variable>();
            ArrayList<Variable> negBinVar = new ArrayList<Variable>();
            HashSet<Structure1D.IntIndex> indices = new HashSet<Structure1D.IntIndex>();
            Set<Structure1D.IntIndex> fixedVariables = this.getFixedVariables();
            for (Expression tmpExpression : constraints) {
                BigDecimal ul;
                posBinVar.clear();
                negBinVar.clear();
                indices.clear();
                indices.addAll(tmpExpression.getLinearKeySet());
                int countExprVars = indices.size();
                indices.removeAll(fixedVariables);
                for (Structure1D.IntIndex tmpIndex : indices) {
                    Variable tmpVariable = this.getVariable(tmpIndex);
                    if (!tmpVariable.isBinary()) continue;
                    BigDecimal tmpFactor = tmpExpression.get(tmpIndex);
                    if (tmpFactor.signum() == 1) {
                        posBinVar.add(tmpVariable);
                        continue;
                    }
                    if (tmpFactor.signum() != -1) continue;
                    negBinVar.add(tmpVariable);
                }
                if (posBinVar.size() == indices.size() && posBinVar.size() != countExprVars && posBinVar.size() != 0 && (ul = tmpExpression.getUpperLimit()) != null && ul.signum() != -1) {
                    posBinVar.sort((v1, v2) -> tmpExpression.get(v1.getIndex()).compareTo(tmpExpression.get(v2.getIndex())));
                    BigDecimal accum = BigMath.ZERO;
                    int count = 0;
                    for (Variable tmpVariable : posBinVar) {
                        if ((accum = accum.add(tmpExpression.get(tmpVariable))).compareTo(ul) > 0) {
                            Expression tmpNewCut = this.addExpression("Cut-" + tmpExpression.getName());
                            tmpNewCut.setLinearFactorsSimple(posBinVar);
                            tmpNewCut.upper(new BigDecimal(count));
                            break;
                        }
                        ++count;
                    }
                }
                if (posBinVar.size() != indices.size()) continue;
            }
        }
    }

    private void scanEntities() {
        Set<Structure1D.IntIndex> fixedVariables = Collections.emptySet();
        BigDecimal fixedValue = BigMath.ZERO;
        for (Expression tmpExpression : this.myExpressions.values()) {
            Presolvers.LINEAR_OBJECTIVE.simplify(tmpExpression, fixedVariables, fixedValue, this::getVariable, this.options.feasibility);
            if (!tmpExpression.isConstraint()) continue;
            Presolvers.ZERO_ONE_TWO.simplify(tmpExpression, fixedVariables, fixedValue, this::getVariable, this.options.feasibility);
        }
        for (Variable tmpVariable : this.myVariables) {
            Presolvers.FIXED_OR_UNBOUNDED.simplify(tmpVariable, this);
        }
    }

    Stream<Expression> expressions() {
        return this.myExpressions.values().stream();
    }

    Integration<?> getIntegration() {
        Integration retVal = null;
        for (IntegerSolver.ModelIntegration modelIntegration : INTEGRATIONS) {
            if (!modelIntegration.isCapable(this)) continue;
            retVal = modelIntegration;
            break;
        }
        if (retVal == null) {
            if (this.isAnyVariableInteger()) {
                if (INTEGER_INTEGRATION.isCapable(this)) {
                    retVal = INTEGER_INTEGRATION;
                }
            } else if (CONVEX_INTEGRATION.isCapable(this)) {
                retVal = CONVEX_INTEGRATION;
            } else if (LINEAR_INTEGRATION.isCapable(this)) {
                retVal = LINEAR_INTEGRATION;
            }
        }
        if (retVal == null) {
            throw new ProgrammingError("No solver integration available that can handle this model!");
        }
        return retVal;
    }

    boolean isFixed() {
        return this.myVariables.stream().allMatch(v -> v.isFixed());
    }

    boolean isInfeasible() {
        for (Expression tmpExpression : this.myExpressions.values()) {
            if (!tmpExpression.isInfeasible()) continue;
            return true;
        }
        for (Variable tmpVariable : this.myVariables) {
            if (!tmpVariable.isInfeasible()) continue;
            return true;
        }
        return false;
    }

    boolean isUnbounded() {
        return this.myVariables.stream().anyMatch(v -> v.isUnbounded());
    }

    Optimisation.Result optimise() {
        if (PRESOLVERS.size() > 0) {
            this.scanEntities();
        }
        Optimisation.Result solver = this.solve(null);
        int limit = this.myVariables.size();
        for (int i = 0; i < limit; ++i) {
            Variable tmpVariable = this.myVariables.get(i);
            if (tmpVariable.isFixed()) continue;
            tmpVariable.setValue(this.options.solution.enforce(solver.get(i)));
        }
        Optimisation.Result retSolution = this.getVariableValues();
        Optimisation.State retState = solver.getState();
        double retValue = this.objective().evaluate(retSolution).doubleValue();
        Optimisation.Result output = new Optimisation.Result(retState, retValue, retSolution);
        return output;
    }

    final void presolve() {
        this.myExpressions.values().forEach(expr -> expr.setRedundant(false));
        boolean needToRepeat = false;
        do {
            Set<Structure1D.IntIndex> fixedVariables = this.getFixedVariables();
            needToRepeat = false;
            for (Expression expr2 : this.getExpressions()) {
                if (needToRepeat || !expr2.isConstraint() || expr2.isInfeasible() || expr2.isRedundant() || expr2.countQuadraticFactors() != 0) continue;
                BigDecimal fixedValue = this.options.solution.enforce(expr2.calculateFixedValue(fixedVariables));
                for (Presolver presolver : PRESOLVERS) {
                    if (needToRepeat) continue;
                    needToRepeat |= presolver.simplify(expr2, fixedVariables, fixedValue, this::getVariable, this.options.solution);
                }
            }
        } while (needToRepeat);
        this.categoriseVariables();
    }

    static {
        ExpressionsBasedModel.addPresolver(Presolvers.ZERO_ONE_TWO);
        ExpressionsBasedModel.addPresolver(Presolvers.OPPOSITE_SIGN);
    }

    static abstract class VariableAnalyser
    extends Simplifier<Variable, VariableAnalyser> {
        protected VariableAnalyser(int executionOrder) {
            super(executionOrder);
        }

        public abstract boolean simplify(Variable var1, ExpressionsBasedModel var2);

        @Override
        boolean isApplicable(Variable target) {
            return true;
        }
    }

    static abstract class Simplifier<ME extends ModelEntity<?>, S extends Simplifier<?, ?>>
    implements Comparable<S> {
        private final int myExecutionOrder;
        private final UUID myUUID = UUID.randomUUID();

        Simplifier(int executionOrder) {
            this.myExecutionOrder = executionOrder;
        }

        @Override
        public final int compareTo(S reference) {
            return Integer.compare(this.myExecutionOrder, ((Simplifier)reference).getExecutionOrder());
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Simplifier)) {
                return false;
            }
            Simplifier other = (Simplifier)obj;
            return !(this.myUUID == null ? other.myUUID != null : !this.myUUID.equals(other.myUUID));
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myUUID == null ? 0 : this.myUUID.hashCode());
            return result;
        }

        final int getExecutionOrder() {
            return this.myExecutionOrder;
        }

        abstract boolean isApplicable(ME var1);
    }

    public static abstract class Presolver
    extends Simplifier<Expression, Presolver> {
        protected Presolver(int executionOrder) {
            super(executionOrder);
        }

        public abstract boolean simplify(Expression var1, Set<Structure1D.IntIndex> var2, BigDecimal var3, Function<Structure1D.IntIndex, Variable> var4, NumberContext var5);

        @Override
        boolean isApplicable(Expression target) {
            return target.isConstraint() && !target.isInfeasible() && !target.isRedundant() && target.countQuadraticFactors() == 0;
        }
    }

    public static abstract class Integration<S extends Optimisation.Solver>
    implements Optimisation.Integration<ExpressionsBasedModel, S> {
        @Override
        public final Optimisation.Result extractSolverState(ExpressionsBasedModel model) {
            return this.toSolverState(model.getVariableValues(), model);
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            int numbVariables = model.countVariables();
            if (this.isSolutionMapped()) {
                List<Variable> freeVariables = model.getFreeVariables();
                Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
                if (solverState.count() != (long)freeVariables.size()) {
                    throw new IllegalStateException();
                }
                Primitive64Array modelSolution = Primitive64Array.make(numbVariables);
                for (Structure1D.IntIndex fixedIndex : fixedVariables) {
                    modelSolution.set((long)fixedIndex.index, (Number)model.getVariable(fixedIndex.index).getValue());
                }
                for (int f = 0; f < freeVariables.size(); ++f) {
                    int freeIndex = model.indexOf(freeVariables.get(f));
                    modelSolution.set((long)freeIndex, solverState.doubleValue(f));
                }
                return new Optimisation.Result(solverState.getState(), modelSolution);
            }
            if (solverState.count() != (long)numbVariables) {
                throw new IllegalStateException();
            }
            return solverState;
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            if (this.isSolutionMapped()) {
                List<Variable> tmpFreeVariables = model.getFreeVariables();
                int numbFreeVars = tmpFreeVariables.size();
                Primitive64Array solverSolution = Primitive64Array.make(numbFreeVars);
                for (int i = 0; i < numbFreeVars; ++i) {
                    Variable variable = tmpFreeVariables.get(i);
                    int modelIndex = model.indexOf(variable);
                    solverSolution.set((long)i, modelState.doubleValue(modelIndex));
                }
                return new Optimisation.Result(modelState.getState(), solverSolution);
            }
            return modelState;
        }

        protected abstract boolean isSolutionMapped();
    }
}

