/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.ojalgo.access.Structure1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.context.NumberContext;

public abstract class Presolvers {
    public static final ExpressionsBasedModel.Presolver BINARY_VALUE = new ExpressionsBasedModel.Presolver(100){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> fixedVariables, BigDecimal fixedValue, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
            boolean didFixVariable;
            block4: {
                BigDecimal compLowLim;
                Set<Variable> binaryVariables;
                block5: {
                    didFixVariable = false;
                    binaryVariables = expression.getBinaryVariables(fixedVariables);
                    if (binaryVariables.size() <= 0) break block4;
                    BigDecimal compUppLim = expression.getUpperLimit();
                    if (compUppLim != null && fixedValue.signum() != 0) {
                        compUppLim = compUppLim.subtract(fixedValue);
                    }
                    if ((compLowLim = expression.getLowerLimit()) != null && fixedValue.signum() != 0) {
                        compLowLim = compLowLim.subtract(fixedValue);
                    }
                    if (compUppLim == null || !expression.isPositive(fixedVariables)) break block5;
                    for (Variable binVar : binaryVariables) {
                        if (expression.get(binVar).compareTo(compUppLim) <= 0) continue;
                        binVar.setFixed(BigMath.ZERO);
                        didFixVariable = true;
                    }
                    break block4;
                }
                if (compLowLim == null || !expression.isNegative(fixedVariables)) break block4;
                for (Variable binVar : binaryVariables) {
                    if (expression.get(binVar).compareTo(compLowLim) >= 0) continue;
                    binVar.setFixed(BigMath.ZERO);
                    didFixVariable = true;
                }
            }
            return didFixVariable;
        }
    };
    public static final ExpressionsBasedModel.VariableAnalyser FIXED_OR_UNBOUNDED = new ExpressionsBasedModel.VariableAnalyser(4){

        @Override
        public boolean simplify(Variable variable, ExpressionsBasedModel model) {
            boolean includedAnywhere;
            if (variable.isInteger()) {
                BigDecimal tmpLimit = variable.getUpperLimit();
                if (tmpLimit != null && tmpLimit.scale() > 0) {
                    variable.upper(tmpLimit.setScale(0, RoundingMode.FLOOR));
                }
                if ((tmpLimit = variable.getLowerLimit()) != null && tmpLimit.scale() > 0) {
                    variable.lower(tmpLimit.setScale(0, RoundingMode.CEILING));
                }
            }
            if (variable.isObjective() && !variable.isFixed() && !variable.isUnbounded() && !(includedAnywhere = model.expressions().anyMatch(expr -> expr.includes(variable)))) {
                int weightSignum = variable.getContributionWeight().signum();
                if (model.isMaximisation() && weightSignum == -1) {
                    if (variable.isLowerLimitSet()) {
                        variable.setFixed(variable.getLowerLimit());
                    } else {
                        variable.setUnbounded(true);
                    }
                } else if (model.isMinimisation() && weightSignum == 1) {
                    if (variable.isLowerLimitSet()) {
                        variable.setFixed(variable.getLowerLimit());
                    } else {
                        variable.setUnbounded(true);
                    }
                } else if (model.isMaximisation() && weightSignum == 1) {
                    if (variable.isUpperLimitSet()) {
                        variable.setFixed(variable.getUpperLimit());
                    } else {
                        variable.setUnbounded(true);
                    }
                } else if (model.isMinimisation() && weightSignum == -1) {
                    if (variable.isUpperLimitSet()) {
                        variable.setFixed(variable.getUpperLimit());
                    } else {
                        variable.setUnbounded(true);
                    }
                }
            }
            return false;
        }
    };
    public static final ExpressionsBasedModel.Presolver LINEAR_OBJECTIVE = new ExpressionsBasedModel.Presolver(10){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> fixedVariables, BigDecimal fixedValue, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
            if (expression.isObjective() && expression.isFunctionLinear()) {
                BigDecimal exprWeight = expression.getContributionWeight();
                for (Map.Entry<Structure1D.IntIndex, BigDecimal> entry : expression.getLinearEntrySet()) {
                    Variable tmpVariable = variableResolver.apply(entry.getKey());
                    BigDecimal varWeight = tmpVariable.getContributionWeight();
                    BigDecimal contribution = exprWeight.multiply(entry.getValue());
                    varWeight = varWeight != null ? varWeight.add(contribution) : contribution;
                    tmpVariable.weight(varWeight);
                }
                expression.weight(null);
            }
            return false;
        }
    };
    public static final ExpressionsBasedModel.Presolver OPPOSITE_SIGN = new ExpressionsBasedModel.Presolver(20){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> fixedVariables, BigDecimal fixedValue, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
            Variable tmpFreeVariable;
            BigDecimal tmpCompUppLim;
            boolean didFixVariable = false;
            BigDecimal tmpCompLowLim = expression.getLowerLimit();
            if (tmpCompLowLim != null && fixedValue.signum() != 0) {
                tmpCompLowLim = tmpCompLowLim.subtract(fixedValue);
            }
            if ((tmpCompUppLim = expression.getUpperLimit()) != null && fixedValue.signum() != 0) {
                tmpCompUppLim = tmpCompUppLim.subtract(fixedValue);
            }
            if (tmpCompLowLim != null && tmpCompLowLim.signum() >= 0 && expression.isNegative(fixedVariables)) {
                if (tmpCompLowLim.signum() == 0) {
                    for (Structure1D.IntIndex tmpLinear : expression.getLinearKeySet()) {
                        if (fixedVariables.contains(tmpLinear)) continue;
                        tmpFreeVariable = variableResolver.apply(tmpLinear);
                        if (tmpFreeVariable.validate(BigMath.ZERO, precision, null)) {
                            tmpFreeVariable.setFixed(BigMath.ZERO);
                            didFixVariable = true;
                            continue;
                        }
                        expression.setInfeasible();
                    }
                } else {
                    expression.setInfeasible();
                }
            }
            if (tmpCompUppLim != null && tmpCompUppLim.signum() <= 0 && expression.isPositive(fixedVariables)) {
                if (tmpCompUppLim.signum() == 0) {
                    for (Structure1D.IntIndex tmpLinear : expression.getLinearKeySet()) {
                        if (fixedVariables.contains(tmpLinear)) continue;
                        tmpFreeVariable = variableResolver.apply(tmpLinear);
                        if (tmpFreeVariable.validate(BigMath.ZERO, precision, null)) {
                            tmpFreeVariable.setFixed(BigMath.ZERO);
                            didFixVariable = true;
                            continue;
                        }
                        expression.setInfeasible();
                    }
                } else {
                    expression.setInfeasible();
                }
            }
            return didFixVariable;
        }
    };
    public static final ExpressionsBasedModel.Presolver ZERO_ONE_TWO = new ExpressionsBasedModel.Presolver(10){

        @Override
        public boolean simplify(Expression expression, Set<Structure1D.IntIndex> fixedVariables, BigDecimal fixedValue, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
            boolean didFixVariable = false;
            if (expression.countLinearFactors() <= fixedVariables.size() + 2) {
                HashSet<Structure1D.IntIndex> remainingLinear = new HashSet<Structure1D.IntIndex>(expression.getLinearKeySet());
                remainingLinear.removeAll(fixedVariables);
                switch (remainingLinear.size()) {
                    case 0: {
                        didFixVariable = Presolvers.doCase0(expression, fixedValue, remainingLinear, variableResolver, precision);
                        break;
                    }
                    case 1: {
                        didFixVariable = Presolvers.doCase1(expression, fixedValue, remainingLinear, variableResolver, precision);
                        break;
                    }
                    case 2: {
                        didFixVariable = Presolvers.doCase2(expression, fixedValue, remainingLinear, variableResolver, precision);
                        break;
                    }
                }
            }
            return didFixVariable;
        }
    };

    static boolean doCase0(Expression expression, BigDecimal fixedValue, HashSet<Structure1D.IntIndex> remaining, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
        expression.setRedundant(true);
        if (expression.validate(fixedValue, precision, null)) {
            expression.level(fixedValue);
        } else {
            expression.setInfeasible();
        }
        return false;
    }

    static boolean doCase1(Expression expression, BigDecimal fixedValue, HashSet<Structure1D.IntIndex> remaining, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
        BigDecimal exprUpper;
        BigDecimal exprLower;
        BigDecimal varMinContr;
        BigDecimal varMaxContr;
        Structure1D.IntIndex index = remaining.iterator().next();
        Variable variable = variableResolver.apply(index);
        BigDecimal factor = expression.get(index);
        BigDecimal oldLower = variable.getLowerLimit();
        BigDecimal oldUpper = variable.getUpperLimit();
        if (factor.signum() == 1) {
            varMaxContr = oldUpper != null ? factor.multiply(oldUpper) : null;
            varMinContr = oldLower != null ? factor.multiply(oldLower) : null;
        } else {
            varMinContr = oldUpper != null ? factor.multiply(oldUpper) : null;
            varMaxContr = oldLower != null ? factor.multiply(oldLower) : null;
        }
        BigDecimal bigDecimal = exprLower = expression.getLowerLimit() != null ? expression.getLowerLimit().subtract(fixedValue) : null;
        if (exprLower != null && varMaxContr != null && precision.isLessThan(exprLower, varMaxContr)) {
            expression.setInfeasible();
            return false;
        }
        BigDecimal bigDecimal2 = exprUpper = expression.getUpperLimit() != null ? expression.getUpperLimit().subtract(fixedValue) : null;
        if (exprUpper != null && varMinContr != null && precision.isMoreThan(exprUpper, varMinContr)) {
            expression.setInfeasible();
            return false;
        }
        if (expression.isEqualityConstraint()) {
            BigDecimal solution = BigFunction.DIVIDE.invoke(exprUpper, factor);
            if (variable.validate(solution, precision, null)) {
                variable.setFixed(solution);
            } else {
                expression.setInfeasible();
            }
        } else {
            BigDecimal newUpper;
            BigDecimal newLower;
            BigDecimal solutionUpper;
            BigDecimal solutionLower = exprLower != null ? BigFunction.DIVIDE.invoke(exprLower, factor) : null;
            BigDecimal bigDecimal3 = solutionUpper = exprUpper != null ? BigFunction.DIVIDE.invoke(exprUpper, factor) : null;
            if (factor.signum() < 0) {
                BigDecimal tmpVal = solutionLower;
                solutionLower = solutionUpper;
                solutionUpper = tmpVal;
            }
            if (solutionLower != null) {
                BigDecimal bigDecimal4 = solutionLower = oldLower != null ? oldLower.max(solutionLower) : solutionLower;
                if (variable.isInteger()) {
                    solutionLower = solutionLower.setScale(0, RoundingMode.CEILING);
                }
                newLower = solutionLower;
            } else {
                newLower = oldLower;
            }
            if (solutionUpper != null) {
                BigDecimal bigDecimal5 = solutionUpper = oldUpper != null ? oldUpper.min(solutionUpper) : solutionUpper;
                if (variable.isInteger()) {
                    solutionUpper = solutionUpper.setScale(0, RoundingMode.FLOOR);
                }
                newUpper = solutionUpper;
            } else {
                newUpper = oldUpper;
            }
            ((Variable)variable.lower(newLower)).upper(newUpper);
            if (variable.isInfeasible()) {
                expression.setInfeasible();
            }
        }
        expression.setRedundant(true);
        if (variable.isEqualityConstraint()) {
            variable.setValue(variable.getLowerLimit());
            return true;
        }
        return false;
    }

    static boolean doCase2(Expression expression, BigDecimal fixedValue, HashSet<Structure1D.IntIndex> remaining, Function<Structure1D.IntIndex, Variable> variableResolver, NumberContext precision) {
        BigDecimal newLimit;
        BigDecimal exprUpper;
        BigDecimal exprLower;
        BigDecimal varMinContrB;
        BigDecimal varMaxContrB;
        BigDecimal varMinContrA;
        BigDecimal varMaxContrA;
        Iterator<Structure1D.IntIndex> tmpIterator = remaining.iterator();
        Variable variableA = variableResolver.apply(tmpIterator.next());
        BigDecimal factorA = expression.get(variableA);
        BigDecimal oldLowerA = variableA.getLowerLimit();
        BigDecimal oldUpperA = variableA.getUpperLimit();
        if (factorA.signum() == 1) {
            varMaxContrA = oldUpperA != null ? factorA.multiply(oldUpperA) : null;
            varMinContrA = oldLowerA != null ? factorA.multiply(oldLowerA) : null;
        } else {
            varMinContrA = oldUpperA != null ? factorA.multiply(oldUpperA) : null;
            varMaxContrA = oldLowerA != null ? factorA.multiply(oldLowerA) : null;
        }
        Variable variableB = variableResolver.apply(tmpIterator.next());
        BigDecimal factorB = expression.get(variableB);
        BigDecimal oldLowerB = variableB.getLowerLimit();
        BigDecimal oldUpperB = variableB.getUpperLimit();
        if (factorB.signum() == 1) {
            varMaxContrB = oldUpperB != null ? factorB.multiply(oldUpperB) : null;
            varMinContrB = oldLowerB != null ? factorB.multiply(oldLowerB) : null;
        } else {
            varMinContrB = oldUpperB != null ? factorB.multiply(oldUpperB) : null;
            varMaxContrB = oldLowerB != null ? factorB.multiply(oldLowerB) : null;
        }
        BigDecimal bigDecimal = exprLower = expression.getLowerLimit() != null ? expression.getLowerLimit().subtract(fixedValue) : null;
        if (exprLower != null && varMaxContrA != null && varMaxContrB != null && precision.isLessThan(exprLower, varMaxContrA.add(varMaxContrB))) {
            expression.setInfeasible();
            return false;
        }
        BigDecimal bigDecimal2 = exprUpper = expression.getUpperLimit() != null ? expression.getUpperLimit().subtract(fixedValue) : null;
        if (exprUpper != null && varMinContrA != null && varMinContrB != null && precision.isMoreThan(exprUpper, varMinContrA.add(varMinContrB))) {
            expression.setInfeasible();
            return false;
        }
        BigDecimal newLowerA = oldLowerA;
        BigDecimal newUpperA = oldUpperA;
        BigDecimal newLowerB = oldLowerB;
        BigDecimal newUpperB = oldUpperB;
        if (exprLower != null) {
            if (varMaxContrB != null && varMaxContrB.compareTo(exprLower) < 0) {
                newLimit = BigFunction.DIVIDE.invoke(exprLower.subtract(varMaxContrB), factorA);
                newLimit = oldLowerA != null ? oldLowerA.max(newLimit) : newLimit;
                BigDecimal bigDecimal3 = newLimit = oldUpperA != null ? oldUpperA.min(newLimit) : newLimit;
                if (factorA.signum() == 1) {
                    newLowerA = newLimit;
                } else {
                    newUpperA = newLimit;
                }
            }
            if (varMaxContrA != null && varMaxContrA.compareTo(exprLower) < 0) {
                newLimit = BigFunction.DIVIDE.invoke(exprLower.subtract(varMaxContrA), factorB);
                newLimit = oldLowerB != null ? oldLowerB.max(newLimit) : newLimit;
                BigDecimal bigDecimal4 = newLimit = oldUpperB != null ? oldUpperB.min(newLimit) : newLimit;
                if (factorB.signum() == 1) {
                    newLowerB = newLimit;
                } else {
                    newUpperB = newLimit;
                }
            }
        }
        if (exprUpper != null) {
            if (varMinContrB != null && varMinContrB.compareTo(exprUpper) > 0) {
                newLimit = BigFunction.DIVIDE.invoke(exprUpper.subtract(varMinContrB), factorA);
                newLimit = oldLowerA != null ? oldLowerA.max(newLimit) : newLimit;
                BigDecimal bigDecimal5 = newLimit = oldUpperA != null ? oldUpperA.min(newLimit) : newLimit;
                if (factorA.signum() == 1) {
                    newUpperA = newLimit;
                } else {
                    newLowerA = newLimit;
                }
            }
            if (varMinContrA != null && varMinContrA.compareTo(exprUpper) > 0) {
                newLimit = BigFunction.DIVIDE.invoke(exprUpper.subtract(varMinContrA), factorB);
                newLimit = oldLowerB != null ? oldLowerB.max(newLimit) : newLimit;
                BigDecimal bigDecimal6 = newLimit = oldUpperB != null ? oldUpperB.min(newLimit) : newLimit;
                if (factorB.signum() == 1) {
                    newUpperB = newLimit;
                } else {
                    newLowerB = newLimit;
                }
            }
        }
        if (variableA.isInteger()) {
            if (newLowerA != null) {
                newLowerA = newLowerA.setScale(0, RoundingMode.CEILING);
            }
            if (newUpperA != null) {
                newUpperA = newUpperA.setScale(0, RoundingMode.FLOOR);
            }
        }
        if (variableB.isInteger()) {
            if (newLowerB != null) {
                newLowerB = newLowerB.setScale(0, RoundingMode.CEILING);
            }
            if (newUpperB != null) {
                newUpperB = newUpperB.setScale(0, RoundingMode.FLOOR);
            }
        }
        ((Variable)variableA.lower(newLowerA)).upper(newUpperA);
        ((Variable)variableB.lower(newLowerB)).upper(newUpperB);
        return variableA.isEqualityConstraint() || variableB.isEqualityConstraint();
    }
}

