/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import com.azul.crs.util.logging.Config;
import com.azul.crs.util.logging.Logger;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class LogConfiguration {
    private static final String REGISTRY = "META-INF/crslog.channels.cfg";
    static final Logger.Level downstreamDefaultLevel = Logger.Level.ERROR;
    static final Logger.Level upstreamDefaultLevel = Logger.Level.ERROR;
    private static final Set<String> localStreamAliases = new HashSet<String>(Arrays.asList("", "stderr", "downstream"));
    private static final Set<String> remoteStreamAliases = new HashSet<String>(Arrays.asList("remote", "upstream"));
    boolean showTimestamp = false;
    private final Map<String, String> classToTag = new HashMap<String, String>();
    private final Map<String, Config> tagsConfiguration = new HashMap<String, Config>();
    private Config nonTaggedClasses;

    public LogConfiguration(Collection<Map.Entry<String, String>> collection) {
        Map<String, Logger.Level> map = this.readRegistry();
        StreamConfiguration streamConfiguration = new StreamConfiguration(localStreamAliases);
        StreamConfiguration streamConfiguration2 = new StreamConfiguration(remoteStreamAliases);
        this.parseOptions(streamConfiguration, streamConfiguration2, collection);
        this.merge(map, streamConfiguration, streamConfiguration2);
    }

    public void reconfigure(Collection<Map.Entry<String, String>> collection) {
        StreamConfiguration streamConfiguration = new StreamConfiguration(localStreamAliases);
        StreamConfiguration streamConfiguration2 = new StreamConfiguration(remoteStreamAliases);
        this.parseOptions(streamConfiguration, streamConfiguration2, collection);
        this._reconfigure(streamConfiguration, streamConfiguration2);
    }

    public String getTagForClass(String string) {
        return this.classToTag.get(string);
    }

    public Config getConfig(String string) {
        if (string == null) {
            return this.nonTaggedClasses;
        }
        return this.tagsConfiguration.get(string);
    }

    private void _reconfigure(StreamConfiguration streamConfiguration, StreamConfiguration streamConfiguration2) {
        for (Map.Entry<String, Config> entry : this.tagsConfiguration.entrySet()) {
            String string = entry.getKey();
            Map.Entry entry2 = streamConfiguration.getConfig(string);
            Map.Entry entry3 = streamConfiguration2.getConfig(string);
            entry.getValue().reconfigure(entry2, entry3);
        }
        this.nonTaggedClasses.reconfigure(streamConfiguration.streamConfig, streamConfiguration2.streamConfig);
    }

    private void merge(Map<String, Logger.Level> map, StreamConfiguration streamConfiguration, StreamConfiguration streamConfiguration2) {
        for (Map.Entry<String, Logger.Level> entry : map.entrySet()) {
            AbstractMap.SimpleEntry<Logger.Level, Boolean> simpleEntry;
            String string = entry.getKey();
            AbstractMap.SimpleEntry<Logger.Level, Boolean> simpleEntry2 = streamConfiguration.getConfig(string);
            if (simpleEntry2 == null) {
                simpleEntry2 = new AbstractMap.SimpleEntry<Logger.Level, Boolean>(downstreamDefaultLevel, false);
            }
            if ((simpleEntry = streamConfiguration2.getConfig(string)) == null) {
                simpleEntry = new AbstractMap.SimpleEntry<Logger.Level, Boolean>(entry.getValue(), false);
            }
            this.tagsConfiguration.put(string, new Config((Logger.Level)((Object)simpleEntry.getKey()), (Logger.Level)((Object)simpleEntry2.getKey()), (Boolean)simpleEntry.getValue(), (Boolean)simpleEntry2.getValue()));
        }
        this.nonTaggedClasses = this.createDefault(streamConfiguration2.streamConfig, streamConfiguration.streamConfig);
    }

    private Config createDefault(Map.Entry<Logger.Level, Boolean> entry, Map.Entry<Logger.Level, Boolean> entry2) {
        Logger.Level level = upstreamDefaultLevel;
        Logger.Level level2 = downstreamDefaultLevel;
        boolean bl = false;
        boolean bl2 = false;
        if (entry != null) {
            level = entry.getKey();
            bl = entry.getValue();
        }
        if (entry2 != null) {
            level2 = entry2.getKey();
            bl2 = entry2.getValue();
        }
        return new Config(level, level2, bl, bl2);
    }

    public boolean showTimestamp() {
        return this.showTimestamp;
    }

    private void parseOptions(StreamConfiguration streamConfiguration, StreamConfiguration streamConfiguration2, Collection<Map.Entry<String, String>> collection) {
        for (Map.Entry<String, String> entry : collection) {
            StreamConfiguration streamConfiguration3;
            Logger.Level level;
            String string = entry.getKey();
            if (!this.isValid(string)) continue;
            String string2 = entry.getValue();
            boolean bl = false;
            while (true) {
                int n;
                if (string2.endsWith("+stack")) {
                    bl = true;
                    n = 6;
                } else {
                    if (!string2.endsWith("+time")) break;
                    this.showTimestamp = true;
                    n = 5;
                }
                string2 = string2.substring(0, string2.length() - n);
            }
            try {
                level = Logger.Level.valueOf(string2.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("[CRS.log][error] unsupported log level '" + string2 + "'");
                continue;
            }
            int n = string.indexOf("+");
            String string3 = null;
            if (n > 0) {
                string3 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((streamConfiguration3 = this.getCorrectStream(streamConfiguration, streamConfiguration2, string)) == null) {
                System.err.println("[CRS.log][error] unsupported stream in log option '" + string + "'");
                continue;
            }
            if (string3 == null || string3.isEmpty()) {
                streamConfiguration3.add(level, bl);
                continue;
            }
            for (String string4 : this.getTags(string3)) {
                if ("vm".equals(string3)) continue;
                streamConfiguration3.add(string4, level, bl);
            }
        }
    }

    private boolean isValid(String string) {
        return string != null && (string.equals("log") || string.startsWith("log:") || string.startsWith("log+"));
    }

    private String[] getTags(String string) {
        return string.split(",");
    }

    private StreamConfiguration getCorrectStream(StreamConfiguration streamConfiguration, StreamConfiguration streamConfiguration2, String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        if (streamConfiguration.support(string2)) {
            return streamConfiguration;
        }
        if (streamConfiguration2.support(string2)) {
            return streamConfiguration2;
        }
        return null;
    }

    private Map<String, Logger.Level> readRegistry() {
        HashMap<String, Logger.Level> hashMap = new HashMap<String, Logger.Level>();
        String string = LogConfiguration.class.getName().replace(".util.logging.LogConfiguration", "");
        int n = string.length();
        boolean bl = n > 12;
        try {
            HashSet<URL> hashSet = new HashSet<URL>();
            ClassLoader classLoader = Logger.class.getClassLoader();
            if (classLoader != null) {
                hashSet.addAll(Collections.list(classLoader.getResources(REGISTRY)));
            }
            hashSet.addAll(Collections.list(ClassLoader.getSystemResources(REGISTRY)));
            for (URL uRL : hashSet) {
                Properties properties = new Properties();
                InputStream inputStream = uRL.openStream();
                Throwable throwable = null;
                try {
                    properties.load(inputStream);
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = enumeration.nextElement().toString();
                        String string4 = properties.getProperty(string3);
                        Logger.Level level = upstreamDefaultLevel;
                        int n2 = string4.lastIndexOf(58);
                        if (n2 > 0) {
                            string2 = string4.substring(0, n2);
                            level = Logger.Level.valueOf(string4.substring(n2 + 1));
                        } else {
                            string2 = string4;
                        }
                        hashMap.put(string2, level);
                        if (bl) {
                            string3 = string + string3.substring(12);
                        }
                        this.classToTag.put(string3, string2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(Level.SEVERE, null, throwable);
        }
        return hashMap;
    }

    private class StreamConfiguration {
        private final Set<String> aliases;
        private Map.Entry<Logger.Level, Boolean> streamConfig = null;
        private Map<String, Map.Entry<Logger.Level, Boolean>> tagToConfig = new HashMap<String, Map.Entry<Logger.Level, Boolean>>();

        public StreamConfiguration(Set<String> set) {
            this.aliases = set;
        }

        public boolean support(String string) {
            return this.aliases.contains(string);
        }

        public void add(Logger.Level level, boolean bl) {
            this.streamConfig = new AbstractMap.SimpleEntry<Logger.Level, Boolean>(level, bl);
        }

        public void add(String string, Logger.Level level, boolean bl) {
            this.tagToConfig.put(string, new AbstractMap.SimpleEntry<Logger.Level, Boolean>(level, bl));
        }

        public Map.Entry getConfig(String string) {
            Map.Entry<Logger.Level, Boolean> entry = this.tagToConfig.get(string);
            if (entry == null) {
                return this.streamConfig;
            }
            return entry;
        }
    }
}

