/*
 * Decompiled with CFR 0.152.
 */
package fiji.process;

import fiji.expressionparser.ImgLibParser;
import fiji.process.IepGui;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Image_Expression_Parser<T extends RealType<T> & NativeType<T>>
implements PlugIn,
OutputAlgorithm<Img<T>> {
    protected boolean user_has_canceled = false;
    protected Map<String, Img<T>> image_map;
    protected String expression;
    protected Img<T> result = null;
    protected String error_message = "";

    public void run(String arg) {
        if (arg.equals("macro")) {
            this.showDialog();
        } else {
            IepGui<T> gui = this.displayGUI();
            gui.setIep(this);
        }
    }

    public boolean checkInput() {
        if (!this.dimensionsAreValid()) {
            this.error_message = "Input images do not have all the same dimensions.";
            return false;
        }
        Object[] validity = this.isExpressionValid();
        boolean is_valid = (Boolean)validity[0];
        String error_msg = (String)validity[1];
        if (!is_valid) {
            this.error_message = "Expression is invalid:\n" + error_msg;
            return false;
        }
        return true;
    }

    public boolean process() {
        this.result = null;
        boolean valid = this.checkInput();
        if (!valid) {
            return false;
        }
        ImgLibParser parser = new ImgLibParser();
        parser.addStandardConstants();
        parser.addStandardFunctions();
        parser.addImgLibAlgorithms();
        Set<String> variables = this.image_map.keySet();
        for (String var : variables) {
            parser.addVariable(var, this.image_map.get(var));
        }
        try {
            Node root_node = parser.parse(this.expression);
            this.result = (Img)parser.evaluate(root_node);
            this.error_message = "";
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.error_message = e.getErrorInfo();
            return false;
        }
    }

    public Img<T> getResult() {
        return this.result;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public void setExpression(String _expression) {
        this.expression = _expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setImageMap(Map<String, Img<T>> im) {
        this.image_map = im;
    }

    public Map<String, Img<T>> getImageMap() {
        return this.image_map;
    }

    private IepGui<T> displayGUI() {
        IepGui gui = new IepGui();
        gui.setLocationRelativeTo(null);
        gui.setVisible(true);
        return gui;
    }

    private boolean dimensionsAreValid() {
        if (this.image_map.size() == 1) {
            return true;
        }
        Collection<Img<T>> images = this.image_map.values();
        Iterator<Img<T>> it = images.iterator();
        Img<T> img = it.next();
        long[] previous_dims = new long[img.numDimensions()];
        img.dimensions(previous_dims);
        while (it.hasNext()) {
            img = it.next();
            long[] dims = new long[img.numDimensions()];
            img.dimensions(dims);
            if (previous_dims.length != dims.length) {
                return false;
            }
            for (int j = 0; j < dims.length; ++j) {
                if (dims[j] == previous_dims[j]) continue;
                return false;
            }
            previous_dims = dims;
        }
        return true;
    }

    private Object[] isExpressionValid() {
        ImgLibParser parser = new ImgLibParser();
        parser.addStandardConstants();
        parser.addStandardFunctions();
        parser.addImgLibAlgorithms();
        Set<String> variables = this.image_map.keySet();
        for (String var : variables) {
            parser.addVariable(var, null);
        }
        parser.parseExpression(this.expression);
        String error = parser.getErrorInfo();
        if (null == error) {
            return new Object[]{true, ""};
        }
        return new Object[]{false, error};
    }

    public Map<String, Img<T>> convertToImglib(Map<String, ImagePlus> imp_map) {
        HashMap<String, Img<T>> map = new HashMap<String, Img<T>>(imp_map.size());
        Set<String> variables = imp_map.keySet();
        for (String var : variables) {
            ImagePlusImg img = ImagePlusAdapter.wrap((ImagePlus)imp_map.get(var));
            map.put(var, (Img<T>)img);
        }
        return map;
    }

    private void showDialog() {
        int i;
        String prefix = "expression.parser.";
        int n_images = WindowManager.getImageCount();
        String[] image_names = new String[n_images + 1];
        char[] letters = "ABCDEFGHIJKLMNOPQRTSUVWXYZ".toCharArray();
        image_names[0] = "None";
        for (int i2 = 0; i2 < n_images; ++i2) {
            image_names[i2 + 1] = WindowManager.getImage((int)(i2 + 1)).getTitle();
        }
        GenericDialog gd = new GenericDialog("Image Expression Parser");
        this.expression = Prefs.get((String)"expression.parser.expression.val", (String)"A^2");
        gd.addStringField("Expression", this.expression, 20);
        for (i = 0; i < n_images; ++i) {
            String tmp_choice = Prefs.get((String)("expression.parser.image.selection." + i), (String)image_names[i + 1]);
            gd.addChoice(String.valueOf(letters[i]), image_names, tmp_choice);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.expression = gd.getNextString();
        Prefs.set((String)"expression.parser.expression.val", (String)this.expression);
        this.image_map = new HashMap<String, Img<T>>(1);
        for (i = 0; i < n_images; ++i) {
            String im = gd.getNextChoice();
            if (im.equals("None")) continue;
            Prefs.set((String)("expression.parser.image.selection." + i), (String)im);
            this.image_map.put(String.valueOf(letters[i]), (Img<T>)ImagePlusAdapter.wrap((ImagePlus)WindowManager.getImage((String)im)));
        }
        if (this.process()) {
            ImageJFunctions.show(this.getResult(), (String)("Parsed with " + this.expression));
        } else {
            IJ.error((String)this.error_message);
        }
    }

    public static <T extends RealType<T> & NativeType<T>> void main(String[] args) {
        ImagePlus imp = IJ.openImage((String)"http://rsb.info.nih.gov/ij/images/blobs.gif");
        ImagePlusImg img = ImagePlusAdapter.wrap((ImagePlus)imp);
        imp.show();
        Image_Expression_Parser<T> iep = new Image_Expression_Parser<T>();
        iep.setExpression("A^2");
        HashMap<String, Img<T>> map = new HashMap<String, Img<T>>(1);
        map.put("A", (Img<T>)img);
        iep.setImageMap(map);
        boolean everything_went_fine = iep.process();
        Img<T> result = iep.getResult();
        if (everything_went_fine) {
            ImagePlus result_imp = ImageJFunctions.show(result);
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int i = 0; i < result_imp.getStackSize(); ++i) {
                FloatProcessor fp = (FloatProcessor)result_imp.getStack().getProcessor(i + 1);
                float[] arr = (float[])fp.getPixels();
                for (int j = 0; j < arr.length; ++j) {
                    if (arr[j] > max) {
                        max = arr[j];
                    }
                    if (!(arr[j] < min)) continue;
                    min = arr[j];
                }
            }
            result_imp.show();
            result_imp.setDisplayRange((double)min, (double)max);
            result_imp.updateAndDraw();
        } else {
            System.err.println("Could not evaluate expression:");
            System.err.println(iep.getErrorMessage());
        }
    }
}

