/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingPolytope;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.Context;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.GeometryUpdater;
import org.scijava.java3d.IndexedGeometryArrayRetained;
import org.scijava.java3d.J3DBuffer;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.MorphRetained;
import org.scijava.java3d.PickCone;
import org.scijava.java3d.PickConeRay;
import org.scijava.java3d.PickConeSegment;
import org.scijava.java3d.PickCylinder;
import org.scijava.java3d.PickCylinderRay;
import org.scijava.java3d.PickCylinderSegment;
import org.scijava.java3d.PickPoint;
import org.scijava.java3d.PickRay;
import org.scijava.java3d.Pipeline;
import org.scijava.java3d.RenderAtom;
import org.scijava.java3d.RenderAtomListInfo;
import org.scijava.java3d.RenderBin;
import org.scijava.java3d.SceneGraphObjectRetained;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.Utils;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Color3b;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4b;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point2d;
import org.scijava.vecmath.Point2f;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Point4d;
import org.scijava.vecmath.Point4f;
import org.scijava.vecmath.TexCoord2f;
import org.scijava.vecmath.TexCoord3f;
import org.scijava.vecmath.TexCoord4f;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3d;
import org.scijava.vecmath.Vector3f;

abstract class GeometryArrayRetained
extends GeometryRetained {
    int vertexFormat;
    int c4fAllocated = 0;
    int vertexCount;
    int validVertexCount;
    float[] vertexData;
    private float[][] mvertexData;
    int stride;
    int texCoordStride;
    int coordinateOffset;
    int normalOffset;
    int colorOffset;
    int textureOffset;
    int[] vertexAttrOffsets;
    int vertexAttrStride;
    private float[] lastAlpha = new float[1];
    float lastScreenAlpha = -1.0f;
    int colorChanged = 0;
    static final float ByteToFloatScale = 0.003921569f;
    static final float FloatToByteScale = 255.0f;
    boolean inUpdater = false;
    ArrayList<GeometryAtom> gaList = new ArrayList(1);
    static final int targetThreads = 192;
    float[] floatRefCoords = null;
    double[] doubleRefCoords = null;
    Point3d[] p3dRefCoords = null;
    Point3f[] p3fRefCoords = null;
    J3DBuffer coordRefBuffer = null;
    FloatBuffer floatBufferRefCoords = null;
    DoubleBuffer doubleBufferRefCoords = null;
    int initialCoordIndex = 0;
    int initialColorIndex = 0;
    int initialNormalIndex = 0;
    int[] initialTexCoordIndex = null;
    int[] initialVertexAttrIndex = null;
    int initialVertexIndex = 0;
    float[] floatRefColors = null;
    byte[] byteRefColors = null;
    Color3f[] c3fRefColors = null;
    Color4f[] c4fRefColors = null;
    Color3b[] c3bRefColors = null;
    Color4b[] c4bRefColors = null;
    J3DBuffer colorRefBuffer = null;
    FloatBuffer floatBufferRefColors = null;
    ByteBuffer byteBufferRefColors = null;
    int vertexType = 0;
    static final int PF = 1;
    static final int PD = 2;
    static final int P3F = 4;
    static final int P3D = 8;
    static final int VERTEX_DEFINED = 15;
    static final int CF = 16;
    static final int CUB = 32;
    static final int C3F = 64;
    static final int C4F = 128;
    static final int C3UB = 256;
    static final int C4UB = 512;
    static final int COLOR_DEFINED = 1008;
    static final int NF = 1024;
    static final int N3F = 2048;
    static final int NORMAL_DEFINED = 3072;
    static final int TF = 4096;
    static final int T2F = 8192;
    static final int T3F = 16384;
    static final int TEXCOORD_DEFINED = 28672;
    static final int AF = 32768;
    static final int VATTR_DEFINED = 32768;
    private int texCoordType = 0;
    private int vertexAttrType = 0;
    static final int COORD_FLOAT = 1;
    static final int COORD_DOUBLE = 2;
    static final int COLOR_FLOAT = 4;
    static final int COLOR_BYTE = 8;
    static final int NORMAL_FLOAT = 16;
    static final int TEXCOORD_FLOAT = 32;
    static final int VATTR_FLOAT = 64;
    float[] floatRefNormals = null;
    Vector3f[] v3fRefNormals = null;
    J3DBuffer normalRefBuffer = null;
    FloatBuffer floatBufferRefNormals = null;
    float[][] floatRefVertexAttrs = null;
    J3DBuffer[] vertexAttrsRefBuffer = null;
    FloatBuffer[] floatBufferRefVertexAttrs = null;
    Object[] refTexCoords = null;
    TexCoord2f[] t2fRefTexCoords = null;
    TexCoord3f[] t3fRefTexCoords = null;
    J3DBuffer[] refTexCoordsBuffer = null;
    float[] interLeavedVertexData = null;
    J3DBuffer interleavedVertexBuffer = null;
    FloatBuffer interleavedFloatBufferImpl = null;
    float[] mirrorFloatRefCoords = null;
    double[] mirrorDoubleRefCoords = null;
    float[] mirrorFloatRefNormals = null;
    float[][] mirrorFloatRefVertexAttrs = null;
    float[] mirrorFloatRefTexCoords = null;
    Object[] mirrorRefTexCoords = null;
    float[][] mirrorFloatRefColors = new float[1][];
    byte[][] mirrorUnsignedByteRefColors = new byte[1][];
    float[][] mirrorInterleavedColorPointer = null;
    int mirrorVertexAllocated = 0;
    int mirrorColorAllocated = 0;
    boolean mirrorNormalAllocated = false;
    static final int COORDINATE_CHANGED = 1;
    static final int NORMAL_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int TEXTURE_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int INDEX_CHANGED = 32;
    static final int STRIPCOUNT_CHANGED = 64;
    static final int VATTR_CHANGED = 128;
    static final int VERTEX_CHANGED = 143;
    static final int[] defaultTexCoordSetMap = new int[]{0};
    int texCoordSetCount = 0;
    int[] texCoordSetMap = null;
    int[] texCoordSetMapOffset = null;
    int vertexAttrCount = 0;
    int[] vertexAttrSizes = null;
    int dirtyFlag = 175;
    int resourceCreationMask = 0;
    private HashMap<RenderBin, HashSet<RenderAtomListInfo>> dlistUsers = null;
    private long[] timeStampPerDlist = new long[2];
    int dlistId = -1;
    Integer dlistObj = null;
    static final int INIT_MIRROR_GEOMETRY = 2;
    ArrayList<VirtualUniverse> morphUniverseList = null;
    ArrayList<ArrayList<MorphRetained>> morphUserLists = null;
    int[] geoOffset;
    int[] compileVcount;
    boolean isCompiled = false;
    boolean isShared = false;
    IndexedGeometryArrayRetained cloneSourceArray = null;
    static final double EPS = 1.0E-13;

    GeometryArrayRetained() {
        this.lastAlpha[0] = 1.0f;
    }

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        this.dirtyFlag = 175;
        this.isEditable = !this.isWriteStatic();
        super.doSetLive(inBackgroundGroup, refCount);
        super.markAsLive();
        if (this.refCount > 1) {
            this.isShared = true;
        } else if (this instanceof IndexedGeometryArrayRetained) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 1024;
            createMessage.type = 17;
            createMessage.universe = null;
            createMessage.args[0] = null;
            createMessage.args[1] = this;
            createMessage.args[2] = new Integer(2);
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.refCount <= 0) {
            this.isShared = false;
        }
    }

    @Override
    void computeBoundingBox() {
        if (this.boundsDirty && VirtualUniverse.mc.cacheAutoComputedBounds) {
            for (ArrayList users : this.userLists) {
                for (Shape3DRetained shape : users) {
                    shape.dirtyBoundsCache();
                }
            }
        }
        if ((this.vertexFormat & 0x80) == 0) {
            this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        } else if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                this.computeBoundingBox(this.initialCoordIndex, this.interleavedFloatBufferImpl);
            } else if ((this.vertexType & 1) != 0) {
                this.computeBoundingBox(this.floatBufferRefCoords);
            } else if ((this.vertexType & 2) != 0) {
                this.computeBoundingBox(this.doubleBufferRefCoords);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            this.computeBoundingBox(this.initialCoordIndex, this.interLeavedVertexData);
        } else if ((this.vertexType & 1) != 0) {
            this.computeBoundingBox(this.floatRefCoords);
        } else if ((this.vertexType & 4) != 0) {
            this.computeBoundingBox(this.p3fRefCoords);
        } else if ((this.vertexType & 8) != 0) {
            this.computeBoundingBox(this.p3dRefCoords);
        } else if ((this.vertexType & 2) != 0) {
            this.computeBoundingBox(this.doubleRefCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCoordsChanged(boolean nullGeo) {
        if (nullGeo) {
            BoundingBox boundingBox = this.geoBounds;
            synchronized (boundingBox) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
                this.boundsDirty = false;
            }
            boundingBox = this.centroid;
            synchronized (boundingBox) {
                this.recompCentroid = false;
                this.geoBounds.getCenter(this.centroid);
            }
        }
        Object object = this.centroid;
        synchronized (object) {
            this.recompCentroid = true;
        }
        object = this.geoBounds;
        synchronized (object) {
            this.boundsDirty = true;
            this.computeBoundingBox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int vIndex, float[] vdata) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int offset = vIndex * this.stride + this.coordinateOffset;
            double xmin = xmax = (double)vdata[offset];
            double ymin = ymax = (double)vdata[offset + 1];
            double zmin = zmax = (double)vdata[offset + 2];
            offset += this.stride;
            for (int i = 1; i < this.validVertexCount; ++i) {
                if ((double)vdata[offset] > xmax) {
                    xmax = vdata[offset];
                }
                if ((double)vdata[offset] < xmin) {
                    xmin = vdata[offset];
                }
                if ((double)vdata[offset + 1] > ymax) {
                    ymax = vdata[offset + 1];
                }
                if ((double)vdata[offset + 1] < ymin) {
                    ymin = vdata[offset + 1];
                }
                if ((double)vdata[offset + 2] > zmax) {
                    zmax = vdata[offset + 2];
                }
                if ((double)vdata[offset + 2] < zmin) {
                    zmin = vdata[offset + 2];
                }
                offset += this.stride;
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int vIndex, FloatBuffer vdata) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int offset = vIndex * this.stride + this.coordinateOffset;
            double xmin = xmax = (double)vdata.get(offset);
            double ymin = ymax = (double)vdata.get(offset + 1);
            double zmin = zmax = (double)vdata.get(offset + 2);
            offset += this.stride;
            for (int i = 1; i < this.validVertexCount; ++i) {
                if ((double)vdata.get(offset) > xmax) {
                    xmax = vdata.get(offset);
                }
                if ((double)vdata.get(offset) < xmin) {
                    xmin = vdata.get(offset);
                }
                if ((double)vdata.get(offset + 1) > ymax) {
                    ymax = vdata.get(offset + 1);
                }
                if ((double)vdata.get(offset + 1) < ymin) {
                    ymin = vdata.get(offset + 1);
                }
                if ((double)vdata.get(offset + 2) > zmax) {
                    zmax = vdata.get(offset + 2);
                }
                if ((double)vdata.get(offset + 2) < zmin) {
                    zmin = vdata.get(offset + 2);
                }
                offset += this.stride;
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(DoubleBuffer buffer) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int sIndex = this.initialCoordIndex;
            int maxIndex = 3 * this.validVertexCount;
            double xmin = xmax = buffer.get(sIndex++);
            double ymin = ymax = buffer.get(sIndex++);
            double zmin = zmax = buffer.get(sIndex++);
            for (int i = sIndex; i < maxIndex; i += 3) {
                int j = i + 1;
                int k = i + 2;
                if (buffer.get(i) > xmax) {
                    xmax = buffer.get(i);
                }
                if (buffer.get(i) < xmin) {
                    xmin = buffer.get(i);
                }
                if (buffer.get(j) > ymax) {
                    ymax = buffer.get(j);
                }
                if (buffer.get(j) < ymin) {
                    ymin = buffer.get(j);
                }
                if (buffer.get(k) > zmax) {
                    zmax = buffer.get(k);
                }
                if (!(buffer.get(k) < zmin)) continue;
                zmin = buffer.get(k);
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(FloatBuffer buffer) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int sIndex = this.initialCoordIndex;
            int maxIndex = 3 * this.validVertexCount;
            double xmin = xmax = (double)buffer.get(sIndex++);
            double ymin = ymax = (double)buffer.get(sIndex++);
            double zmin = zmax = (double)buffer.get(sIndex++);
            for (int i = sIndex; i < maxIndex; i += 3) {
                int j = i + 1;
                int k = i + 2;
                if ((double)buffer.get(i) > xmax) {
                    xmax = buffer.get(i);
                }
                if ((double)buffer.get(i) < xmin) {
                    xmin = buffer.get(i);
                }
                if ((double)buffer.get(j) > ymax) {
                    ymax = buffer.get(j);
                }
                if ((double)buffer.get(j) < ymin) {
                    ymin = buffer.get(j);
                }
                if ((double)buffer.get(k) > zmax) {
                    zmax = buffer.get(k);
                }
                if (!((double)buffer.get(k) < zmin)) continue;
                zmin = buffer.get(k);
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(float[] coords) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int sIndex = this.initialCoordIndex;
            int maxIndex = 3 * this.validVertexCount;
            double xmin = xmax = (double)coords[sIndex++];
            double ymin = ymax = (double)coords[sIndex++];
            double zmin = zmax = (double)coords[sIndex++];
            for (int i = sIndex; i < maxIndex; i += 3) {
                int j = i + 1;
                int k = i + 2;
                if ((double)coords[i] > xmax) {
                    xmax = coords[i];
                }
                if ((double)coords[i] < xmin) {
                    xmin = coords[i];
                }
                if ((double)coords[j] > ymax) {
                    ymax = coords[j];
                }
                if ((double)coords[j] < ymin) {
                    ymin = coords[j];
                }
                if ((double)coords[k] > zmax) {
                    zmax = coords[k];
                }
                if (!((double)coords[k] < zmin)) continue;
                zmin = coords[k];
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(double[] coords) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int sIndex = this.initialCoordIndex;
            int maxIndex = 3 * this.validVertexCount;
            double xmin = xmax = coords[sIndex++];
            double ymin = ymax = coords[sIndex++];
            double zmin = zmax = coords[sIndex++];
            for (int i = sIndex; i < maxIndex; i += 3) {
                int j = i + 1;
                int k = i + 2;
                if (coords[i] > xmax) {
                    xmax = coords[i];
                }
                if (coords[i] < xmin) {
                    xmin = coords[i];
                }
                if (coords[j] > ymax) {
                    ymax = coords[j];
                }
                if (coords[j] < ymin) {
                    ymin = coords[j];
                }
                if (coords[k] > zmax) {
                    zmax = coords[k];
                }
                if (!(coords[k] < zmin)) continue;
                zmin = coords[k];
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3f[] coords) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double xmin = xmax = (double)coords[this.initialCoordIndex].x;
            double ymin = ymax = (double)coords[this.initialCoordIndex].y;
            double zmin = zmax = (double)coords[this.initialCoordIndex].z;
            for (int i = this.initialCoordIndex + 1; i < this.validVertexCount; ++i) {
                Point3f p = coords[i];
                if ((double)p.x > xmax) {
                    xmax = p.x;
                }
                if ((double)p.x < xmin) {
                    xmin = p.x;
                }
                if ((double)p.y > ymax) {
                    ymax = p.y;
                }
                if ((double)p.y < ymin) {
                    ymin = p.y;
                }
                if ((double)p.z > zmax) {
                    zmax = p.z;
                }
                if (!((double)p.z < zmin)) continue;
                zmin = p.z;
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3d[] coords) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double zmax;
            double ymax;
            double xmax;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double xmin = xmax = coords[this.initialCoordIndex].x;
            double ymin = ymax = coords[this.initialCoordIndex].y;
            double zmin = zmax = coords[this.initialCoordIndex].z;
            for (int i = this.initialCoordIndex + 1; i < this.validVertexCount; ++i) {
                Point3d p = coords[i];
                if (p.x > xmax) {
                    xmax = p.x;
                }
                if (p.x < xmin) {
                    xmin = p.x;
                }
                if (p.y > ymax) {
                    ymax = p.y;
                }
                if (p.y < ymin) {
                    ymin = p.y;
                }
                if (p.z > zmax) {
                    zmax = p.z;
                }
                if (!(p.z < zmin)) continue;
                zmin = p.z;
            }
            this.geoBounds.setUpper(xmax, ymax, zmax);
            this.geoBounds.setLower(xmin, ymin, zmin);
            this.boundsDirty = false;
        }
    }

    @Override
    synchronized void update() {
    }

    void setupMirrorVertexPointer(int vType) {
        switch (vType) {
            case 1: {
                if (this.floatRefCoords == null) {
                    if ((this.vertexType & 0xF) != 1) break;
                    this.vertexType &= 0xFFFFFFFE;
                    this.mirrorFloatRefCoords = null;
                    this.mirrorVertexAllocated &= 0xFFFFFFFE;
                    break;
                }
                this.vertexType |= 1;
                this.mirrorFloatRefCoords = this.floatRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFE;
                break;
            }
            case 2: {
                if (this.doubleRefCoords == null) {
                    if ((this.vertexType & 0xF) == 2) {
                        this.mirrorDoubleRefCoords = null;
                        this.mirrorVertexAllocated &= 0xFFFFFFFD;
                        this.vertexType &= 0xFFFFFFFD;
                    }
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                this.vertexType |= 2;
                this.mirrorDoubleRefCoords = this.doubleRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFD;
                break;
            }
            case 4: {
                if (this.p3fRefCoords == null) {
                    this.vertexType &= 0xFFFFFFFB;
                    break;
                }
                this.vertexType |= 4;
                if ((this.mirrorVertexAllocated & 1) == 0) {
                    this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 1;
                }
                int index = this.initialCoordIndex * 3;
                for (int i = this.initialCoordIndex; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefCoords[index++] = this.p3fRefCoords[i].x;
                    this.mirrorFloatRefCoords[index++] = this.p3fRefCoords[i].y;
                    this.mirrorFloatRefCoords[index++] = this.p3fRefCoords[i].z;
                }
                break;
            }
            case 8: {
                if (this.p3dRefCoords == null) {
                    this.vertexType &= 0xFFFFFFF7;
                    break;
                }
                this.vertexType |= 8;
                if ((this.mirrorVertexAllocated & 2) == 0) {
                    this.mirrorDoubleRefCoords = new double[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 2;
                }
                int index = this.initialCoordIndex * 3;
                for (int i = this.initialCoordIndex; i < this.validVertexCount; ++i) {
                    this.mirrorDoubleRefCoords[index++] = this.p3dRefCoords[i].x;
                    this.mirrorDoubleRefCoords[index++] = this.p3dRefCoords[i].y;
                    this.mirrorDoubleRefCoords[index++] = this.p3dRefCoords[i].z;
                }
                break;
            }
        }
    }

    void setupMirrorInterleavedColorPointer(boolean force) {
        if (force || this.c4fAllocated != 0) {
            int length = 4 * this.vertexCount;
            if (this.mirrorInterleavedColorPointer == null) {
                this.mirrorInterleavedColorPointer = new float[1][length];
            }
            int index = 4 * this.initialVertexIndex;
            int offset = this.stride * this.initialVertexIndex + this.colorOffset;
            if ((this.vertexFormat & 0x800) == 0 && this.interLeavedVertexData != null) {
                if ((this.vertexFormat & 8) != 0) {
                    for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset];
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset + 1];
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset + 2];
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset + 3];
                        offset += this.stride;
                    }
                } else {
                    for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset];
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset + 1];
                        this.mirrorInterleavedColorPointer[0][index++] = this.interLeavedVertexData[offset + 2];
                        this.mirrorInterleavedColorPointer[0][index++] = 1.0f;
                        offset += this.stride;
                    }
                }
            } else if ((this.vertexFormat & 8) != 0 && this.interleavedFloatBufferImpl != null) {
                for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                    this.interleavedFloatBufferImpl.position(offset);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], index, 4);
                    index += 4;
                    offset += this.stride;
                }
            } else {
                for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                    this.interleavedFloatBufferImpl.position(offset);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], index, 3);
                    this.mirrorInterleavedColorPointer[0][index + 3] = 1.0f;
                    index += 4;
                    offset += this.stride;
                }
            }
            this.c4fAllocated = 8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setupMirrorColorPointer(int ctype, boolean force) {
        block61: {
            int dstIndex;
            int srcIndex;
            block63: {
                block62: {
                    int multiplier;
                    srcIndex = 0;
                    dstIndex = 0;
                    if (this.c4fAllocated == 0 && !force) {
                        multiplier = 3;
                    } else {
                        if (force && this.c4fAllocated == 0 && (this.vertexFormat & 8) == 0) {
                            this.mirrorColorAllocated = 0;
                        }
                        this.c4fAllocated = 8;
                        multiplier = 4;
                    }
                    if ((this.vertexFormat & 0x800) != 0) break block62;
                    switch (ctype) {
                        case 16: {
                            if (this.floatRefColors == null) {
                                if (this.c4fAllocated == 0 && !force && (this.vertexType & 0x3F0) == 16) {
                                    this.mirrorFloatRefColors[0] = null;
                                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                                }
                                this.vertexType &= 0xFFFFFFEF;
                                return;
                            }
                            this.vertexType |= 0x10;
                            if (this.c4fAllocated == 0 && !force) {
                                this.mirrorFloatRefColors[0] = this.floatRefColors;
                                this.mirrorColorAllocated &= 0xFFFFFFEF;
                                break;
                            }
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            if ((this.vertexFormat & 8) == 0) {
                                srcIndex = this.initialColorIndex * 3;
                                dstIndex = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.floatRefColors[srcIndex++];
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.floatRefColors[srcIndex++];
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.floatRefColors[srcIndex++];
                                    this.mirrorFloatRefColors[0][dstIndex++] = 1.0f;
                                }
                                break block61;
                            } else {
                                srcIndex = this.initialColorIndex * 4;
                                System.arraycopy(this.floatRefColors, srcIndex, this.mirrorFloatRefColors[0], srcIndex, 4 * this.validVertexCount);
                                break;
                            }
                        }
                        case 32: {
                            if (this.byteRefColors == null) {
                                if (this.c4fAllocated == 0 && !force && (this.vertexType & 0x3F0) == 32) {
                                    this.mirrorUnsignedByteRefColors[0] = null;
                                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                                }
                                this.vertexType &= 0xFFFFFFDF;
                                return;
                            }
                            this.vertexType |= 0x20;
                            if (this.c4fAllocated == 0 && !force) {
                                this.mirrorUnsignedByteRefColors[0] = this.byteRefColors;
                                this.mirrorColorAllocated &= 0xFFFFFFDF;
                                break;
                            }
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            if ((this.vertexFormat & 8) == 0) {
                                srcIndex = this.initialColorIndex * 3;
                                dstIndex = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.byteRefColors[srcIndex++];
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.byteRefColors[srcIndex++];
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.byteRefColors[srcIndex++];
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = -1;
                                }
                                break block61;
                            } else {
                                srcIndex = this.initialColorIndex * 4;
                                System.arraycopy(this.byteRefColors, srcIndex, this.mirrorUnsignedByteRefColors[0], srcIndex, 4 * this.validVertexCount);
                                break;
                            }
                        }
                        case 64: {
                            if (this.c3fRefColors == null) {
                                this.vertexType &= 0xFFFFFFBF;
                                return;
                            }
                            this.vertexType |= 0x40;
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[this.vertexCount * multiplier];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            if ((this.c4fAllocated & 8) == 0) {
                                dstIndex = this.initialColorIndex * 3;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.c3fRefColors[i].x;
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.c3fRefColors[i].y;
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.c3fRefColors[i].z;
                                }
                                break block61;
                            } else {
                                dstIndex = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.c3fRefColors[i].x;
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.c3fRefColors[i].y;
                                    this.mirrorFloatRefColors[0][dstIndex++] = this.c3fRefColors[i].z;
                                    this.mirrorFloatRefColors[0][dstIndex++] = 1.0f;
                                }
                            }
                            break block61;
                        }
                        case 128: {
                            if (this.c4fRefColors == null) {
                                this.vertexType &= 0xFFFFFF7F;
                                return;
                            }
                            this.vertexType |= 0x80;
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[this.vertexCount << 2];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            dstIndex = this.initialColorIndex * 4;
                            for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                this.mirrorFloatRefColors[0][dstIndex++] = this.c4fRefColors[i].x;
                                this.mirrorFloatRefColors[0][dstIndex++] = this.c4fRefColors[i].y;
                                this.mirrorFloatRefColors[0][dstIndex++] = this.c4fRefColors[i].z;
                                this.mirrorFloatRefColors[0][dstIndex++] = this.c4fRefColors[i].w;
                            }
                            break;
                        }
                        case 256: {
                            if (this.c3bRefColors == null) {
                                this.vertexType &= 0xFFFFFEFF;
                                return;
                            }
                            this.vertexType |= 0x100;
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount * multiplier];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            if ((this.c4fAllocated & 8) == 0) {
                                dstIndex = this.initialColorIndex * 3;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c3bRefColors[i].x;
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c3bRefColors[i].y;
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c3bRefColors[i].z;
                                }
                                break block61;
                            } else {
                                dstIndex = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c3bRefColors[i].x;
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c3bRefColors[i].y;
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c3bRefColors[i].z;
                                    this.mirrorUnsignedByteRefColors[0][dstIndex++] = -1;
                                }
                            }
                            break block61;
                        }
                        case 512: {
                            if (this.c4bRefColors == null) {
                                this.vertexType &= 0xFFFFFDFF;
                                return;
                            }
                            this.vertexType |= 0x200;
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount << 2];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            dstIndex = this.initialColorIndex * 4;
                            for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c4bRefColors[i].x;
                                this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c4bRefColors[i].y;
                                this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c4bRefColors[i].z;
                                this.mirrorUnsignedByteRefColors[0][dstIndex++] = this.c4bRefColors[i].w;
                            }
                            break;
                        }
                    }
                    break block61;
                }
                if (this.colorRefBuffer == null) {
                    if (this.c4fAllocated == 0 && !force && (this.vertexType & 0x3F0) == 16) {
                        this.mirrorFloatRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFEF;
                    }
                    this.vertexType &= 0xFFFFFFEF;
                    if (this.c4fAllocated == 0 && !force && (this.vertexType & 0x3F0) == 32) {
                        this.mirrorUnsignedByteRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFDF;
                    }
                    this.vertexType &= 0xFFFFFFDF;
                    return;
                }
                if (this.floatBufferRefColors == null) break block63;
                this.vertexType |= 0x10;
                this.vertexType &= 0xFFFFFFDF;
                if (this.c4fAllocated == 0 && !force) {
                    this.mirrorFloatRefColors[0] = null;
                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                    break block61;
                } else {
                    if ((this.mirrorColorAllocated & 0x10) == 0) {
                        this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 0x10;
                    }
                    this.floatBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        srcIndex = this.initialColorIndex * 3;
                        dstIndex = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(srcIndex);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; dstIndex += 4, ++i) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], dstIndex, 3);
                            this.mirrorFloatRefColors[0][dstIndex + 3] = 1.0f;
                        }
                        break block61;
                    } else {
                        srcIndex = this.initialColorIndex * 4;
                        dstIndex = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(srcIndex);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; dstIndex += 4, ++i) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], dstIndex, 4);
                        }
                    }
                }
                break block61;
            }
            if (this.byteBufferRefColors != null) {
                this.vertexType |= 0x20;
                this.vertexType &= 0xFFFFFFEF;
                if (this.c4fAllocated == 0 && !force) {
                    this.mirrorUnsignedByteRefColors[0] = null;
                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                } else {
                    if ((this.mirrorColorAllocated & 0x20) == 0) {
                        this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 0x20;
                    }
                    this.byteBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        srcIndex = this.initialColorIndex * 3;
                        dstIndex = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(srcIndex);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; dstIndex += 4, ++i) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], dstIndex, 3);
                            this.mirrorUnsignedByteRefColors[0][dstIndex + 3] = -1;
                        }
                    } else {
                        srcIndex = this.initialColorIndex * 4;
                        dstIndex = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(srcIndex);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; dstIndex += 4, ++i) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], dstIndex, 4);
                        }
                    }
                }
            }
        }
        this.colorChanged = 65535;
    }

    void setupMirrorNormalPointer(int ntype) {
        switch (ntype) {
            case 1024: {
                if (this.floatRefNormals == null) {
                    if ((this.vertexType & 0xC00) != 1024) break;
                    this.vertexType &= 0xFFFFFBFF;
                    this.mirrorFloatRefNormals = null;
                    this.mirrorNormalAllocated = false;
                    break;
                }
                this.vertexType |= 0x400;
                this.mirrorFloatRefNormals = this.floatRefNormals;
                this.mirrorNormalAllocated = false;
                break;
            }
            case 2048: {
                if (this.v3fRefNormals == null) {
                    if ((this.vertexType & 0xC00) == 2048) {
                        this.vertexType &= 0xFFFFF7FF;
                    }
                    return;
                }
                this.vertexType |= 0x800;
                if (!this.mirrorNormalAllocated) {
                    this.mirrorFloatRefNormals = new float[this.vertexCount * 3];
                    this.mirrorNormalAllocated = true;
                }
                int index = this.initialNormalIndex * 3;
                for (int i = this.initialNormalIndex; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefNormals[index++] = this.v3fRefNormals[i].x;
                    this.mirrorFloatRefNormals[index++] = this.v3fRefNormals[i].y;
                    this.mirrorFloatRefNormals[index++] = this.v3fRefNormals[i].z;
                }
                break;
            }
        }
    }

    void setupMirrorTexCoordPointer(int type) {
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            this.doSetupMirrorTexCoordPointer(i, type);
        }
        this.validateTexCoordPointerType();
    }

    void setupMirrorTexCoordPointer(int texCoordSet, int type) {
        this.doSetupMirrorTexCoordPointer(texCoordSet, type);
        this.validateTexCoordPointerType();
    }

    private void validateTexCoordPointerType() {
        boolean allNonNull = true;
        boolean allNull = true;
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            if (this.refTexCoords[i] == null) {
                allNonNull = false;
                continue;
            }
            allNull = false;
        }
        if (allNull) {
            this.texCoordType = 0;
        }
        this.vertexType &= 0xFFFF8FFF;
        if (allNonNull) {
            this.vertexType |= this.texCoordType;
        }
    }

    private void doSetupMirrorTexCoordPointer(int texCoordSet, int type) {
        switch (type) {
            case 4096: {
                this.texCoordType = 4096;
                this.mirrorRefTexCoords[texCoordSet] = this.refTexCoords[texCoordSet];
                break;
            }
            case 8192: {
                this.texCoordType = 8192;
                this.t2fRefTexCoords = (TexCoord2f[])this.refTexCoords[texCoordSet];
                if (this.t2fRefTexCoords == null) {
                    this.mirrorRefTexCoords[texCoordSet] = null;
                    break;
                }
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[texCoordSet];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 2) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                        this.mirrorRefTexCoords[texCoordSet] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                    this.mirrorRefTexCoords[texCoordSet] = this.mirrorFloatRefTexCoords;
                }
                int index = this.initialTexCoordIndex[texCoordSet] * 2;
                for (int i = this.initialTexCoordIndex[texCoordSet]; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefTexCoords[index++] = this.t2fRefTexCoords[i].x;
                    this.mirrorFloatRefTexCoords[index++] = this.t2fRefTexCoords[i].y;
                }
                break;
            }
            case 16384: {
                this.texCoordType = 16384;
                this.t3fRefTexCoords = (TexCoord3f[])this.refTexCoords[texCoordSet];
                if (this.t3fRefTexCoords == null) {
                    this.mirrorRefTexCoords[texCoordSet] = null;
                    break;
                }
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[texCoordSet];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 3) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                        this.mirrorRefTexCoords[texCoordSet] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                    this.mirrorRefTexCoords[texCoordSet] = this.mirrorFloatRefTexCoords;
                }
                int index = this.initialTexCoordIndex[texCoordSet] * 3;
                for (int i = this.initialTexCoordIndex[texCoordSet]; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefTexCoords[index++] = this.t3fRefTexCoords[i].x;
                    this.mirrorFloatRefTexCoords[index++] = this.t3fRefTexCoords[i].y;
                    this.mirrorFloatRefTexCoords[index++] = this.t3fRefTexCoords[i].z;
                }
                break;
            }
        }
    }

    void setupMirrorVertexAttrPointer(int type) {
        for (int i = 0; i < this.vertexAttrCount; ++i) {
            this.doSetupMirrorVertexAttrPointer(i, type);
        }
        this.validateVertexAttrPointerType();
    }

    void setupMirrorVertexAttrPointer(int vertexAttrNum, int type) {
        this.doSetupMirrorVertexAttrPointer(vertexAttrNum, type);
        this.validateVertexAttrPointerType();
    }

    private void validateVertexAttrPointerType() {
        boolean allNonNull = true;
        boolean allNull = true;
        if ((this.vertexFormat & 0x800) == 0) {
            for (int i = 0; i < this.vertexAttrCount; ++i) {
                if (this.floatRefVertexAttrs[i] == null) {
                    allNonNull = false;
                    continue;
                }
                allNull = false;
            }
        } else {
            for (int i = 0; i < this.vertexAttrCount; ++i) {
                if (this.floatBufferRefVertexAttrs[i] == null) {
                    allNonNull = false;
                    continue;
                }
                allNull = false;
            }
        }
        if (allNull) {
            this.vertexAttrType = 0;
        }
        this.vertexType &= 0xFFFF7FFF;
        if (allNonNull) {
            this.vertexType |= this.vertexAttrType;
        }
    }

    private void doSetupMirrorVertexAttrPointer(int vertexAttrNum, int type) {
        switch (type) {
            case 32768: {
                this.vertexAttrType = 32768;
                this.mirrorFloatRefVertexAttrs[vertexAttrNum] = this.floatRefVertexAttrs[vertexAttrNum];
                break;
            }
        }
    }

    void createGeometryArrayData(int vertexCount, int vertexFormat) {
        if ((vertexFormat & 0x460) != 0) {
            this.createGeometryArrayData(vertexCount, vertexFormat, 1, defaultTexCoordSetMap);
        } else {
            this.createGeometryArrayData(vertexCount, vertexFormat, 0, null);
        }
    }

    void createGeometryArrayData(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap) {
        this.createGeometryArrayData(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, 0, null);
    }

    void createGeometryArrayData(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes) {
        this.vertexFormat = vertexFormat;
        this.vertexCount = vertexCount;
        this.validVertexCount = vertexCount;
        this.texCoordSetCount = texCoordSetCount;
        this.texCoordSetMap = (int[])(texCoordSetMap == null ? null : Arrays.copyOf(texCoordSetMap, texCoordSetMap.length));
        this.vertexAttrCount = vertexAttrCount;
        this.vertexAttrSizes = (int[])(vertexAttrSizes == null ? null : Arrays.copyOf(vertexAttrSizes, vertexAttrSizes.length));
        this.vertexAttrStride = this.vertexAttrStride();
        this.stride = this.stride();
        this.vertexAttrOffsets = this.vertexAttrOffsets();
        this.texCoordSetMapOffset = this.texCoordSetMapOffset();
        this.textureOffset = this.textureOffset();
        this.colorOffset = this.colorOffset();
        this.normalOffset = this.normalOffset();
        this.coordinateOffset = this.coordinateOffset();
        if ((vertexFormat & 0x80) == 0) {
            this.vertexData = new float[this.vertexCount * this.stride];
        } else {
            this.vertexData = null;
            if ((vertexFormat & 0x460) != 0) {
                this.mirrorRefTexCoords = new Object[texCoordSetCount];
                this.refTexCoords = new Object[texCoordSetCount];
                if ((vertexFormat & 0x800) != 0) {
                    this.refTexCoordsBuffer = new J3DBuffer[texCoordSetCount];
                }
            }
            if ((vertexFormat & 0x1000) != 0) {
                this.floatRefVertexAttrs = new float[vertexAttrCount][];
                this.mirrorFloatRefVertexAttrs = new float[vertexAttrCount][];
                if ((vertexFormat & 0x800) != 0) {
                    this.vertexAttrsRefBuffer = new J3DBuffer[vertexAttrCount];
                    this.floatBufferRefVertexAttrs = new FloatBuffer[vertexAttrCount];
                }
            }
        }
        if ((vertexFormat & 0x460) != 0) {
            this.initialTexCoordIndex = new int[texCoordSetCount];
        }
        if ((vertexFormat & 0x1000) != 0) {
            this.initialVertexAttrIndex = new int[vertexAttrCount];
        }
        this.noAlpha = (vertexFormat & 8) == 0;
        this.lastAlpha[0] = 1.0f;
    }

    void setVertexFormat(boolean useAlpha, boolean ignoreVC, Context ctx) {
        Pipeline.getPipeline().setVertexFormat(ctx, this, this.vertexFormat, useAlpha, ignoreVC);
    }

    float[] updateAlphaInFloatRefColors(Canvas3D cv, int screen, float alpha) {
        int i;
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorFloatRefColors[0];
        }
        if ((double)alpha <= 1.0E-6) {
            alpha = 1.0E-6f;
        }
        assert (this.lastAlpha != null);
        assert (this.mirrorFloatRefColors != null);
        assert (this.mirrorFloatRefColors.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= screen) {
            float[] la = new float[screen + 1];
            for (i = 0; i < this.lastAlpha.length; ++i) {
                la[i] = this.lastAlpha[i];
            }
            this.lastAlpha = la;
        }
        if (this.mirrorFloatRefColors.length <= screen) {
            float[][] cfData = new float[screen + 1][];
            for (i = 0; i < this.mirrorFloatRefColors.length; ++i) {
                cfData[i] = this.mirrorFloatRefColors[i];
            }
            for (i = this.mirrorFloatRefColors.length; i < screen + 1; ++i) {
                cfData[i] = new float[4 * this.vertexCount];
                System.arraycopy(cfData[0], 0, cfData[i], 0, 4 * this.vertexCount);
                this.lastAlpha[i] = this.lastAlpha[0];
            }
            this.mirrorFloatRefColors = cfData;
        }
        assert ((double)this.lastAlpha[screen] >= 0.0);
        if ((this.colorChanged & 1 << screen) == 0) {
            if ((double)Math.abs(this.lastAlpha[screen] - alpha) <= 1.0E-6) {
                return this.mirrorFloatRefColors[screen];
            }
            float m = alpha / this.lastAlpha[screen];
            float[] cdata = this.mirrorFloatRefColors[screen];
            int i2 = 0;
            int j = 0;
            while (i2 < this.vertexCount) {
                cdata[j + 3] = cdata[j + 3] * m;
                ++i2;
                j += 4;
            }
        } else if (screen == 0) {
            float[] cdata = this.mirrorFloatRefColors[screen];
            int j = this.initialColorIndex * 4;
            int i3 = this.initialColorIndex;
            while (i3 < this.validVertexCount) {
                cdata[j + 3] = cdata[j + 3] * alpha;
                ++i3;
                j += 4;
            }
        } else {
            float m = (this.colorChanged & 1) == 0 ? alpha / this.lastAlpha[0] : alpha;
            float[] sdata = this.mirrorFloatRefColors[0];
            float[] cdata = this.mirrorFloatRefColors[screen];
            int j = this.initialColorIndex * 4;
            for (int i4 = this.initialColorIndex; i4 < this.validVertexCount; ++i4) {
                cdata[j] = sdata[j++];
                cdata[j] = sdata[j++];
                cdata[j] = sdata[j++];
                cdata[j] = sdata[j++] * m;
            }
        }
        this.lastAlpha[screen] = alpha;
        this.colorChanged &= ~(1 << screen);
        this.dirtyFlag |= 4;
        return this.mirrorFloatRefColors[screen];
    }

    byte[] updateAlphaInByteRefColors(Canvas3D cv, int screen, float alpha) {
        int i;
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorUnsignedByteRefColors[0];
        }
        if ((double)alpha <= 1.0E-6) {
            alpha = 1.0E-6f;
        }
        assert (this.lastAlpha != null);
        assert (this.mirrorUnsignedByteRefColors != null);
        assert (this.mirrorUnsignedByteRefColors.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= screen) {
            float[] la = new float[screen + 1];
            for (i = 0; i < this.lastAlpha.length; ++i) {
                la[i] = this.lastAlpha[i];
            }
            this.lastAlpha = la;
        }
        if (this.mirrorUnsignedByteRefColors.length <= screen) {
            byte[][] cbData = new byte[screen + 1][];
            for (i = 0; i < this.mirrorUnsignedByteRefColors.length; ++i) {
                cbData[i] = this.mirrorUnsignedByteRefColors[i];
            }
            for (i = this.mirrorUnsignedByteRefColors.length; i < screen + 1; ++i) {
                cbData[i] = new byte[4 * this.vertexCount];
                System.arraycopy(cbData[0], 0, cbData[i], 0, 4 * this.vertexCount);
                this.lastAlpha[i] = this.lastAlpha[0];
            }
            this.mirrorUnsignedByteRefColors = cbData;
        }
        assert ((double)this.lastAlpha[screen] >= 0.0);
        if ((this.colorChanged & 1 << screen) == 0) {
            if ((double)Math.abs(this.lastAlpha[screen] - alpha) <= 1.0E-6) {
                return this.mirrorUnsignedByteRefColors[screen];
            }
            float m = alpha / this.lastAlpha[screen];
            byte[] cdata = this.mirrorUnsignedByteRefColors[screen];
            int i2 = 0;
            int j = 0;
            while (i2 < this.vertexCount) {
                cdata[j + 3] = (byte)((float)(cdata[j + 3] & 0xFF) * m);
                ++i2;
                j += 4;
            }
        } else if (screen == 0) {
            byte[] cdata = this.mirrorUnsignedByteRefColors[screen];
            int j = this.initialColorIndex * 4;
            int i3 = this.initialColorIndex;
            while (i3 < this.validVertexCount) {
                cdata[j + 3] = (byte)((float)(cdata[j + 3] & 0xFF) * alpha);
                ++i3;
                j += 4;
            }
        } else {
            float m = (this.colorChanged & 1) == 0 ? alpha / this.lastAlpha[0] : alpha;
            byte[] sdata = this.mirrorUnsignedByteRefColors[0];
            byte[] cdata = this.mirrorUnsignedByteRefColors[screen];
            int j = this.initialColorIndex * 4;
            for (int i4 = this.initialColorIndex; i4 < this.validVertexCount; ++i4) {
                cdata[j] = sdata[j++];
                cdata[j] = sdata[j++];
                cdata[j] = sdata[j++];
                cdata[j] = (byte)((float)(sdata[j++] & 0xFF) * m);
            }
        }
        this.lastAlpha[screen] = alpha;
        this.colorChanged &= ~(1 << screen);
        this.dirtyFlag |= 4;
        return this.mirrorUnsignedByteRefColors[screen];
    }

    Object[] updateAlphaInVertexData(Canvas3D cv, int screen, float alpha) {
        int i;
        Object[] retVal = new Object[2];
        retVal[0] = Boolean.FALSE;
        if ((this.vertexFormat & 4) == 0) {
            retVal[1] = this.vertexData;
            return retVal;
        }
        if ((double)alpha <= 1.0E-6) {
            alpha = 1.0E-6f;
        }
        retVal[0] = Boolean.TRUE;
        assert (this.lastAlpha != null);
        assert (this.mvertexData == null || this.mvertexData.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= screen) {
            float[] la = new float[screen + 1];
            for (int i2 = 0; i2 < this.lastAlpha.length; ++i2) {
                la[i2] = this.lastAlpha[i2];
            }
            this.lastAlpha = la;
        }
        if (this.mvertexData == null || this.mvertexData.length <= screen) {
            float[][] cfData = new float[screen + 1][];
            int oldSize = 1;
            if (this.mvertexData != null) {
                oldSize = this.mvertexData.length;
                for (i = 0; i < this.mvertexData.length; ++i) {
                    cfData[i] = this.mvertexData[i];
                }
            }
            if (cfData[0] == null) {
                cfData[0] = this.vertexData;
            }
            if (screen > 0) {
                for (i = oldSize; i < screen + 1; ++i) {
                    cfData[i] = new float[this.stride * this.vertexCount];
                    System.arraycopy(cfData[0], 0, cfData[i], 0, this.stride * this.vertexCount);
                    this.lastAlpha[i] = this.lastAlpha[0];
                }
            }
            this.mvertexData = cfData;
        }
        assert ((double)this.lastAlpha[screen] >= 0.0);
        if ((this.colorChanged & 1 << screen) == 0) {
            if ((double)Math.abs(this.lastAlpha[screen] - alpha) <= 1.0E-6) {
                retVal[1] = this.mvertexData[screen];
                return retVal;
            }
            float m = alpha / this.lastAlpha[screen];
            float[] cdata = this.mvertexData[screen];
            i = 0;
            int j = this.colorOffset;
            while (i < this.vertexCount) {
                int n = j + 3;
                cdata[n] = cdata[n] * m;
                ++i;
                j += this.stride;
            }
        } else if (screen == 0) {
            float[] cdata = this.mvertexData[screen];
            double m = alpha / this.lastAlpha[0];
            int i3 = 0;
            int j = this.colorOffset;
            while (i3 < this.vertexCount) {
                int n = j + 3;
                cdata[n] = (float)((double)cdata[n] * m);
                ++i3;
                j += this.stride;
            }
        } else {
            float m = alpha / this.lastAlpha[0];
            float[] sdata = this.mvertexData[0];
            float[] cdata = this.mvertexData[screen];
            int i4 = 0;
            int j = this.colorOffset;
            while (i4 < this.vertexCount) {
                System.arraycopy(sdata, j, cdata, j, 3);
                cdata[j + 3] = sdata[j + 3] * m;
                ++i4;
                j += this.stride;
            }
        }
        this.lastAlpha[screen] = alpha;
        this.colorChanged &= ~(1 << screen);
        this.dirtyFlag |= 4;
        retVal[1] = this.mvertexData[screen];
        return retVal;
    }

    Object[] updateAlphaInInterLeavedData(Canvas3D cv, int screen, float alpha) {
        int i;
        Object[] retVal = new Object[2];
        retVal[0] = Boolean.FALSE;
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            retVal[1] = this.mirrorInterleavedColorPointer[0];
            return retVal;
        }
        int coffset = this.initialColorIndex << 2;
        if ((double)alpha <= 1.0E-6) {
            alpha = 1.0E-6f;
        }
        retVal[0] = Boolean.TRUE;
        assert (this.lastAlpha != null);
        assert (this.mirrorInterleavedColorPointer != null);
        assert (this.mirrorInterleavedColorPointer.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= screen) {
            float[] la = new float[screen + 1];
            for (i = 0; i < this.lastAlpha.length; ++i) {
                la[i] = this.lastAlpha[i];
            }
            this.lastAlpha = la;
        }
        if (this.mirrorInterleavedColorPointer.length <= screen) {
            float[][] cfData = new float[screen + 1][];
            for (i = 0; i < this.mirrorInterleavedColorPointer.length; ++i) {
                cfData[i] = this.mirrorInterleavedColorPointer[i];
            }
            for (i = this.mirrorInterleavedColorPointer.length; i < screen + 1; ++i) {
                cfData[i] = new float[4 * this.vertexCount];
                System.arraycopy(cfData[0], 0, cfData[i], 0, 4 * this.vertexCount);
                this.lastAlpha[i] = this.lastAlpha[0];
            }
            this.mirrorInterleavedColorPointer = cfData;
        }
        assert ((double)this.lastAlpha[screen] >= 0.0);
        if ((this.colorChanged & 1 << screen) == 0) {
            if ((double)Math.abs(this.lastAlpha[screen] - alpha) <= 1.0E-6) {
                retVal[1] = this.mirrorInterleavedColorPointer[screen];
                return retVal;
            }
            float m = alpha / this.lastAlpha[screen];
            float[] cdata = this.mirrorInterleavedColorPointer[screen];
            for (int i2 = coffset = this.initialColorIndex << 2; i2 < coffset + (this.vertexCount << 2); i2 += 4) {
                cdata[i2 + 3] = cdata[i2 + 3] * m;
            }
        } else if (screen == 0) {
            float[] cdata = this.mirrorInterleavedColorPointer[screen];
            for (i = coffset; i < coffset + (this.vertexCount << 2); i += 4) {
                cdata[i + 3] = cdata[i + 3] * alpha;
            }
        } else {
            float m = (this.colorChanged & 1) == 0 ? alpha / this.lastAlpha[0] : alpha;
            float[] sdata = this.mirrorInterleavedColorPointer[0];
            float[] cdata = this.mirrorInterleavedColorPointer[screen];
            int i3 = coffset;
            while (i3 < coffset + (this.vertexCount << 2)) {
                cdata[i3] = sdata[i3++];
                cdata[i3] = sdata[i3++];
                cdata[i3] = sdata[i3++];
                cdata[i3] = sdata[i3++] * m;
            }
        }
        this.lastAlpha[screen] = alpha;
        this.colorChanged &= ~(1 << screen);
        this.dirtyFlag |= 4;
        retVal[1] = this.mirrorInterleavedColorPointer[screen];
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, int screen, boolean ignoreVertexColors) {
        boolean useAlpha = false;
        if ((this.vertexFormat & 0x80) == 0) {
            float[] vdata;
            int cdirty;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                cdirty = this.dirtyFlag;
                if (updateAlpha && !ignoreVertexColors) {
                    Object[] retVal = this.updateAlphaInVertexData(cv, screen, alpha);
                    useAlpha = retVal[0] == Boolean.TRUE;
                    vdata = (float[])retVal[1];
                    if (alpha != this.lastScreenAlpha) {
                        this.lastScreenAlpha = alpha;
                        cdirty |= 4;
                    }
                } else {
                    vdata = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        cdirty |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().execute(cv.ctx, this, this.geoType, isNonUniformScale, useAlpha, ignoreVertexColors, this.initialVertexIndex, this.validVertexCount, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, cv.numActiveTexUnit, this.vertexAttrCount, this.vertexAttrSizes, vdata, null, cdirty);
        } else if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int cdirty;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] cdata = null;
                GeometryArrayRetained geometryArrayRetained = this;
                synchronized (geometryArrayRetained) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        Object[] retVal = this.updateAlphaInInterLeavedData(cv, screen, alpha);
                        useAlpha = retVal[0] == Boolean.TRUE;
                        cdata = (float[])retVal[1];
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        cdirty |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().execute(cv.ctx, this, this.geoType, isNonUniformScale, useAlpha, ignoreVertexColors, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, cv.numActiveTexUnit, this.vertexAttrCount, this.vertexAttrSizes, this.interLeavedVertexData, cdata, cdirty);
            } else {
                int cdirty;
                GeometryArrayRetained geometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] cbdata = null;
                float[] cfdata = null;
                if ((this.vertexType & 0xD0) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        cdirty = this.dirtyFlag;
                        if (updateAlpha && !ignoreVertexColors) {
                            cfdata = this.updateAlphaInFloatRefColors(cv, screen, alpha);
                            if (alpha != this.lastScreenAlpha) {
                                this.lastScreenAlpha = alpha;
                                cdirty |= 4;
                            }
                        } else {
                            cfdata = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                cdirty |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        cdirty = this.dirtyFlag;
                        if (updateAlpha && !ignoreVertexColors) {
                            cbdata = this.updateAlphaInByteRefColors(cv, screen, alpha);
                            if (alpha != this.lastScreenAlpha) {
                                this.lastScreenAlpha = alpha;
                                cdirty |= 4;
                            }
                        } else {
                            cbdata = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                cdirty |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    cdirty = this.dirtyFlag;
                }
                int vdefined = 0;
                if ((this.vertexType & 5) != 0) {
                    vdefined |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    vdefined |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    vdefined |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    vdefined |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    vdefined |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    vdefined |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    vdefined |= 0x20;
                }
                Pipeline.getPipeline().executeVA(cv.ctx, this, this.geoType, isNonUniformScale, ignoreVertexColors, this.validVertexCount, this.vertexFormat | this.c4fAllocated, vdefined, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, cfdata, cbdata, this.initialNormalIndex, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, cv.numActiveTexUnit, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, cdirty);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int cdirty;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] cdata = null;
            GeometryArrayRetained cfdata = this;
            synchronized (cfdata) {
                cdirty = this.dirtyFlag;
                if (updateAlpha && !ignoreVertexColors) {
                    Object[] retVal = this.updateAlphaInInterLeavedData(cv, screen, alpha);
                    useAlpha = retVal[0] == Boolean.TRUE;
                    cdata = (float[])retVal[1];
                    if (alpha != this.lastScreenAlpha) {
                        this.lastScreenAlpha = alpha;
                        cdirty |= 4;
                    }
                } else {
                    cdata = null;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        cdirty |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().executeInterleavedBuffer(cv.ctx, this, this.geoType, isNonUniformScale, useAlpha, ignoreVertexColors, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, cv.numActiveTexUnit, this.interleavedFloatBufferImpl, cdata, cdirty);
        } else {
            int cdirty;
            GeometryArrayRetained vdefined;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] cbdata = null;
            float[] cfdata = null;
            if ((this.vertexType & 0x10) != 0) {
                vdefined = this;
                synchronized (vdefined) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        cfdata = this.updateAlphaInFloatRefColors(cv, screen, alpha);
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else {
                        cfdata = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            cdirty |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                vdefined = this;
                synchronized (vdefined) {
                    cdirty = this.dirtyFlag;
                    if (updateAlpha && !ignoreVertexColors) {
                        cbdata = this.updateAlphaInByteRefColors(cv, screen, alpha);
                        if (alpha != this.lastScreenAlpha) {
                            this.lastScreenAlpha = alpha;
                            cdirty |= 4;
                        }
                    } else {
                        cbdata = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            cdirty |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                cdirty = this.dirtyFlag;
            }
            Buffer vcoord = null;
            Buffer cdataBuffer = null;
            FloatBuffer normal = null;
            int vdefined2 = 0;
            if ((this.vertexType & 1) != 0) {
                vdefined2 |= 1;
                vcoord = this.floatBufferRefCoords;
            } else if ((this.vertexType & 2) != 0) {
                vdefined2 |= 2;
                vcoord = this.doubleBufferRefCoords;
            }
            if ((this.vertexType & 0x10) != 0) {
                vdefined2 |= 4;
                cdataBuffer = this.floatBufferRefColors;
            } else if ((this.vertexType & 0x20) != 0) {
                vdefined2 |= 8;
                cdataBuffer = this.byteBufferRefColors;
            }
            if ((this.vertexType & 0xC00) != 0) {
                vdefined2 |= 0x10;
                normal = this.floatBufferRefNormals;
            }
            if ((this.vertexType & 0x8000) != 0) {
                vdefined2 |= 0x40;
            }
            if ((this.vertexType & 0x7000) != 0) {
                vdefined2 |= 0x20;
            }
            Pipeline.getPipeline().executeVABuffer(cv.ctx, this, this.geoType, isNonUniformScale, ignoreVertexColors, this.validVertexCount, this.vertexFormat | this.c4fAllocated, vdefined2, this.initialCoordIndex, vcoord, this.initialColorIndex, cdataBuffer, cfdata, cbdata, this.initialNormalIndex, normal, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.floatBufferRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, cv.numActiveTexUnit, this.initialTexCoordIndex, this.texCoordStride, this.refTexCoords, cdirty);
        }
    }

    void buildGA(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, boolean ignoreVertexColors, Transform3D xform, Transform3D nxform) {
        float[] vdata = null;
        assert ((this.vertexFormat & 0x800) == 0);
        if ((this.vertexFormat & 0x80) == 0) {
            vdata = this.vertexData;
        } else if ((this.vertexFormat & 0x100) != 0 && (this.vertexFormat & 0x800) == 0) {
            vdata = this.interLeavedVertexData;
        }
        if (vdata != null) {
            Pipeline.getPipeline().buildGA(cv.ctx, this, this.geoType, isNonUniformScale, updateAlpha, alpha, ignoreVertexColors, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, this.vertexAttrCount, this.vertexAttrSizes, xform == null ? null : xform.mat, nxform == null ? null : nxform.mat, vdata);
        } else {
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                int vdefined = 0;
                if ((this.vertexType & 5) != 0) {
                    vdefined |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    vdefined |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    vdefined |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    vdefined |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    vdefined |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    vdefined |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    vdefined |= 0x20;
                }
                Pipeline.getPipeline().buildGAForByRef(cv.ctx, this, this.geoType, isNonUniformScale, updateAlpha, alpha, ignoreVertexColors, this.validVertexCount, this.vertexFormat, vdefined, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, this.mirrorFloatRefColors[0], this.mirrorUnsignedByteRefColors[0], this.initialNormalIndex, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, xform == null ? null : xform.mat, nxform == null ? null : nxform.mat);
            }
        }
    }

    void unIndexify(IndexedGeometryArrayRetained src) {
        if ((src.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(src);
        } else {
            this.unIndexifyNIOBuffer(src);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryArrayRetained src) {
        int vOffset = 0;
        int tOffset = 0;
        int colorStride = 0;
        float[] vdata = null;
        int start = src.initialIndexIndex;
        int end = src.initialIndexIndex + src.validIndexCount;
        if ((src.vertexFormat & 0x80) == 0 || (src.vertexFormat & 0x100) != 0) {
            if ((src.vertexFormat & 0x80) == 0) {
                vdata = src.vertexData;
                if ((src.vertexFormat & 4) != 0) {
                    colorStride = 4;
                }
            } else if ((src.vertexFormat & 0x100) != 0) {
                vdata = src.interLeavedVertexData;
                if ((src.vertexFormat & 8) != 0) {
                    colorStride = 4;
                } else if ((src.vertexFormat & 4) != 0) {
                    colorStride = 3;
                }
            }
            for (int index = start; index < end; ++index) {
                int i;
                if ((this.vertexFormat & 2) != 0) {
                    System.arraycopy(vdata, src.indexNormal[index] * src.stride + src.normalOffset, this.vertexData, vOffset + this.normalOffset, 3);
                }
                if (colorStride == 4) {
                    System.arraycopy(vdata, src.indexColor[index] * src.stride + src.colorOffset, this.vertexData, vOffset + this.colorOffset, colorStride);
                } else if (colorStride == 3) {
                    System.arraycopy(vdata, src.indexColor[index] * src.stride + src.colorOffset, this.vertexData, vOffset + this.colorOffset, colorStride);
                    this.vertexData[vOffset + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int tcOffset = vOffset + this.textureOffset;
                    int interleavedOffset = 0;
                    i = 0;
                    while (i < this.texCoordSetCount) {
                        if ((src.vertexFormat & 0x100) != 0) {
                            interleavedOffset = i * this.texCoordStride;
                        }
                        System.arraycopy(vdata, src.indexTexCoord[i][index] * src.stride + src.textureOffset + interleavedOffset, this.vertexData, tcOffset, this.texCoordStride);
                        ++i;
                        tcOffset += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 0x1000) != 0) {
                    assert ((src.vertexFormat & 0x100) == 0);
                    for (i = 0; i < this.vertexAttrCount; ++i) {
                        int vaOffset = vOffset + this.vertexAttrOffsets[i];
                        System.arraycopy(vdata, src.indexVertexAttr[i][index] * src.stride + src.vertexAttrOffsets[i], this.vertexData, vaOffset, this.vertexAttrSizes[i]);
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    System.arraycopy(vdata, src.indexCoord[index] * src.stride + src.coordinateOffset, this.vertexData, vOffset + this.coordinateOffset, 3);
                }
                vOffset += this.stride;
            }
        } else {
            int i;
            int srcOffset;
            int index;
            if ((this.vertexFormat & 2) != 0) {
                vOffset = this.normalOffset;
                switch (src.vertexType & 0xC00) {
                    case 1024: {
                        for (index = start; index < end; ++index) {
                            System.arraycopy(src.floatRefNormals, src.indexNormal[index] * 3, this.vertexData, vOffset, 3);
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 2048: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexNormal[index];
                            this.vertexData[vOffset] = src.v3fRefNormals[srcOffset].x;
                            this.vertexData[vOffset + 1] = src.v3fRefNormals[srcOffset].y;
                            this.vertexData[vOffset + 2] = src.v3fRefNormals[srcOffset].z;
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                vOffset = this.colorOffset;
                int multiplier = 3;
                if ((src.vertexFormat & 8) != 0) {
                    multiplier = 4;
                }
                switch (src.vertexType & 0x3F0) {
                    case 16: {
                        for (index = start; index < end; ++index) {
                            if ((src.vertexFormat & 8) != 0) {
                                System.arraycopy(src.floatRefColors, src.indexColor[index] * multiplier, this.vertexData, vOffset, 4);
                            } else {
                                System.arraycopy(src.floatRefColors, src.indexColor[index] * multiplier, this.vertexData, vOffset, 3);
                                this.vertexData[vOffset + 3] = 1.0f;
                            }
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 32: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexColor[index] * multiplier;
                            this.vertexData[vOffset] = (float)(src.byteRefColors[srcOffset] & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 1] = (float)(src.byteRefColors[srcOffset + 1] & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 2] = (float)(src.byteRefColors[srcOffset + 2] & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 3] = (src.vertexFormat & 8) != 0 ? (float)(src.byteRefColors[srcOffset + 3] & 0xFF) * 0.003921569f : 1.0f;
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 64: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexColor[index];
                            this.vertexData[vOffset] = src.c3fRefColors[srcOffset].x;
                            this.vertexData[vOffset + 1] = src.c3fRefColors[srcOffset].y;
                            this.vertexData[vOffset + 2] = src.c3fRefColors[srcOffset].z;
                            this.vertexData[vOffset + 3] = 1.0f;
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 128: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexColor[index];
                            this.vertexData[vOffset] = src.c4fRefColors[srcOffset].x;
                            this.vertexData[vOffset + 1] = src.c4fRefColors[srcOffset].y;
                            this.vertexData[vOffset + 2] = src.c4fRefColors[srcOffset].z;
                            this.vertexData[vOffset + 3] = src.c4fRefColors[srcOffset].w;
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 256: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexColor[index];
                            this.vertexData[vOffset] = (float)(src.c3bRefColors[srcOffset].x & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 1] = (float)(src.c3bRefColors[srcOffset].y & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 2] = (float)(src.c3bRefColors[srcOffset].z & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 3] = 1.0f;
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 512: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexColor[index];
                            this.vertexData[vOffset] = (float)(src.c4bRefColors[srcOffset].x & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 1] = (float)(src.c4bRefColors[srcOffset].y & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 2] = (float)(src.c4bRefColors[srcOffset].z & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 3] = (float)(src.c4bRefColors[srcOffset].w & 0xFF) * 0.003921569f;
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                vOffset = this.textureOffset;
                switch (src.vertexType & 0x7000) {
                    case 4096: {
                        for (index = start; index < end; ++index) {
                            tOffset = vOffset;
                            for (i = 0; i < this.texCoordSetCount; ++i) {
                                System.arraycopy(src.refTexCoords[i], src.indexTexCoord[i][index] * this.texCoordStride, this.vertexData, tOffset, this.texCoordStride);
                                tOffset += this.texCoordStride;
                            }
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 8192: {
                        for (index = start; index < end; ++index) {
                            tOffset = vOffset;
                            for (i = 0; i < this.texCoordSetCount; ++i) {
                                srcOffset = src.indexTexCoord[i][index];
                                this.vertexData[tOffset] = ((TexCoord2f[])src.refTexCoords[i])[srcOffset].x;
                                this.vertexData[tOffset + 1] = ((TexCoord2f[])src.refTexCoords[i])[srcOffset].y;
                                tOffset += this.texCoordStride;
                            }
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 16384: {
                        for (index = start; index < end; ++index) {
                            tOffset = vOffset;
                            for (i = 0; i < this.texCoordSetCount; ++i) {
                                srcOffset = src.indexTexCoord[i][index];
                                this.vertexData[tOffset] = ((TexCoord3f[])src.refTexCoords[i])[srcOffset].x;
                                this.vertexData[tOffset + 1] = ((TexCoord3f[])src.refTexCoords[i])[srcOffset].y;
                                this.vertexData[tOffset + 2] = ((TexCoord3f[])src.refTexCoords[i])[srcOffset].z;
                                tOffset += this.texCoordStride;
                            }
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                vOffset = 0;
                switch (src.vertexType & 0x8000) {
                    case 32768: {
                        for (index = start; index < end; ++index) {
                            for (i = 0; i < this.vertexAttrCount; ++i) {
                                int vaOffset = vOffset + this.vertexAttrOffsets[i];
                                System.arraycopy(src.floatRefVertexAttrs[i], src.indexVertexAttr[i][index] * this.vertexAttrSizes[i], this.vertexData, vaOffset, this.vertexAttrSizes[i]);
                            }
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                vOffset = this.coordinateOffset;
                switch (src.vertexType & 0xF) {
                    case 1: {
                        for (index = start; index < end; ++index) {
                            System.arraycopy(src.floatRefCoords, src.indexCoord[index] * 3, this.vertexData, vOffset, 3);
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 2: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexCoord[index] * 3;
                            this.vertexData[vOffset] = (float)src.doubleRefCoords[srcOffset];
                            this.vertexData[vOffset + 1] = (float)src.doubleRefCoords[srcOffset + 1];
                            this.vertexData[vOffset + 2] = (float)src.doubleRefCoords[srcOffset + 2];
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 4: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexCoord[index];
                            this.vertexData[vOffset] = src.p3fRefCoords[srcOffset].x;
                            this.vertexData[vOffset + 1] = src.p3fRefCoords[srcOffset].y;
                            this.vertexData[vOffset + 2] = src.p3fRefCoords[srcOffset].z;
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 8: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexCoord[index];
                            this.vertexData[vOffset] = (float)src.p3dRefCoords[srcOffset].x;
                            this.vertexData[vOffset + 1] = (float)src.p3dRefCoords[srcOffset].y;
                            this.vertexData[vOffset + 2] = (float)src.p3dRefCoords[srcOffset].z;
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryArrayRetained src) {
        int vOffset = 0;
        int tOffset = 0;
        int colorStride = 0;
        int start = src.initialIndexIndex;
        int end = src.initialIndexIndex + src.validIndexCount;
        if ((src.vertexFormat & 0x100) != 0) {
            if ((src.vertexFormat & 8) != 0) {
                colorStride = 4;
            } else if ((src.vertexFormat & 4) != 0) {
                colorStride = 3;
            }
            for (int index = start; index < end; ++index) {
                if ((this.vertexFormat & 2) != 0) {
                    src.interleavedFloatBufferImpl.position(src.indexNormal[index] * src.stride + src.normalOffset);
                    src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.normalOffset, 3);
                }
                if (colorStride == 4) {
                    src.interleavedFloatBufferImpl.position(src.indexColor[index] * src.stride + src.colorOffset);
                    src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.colorOffset, colorStride);
                } else if (colorStride == 3) {
                    src.interleavedFloatBufferImpl.position(src.indexColor[index] * src.stride + src.colorOffset);
                    src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.colorOffset, colorStride);
                    this.vertexData[vOffset + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int tcOffset = vOffset + this.textureOffset;
                    int i = 0;
                    while (i < this.texCoordSetCount) {
                        src.interleavedFloatBufferImpl.position(src.indexTexCoord[i][index] * src.stride + src.textureOffset);
                        src.interleavedFloatBufferImpl.get(this.vertexData, tcOffset, this.texCoordStride);
                        ++i;
                        tcOffset += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    src.interleavedFloatBufferImpl.position(src.indexCoord[index] * src.stride + src.coordinateOffset);
                    src.interleavedFloatBufferImpl.get(this.vertexData, vOffset + this.coordinateOffset, 3);
                }
                vOffset += this.stride;
            }
        } else {
            int i;
            int srcOffset;
            int index;
            if ((this.vertexFormat & 2) != 0) {
                vOffset = this.normalOffset;
                if ((src.vertexType & 0xC00) != 0) {
                    for (index = start; index < end; ++index) {
                        src.floatBufferRefNormals.position(src.indexNormal[index] * 3);
                        src.floatBufferRefNormals.get(this.vertexData, vOffset, 3);
                        vOffset += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                vOffset = this.colorOffset;
                int multiplier = 3;
                if ((src.vertexFormat & 8) != 0) {
                    multiplier = 4;
                }
                switch (src.vertexType & 0x3F0) {
                    case 16: {
                        for (index = start; index < end; ++index) {
                            if ((src.vertexFormat & 8) != 0) {
                                src.floatBufferRefColors.position(src.indexColor[index] * multiplier);
                                src.floatBufferRefColors.get(this.vertexData, vOffset, 4);
                            } else {
                                src.floatBufferRefColors.position(src.indexColor[index] * multiplier);
                                src.floatBufferRefColors.get(this.vertexData, vOffset, 3);
                                this.vertexData[vOffset + 3] = 1.0f;
                            }
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 32: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexColor[index] * multiplier;
                            this.vertexData[vOffset] = (float)(src.byteBufferRefColors.get(srcOffset) & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 1] = (float)(src.byteBufferRefColors.get(srcOffset + 1) & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 2] = (float)(src.byteBufferRefColors.get(srcOffset + 2) & 0xFF) * 0.003921569f;
                            this.vertexData[vOffset + 3] = (src.vertexFormat & 8) != 0 ? (float)(src.byteBufferRefColors.get(srcOffset + 3) & 0xFF) * 0.003921569f : 1.0f;
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                vOffset = this.textureOffset;
                if ((src.vertexType & 0x7000) != 0) {
                    for (index = start; index < end; ++index) {
                        tOffset = vOffset;
                        for (i = 0; i < this.texCoordSetCount; ++i) {
                            FloatBuffer texBuffer = (FloatBuffer)src.refTexCoordsBuffer[i].getROBuffer();
                            texBuffer.position(src.indexTexCoord[i][index] * this.texCoordStride);
                            texBuffer.get(this.vertexData, tOffset, this.texCoordStride);
                            tOffset += this.texCoordStride;
                        }
                        vOffset += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                vOffset = 0;
                if ((src.vertexType & 0x8000) == 32768) {
                    for (index = start; index < end; ++index) {
                        for (i = 0; i < this.vertexAttrCount; ++i) {
                            int vaOffset = vOffset + this.vertexAttrOffsets[i];
                            FloatBuffer vaBuffer = src.floatBufferRefVertexAttrs[i];
                            vaBuffer.position(src.indexVertexAttr[i][index] * this.vertexAttrSizes[i]);
                            vaBuffer.get(this.vertexData, vaOffset, this.vertexAttrSizes[i]);
                        }
                        vOffset += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                vOffset = this.coordinateOffset;
                switch (src.vertexType & 0xF) {
                    case 1: {
                        for (index = start; index < end; ++index) {
                            src.floatBufferRefCoords.position(src.indexCoord[index] * 3);
                            src.floatBufferRefCoords.get(this.vertexData, vOffset, 3);
                            vOffset += this.stride;
                        }
                        break;
                    }
                    case 2: {
                        for (index = start; index < end; ++index) {
                            srcOffset = src.indexCoord[index] * 3;
                            this.vertexData[vOffset] = (float)src.doubleBufferRefCoords.get(srcOffset);
                            this.vertexData[vOffset + 1] = (float)src.doubleBufferRefCoords.get(srcOffset + 1);
                            this.vertexData[vOffset + 2] = (float)src.doubleBufferRefCoords.get(srcOffset + 2);
                            vOffset += this.stride;
                        }
                        break;
                    }
                }
            }
        }
    }

    int stride() {
        int stride = 0;
        if ((this.vertexFormat & 1) != 0) {
            stride += 3;
        }
        if ((this.vertexFormat & 2) != 0) {
            stride += 3;
        }
        if ((this.vertexFormat & 4) != 0) {
            stride = (this.vertexFormat & 0x80) == 0 ? (stride += 4) : ((this.vertexFormat & 8) == 0 ? (stride += 3) : (stride += 4));
        }
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x20) != 0) {
                this.texCoordStride = 2;
            } else if ((this.vertexFormat & 0x40) != 0) {
                this.texCoordStride = 3;
            } else if ((this.vertexFormat & 0x400) != 0) {
                this.texCoordStride = 4;
            }
            stride += this.texCoordStride * this.texCoordSetCount;
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            stride += this.vertexAttrStride;
        }
        return stride;
    }

    int[] texCoordSetMapOffset() {
        if (this.texCoordSetMap == null) {
            return null;
        }
        this.texCoordSetMapOffset = new int[this.texCoordSetMap.length];
        for (int i = 0; i < this.texCoordSetMap.length; ++i) {
            this.texCoordSetMapOffset[i] = this.texCoordSetMap[i] == -1 ? -1 : this.texCoordSetMap[i] * this.texCoordStride;
        }
        return this.texCoordSetMapOffset;
    }

    int vertexAttrStride() {
        int sum = 0;
        for (int i = 0; i < this.vertexAttrCount; ++i) {
            sum += this.vertexAttrSizes[i];
        }
        return sum;
    }

    int[] vertexAttrOffsets() {
        int[] offsets = this.vertexAttrCount > 0 ? new int[this.vertexAttrCount] : new int[]{0};
        for (int i = 1; i < this.vertexAttrCount; ++i) {
            offsets[i] = offsets[i - 1] + this.vertexAttrSizes[i - 1];
        }
        return offsets;
    }

    int textureOffset() {
        int offset = this.vertexAttrOffsets[0];
        if ((this.vertexFormat & 0x1000) != 0) {
            offset += this.vertexAttrStride;
        }
        return offset;
    }

    int colorOffset() {
        int offset = this.textureOffset;
        if ((this.vertexFormat & 0x20) != 0) {
            offset += 2 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x40) != 0) {
            offset += 3 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x400) != 0) {
            offset += 4 * this.texCoordSetCount;
        }
        return offset;
    }

    int normalOffset() {
        int offset = this.colorOffset;
        if ((this.vertexFormat & 4) != 0) {
            offset = (this.vertexFormat & 0x80) == 0 ? (offset += 4) : ((this.vertexFormat & 8) == 0 ? (offset += 3) : (offset += 4));
        }
        return offset;
    }

    int coordinateOffset() {
        int offset = this.normalOffset;
        if ((this.vertexFormat & 2) != 0) {
            offset += 3;
        }
        return offset;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    int getVertexFormat() {
        return this.vertexFormat;
    }

    int getVertexAttrCount() {
        return this.vertexAttrCount;
    }

    void getVertexAttrSizes(int[] vertexAttrSizes) {
        for (int i = 0; i < this.vertexAttrCount; ++i) {
            vertexAttrSizes[i] = this.vertexAttrSizes[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDataChangedMessage(boolean coordinatesChanged) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source != null && this.source.isLive()) {
                int j;
                int i;
                int k;
                int threads = 128;
                threads |= 0x400;
                ArrayList<VirtualUniverse> arrayList = this.universeList;
                synchronized (arrayList) {
                    int numShapeMessages = this.universeList.size();
                    J3dMessage[] m = new J3dMessage[numShapeMessages];
                    k = 0;
                    i = 0;
                    while (i < numShapeMessages) {
                        LeafRetained src;
                        Shape3DRetained s;
                        this.gaList.clear();
                        ArrayList shapeList = (ArrayList)this.userLists.get(i);
                        for (j = 0; j < shapeList.size(); ++j) {
                            s = (Shape3DRetained)shapeList.get(j);
                            src = (LeafRetained)s.sourceNode;
                            if (!coordinatesChanged || !src.boundsAutoCompute) continue;
                            src.boundsDirty = true;
                        }
                        for (j = 0; j < shapeList.size(); ++j) {
                            s = (Shape3DRetained)shapeList.get(j);
                            src = (LeafRetained)s.sourceNode;
                            if (src.boundsDirty) {
                                src.updateBounds();
                                src.boundsDirty = false;
                            }
                            this.gaList.add(Shape3DRetained.getGeomAtom(s));
                        }
                        m[k] = new J3dMessage();
                        m[k].type = 17;
                        m[k].threads = threads;
                        m[k].args[0] = this.gaList.toArray();
                        m[k].args[1] = this;
                        m[k].args[2] = null;
                        m[k].args[3] = new Integer(this.changedFrequent);
                        m[k].universe = (VirtualUniverse)this.universeList.get(i);
                        ++i;
                        ++k;
                    }
                    VirtualUniverse.mc.processMessage(m);
                }
                if (this.morphUniverseList != null) {
                    arrayList = this.morphUniverseList;
                    synchronized (arrayList) {
                        int numMorphMessages = this.morphUniverseList.size();
                        if (numMorphMessages > 0) {
                            ArrayList<VirtualUniverse> arrayList2 = this.morphUniverseList;
                            synchronized (arrayList2) {
                                i = 0;
                                while (i < numMorphMessages) {
                                    ArrayList<MorphRetained> morphList = this.morphUserLists.get(i);
                                    for (j = 0; j < morphList.size(); ++j) {
                                        morphList.get(j).updateMorphedGeometryArray(this, coordinatesChanged);
                                    }
                                    ++i;
                                    ++k;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void setCoordinate(int index, float[] coordinate) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[offset] = coordinate[0];
        this.vertexData[offset + 1] = coordinate[1];
        this.vertexData[offset + 2] = coordinate[2];
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int index, double[] coordinate) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[offset] = (float)coordinate[0];
        this.vertexData[offset + 1] = (float)coordinate[1];
        this.vertexData[offset + 2] = (float)coordinate[2];
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int index, Point3f coordinate) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[offset] = coordinate.x;
        this.vertexData[offset + 1] = coordinate.y;
        this.vertexData[offset + 2] = coordinate.z;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int index, Point3d coordinate) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[offset] = (float)coordinate.x;
        this.vertexData[offset + 1] = (float)coordinate.y;
        this.vertexData[offset + 2] = (float)coordinate.z;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, float[] coordinates) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = coordinates[i];
            this.vertexData[j + 1] = coordinates[i + 1];
            this.vertexData[j + 2] = coordinates[i + 2];
            i += 3;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, double[] coordinates) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = (float)coordinates[i];
            this.vertexData[j + 1] = (float)coordinates[i + 1];
            this.vertexData[j + 2] = (float)coordinates[i + 2];
            i += 3;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, Point3f[] coordinates) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = coordinates[i].x;
            this.vertexData[j + 1] = coordinates[i].y;
            this.vertexData[j + 2] = coordinates[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, Point3d[] coordinates) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = (float)coordinates[i].x;
            this.vertexData[j + 1] = (float)coordinates[i].y;
            this.vertexData[j + 2] = (float)coordinates[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, float[] coordinates, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = start * 3;
        int j = offset;
        while (i < (start + length) * 3) {
            this.vertexData[j] = coordinates[i];
            this.vertexData[j + 1] = coordinates[i + 1];
            this.vertexData[j + 2] = coordinates[i + 2];
            i += 3;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, double[] coordinates, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = start * 3;
        int j = offset;
        while (i < (start + length) * 3) {
            this.vertexData[j] = (float)coordinates[i];
            this.vertexData[j + 1] = (float)coordinates[i + 1];
            this.vertexData[j + 2] = (float)coordinates[i + 2];
            i += 3;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, Point3f[] coordinates, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = coordinates[i].x;
            this.vertexData[j + 1] = coordinates[i].y;
            this.vertexData[j + 2] = coordinates[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int index, Point3d[] coordinates, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.coordinateOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = (float)coordinates[i].x;
            this.vertexData[j + 1] = (float)coordinates[i].y;
            this.vertexData[j + 2] = (float)coordinates[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!isLive) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setColor(int index, float[] color) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[offset] = color[0];
        this.vertexData[offset + 1] = color[1];
        this.vertexData[offset + 2] = color[2];
        this.vertexData[offset + 3] = (this.vertexFormat & 8) != 0 ? color[3] * this.lastAlpha[0] : this.lastAlpha[0];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int index, byte[] color) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[offset] = (float)(color[0] & 0xFF) * 0.003921569f;
        this.vertexData[offset + 1] = (float)(color[1] & 0xFF) * 0.003921569f;
        this.vertexData[offset + 2] = (float)(color[2] & 0xFF) * 0.003921569f;
        this.vertexData[offset + 3] = (this.vertexFormat & 8) != 0 ? (float)(color[3] & 0xFF) * 0.003921569f * this.lastAlpha[0] : this.lastAlpha[0];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int index, Color3f color) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[offset] = color.x;
        this.vertexData[offset + 1] = color.y;
        this.vertexData[offset + 2] = color.z;
        this.vertexData[offset + 3] = this.lastAlpha[0];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int index, Color4f color) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[offset] = color.x;
        this.vertexData[offset + 1] = color.y;
        this.vertexData[offset + 2] = color.z;
        this.vertexData[offset + 3] = color.w * this.lastAlpha[0];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int index, Color3b color) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[offset] = (float)(color.x & 0xFF) * 0.003921569f;
        this.vertexData[offset + 1] = (float)(color.y & 0xFF) * 0.003921569f;
        this.vertexData[offset + 2] = (float)(color.z & 0xFF) * 0.003921569f;
        this.vertexData[offset + 3] = this.lastAlpha[0];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int index, Color4b color) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[offset] = (float)(color.x & 0xFF) * 0.003921569f;
        this.vertexData[offset + 1] = (float)(color.y & 0xFF) * 0.003921569f;
        this.vertexData[offset + 2] = (float)(color.z & 0xFF) * 0.003921569f;
        this.vertexData[offset + 3] = (float)(color.w & 0xFF) * 0.003921569f * this.lastAlpha[0];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, float[] colors) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int i = 0;
            int j = offset;
            while (i < num) {
                this.vertexData[j] = colors[i];
                this.vertexData[j + 1] = colors[i + 1];
                this.vertexData[j + 2] = colors[i + 2];
                this.vertexData[j + 3] = colors[i + 3] * this.lastAlpha[0];
                i += 4;
                j += this.stride;
            }
        } else {
            int i = 0;
            int j = offset;
            while (i < num) {
                this.vertexData[j] = colors[i];
                this.vertexData[j + 1] = colors[i + 1];
                this.vertexData[j + 2] = colors[i + 2];
                this.vertexData[j + 3] = this.lastAlpha[0];
                i += 3;
                j += this.stride;
            }
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, byte[] colors) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int i = 0;
            int j = offset;
            while (i < num) {
                this.vertexData[j] = (float)(colors[i] & 0xFF) * 0.003921569f;
                this.vertexData[j + 1] = (float)(colors[i + 1] & 0xFF) * 0.003921569f;
                this.vertexData[j + 2] = (float)(colors[i + 2] & 0xFF) * 0.003921569f;
                this.vertexData[j + 3] = (float)(colors[i + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                i += 4;
                j += this.stride;
            }
        } else {
            int i = 0;
            int j = offset;
            while (i < num) {
                this.vertexData[j] = (float)(colors[i] & 0xFF) * 0.003921569f;
                this.vertexData[j + 1] = (float)(colors[i + 1] & 0xFF) * 0.003921569f;
                this.vertexData[j + 2] = (float)(colors[i + 2] & 0xFF) * 0.003921569f;
                this.vertexData[j + 3] = this.lastAlpha[0];
                i += 3;
                j += this.stride;
            }
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color3f[] colors) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = colors[i].x;
            this.vertexData[j + 1] = colors[i].y;
            this.vertexData[j + 2] = colors[i].z;
            this.vertexData[j + 3] = this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color4f[] colors) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = colors[i].x;
            this.vertexData[j + 1] = colors[i].y;
            this.vertexData[j + 2] = colors[i].z;
            this.vertexData[j + 3] = colors[i].w * this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color3b[] colors) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = (float)(colors[i].x & 0xFF) * 0.003921569f;
            this.vertexData[j + 1] = (float)(colors[i].y & 0xFF) * 0.003921569f;
            this.vertexData[j + 2] = (float)(colors[i].z & 0xFF) * 0.003921569f;
            this.vertexData[j + 3] = this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color4b[] colors) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = (float)(colors[i].x & 0xFF) * 0.003921569f;
            this.vertexData[j + 1] = (float)(colors[i].y & 0xFF) * 0.003921569f;
            this.vertexData[j + 2] = (float)(colors[i].z & 0xFF) * 0.003921569f;
            this.vertexData[j + 3] = (float)(colors[i].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, float[] colors, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int i = start * 4;
            int j = offset;
            while (i < (start + length) * 4) {
                this.vertexData[j] = colors[i];
                this.vertexData[j + 1] = colors[i + 1];
                this.vertexData[j + 2] = colors[i + 2];
                this.vertexData[j + 3] = colors[i + 3] * this.lastAlpha[0];
                i += 4;
                j += this.stride;
            }
        } else {
            int i = start * 3;
            int j = offset;
            while (i < (start + length) * 3) {
                this.vertexData[j] = colors[i];
                this.vertexData[j + 1] = colors[i + 1];
                this.vertexData[j + 2] = colors[i + 2];
                this.vertexData[j + 3] = this.lastAlpha[0];
                i += 3;
                j += this.stride;
            }
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, byte[] colors, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int i = start * 4;
            int j = offset;
            while (i < (start + length) * 4) {
                this.vertexData[j] = (float)(colors[i] & 0xFF) * 0.003921569f;
                this.vertexData[j + 1] = (float)(colors[i + 1] & 0xFF) * 0.003921569f;
                this.vertexData[j + 2] = (float)(colors[i + 2] & 0xFF) * 0.003921569f;
                this.vertexData[j + 3] = (float)(colors[i + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                i += 4;
                j += this.stride;
            }
        } else {
            int i = start * 3;
            int j = offset;
            while (i < (start + length) * 3) {
                this.vertexData[j] = (float)(colors[i] & 0xFF) * 0.003921569f;
                this.vertexData[j + 1] = (float)(colors[i + 1] & 0xFF) * 0.003921569f;
                this.vertexData[j + 2] = (float)(colors[i + 2] & 0xFF) * 0.003921569f;
                this.vertexData[j + 3] = this.lastAlpha[0];
                i += 3;
                j += this.stride;
            }
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color3f[] colors, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = colors[i].x;
            this.vertexData[j + 1] = colors[i].y;
            this.vertexData[j + 2] = colors[i].z;
            this.vertexData[j + 3] = this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color4f[] colors, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = colors[i].x;
            this.vertexData[j + 1] = colors[i].y;
            this.vertexData[j + 2] = colors[i].z;
            this.vertexData[j + 3] = colors[i].w * this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color3b[] colors, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = (float)(colors[i].x & 0xFF) * 0.003921569f;
            this.vertexData[j + 1] = (float)(colors[i].y & 0xFF) * 0.003921569f;
            this.vertexData[j + 2] = (float)(colors[i].z & 0xFF) * 0.003921569f;
            this.vertexData[j + 3] = this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int index, Color4b[] colors, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.colorOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = (float)(colors[i].x & 0xFF) * 0.003921569f;
            this.vertexData[j + 1] = (float)(colors[i].y & 0xFF) * 0.003921569f;
            this.vertexData[j + 2] = (float)(colors[i].z & 0xFF) * 0.003921569f;
            this.vertexData[j + 3] = (float)(colors[i].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormal(int index, float[] normal) {
        boolean isLive;
        int offset = this.stride * index + this.normalOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.vertexData[offset] = normal[0];
        this.vertexData[offset + 1] = normal[1];
        this.vertexData[offset + 2] = normal[2];
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormal(int index, Vector3f normal) {
        boolean isLive;
        int offset = this.stride * index + this.normalOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.vertexData[offset] = normal.x;
        this.vertexData[offset + 1] = normal.y;
        this.vertexData[offset + 2] = normal.z;
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int index, float[] normals) {
        boolean isLive;
        int offset = this.stride * index + this.normalOffset;
        int num = normals.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = normals[i];
            this.vertexData[j + 1] = normals[i + 1];
            this.vertexData[j + 2] = normals[i + 2];
            i += 3;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int index, Vector3f[] normals) {
        boolean isLive;
        int offset = this.stride * index + this.normalOffset;
        int num = normals.length;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int i = 0;
        int j = offset;
        while (i < num) {
            this.vertexData[j] = normals[i].x;
            this.vertexData[j + 1] = normals[i].y;
            this.vertexData[j + 2] = normals[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int index, float[] normals, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.normalOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int i = start * 3;
        int j = offset;
        while (i < (start + length) * 3) {
            this.vertexData[j] = normals[i];
            this.vertexData[j + 1] = normals[i + 1];
            this.vertexData[j + 2] = normals[i + 2];
            i += 3;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int index, Vector3f[] normals, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.normalOffset;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = normals[i].x;
            this.vertexData[j + 1] = normals[i].y;
            this.vertexData[j + 2] = normals[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int texCoordSet, int index, float[] texCoords, int start, int length) {
        boolean isLive;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x400) != 0) {
            int i = start * 4;
            int j = offset;
            for (int k = 0; k < length; ++k) {
                this.vertexData[j] = texCoords[i++];
                this.vertexData[j + 1] = texCoords[i++];
                this.vertexData[j + 2] = texCoords[i++];
                this.vertexData[j + 3] = texCoords[i++];
                j += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int i = start * 3;
            int j = offset;
            for (int k = 0; k < length; ++k) {
                this.vertexData[j] = texCoords[i++];
                this.vertexData[j + 1] = texCoords[i++];
                this.vertexData[j + 2] = texCoords[i++];
                j += this.stride;
            }
        } else {
            int i = start * 2;
            int j = offset;
            for (int k = 0; k < length; ++k) {
                this.vertexData[j] = texCoords[i++];
                this.vertexData[j + 1] = texCoords[i++];
                j += this.stride;
            }
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int texCoordSet, int index, Point2f[] texCoords, int start, int length) {
        boolean isLive;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = texCoords[i].x;
            this.vertexData[j + 1] = texCoords[i].y;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int texCoordSet, int index, Point3f[] texCoords, int start, int length) {
        boolean isLive;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = texCoords[i].x;
            this.vertexData[j + 1] = texCoords[i].y;
            this.vertexData[j + 2] = texCoords[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int texCoordSet, int index, TexCoord2f[] texCoords, int start, int length) {
        boolean isLive;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = texCoords[i].x;
            this.vertexData[j + 1] = texCoords[i].y;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int texCoordSet, int index, TexCoord3f[] texCoords, int start, int length) {
        boolean isLive;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = texCoords[i].x;
            this.vertexData[j + 1] = texCoords[i].y;
            this.vertexData[j + 2] = texCoords[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int texCoordSet, int index, TexCoord4f[] texCoords, int start, int length) {
        boolean isLive;
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int i = start;
        int j = offset;
        while (i < start + length) {
            this.vertexData[j] = texCoords[i].x;
            this.vertexData[j + 1] = texCoords[i].y;
            this.vertexData[j + 2] = texCoords[i].z;
            this.vertexData[j + 3] = texCoords[i].w;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttr(int vertexAttrNum, int index, Point2f vertexAttr) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexData[offset] = vertexAttr.x;
        this.vertexData[offset + 1] = vertexAttr.y;
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttr(int vertexAttrNum, int index, Point3f vertexAttr) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexData[offset] = vertexAttr.x;
        this.vertexData[offset + 1] = vertexAttr.y;
        this.vertexData[offset + 2] = vertexAttr.z;
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttr(int vertexAttrNum, int index, Point4f vertexAttr) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexData[offset] = vertexAttr.x;
        this.vertexData[offset + 1] = vertexAttr.y;
        this.vertexData[offset + 2] = vertexAttr.z;
        this.vertexData[offset + 3] = vertexAttr.w;
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int vertexAttrNum, int index, float[] vertexAttrs, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        int size = this.vertexAttrSizes[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int i = start * size;
        int j = offset;
        for (int k = 0; k < length; ++k) {
            for (int ii = 0; ii < size; ++ii) {
                this.vertexData[j + ii] = vertexAttrs[i + ii];
            }
            i += size;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int vertexAttrNum, int index, Point2f[] vertexAttrs, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int i = start;
        int j = offset;
        for (int k = 0; k < length; ++k) {
            this.vertexData[j] = vertexAttrs[i].x;
            this.vertexData[j + 1] = vertexAttrs[i].y;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int vertexAttrNum, int index, Point3f[] vertexAttrs, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int i = start;
        int j = offset;
        for (int k = 0; k < length; ++k) {
            this.vertexData[j] = vertexAttrs[i].x;
            this.vertexData[j + 1] = vertexAttrs[i].y;
            this.vertexData[j + 2] = vertexAttrs[i].z;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int vertexAttrNum, int index, Point4f[] vertexAttrs, int start, int length) {
        boolean isLive;
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int i = start;
        int j = offset;
        for (int k = 0; k < length; ++k) {
            this.vertexData[j] = vertexAttrs[i].x;
            this.vertexData[j + 1] = vertexAttrs[i].y;
            this.vertexData[j + 2] = vertexAttrs[i].z;
            this.vertexData[j + 3] = vertexAttrs[i].w;
            ++i;
            j += this.stride;
        }
        if (isLive) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void getCoordinate(int index, float[] coordinate) {
        int offset = this.stride * index + this.coordinateOffset;
        coordinate[0] = this.vertexData[offset];
        coordinate[1] = this.vertexData[offset + 1];
        coordinate[2] = this.vertexData[offset + 2];
    }

    void getCoordinate(int index, double[] coordinate) {
        int offset = this.stride * index + this.coordinateOffset;
        coordinate[0] = this.vertexData[offset];
        coordinate[1] = this.vertexData[offset + 1];
        coordinate[2] = this.vertexData[offset + 2];
    }

    void getCoordinate(int index, Point3f coordinate) {
        int offset = this.stride * index + this.coordinateOffset;
        coordinate.x = this.vertexData[offset];
        coordinate.y = this.vertexData[offset + 1];
        coordinate.z = this.vertexData[offset + 2];
    }

    void getCoordinate(int index, Point3d coordinate) {
        int offset = this.stride * index + this.coordinateOffset;
        coordinate.x = this.vertexData[offset];
        coordinate.y = this.vertexData[offset + 1];
        coordinate.z = this.vertexData[offset + 2];
    }

    void getCoordinates(int index, float[] coordinates) {
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            coordinates[i] = this.vertexData[j];
            coordinates[i + 1] = this.vertexData[j + 1];
            coordinates[i + 2] = this.vertexData[j + 2];
            i += 3;
            j += this.stride;
        }
    }

    void getCoordinates(int index, double[] coordinates) {
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            coordinates[i] = this.vertexData[j];
            coordinates[i + 1] = this.vertexData[j + 1];
            coordinates[i + 2] = this.vertexData[j + 2];
            i += 3;
            j += this.stride;
        }
    }

    void getCoordinates(int index, Point3f[] coordinates) {
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            coordinates[i].x = this.vertexData[j];
            coordinates[i].y = this.vertexData[j + 1];
            coordinates[i].z = this.vertexData[j + 2];
            ++i;
            j += this.stride;
        }
    }

    void getCoordinates(int index, Point3d[] coordinates) {
        int offset = this.stride * index + this.coordinateOffset;
        int num = coordinates.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            coordinates[i].x = this.vertexData[j];
            coordinates[i].y = this.vertexData[j + 1];
            coordinates[i].z = this.vertexData[j + 2];
            ++i;
            j += this.stride;
        }
    }

    void getColor(int index, float[] color) {
        int offset = this.stride * index + this.colorOffset;
        color[0] = this.vertexData[offset];
        color[1] = this.vertexData[offset + 1];
        color[2] = this.vertexData[offset + 2];
        if ((this.vertexFormat & 8) != 0) {
            color[3] = this.vertexData[offset + 3] / this.lastAlpha[0];
        }
    }

    void getColor(int index, byte[] color) {
        int offset = this.stride * index + this.colorOffset;
        color[0] = (byte)(this.vertexData[offset] * 255.0f);
        color[1] = (byte)(this.vertexData[offset + 1] * 255.0f);
        color[2] = (byte)(this.vertexData[offset + 2] * 255.0f);
        if ((this.vertexFormat & 8) != 0) {
            color[3] = (byte)(this.vertexData[offset + 3] / this.lastAlpha[0] * 255.0f);
        }
    }

    void getColor(int index, Color3f color) {
        int offset = this.stride * index + this.colorOffset;
        color.x = this.vertexData[offset];
        color.y = this.vertexData[offset + 1];
        color.z = this.vertexData[offset + 2];
    }

    void getColor(int index, Color4f color) {
        int offset = this.stride * index + this.colorOffset;
        color.x = this.vertexData[offset];
        color.y = this.vertexData[offset + 1];
        color.z = this.vertexData[offset + 2];
        color.w = this.vertexData[offset + 3] / this.lastAlpha[0];
    }

    void getColor(int index, Color3b color) {
        int offset = this.stride * index + this.colorOffset;
        color.x = (byte)(this.vertexData[offset] * 255.0f);
        color.y = (byte)(this.vertexData[offset + 1] * 255.0f);
        color.z = (byte)(this.vertexData[offset + 2] * 255.0f);
    }

    void getColor(int index, Color4b color) {
        int offset = this.stride * index + this.colorOffset;
        color.x = (byte)(this.vertexData[offset] * 255.0f);
        color.y = (byte)(this.vertexData[offset + 1] * 255.0f);
        color.z = (byte)(this.vertexData[offset + 2] * 255.0f);
        color.w = (byte)(this.vertexData[offset + 3] / this.lastAlpha[0] * 255.0f);
    }

    void getColors(int index, float[] colors) {
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        float val = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int i = 0;
            int j = offset;
            while (i < num) {
                colors[i] = this.vertexData[j];
                colors[i + 1] = this.vertexData[j + 1];
                colors[i + 2] = this.vertexData[j + 2];
                colors[i + 3] = this.vertexData[j + 3] * val;
                i += 4;
                j += this.stride;
            }
        } else {
            int i = 0;
            int j = offset;
            while (i < num) {
                colors[i] = this.vertexData[j];
                colors[i + 1] = this.vertexData[j + 1];
                colors[i + 2] = this.vertexData[j + 2];
                i += 3;
                j += this.stride;
            }
        }
    }

    void getColors(int index, byte[] colors) {
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        float val = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int i = 0;
            int j = offset;
            while (i < num) {
                colors[i] = (byte)(this.vertexData[j] * 255.0f);
                colors[i + 1] = (byte)(this.vertexData[j + 1] * 255.0f);
                colors[i + 2] = (byte)(this.vertexData[j + 2] * 255.0f);
                colors[i + 3] = (byte)(this.vertexData[j + 3] * val * 255.0f);
                i += 4;
                j += this.stride;
            }
        } else {
            int i = 0;
            int j = offset;
            while (i < num) {
                colors[i] = (byte)(this.vertexData[j] * 255.0f);
                colors[i + 1] = (byte)(this.vertexData[j + 1] * 255.0f);
                colors[i + 2] = (byte)(this.vertexData[j + 2] * 255.0f);
                i += 3;
                j += this.stride;
            }
        }
    }

    void getColors(int index, Color3f[] colors) {
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            colors[i].x = this.vertexData[j];
            colors[i].y = this.vertexData[j + 1];
            colors[i].z = this.vertexData[j + 2];
            ++i;
            j += this.stride;
        }
    }

    void getColors(int index, Color4f[] colors) {
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        float val = 1.0f / this.lastAlpha[0];
        int i = 0;
        int j = offset;
        while (i < num) {
            colors[i].x = this.vertexData[j];
            colors[i].y = this.vertexData[j + 1];
            colors[i].z = this.vertexData[j + 2];
            colors[i].w = this.vertexData[j + 3] * val;
            ++i;
            j += this.stride;
        }
    }

    void getColors(int index, Color3b[] colors) {
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            colors[i].x = (byte)(this.vertexData[j] * 255.0f);
            colors[i].y = (byte)(this.vertexData[j + 1] * 255.0f);
            colors[i].z = (byte)(this.vertexData[j + 2] * 255.0f);
            ++i;
            j += this.stride;
        }
    }

    void getColors(int index, Color4b[] colors) {
        int offset = this.stride * index + this.colorOffset;
        int num = colors.length;
        float val = 1.0f / this.lastAlpha[0];
        int i = 0;
        int j = offset;
        while (i < num) {
            colors[i].x = (byte)(this.vertexData[j] * 255.0f);
            colors[i].y = (byte)(this.vertexData[j + 1] * 255.0f);
            colors[i].z = (byte)(this.vertexData[j + 2] * 255.0f);
            colors[i].w = (byte)(this.vertexData[j + 3] * val * 255.0f);
            ++i;
            j += this.stride;
        }
    }

    void getNormal(int index, float[] normal) {
        int offset = this.stride * index + this.normalOffset;
        normal[0] = this.vertexData[offset];
        normal[1] = this.vertexData[offset + 1];
        normal[2] = this.vertexData[offset + 2];
    }

    void getNormal(int index, Vector3f normal) {
        int offset = this.stride * index + this.normalOffset;
        normal.x = this.vertexData[offset];
        normal.y = this.vertexData[offset + 1];
        normal.z = this.vertexData[offset + 2];
    }

    void getNormals(int index, float[] normals) {
        int offset = this.stride * index + this.normalOffset;
        int num = normals.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            normals[i] = this.vertexData[j];
            normals[i + 1] = this.vertexData[j + 1];
            normals[i + 2] = this.vertexData[j + 2];
            i += 3;
            j += this.stride;
        }
    }

    void getNormals(int index, Vector3f[] normals) {
        int offset = this.stride * index + this.normalOffset;
        int num = normals.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            normals[i].x = this.vertexData[j];
            normals[i].y = this.vertexData[j + 1];
            normals[i].z = this.vertexData[j + 2];
            ++i;
            j += this.stride;
        }
    }

    void getTextureCoordinate(int texCoordSet, int index, float[] texCoord) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        texCoord[0] = this.vertexData[offset];
        texCoord[1] = this.vertexData[offset + 1];
        if ((this.vertexFormat & 0x40) != 0) {
            texCoord[2] = this.vertexData[offset + 2];
        } else if ((this.vertexFormat & 0x400) != 0) {
            texCoord[2] = this.vertexData[offset + 2];
            texCoord[3] = this.vertexData[offset + 3];
        }
    }

    void getTextureCoordinate(int texCoordSet, int index, TexCoord2f texCoord) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        texCoord.x = this.vertexData[offset];
        texCoord.y = this.vertexData[offset + 1];
    }

    void getTextureCoordinate(int texCoordSet, int index, TexCoord3f texCoord) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        texCoord.x = this.vertexData[offset];
        texCoord.y = this.vertexData[offset + 1];
        texCoord.z = this.vertexData[offset + 2];
    }

    void getTextureCoordinate(int texCoordSet, int index, TexCoord4f texCoord) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        texCoord.x = this.vertexData[offset];
        texCoord.y = this.vertexData[offset + 1];
        texCoord.z = this.vertexData[offset + 2];
        texCoord.w = this.vertexData[offset + 3];
    }

    void getTextureCoordinates(int texCoordSet, int index, float[] texCoords) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int num = texCoords.length;
        if ((this.vertexFormat & 0x400) != 0) {
            int i = 0;
            int j = offset;
            while (i < num) {
                texCoords[i] = this.vertexData[j];
                texCoords[i + 1] = this.vertexData[j + 1];
                texCoords[i + 2] = this.vertexData[j + 2];
                texCoords[i + 3] = this.vertexData[j + 3];
                i += 4;
                j += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int i = 0;
            int j = offset;
            while (i < num) {
                texCoords[i] = this.vertexData[j];
                texCoords[i + 1] = this.vertexData[j + 1];
                texCoords[i + 2] = this.vertexData[j + 2];
                i += 3;
                j += this.stride;
            }
        } else {
            int i = 0;
            int j = offset;
            while (i < num) {
                texCoords[i] = this.vertexData[j];
                texCoords[i + 1] = this.vertexData[j + 1];
                i += 2;
                j += this.stride;
            }
        }
    }

    void getTextureCoordinates(int texCoordSet, int index, TexCoord2f[] texCoords) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int num = texCoords.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            texCoords[i].x = this.vertexData[j];
            texCoords[i].y = this.vertexData[j + 1];
            ++i;
            j += this.stride;
        }
    }

    void getTextureCoordinates(int texCoordSet, int index, TexCoord3f[] texCoords) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int num = texCoords.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            texCoords[i].x = this.vertexData[j];
            texCoords[i].y = this.vertexData[j + 1];
            texCoords[i].z = this.vertexData[j + 2];
            ++i;
            j += this.stride;
        }
    }

    void getTextureCoordinates(int texCoordSet, int index, TexCoord4f[] texCoords) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int num = texCoords.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            texCoords[i].x = this.vertexData[j];
            texCoords[i].y = this.vertexData[j + 1];
            texCoords[i].z = this.vertexData[j + 2];
            texCoords[i].w = this.vertexData[j + 3];
            ++i;
            j += this.stride;
        }
    }

    void getTextureCoordinates(int texCoordSet, int index, Point2f[] texCoords) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int num = texCoords.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            texCoords[i].x = this.vertexData[j];
            texCoords[i].y = this.vertexData[j + 1];
            ++i;
            j += this.stride;
        }
    }

    void getTextureCoordinates(int texCoordSet, int index, Point3f[] texCoords) {
        int offset = this.stride * index + this.textureOffset + texCoordSet * this.texCoordStride;
        int num = texCoords.length;
        int i = 0;
        int j = offset;
        while (i < num) {
            texCoords[i].x = this.vertexData[j];
            texCoords[i].y = this.vertexData[j + 1];
            texCoords[i].z = this.vertexData[j + 2];
            ++i;
            j += this.stride;
        }
    }

    public void getVertexAttr(int vertexAttrNum, int index, float[] vertexAttr) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        int size = this.vertexAttrSizes[vertexAttrNum];
        for (int i = 0; i < size; ++i) {
            vertexAttr[i] = this.vertexData[offset + i];
        }
    }

    public void getVertexAttr(int vertexAttrNum, int index, Point2f vertexAttr) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        vertexAttr.x = this.vertexData[offset];
        vertexAttr.y = this.vertexData[offset + 1];
    }

    public void getVertexAttr(int vertexAttrNum, int index, Point3f vertexAttr) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        vertexAttr.x = this.vertexData[offset];
        vertexAttr.y = this.vertexData[offset + 1];
        vertexAttr.z = this.vertexData[offset + 2];
    }

    public void getVertexAttr(int vertexAttrNum, int index, Point4f vertexAttr) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        vertexAttr.x = this.vertexData[offset];
        vertexAttr.y = this.vertexData[offset + 1];
        vertexAttr.z = this.vertexData[offset + 2];
        vertexAttr.w = this.vertexData[offset + 3];
    }

    public void getVertexAttrs(int vertexAttrNum, int index, float[] vertexAttrs) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        int size = this.vertexAttrSizes[vertexAttrNum];
        int i = 0;
        for (int j = offset; i < vertexAttrs.length && j < this.vertexData.length; i += size, j += this.stride) {
            for (int k = 0; k < size; ++k) {
                vertexAttrs[i + k] = this.vertexData[j + k];
            }
        }
    }

    public void getVertexAttrs(int vertexAttrNum, int index, Point2f[] vertexAttrs) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        int i = 0;
        for (int j = offset; i < vertexAttrs.length && j < this.vertexData.length; ++i, j += this.stride) {
            vertexAttrs[i].x = this.vertexData[j];
            vertexAttrs[i].y = this.vertexData[j + 1];
        }
    }

    public void getVertexAttrs(int vertexAttrNum, int index, Point3f[] vertexAttrs) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        int i = 0;
        for (int j = offset; i < vertexAttrs.length && j < this.vertexData.length; ++i, j += this.stride) {
            vertexAttrs[i].x = this.vertexData[j];
            vertexAttrs[i].y = this.vertexData[j + 1];
            vertexAttrs[i].z = this.vertexData[j + 2];
        }
    }

    public void getVertexAttrs(int vertexAttrNum, int index, Point4f[] vertexAttrs) {
        int offset = this.stride * index + this.vertexAttrOffsets[vertexAttrNum];
        int i = 0;
        for (int j = offset; i < vertexAttrs.length && j < this.vertexData.length; ++i, j += this.stride) {
            vertexAttrs[i].x = this.vertexData[j];
            vertexAttrs[i].y = this.vertexData[j + 1];
            vertexAttrs[i].z = this.vertexData[j + 2];
            vertexAttrs[i].w = this.vertexData[j + 3];
        }
    }

    void updateData(GeometryUpdater updater) {
        boolean nullGeo = false;
        this.geomLock.getLock();
        this.inUpdater = true;
        updater.updateData((Geometry)this.source);
        this.inUpdater = false;
        if ((this.vertexFormat & 0x80) != 0) {
            if ((this.vertexFormat & 0x800) != 0) {
                if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                    if ((this.vertexFormat & 0x100) != 0) {
                        this.setupMirrorInterleavedColorPointer(false);
                        nullGeo = this.interleavedFloatBufferImpl == null;
                    } else {
                        this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                        nullGeo = (this.vertexType & 0xF) == 0;
                    }
                }
            } else if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                if ((this.vertexFormat & 0x100) != 0) {
                    this.setupMirrorInterleavedColorPointer(false);
                    nullGeo = this.interLeavedVertexData == null;
                } else {
                    this.setupMirrorVertexPointer(this.vertexType & 0xF);
                    this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                    this.setupMirrorNormalPointer(this.vertexType & 0xC00);
                    this.setupMirrorTexCoordPointer(this.texCoordType);
                    this.setupMirrorVertexAttrPointer(this.vertexAttrType);
                    boolean bl = nullGeo = (this.vertexType & 0xF) == 0;
                }
            }
            if ((this.vertexFormat & 0x2000) != 0) {
                assert (this instanceof IndexedGeometryArrayRetained);
                if (((IndexedGeometryArrayRetained)this).getCoordIndicesRef() == null) {
                    nullGeo = true;
                }
                ((IndexedGeometryArrayRetained)this).doPostUpdaterUpdate();
            }
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.geomLock.unLock();
        if (this.source != null && this.source.isLive()) {
            this.processCoordsChanged(nullGeo);
            this.sendDataChangedMessage(true);
        }
    }

    boolean intersectBoundingBox(Point3d[] coordinates, BoundingBox box, double[] dist, Point3d iPnt) {
        int i;
        int[] out = new int[6];
        for (i = 0; i < 6; ++i) {
            out[i] = 0;
        }
        for (i = 0; i < coordinates.length; ++i) {
            if (coordinates[i].x >= box.lower.x && coordinates[i].x <= box.upper.x && coordinates[i].y >= box.lower.y && coordinates[i].y <= box.upper.y && coordinates[i].z >= box.lower.z && coordinates[i].z <= box.upper.z) {
                return true;
            }
            if (coordinates[i].x < box.lower.x) {
                out[0] = out[0] + 1;
            }
            if (coordinates[i].y < box.lower.y) {
                out[1] = out[1] + 1;
            }
            if (coordinates[i].z < box.lower.z) {
                out[2] = out[2] + 1;
            }
            if (coordinates[i].x > box.upper.x) {
                out[3] = out[3] + 1;
            }
            if (coordinates[i].y > box.upper.y) {
                out[4] = out[4] + 1;
            }
            if (!(coordinates[i].z > box.upper.z)) continue;
            out[5] = out[5] + 1;
        }
        if (out[0] == coordinates.length || out[1] == coordinates.length || out[2] == coordinates.length || out[3] == coordinates.length || out[4] == coordinates.length || out[5] == coordinates.length) {
            return false;
        }
        Point3d[] pCoor = new Point3d[4];
        for (i = 0; i < 4; ++i) {
            pCoor[i] = new Point3d();
        }
        Point3d boxCenter = new Point3d();
        box.getCenter(boxCenter);
        pCoor[0].set(box.lower.x, box.lower.y, box.lower.z);
        pCoor[1].set(box.lower.x, box.lower.y, box.upper.z);
        pCoor[2].set(box.lower.x, box.upper.y, box.upper.z);
        pCoor[3].set(box.lower.x, box.upper.y, box.lower.z);
        if (this.intersectPolygon(pCoor, coordinates)) {
            if (dist != null) {
                this.computeMinDistance(pCoor, boxCenter, null, dist, iPnt);
            }
            return true;
        }
        pCoor[0].set(box.upper.x, box.lower.y, box.lower.z);
        pCoor[1].set(box.upper.x, box.upper.y, box.lower.z);
        pCoor[2].set(box.upper.x, box.upper.y, box.upper.z);
        pCoor[3].set(box.upper.x, box.lower.y, box.upper.z);
        if (this.intersectPolygon(pCoor, coordinates)) {
            if (dist != null) {
                this.computeMinDistance(pCoor, boxCenter, null, dist, iPnt);
            }
            return true;
        }
        pCoor[0].set(box.upper.x, box.lower.y, box.upper.z);
        pCoor[1].set(box.lower.x, box.lower.y, box.upper.z);
        pCoor[2].set(box.lower.x, box.lower.y, box.lower.z);
        pCoor[3].set(box.upper.x, box.lower.y, box.lower.z);
        if (this.intersectPolygon(pCoor, coordinates)) {
            if (dist != null) {
                this.computeMinDistance(pCoor, boxCenter, null, dist, iPnt);
            }
            return true;
        }
        pCoor[0].set(box.upper.x, box.upper.y, box.upper.z);
        pCoor[1].set(box.upper.x, box.upper.y, box.lower.z);
        pCoor[2].set(box.lower.x, box.upper.y, box.lower.z);
        pCoor[3].set(box.lower.x, box.upper.y, box.upper.z);
        if (this.intersectPolygon(pCoor, coordinates)) {
            if (dist != null) {
                this.computeMinDistance(pCoor, boxCenter, null, dist, iPnt);
            }
            return true;
        }
        pCoor[0].set(box.upper.x, box.upper.y, box.upper.z);
        pCoor[1].set(box.lower.x, box.upper.y, box.upper.z);
        pCoor[2].set(box.lower.x, box.lower.y, box.upper.z);
        pCoor[3].set(box.upper.x, box.lower.y, box.upper.z);
        if (this.intersectPolygon(pCoor, coordinates)) {
            if (dist != null) {
                this.computeMinDistance(pCoor, boxCenter, null, dist, iPnt);
            }
            return true;
        }
        pCoor[0].set(box.upper.x, box.upper.y, box.lower.z);
        pCoor[1].set(box.upper.x, box.lower.y, box.lower.z);
        pCoor[2].set(box.lower.x, box.lower.y, box.lower.z);
        pCoor[3].set(box.lower.x, box.upper.y, box.lower.z);
        if (this.intersectPolygon(pCoor, coordinates)) {
            if (dist != null) {
                this.computeMinDistance(pCoor, boxCenter, null, dist, iPnt);
            }
            return true;
        }
        return false;
    }

    boolean intersectBoundingSphere(Point3d[] coordinates, BoundingSphere sphere, double[] dist, Point3d iPnt) {
        int j;
        int i;
        Vector3d tempV3D = new Vector3d();
        for (i = 0; i < coordinates.length; ++i) {
            tempV3D.x = coordinates[i].x - sphere.center.x;
            tempV3D.y = coordinates[i].y - sphere.center.y;
            tempV3D.z = coordinates[i].z - sphere.center.z;
            if (!(tempV3D.length() <= sphere.radius)) continue;
            if (dist != null) {
                this.computeMinDistance(coordinates, sphere.getCenter(), null, dist, iPnt);
            }
            return true;
        }
        for (i = 0; i < coordinates.length; ++i) {
            boolean esFlag = i < coordinates.length - 1 ? this.edgeIntersectSphere(sphere, coordinates[i], coordinates[i + 1]) : this.edgeIntersectSphere(sphere, coordinates[i], coordinates[0]);
            if (!esFlag) continue;
            if (dist != null) {
                this.computeMinDistance(coordinates, sphere.getCenter(), null, dist, iPnt);
            }
            return true;
        }
        if (coordinates.length < 3) {
            return false;
        }
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        Vector3d pa = new Vector3d();
        Point3d q = new Point3d();
        i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (!(vec0.length() > 0.0)) continue;
        }
        for (j = i; j < coordinates.length - 1; ++j) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        double nLenSq = pNrm.lengthSquared();
        if (nLenSq == 0.0) {
            return false;
        }
        pa.x = coordinates[0].x - sphere.center.x;
        pa.y = coordinates[0].y - sphere.center.y;
        pa.z = coordinates[0].z - sphere.center.z;
        double pNrmDotPa = pNrm.dot(pa);
        double pqLen = Math.sqrt(pNrmDotPa * pNrmDotPa / nLenSq);
        if (pqLen > sphere.radius) {
            return false;
        }
        double tq = pNrmDotPa / nLenSq;
        q.x = sphere.center.x + tq * pNrm.x;
        q.y = sphere.center.y + tq * pNrm.y;
        q.z = sphere.center.z + tq * pNrm.z;
        if (this.pointIntersectPolygon2D(pNrm, coordinates, q)) {
            if (dist != null) {
                this.computeMinDistance(coordinates, sphere.getCenter(), pNrm, dist, iPnt);
            }
            return true;
        }
        return false;
    }

    boolean intersectBoundingPolytope(Point3d[] coordinates, BoundingPolytope polytope, double[] dist, Point3d iPnt) {
        int j;
        int j2;
        int i;
        boolean debug = false;
        Point4d tP4d = new Point4d();
        double distanceSign = -1.0;
        if (coordinates.length == 2) {
            if (polytope.intersect(coordinates[0], coordinates[1], tP4d)) {
                if (dist != null) {
                    polytope.getCenter(iPnt);
                    double x = tP4d.x - iPnt.x;
                    double y = tP4d.y - iPnt.y;
                    double z = tP4d.z - iPnt.z;
                    dist[0] = Math.sqrt(x * x + y * y + z * z);
                    iPnt.x = tP4d.x;
                    iPnt.y = tP4d.y;
                    iPnt.z = tP4d.z;
                }
                return true;
            }
            return false;
        }
        if (debug) {
            int i2;
            System.err.println("The value of the input vertices are: ");
            for (i2 = 0; i2 < coordinates.length; ++i2) {
                System.err.println("The " + i2 + " th vertex is: " + coordinates[i2]);
            }
            System.err.println("The value of the input bounding Polytope's planes =");
            for (i2 = 0; i2 < polytope.planes.length; ++i2) {
                System.err.println("The " + i2 + " th plane is: " + polytope.planes[i2]);
            }
        }
        double[] centers = new double[]{0.8, 0.9, 1.1, 1.2};
        boolean intersection = true;
        boolean PreTest = false;
        if (PreTest) {
            for (int i3 = 0; i3 < coordinates.length; ++i3) {
                for (int j3 = 0; j3 < polytope.planes.length; ++j3) {
                    if (!(polytope.planes[j3].x * coordinates[i3].x + polytope.planes[j3].y * coordinates[i3].y + polytope.planes[j3].z * coordinates[i3].z <= distanceSign * polytope.planes[j3].w)) {
                        intersection = false;
                        break;
                    }
                    intersection = true;
                }
                if (!intersection) continue;
                if (dist != null) {
                    this.computeMinDistance(coordinates, polytope.getCenter(), null, dist, iPnt);
                }
                return true;
            }
        }
        int numberCols = polytope.planes.length + 2 + coordinates.length + 1;
        int numberRows = 1 + coordinates.length;
        double[][] problemTableau = new double[numberRows][numberCols];
        for (i = 0; i < polytope.planes.length; ++i) {
            for (j2 = 0; j2 < coordinates.length; ++j2) {
                problemTableau[j2][i] = -1.0 * (polytope.planes[i].x * coordinates[j2].x + polytope.planes[i].y * coordinates[j2].y + polytope.planes[i].z * coordinates[j2].z);
            }
        }
        for (i = 0; i < coordinates.length; ++i) {
            problemTableau[i][polytope.planes.length] = -1.0;
            problemTableau[i][polytope.planes.length + 1] = 1.0;
            for (j2 = 0; j2 < coordinates.length; ++j2) {
                problemTableau[i][j2 + polytope.planes.length + 2] = i == j2 ? 1.0 : 0.0;
                problemTableau[i][numberCols - 1] = centers[i];
            }
        }
        for (j = 0; j < polytope.planes.length; ++j) {
            problemTableau[numberRows - 1][j] = distanceSign * polytope.planes[j].w;
        }
        problemTableau[numberRows - 1][polytope.planes.length] = 1.0;
        problemTableau[numberRows - 1][polytope.planes.length + 1] = -1.0;
        for (j = 0; j < coordinates.length; ++j) {
            problemTableau[numberRows - 1][polytope.planes.length + 2 + j] = 0.0;
        }
        if (debug) {
            System.err.println("The value of the problem tableau is: ");
            for (i = 0; i < problemTableau.length; ++i) {
                for (j2 = 0; j2 < problemTableau[0].length; ++j2) {
                    System.err.print(problemTableau[i][j2] + "  ");
                }
                System.err.println();
            }
        }
        double distance = this.generalStandardSimplexSolver(problemTableau, Double.NEGATIVE_INFINITY);
        if (debug) {
            System.err.println("The value returned by the general standard simplex = " + distance);
        }
        if (distance == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (dist != null) {
            this.computeMinDistance(coordinates, polytope.getCenter(), null, dist, iPnt);
        }
        return true;
    }

    double generalStandardSimplexSolver(double[][] problemTableau, double stopingValue) {
        boolean debug = false;
        int numRow = problemTableau.length;
        int numCol = problemTableau[0].length;
        boolean optimal = false;
        if (debug) {
            System.err.println("The number of rows is : " + numRow);
            System.err.println("The number of columns is : " + numCol);
        }
        while (!optimal) {
            double element;
            int i;
            if (debug) {
                System.err.println("input problem tableau is:");
                for (int k = 0; k < numRow; ++k) {
                    for (int j = 0; j < numCol; ++j) {
                        System.err.println("kth, jth value is:" + k + " " + j + " : " + problemTableau[k][j]);
                    }
                }
            }
            double maxElement = 0.0;
            int pivotColIndex = -1;
            for (i = 0; i < numCol - 1; ++i) {
                element = problemTableau[numRow - 1][i];
                if (!(element < maxElement)) continue;
                maxElement = element;
                pivotColIndex = i;
            }
            if (pivotColIndex == -1) {
                optimal = true;
            }
            if (optimal) continue;
            double prevRatio = Double.POSITIVE_INFINITY;
            double ratio = 0.0;
            int pivotRowIndex = -1;
            for (i = 0; i < numRow - 1; ++i) {
                element = problemTableau[i][pivotColIndex];
                double endElement = problemTableau[i][numCol - 1];
                if (element == 0.0) {
                    if (!debug) continue;
                    System.err.println("Division by zero has occurred");
                    System.err.println("Within the linear program solver");
                    System.err.println("Ignoring the zero as a potential pivot");
                    continue;
                }
                if (element < 0.0 || endElement < 0.0) {
                    if (!debug) continue;
                    System.err.println("Ignoring cases where element is negative");
                    System.err.println("The value of element is: " + element);
                    System.err.println("The value of end Element is: " + endElement);
                    continue;
                }
                ratio = endElement / element;
                if (debug) {
                    System.err.println("The value of element is: " + element);
                    System.err.println("The value of endElement is: " + endElement);
                    System.err.println("The value of ratio is: " + ratio);
                    System.err.println("The value of prevRatio is: " + prevRatio);
                    System.err.println("Value of ratio <= prevRatio is :" + (ratio <= prevRatio));
                }
                if (!(ratio <= prevRatio)) continue;
                if (debug) {
                    System.err.println("updating prevRatio with ratio");
                }
                prevRatio = ratio;
                pivotRowIndex = i;
            }
            if (pivotRowIndex == -1) {
                if (debug) {
                    System.err.println("UNABLE TO FIND SOLUTION");
                    System.err.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double pivotValue = problemTableau[pivotRowIndex][pivotColIndex];
            if (debug) {
                System.err.println("The value of row index is: " + pivotRowIndex);
                System.err.println("The value of col index is: " + pivotColIndex);
                System.err.println("The value of pivotValue is: " + pivotValue);
            }
            for (i = 0; i < numCol; ++i) {
                problemTableau[pivotRowIndex][i] = problemTableau[pivotRowIndex][i] / pivotValue;
            }
            for (i = 0; i < numRow; ++i) {
                if (i == pivotRowIndex) continue;
                double multiplier = problemTableau[i][pivotColIndex];
                for (int j = 0; j < numCol; ++j) {
                    problemTableau[i][j] = problemTableau[i][j] - multiplier * problemTableau[pivotRowIndex][j];
                }
            }
        }
        return problemTableau[numRow - 1][numCol - 1];
    }

    boolean edgeIntersectSphere(BoundingSphere sphere, Point3d start, Point3d end) {
        Vector3d ab = new Vector3d();
        Vector3d ap = new Vector3d();
        ab.x = end.x - start.x;
        ab.y = end.y - start.y;
        ab.z = end.z - start.z;
        ap.x = sphere.center.x - start.x;
        ap.y = sphere.center.y - start.y;
        ap.z = sphere.center.z - start.z;
        double abDotAp = ab.dot(ap);
        if (abDotAp < 0.0) {
            return false;
        }
        double abLenSq = ab.lengthSquared();
        double acLenSq = abDotAp * abDotAp / abLenSq;
        if (acLenSq < abLenSq) {
            return false;
        }
        double radiusSq = sphere.radius * sphere.radius;
        double apLenSq = ap.lengthSquared();
        return apLenSq - acLenSq <= radiusSq;
    }

    double det2D(Point2d a, Point2d b, Point2d p) {
        return (p.x - a.x) * (a.y - b.y) + (a.y - p.y) * (a.x - b.x);
    }

    boolean pointIntersectPolygon2D(Vector3d normal, Point3d[] coord, Point3d point) {
        Point2d[] coord2D = new Point2d[coord.length];
        Point2d pnt = new Point2d();
        double absNrmX = Math.abs(normal.x);
        double absNrmY = Math.abs(normal.y);
        double absNrmZ = Math.abs(normal.z);
        int axis = absNrmX > absNrmY ? 0 : 1;
        if (axis == 0) {
            if (absNrmX < absNrmZ) {
                axis = 2;
            }
        } else if (axis == 1 && absNrmY < absNrmZ) {
            axis = 2;
        }
        block10: for (int i = 0; i < coord.length; ++i) {
            coord2D[i] = new Point2d();
            switch (axis) {
                case 0: {
                    coord2D[i].x = coord[i].y;
                    coord2D[i].y = coord[i].z;
                    continue block10;
                }
                case 1: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].z;
                    continue block10;
                }
                case 2: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].y;
                }
            }
        }
        switch (axis) {
            case 0: {
                pnt.x = point.y;
                pnt.y = point.z;
                break;
            }
            case 1: {
                pnt.x = point.x;
                pnt.y = point.z;
                break;
            }
            case 2: {
                pnt.x = point.x;
                pnt.y = point.y;
            }
        }
        for (int j = 0; j < coord.length; ++j) {
            if (j < coord.length - 1) {
                if (this.det2D(coord2D[j], coord2D[j + 1], pnt) > 0.0) continue;
                return false;
            }
            if (this.det2D(coord2D[j], coord2D[0], pnt) > 0.0) continue;
            return false;
        }
        return true;
    }

    boolean edgeIntersectPlane(Vector3d normal, Point3d pnt, Point3d start, Point3d end, Point3d iPnt) {
        Vector3d tempV3d = new Vector3d();
        Vector3d direction = new Vector3d();
        tempV3d.set((Tuple3d)pnt);
        double pD = normal.dot(tempV3d);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        double pNrmDotrDir = normal.dot(direction);
        if (pNrmDotrDir == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)start);
        double tr = (pD - normal.dot(tempV3d)) / pNrmDotrDir;
        if (tr < 0.0 || tr > 1.0) {
            return false;
        }
        iPnt.x = start.x + tr * direction.x;
        iPnt.y = start.y + tr * direction.y;
        iPnt.z = start.z + tr * direction.z;
        return true;
    }

    boolean edgeIntersectPolygon2D(Vector3d normal, Point3d[] coord, Point3d[] seg) {
        int i;
        Point2d[] coord2D = new Point2d[coord.length];
        Point2d[] seg2D = new Point2d[2];
        double absNrmX = Math.abs(normal.x);
        double absNrmY = Math.abs(normal.y);
        double absNrmZ = Math.abs(normal.z);
        int axis = absNrmX > absNrmY ? 0 : 1;
        if (axis == 0) {
            if (absNrmX < absNrmZ) {
                axis = 2;
            }
        } else if (axis == 1 && absNrmY < absNrmZ) {
            axis = 2;
        }
        block10: for (i = 0; i < coord.length; ++i) {
            coord2D[i] = new Point2d();
            switch (axis) {
                case 0: {
                    coord2D[i].x = coord[i].y;
                    coord2D[i].y = coord[i].z;
                    continue block10;
                }
                case 1: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].z;
                    continue block10;
                }
                case 2: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].y;
                }
            }
        }
        block11: for (i = 0; i < 2; ++i) {
            seg2D[i] = new Point2d();
            switch (axis) {
                case 0: {
                    seg2D[i].x = seg[i].y;
                    seg2D[i].y = seg[i].z;
                    continue block11;
                }
                case 1: {
                    seg2D[i].x = seg[i].x;
                    seg2D[i].y = seg[i].z;
                    continue block11;
                }
                case 2: {
                    seg2D[i].x = seg[i].x;
                    seg2D[i].y = seg[i].y;
                }
            }
        }
        boolean[][] pntTest = new boolean[2][coord.length];
        for (int j = 0; j < coord.length; ++j) {
            for (i = 0; i < 2; ++i) {
                pntTest[i][j] = j < coord.length - 1 ? this.det2D(coord2D[j], coord2D[j + 1], seg2D[i]) < 0.0 : this.det2D(coord2D[j], coord2D[0], seg2D[i]) < 0.0;
            }
            if (pntTest[0][j] || pntTest[1][j]) continue;
            return false;
        }
        boolean testFlag = true;
        for (i = 0; i < coord.length; ++i) {
            if (pntTest[0][i]) continue;
            testFlag = false;
            break;
        }
        if (testFlag) {
            return true;
        }
        testFlag = true;
        for (i = 0; i < coord.length; ++i) {
            if (pntTest[1][i]) continue;
            testFlag = false;
            break;
        }
        if (testFlag) {
            return true;
        }
        int cnt = 0;
        for (i = 0; i < coord.length; ++i) {
            if (!(this.det2D(seg2D[0], seg2D[1], coord2D[i]) < 0.0)) continue;
            ++cnt;
        }
        return cnt != 0 && cnt != coord.length;
    }

    double getCompValue(Point3d v, int i) {
        switch (i) {
            case 0: {
                return v.x;
            }
            case 1: {
                return v.y;
            }
        }
        return v.z;
    }

    double getCompValue(Point3d v0, Point3d v1, int i) {
        switch (i) {
            case 0: {
                return v0.x - v1.x;
            }
            case 1: {
                return v0.y - v1.y;
            }
        }
        return v0.z - v1.z;
    }

    boolean pointInTri(Point3d v0, Point3d u0, Point3d u1, Point3d u2, Vector3d normal) {
        int i1;
        int i0;
        double nAbsX = Math.abs(normal.x);
        double nAbsY = Math.abs(normal.y);
        double nAbsZ = Math.abs(normal.z);
        if (nAbsX > nAbsY) {
            if (nAbsX > nAbsZ) {
                i0 = 1;
                i1 = 2;
            } else {
                i0 = 0;
                i1 = 1;
            }
        } else if (nAbsZ > nAbsY) {
            i0 = 0;
            i1 = 1;
        } else {
            i0 = 0;
            i1 = 2;
        }
        return this.pointInTri(v0, u0, u1, u2, i0, i1);
    }

    boolean pointInTri(Point3d v0, Point3d u0, Point3d u1, Point3d u2, int i0, int i1) {
        double a = this.getCompValue(u1, u0, i1);
        double b = -this.getCompValue(u1, u0, i0);
        double c = -a * this.getCompValue(u0, i0) - b * this.getCompValue(u0, i1);
        double d0 = a * this.getCompValue(v0, i0) + b * this.getCompValue(v0, i1) + c;
        a = this.getCompValue(u2, u1, i1);
        b = -this.getCompValue(u2, u1, i0);
        c = -a * this.getCompValue(u1, i0) - b * this.getCompValue(u1, i1);
        double d1 = a * this.getCompValue(v0, i0) + b * this.getCompValue(v0, i1) + c;
        a = this.getCompValue(u0, u2, i1);
        b = -this.getCompValue(u0, u2, i0);
        c = -a * this.getCompValue(u2, i0) - b * this.getCompValue(u2, i1);
        double d2 = a * this.getCompValue(v0, i0) + b * this.getCompValue(v0, i1) + c;
        return d0 * d1 > 0.0 && d0 * d2 > 0.0;
    }

    boolean edgeAgainstEdge(Point3d v0, Point3d u0, Point3d u1, double aX, double aY, int i0, int i1) {
        double bX = this.getCompValue(u0, u1, i0);
        double bY = this.getCompValue(u0, u1, i1);
        double cX = this.getCompValue(v0, u0, i0);
        double cY = this.getCompValue(v0, u0, i1);
        double f = aY * bX - aX * bY;
        double d = bY * cX - bX * cY;
        if (f > 0.0 && d >= 0.0 && d <= f || f < 0.0 && d <= 0.0 && d >= f) {
            double e = aX * cY - aY * cX;
            if (f > 0.0 ? e >= 0.0 && e <= f : e <= 0.0 && e >= f) {
                return true;
            }
        }
        return false;
    }

    boolean edgeAgainstTriEdges(Point3d v0, Point3d v1, Point3d u0, Point3d u1, Point3d u2, int i0, int i1) {
        double aY;
        double aX = this.getCompValue(v1, v0, i0);
        if (this.edgeAgainstEdge(v0, u0, u1, aX, aY = this.getCompValue(v1, v0, i1), i0, i1)) {
            return true;
        }
        if (this.edgeAgainstEdge(v0, u1, u2, aX, aY, i0, i1)) {
            return true;
        }
        return this.edgeAgainstEdge(v0, u2, u0, aX, aY, i0, i1);
    }

    boolean coplanarTriTri(Vector3d normal, Point3d v0, Point3d v1, Point3d v2, Point3d u0, Point3d u1, Point3d u2) {
        int i1;
        int i0;
        double nAbsX = Math.abs(normal.x);
        double nAbsY = Math.abs(normal.y);
        double nAbsZ = Math.abs(normal.z);
        if (nAbsX > nAbsY) {
            if (nAbsX > nAbsZ) {
                i0 = 1;
                i1 = 2;
            } else {
                i0 = 0;
                i1 = 1;
            }
        } else if (nAbsZ > nAbsY) {
            i0 = 0;
            i1 = 1;
        } else {
            i0 = 0;
            i1 = 2;
        }
        if (this.edgeAgainstTriEdges(v0, v1, u0, u1, u2, i0, i1)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(v1, v2, u0, u1, u2, i0, i1)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(v2, v0, u0, u1, u2, i0, i1)) {
            return true;
        }
        if (this.pointInTri(v0, u0, u1, u2, i0, i1)) {
            return true;
        }
        return this.pointInTri(u0, v0, v1, v2, i0, i1);
    }

    boolean intersectTriPnt(Point3d v0, Point3d v1, Point3d v2, Point3d u) {
        int i1;
        int i0;
        Vector3d e1 = new Vector3d();
        Vector3d e2 = new Vector3d();
        Vector3d n1 = new Vector3d();
        Vector3d tempV3d = new Vector3d();
        e1.x = v1.x - v0.x;
        e1.y = v1.y - v0.y;
        e1.z = v1.z - v0.z;
        e2.x = v2.x - v0.x;
        e2.y = v2.y - v0.y;
        e2.z = v2.z - v0.z;
        n1.cross(e1, e2);
        if (n1.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)v0);
        double d1 = -n1.dot(tempV3d);
        tempV3d.set((Tuple3d)u);
        double du = n1.dot(tempV3d) + d1;
        if (Math.abs(du) < 1.0E-13) {
            du = 0.0;
        }
        if (du != 0.0) {
            return false;
        }
        double nAbsX = Math.abs(n1.x);
        double nAbsY = Math.abs(n1.y);
        double nAbsZ = Math.abs(n1.z);
        if (nAbsX > nAbsY) {
            if (nAbsX > nAbsZ) {
                i0 = 1;
                i1 = 2;
            } else {
                i0 = 0;
                i1 = 1;
            }
        } else if (nAbsZ > nAbsY) {
            i0 = 0;
            i1 = 1;
        } else {
            i0 = 0;
            i1 = 2;
        }
        return this.pointInTri(u, v0, v1, v2, i0, i1);
    }

    boolean intersectTriTri(Point3d v0, Point3d v1, Point3d v2, Point3d u0, Point3d u1, Point3d u2) {
        Vector3d e1 = new Vector3d();
        Vector3d e2 = new Vector3d();
        Vector3d n1 = new Vector3d();
        Vector3d n2 = new Vector3d();
        Vector3d tempV3d = new Vector3d();
        double vp0 = 0.0;
        double vp1 = 0.0;
        double vp2 = 0.0;
        double up0 = 0.0;
        double up1 = 0.0;
        double up2 = 0.0;
        e1.x = v1.x - v0.x;
        e1.y = v1.y - v0.y;
        e1.z = v1.z - v0.z;
        e2.x = v2.x - v0.x;
        e2.y = v2.y - v0.y;
        e2.z = v2.z - v0.z;
        n1.cross(e1, e2);
        if (n1.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)v0);
        double d1 = -n1.dot(tempV3d);
        tempV3d.set((Tuple3d)u0);
        double du0 = n1.dot(tempV3d) + d1;
        tempV3d.set((Tuple3d)u1);
        double du1 = n1.dot(tempV3d) + d1;
        tempV3d.set((Tuple3d)u2);
        double du2 = n1.dot(tempV3d) + d1;
        if (Math.abs(du0) < 1.0E-13) {
            du0 = 0.0;
        }
        if (Math.abs(du1) < 1.0E-13) {
            du1 = 0.0;
        }
        if (Math.abs(du2) < 1.0E-13) {
            du2 = 0.0;
        }
        double du0du1 = du0 * du1;
        double du0du2 = du0 * du2;
        if (du0du1 > 0.0 && du0du2 > 0.0) {
            return false;
        }
        e1.x = u1.x - u0.x;
        e1.y = u1.y - u0.y;
        e1.z = u1.z - u0.z;
        e2.x = u2.x - u0.x;
        e2.y = u2.y - u0.y;
        e2.z = u2.z - u0.z;
        n2.cross(e1, e2);
        if (n2.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)u0);
        double d2 = -n2.dot(tempV3d);
        tempV3d.set((Tuple3d)v0);
        double dv0 = n2.dot(tempV3d) + d2;
        tempV3d.set((Tuple3d)v1);
        double dv1 = n2.dot(tempV3d) + d2;
        tempV3d.set((Tuple3d)v2);
        double dv2 = n2.dot(tempV3d) + d2;
        if (Math.abs(dv0) < 1.0E-13) {
            dv0 = 0.0;
        }
        if (Math.abs(dv1) < 1.0E-13) {
            dv1 = 0.0;
        }
        if (Math.abs(dv2) < 1.0E-13) {
            dv2 = 0.0;
        }
        double dv0dv1 = dv0 * dv1;
        double dv0dv2 = dv0 * dv2;
        if (dv0dv1 > 0.0 && dv0dv2 > 0.0) {
            return false;
        }
        tempV3d.cross(n1, n2);
        double max = Math.abs(tempV3d.x);
        int index = 0;
        double bb = Math.abs(tempV3d.y);
        double cc = Math.abs(tempV3d.z);
        if (bb > max) {
            max = bb;
            index = 1;
        }
        if (cc > max) {
            max = cc;
            index = 2;
        }
        switch (index) {
            case 0: {
                vp0 = v0.x;
                vp1 = v1.x;
                vp2 = v2.x;
                up0 = u0.x;
                up1 = u1.x;
                up2 = u2.x;
                break;
            }
            case 1: {
                vp0 = v0.y;
                vp1 = v1.y;
                vp2 = v2.y;
                up0 = u0.y;
                up1 = u1.y;
                up2 = u2.y;
                break;
            }
            case 2: {
                vp0 = v0.z;
                vp1 = v1.z;
                vp2 = v2.z;
                up0 = u0.z;
                up1 = u1.z;
                up2 = u2.z;
            }
        }
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double x0 = 0.0;
        double x1 = 0.0;
        if (dv0dv1 > 0.0) {
            a = vp2;
            b = (vp0 - vp2) * dv2;
            c = (vp1 - vp2) * dv2;
            x0 = dv2 - dv0;
            x1 = dv2 - dv1;
        } else if (dv0dv2 > 0.0) {
            a = vp1;
            b = (vp0 - vp1) * dv1;
            c = (vp2 - vp1) * dv1;
            x0 = dv1 - dv0;
            x1 = dv1 - dv2;
        } else if (dv1 * dv2 > 0.0 || dv0 != 0.0) {
            a = vp0;
            b = (vp1 - vp0) * dv0;
            c = (vp2 - vp0) * dv0;
            x0 = dv0 - dv1;
            x1 = dv0 - dv2;
        } else if (dv1 != 0.0) {
            a = vp1;
            b = (vp0 - vp1) * dv1;
            c = (vp2 - vp1) * dv1;
            x0 = dv1 - dv0;
            x1 = dv1 - dv2;
        } else if (dv2 != 0.0) {
            a = vp2;
            b = (vp0 - vp2) * dv2;
            c = (vp1 - vp2) * dv2;
            x0 = dv2 - dv0;
            x1 = dv2 - dv1;
        } else {
            boolean toreturn = this.coplanarTriTri(n1, v0, v1, v2, u0, u1, u2);
            return toreturn;
        }
        double d = 0.0;
        double e = 0.0;
        double f = 0.0;
        double y0 = 0.0;
        double y1 = 0.0;
        if (du0du1 > 0.0) {
            d = up2;
            e = (up0 - up2) * du2;
            f = (up1 - up2) * du2;
            y0 = du2 - du0;
            y1 = du2 - du1;
        } else if (du0du2 > 0.0) {
            d = up1;
            e = (up0 - up1) * du1;
            f = (up2 - up1) * du1;
            y0 = du1 - du0;
            y1 = du1 - du2;
        } else if (du1 * du2 > 0.0 || du0 != 0.0) {
            d = up0;
            e = (up1 - up0) * du0;
            f = (up2 - up0) * du0;
            y0 = du0 - du1;
            y1 = du0 - du2;
        } else if (du1 != 0.0) {
            d = up1;
            e = (up0 - up1) * du1;
            f = (up2 - up1) * du1;
            y0 = du1 - du0;
            y1 = du1 - du2;
        } else if (du2 != 0.0) {
            d = up2;
            e = (up0 - up2) * du2;
            f = (up1 - up2) * du2;
            y0 = du2 - du0;
            y1 = du2 - du1;
        } else {
            boolean toreturn = this.coplanarTriTri(n2, v0, v1, v2, u0, u1, u2);
            return toreturn;
        }
        double xx = x0 * x1;
        double yy = y0 * y1;
        double xxyy = xx * yy;
        double tmp = a * xxyy;
        double isect1S = tmp + b * x1 * yy;
        double isect1E = tmp + c * x0 * yy;
        tmp = d * xxyy;
        double isect2S = tmp + e * y1 * xx;
        double isect2E = tmp + f * y0 * xx;
        if (isect1S > isect1E) {
            tmp = isect1S;
            isect1S = isect1E;
            isect1E = tmp;
        }
        if (isect2S > isect2E) {
            tmp = isect2S;
            isect2S = isect2E;
            isect2E = tmp;
        }
        return !(isect1E < isect2S) && !(isect2E < isect1S);
    }

    boolean intersectPolygon(Point3d[] coord1, Point3d[] coord2) {
        boolean epFlag;
        int j;
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        int i = 0;
        while (i < coord1.length - 1) {
            vec0.x = coord1[i + 1].x - coord1[i].x;
            vec0.y = coord1[i + 1].y - coord1[i].y;
            vec0.z = coord1[i + 1].z - coord1[i++].z;
            if (!(vec0.length() > 0.0)) continue;
        }
        for (j = i; j < coord1.length - 1; ++j) {
            vec1.x = coord1[j + 1].x - coord1[j].x;
            vec1.y = coord1[j + 1].y - coord1[j].y;
            vec1.z = coord1[j + 1].z - coord1[j].z;
            if (vec1.length() > 0.0) break;
        }
        if (j == coord1.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        if (pNrm.length() == 0.0) {
            return false;
        }
        j = 0;
        Point3d[] seg = new Point3d[]{new Point3d(), new Point3d()};
        for (i = 0; !(i >= coord2.length || (epFlag = i < coord2.length - 1 ? this.edgeIntersectPlane(pNrm, coord1[0], coord2[i], coord2[i + 1], seg[j]) : this.edgeIntersectPlane(pNrm, coord1[0], coord2[i], coord2[0], seg[j])) && ++j > 1); ++i) {
        }
        if (j == 0) {
            return false;
        }
        if (coord2.length < 3) {
            boolean toreturn = this.pointIntersectPolygon2D(pNrm, coord1, seg[0]);
            return toreturn;
        }
        boolean toreturn = this.edgeIntersectPolygon2D(pNrm, coord1, seg);
        return toreturn;
    }

    boolean intersectRay(Point3d[] coordinates, PickRay ray, double[] dist, Point3d iPnt) {
        return this.intersectRayOrSegment(coordinates, ray.direction, ray.origin, dist, iPnt, false);
    }

    boolean intersectSegment(Point3d[] coordinates, Point3d start, Point3d end, double[] dist, Point3d iPnt) {
        Vector3d direction = new Vector3d();
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        boolean result = this.intersectRayOrSegment(coordinates, direction, start, dist, iPnt, true);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean intersectRayOrSegment(Point3d[] coordinates, Vector3d direction, Point3d origin, double[] dist, Point3d iPnt, boolean isSegment) {
        int i;
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        double pNrmDotrDir = 0.0;
        boolean isIntersect = false;
        int k = 0;
        int l = 0;
        for (i = 0; i < coordinates.length; ++i) {
            l = i != coordinates.length - 1 ? i + 1 : 0;
            vec0.x = coordinates[l].x - coordinates[i].x;
            vec0.y = coordinates[l].y - coordinates[i].y;
            vec0.z = coordinates[l].z - coordinates[i].z;
            if (vec0.length() > 0.0) break;
        }
        for (int j = l; j < coordinates.length; ++j) {
            k = j != coordinates.length - 1 ? j + 1 : 0;
            vec1.x = coordinates[k].x - coordinates[j].x;
            vec1.y = coordinates[k].y - coordinates[j].y;
            vec1.z = coordinates[k].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
        }
        pNrm.cross(vec0, vec1);
        if (vec1.length() == 0.0 || pNrm.length() == 0.0) {
            k = l == 0 ? coordinates.length - 1 : l - 1;
            return this.intersectLineAndRay(coordinates[l], coordinates[k], origin, direction, dist, iPnt);
        }
        pNrmDotrDir = pNrm.dot(direction);
        if (pNrmDotrDir == 0.0) {
            i = 0;
            while (i < coordinates.length) {
                k = i != coordinates.length - 1 ? i + 1 : 0;
                if (this.intersectLineAndRay(coordinates[i], coordinates[k], origin, direction, dist, iPnt)) {
                    return true;
                }
                ++i;
            }
            return isIntersect;
        }
        Vector3d tempV3d = new Vector3d();
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        tempV3d.set((Tuple3d)origin);
        dist[0] = (pD - pNrm.dot(tempV3d)) / pNrmDotrDir;
        if (dist[0] < -1.0E-13) return false;
        if (isSegment && dist[0] > 1.0000000000001) {
            return false;
        }
        if (iPnt == null) {
            iPnt = new Point3d();
        }
        iPnt.x = origin.x + direction.x * dist[0];
        iPnt.y = origin.y + direction.y * dist[0];
        iPnt.z = origin.z + direction.z * dist[0];
        double absNrmX = Math.abs(pNrm.x);
        double absNrmY = Math.abs(pNrm.y);
        double absNrmZ = Math.abs(pNrm.z);
        double lastSign = 0.0;
        Point3d p0 = coordinates[coordinates.length - 1];
        Point3d p1 = coordinates[0];
        isIntersect = true;
        if (absNrmX > absNrmY) {
            if (absNrmX < absNrmZ) {
                for (i = 0; i < coordinates.length; ++i) {
                    p0 = coordinates[i];
                    p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                    double sign = (iPnt.y - p0.y) * (p1.x - p0.x) - (iPnt.x - p0.x) * (p1.y - p0.y);
                    if (GeometryArrayRetained.isNonZero(sign)) {
                        if (sign * lastSign < 0.0) {
                            return false;
                        }
                        lastSign = sign;
                        continue;
                    }
                    double t = p1.y - p0.y;
                    if (GeometryArrayRetained.isNonZero(t)) {
                        if (!((t = (iPnt.y - p0.y) / t) > -1.0E-13)) return false;
                        if (!(t < 1.0000000000001)) return false;
                        boolean bl = true;
                        isIntersect = bl;
                    } else {
                        t = p1.x - p0.x;
                        if (!GeometryArrayRetained.isNonZero(t)) continue;
                        if (!((t = (iPnt.x - p0.x) / t) > -1.0E-13)) return false;
                        if (!(t < 1.0000000000001)) return false;
                        boolean bl = true;
                        isIntersect = bl;
                    }
                    break;
                }
            } else {
                for (i = 0; i < coordinates.length; ++i) {
                    p0 = coordinates[i];
                    p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                    double sign = (iPnt.y - p0.y) * (p1.z - p0.z) - (iPnt.z - p0.z) * (p1.y - p0.y);
                    if (GeometryArrayRetained.isNonZero(sign)) {
                        if (sign * lastSign < 0.0) {
                            return false;
                        }
                        lastSign = sign;
                        continue;
                    }
                    double t = p1.y - p0.y;
                    if (GeometryArrayRetained.isNonZero(t)) {
                        if (!((t = (iPnt.y - p0.y) / t) > -1.0E-13)) return false;
                        if (!(t < 1.0000000000001)) return false;
                        boolean bl = true;
                        isIntersect = bl;
                    } else {
                        t = p1.z - p0.z;
                        if (!GeometryArrayRetained.isNonZero(t)) continue;
                        if (!((t = (iPnt.z - p0.z) / t) > -1.0E-13)) return false;
                        if (!(t < 1.0000000000001)) return false;
                        boolean bl = true;
                        isIntersect = bl;
                    }
                    break;
                }
            }
        } else if (absNrmY < absNrmZ) {
            for (i = 0; i < coordinates.length; ++i) {
                p0 = coordinates[i];
                p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                double sign = (iPnt.y - p0.y) * (p1.x - p0.x) - (iPnt.x - p0.x) * (p1.y - p0.y);
                if (GeometryArrayRetained.isNonZero(sign)) {
                    if (sign * lastSign < 0.0) {
                        return false;
                    }
                    lastSign = sign;
                    continue;
                }
                double t = p1.y - p0.y;
                if (GeometryArrayRetained.isNonZero(t)) {
                    if (!((t = (iPnt.y - p0.y) / t) > -1.0E-13)) return false;
                    if (!(t < 1.0000000000001)) return false;
                    boolean bl = true;
                    isIntersect = bl;
                } else {
                    t = p1.x - p0.x;
                    if (!GeometryArrayRetained.isNonZero(t)) continue;
                    if (!((t = (iPnt.x - p0.x) / t) > -1.0E-13)) return false;
                    if (!(t < 1.0000000000001)) return false;
                    boolean bl = true;
                    isIntersect = bl;
                }
                break;
            }
        } else {
            for (i = 0; i < coordinates.length; ++i) {
                p0 = coordinates[i];
                p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                double sign = (iPnt.x - p0.x) * (p1.z - p0.z) - (iPnt.z - p0.z) * (p1.x - p0.x);
                if (GeometryArrayRetained.isNonZero(sign)) {
                    if (sign * lastSign < 0.0) {
                        return false;
                    }
                    lastSign = sign;
                    continue;
                }
                double t = p1.x - p0.x;
                if (GeometryArrayRetained.isNonZero(t)) {
                    if (!((t = (iPnt.x - p0.x) / t) > -1.0E-13)) return false;
                    if (!(t < 1.0000000000001)) return false;
                    boolean bl = true;
                    isIntersect = bl;
                } else {
                    t = p1.z - p0.z;
                    if (!GeometryArrayRetained.isNonZero(t)) continue;
                    if (!((t = (iPnt.z - p0.z) / t) > -1.0E-13)) return false;
                    if (!(t < 1.0000000000001)) return false;
                    boolean bl = true;
                    isIntersect = bl;
                }
                break;
            }
        }
        if (!isIntersect) return isIntersect;
        dist[0] = dist[0] * direction.length();
        return isIntersect;
    }

    static final boolean isNonZero(double v) {
        return v > 1.0E-13 || v < -1.0E-13;
    }

    boolean inside(Point3d[] coordinates, PickPoint point, int ccw) {
        int j;
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        Vector3d tempV3d = new Vector3d();
        int i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (!(vec0.length() > 0.0)) continue;
        }
        for (j = i; j < coordinates.length - 1; ++j) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        if (ccw == 1) {
            pNrm.cross(vec0, vec1);
        } else {
            pNrm.cross(vec1, vec0);
        }
        if (pNrm.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        tempV3d.set((Tuple3d)point.location);
        return pD - pNrm.dot(tempV3d) <= 0.0;
    }

    boolean intersectPntAndPnt(Point3d pnt1, Point3d pnt2) {
        return pnt1.x == pnt2.x && pnt1.y == pnt2.y && pnt1.z == pnt2.z;
    }

    boolean intersectPntAndRay(Point3d pnt, Point3d ori, Vector3d dir, double[] dist) {
        double temp;
        int flag = 0;
        if (dir.x != 0.0) {
            flag = 0;
            dist[0] = (pnt.x - ori.x) / dir.x;
        } else if (dir.y != 0.0) {
            if (pnt.x != ori.x) {
                return false;
            }
            flag = 1;
            dist[0] = (pnt.y - ori.y) / dir.y;
        } else if (dir.z != 0.0) {
            if (pnt.x != ori.x || pnt.y != ori.y) {
                return false;
            }
            flag = 2;
            dist[0] = (pnt.z - ori.z) / dir.z;
        } else {
            return false;
        }
        if (dist[0] < 0.0) {
            return false;
        }
        if (flag == 0 && (pnt.y < (temp = ori.y + dist[0] * dir.y) - 1.0E-13 || pnt.y > temp + 1.0E-13)) {
            return false;
        }
        return flag >= 2 || !(pnt.z < (temp = ori.z + dist[0] * dir.z) - 1.0E-13) && !(pnt.z > temp + 1.0E-13);
    }

    boolean intersectLineAndRay(Point3d start, Point3d end, Point3d ori, Vector3d dir, double[] dist, Point3d iPnt) {
        Vector3d lDir = new Vector3d();
        lDir.x = end.x - start.x;
        lDir.y = end.y - start.y;
        lDir.z = end.z - start.z;
        double m00 = lDir.x;
        double m11 = -dir.y;
        double m10 = lDir.y;
        double m01 = -dir.x;
        double dmt = m00 * m11 - m10 * m01;
        if (dmt == 0.0) {
            boolean isIntersect = false;
            if (lDir.x == 0.0 && lDir.y == 0.0 && lDir.z == 0.0 && (isIntersect = this.intersectPntAndRay(start, ori, dir, dist)) && iPnt != null) {
                iPnt.set((Tuple3d)start);
            }
            return isIntersect;
        }
        double tmp1 = 1.0 / dmt;
        double mInv00 = tmp1 * m11;
        double mInv01 = tmp1 * -m01;
        double mInv10 = tmp1 * -m10;
        double mInv11 = tmp1 * m00;
        tmp1 = ori.x - start.x;
        double tmp2 = ori.y - start.y;
        double t = mInv00 * tmp1 + mInv01 * tmp2;
        double s = mInv10 * tmp1 + mInv11 * tmp2;
        if (s < 0.0) {
            return false;
        }
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        tmp1 = ori.z + s * dir.z;
        tmp2 = start.z + t * lDir.z;
        if (tmp1 < tmp2 - 1.0E-13 || tmp1 > tmp2 + 1.0E-13) {
            return false;
        }
        dist[0] = s;
        if (iPnt != null) {
            iPnt.x = ori.x + dir.x * dist[0];
            iPnt.y = ori.y + dir.y * dist[0];
            iPnt.z = ori.z + dir.z * dist[0];
        }
        return true;
    }

    boolean intersectCylinder(Point3d[] coordinates, PickCylinder cyl, double[] dist, Point3d iPnt) {
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt1 = new Point3d();
        Vector3d originToIpnt = new Vector3d();
        if (iPnt == null) {
            iPnt = new Point3d();
        }
        cyl.getOrigin(origin);
        cyl.getDirection(direction);
        double radius = cyl.getRadius();
        if (cyl instanceof PickCylinderSegment) {
            ((PickCylinderSegment)cyl).getEnd(end);
        }
        if (coordinates.length > 2 && (cyl instanceof PickCylinderRay ? this.intersectRay(coordinates, new PickRay(origin, direction), dist, iPnt) : this.intersectSegment(coordinates, origin, end, dist, iPnt))) {
            return true;
        }
        for (int i = 0; i < coordinates.length; ++i) {
            int j = i < coordinates.length - 1 ? i + 1 : 0;
            double sqDistToEdge = cyl instanceof PickCylinderSegment ? Utils.segmentToSegment(origin, end, coordinates[i], coordinates[j], iPnt1, iPnt, null) : Utils.rayToSegment(origin, direction, coordinates[i], coordinates[j], iPnt1, iPnt, null);
            if (!(sqDistToEdge <= radius * radius)) continue;
            originToIpnt.sub((Tuple3d)iPnt1, (Tuple3d)origin);
            dist[0] = originToIpnt.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d[] coordinates, PickCone cone, double[] dist, Point3d iPnt) {
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Vector3d originToIpnt = new Vector3d();
        Point3d iPnt1 = new Point3d();
        if (iPnt == null) {
            iPnt = new Point3d();
        }
        cone.getOrigin(origin);
        cone.getDirection(direction);
        if (cone instanceof PickConeSegment) {
            ((PickConeSegment)cone).getEnd(end);
        }
        if (coordinates.length > 2 && (cone instanceof PickConeRay ? this.intersectRay(coordinates, new PickRay(origin, direction), dist, iPnt) : this.intersectSegment(coordinates, origin, end, dist, iPnt))) {
            return true;
        }
        int j = 0;
        for (int i = 0; i < coordinates.length; ++i) {
            j = i < coordinates.length - 1 ? i + 1 : 0;
            double sqDistToEdge = cone instanceof PickConeSegment ? Utils.segmentToSegment(origin, end, coordinates[i], coordinates[j], iPnt1, iPnt, null) : Utils.rayToSegment(origin, direction, coordinates[i], coordinates[j], iPnt1, iPnt, null);
            originToIpnt.sub((Tuple3d)iPnt1, (Tuple3d)origin);
            double distance = originToIpnt.length();
            double radius = Math.tan(cone.getSpreadAngle()) * distance;
            if (!(sqDistToEdge <= radius * radius)) continue;
            dist[0] = distance;
            return true;
        }
        return false;
    }

    boolean intersectCylinder(Point3d pt, PickCylinder cyl, double[] dist) {
        double sqDist;
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt = new Point3d();
        Vector3d originToIpnt = new Vector3d();
        cyl.getOrigin(origin);
        cyl.getDirection(direction);
        double radius = cyl.getRadius();
        if (cyl instanceof PickCylinderSegment) {
            ((PickCylinderSegment)cyl).getEnd(end);
            sqDist = Utils.ptToSegSquare(pt, origin, end, iPnt);
        } else {
            sqDist = Utils.ptToRaySquare(pt, origin, direction, iPnt);
        }
        if (sqDist <= radius * radius) {
            originToIpnt.sub((Tuple3d)iPnt, (Tuple3d)origin);
            dist[0] = originToIpnt.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d pt, PickCone cone, double[] dist) {
        double sqDist;
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt = new Point3d();
        Vector3d originToIpnt = new Vector3d();
        cone.getOrigin(origin);
        cone.getDirection(direction);
        if (cone instanceof PickConeSegment) {
            ((PickConeSegment)cone).getEnd(end);
            sqDist = Utils.ptToSegSquare(pt, origin, end, iPnt);
        } else {
            sqDist = Utils.ptToRaySquare(pt, origin, direction, iPnt);
        }
        originToIpnt.sub((Tuple3d)iPnt, (Tuple3d)origin);
        double distance = originToIpnt.length();
        double radius = Math.tan(cone.getSpreadAngle()) * distance;
        if (sqDist <= radius * radius) {
            dist[0] = distance;
            return true;
        }
        return false;
    }

    void setCoordRefBuffer(J3DBuffer coords) {
        boolean isLive;
        if (coords != null) {
            switch (coords.bufferType) {
                case FLOAT: {
                    assert (((FloatBuffer)coords.getROBuffer()).isDirect());
                    break;
                }
                case DOUBLE: {
                    assert (((DoubleBuffer)coords.getROBuffer()).isDirect());
                    break;
                }
                case NULL: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (3 * idx.maxCoordIndex >= coords.getROBuffer().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (coords.getROBuffer().limit() < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.coordRefBuffer = coords;
        if (coords == null) {
            this.floatBufferRefCoords = null;
            this.doubleBufferRefCoords = null;
            this.vertexType &= 0xFFFFFFFD;
            this.vertexType &= 0xFFFFFFFE;
        } else {
            switch (coords.bufferType) {
                case FLOAT: {
                    this.floatBufferRefCoords = (FloatBuffer)coords.getROBuffer();
                    this.doubleBufferRefCoords = null;
                    this.vertexType |= 1;
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                case DOUBLE: {
                    this.floatBufferRefCoords = null;
                    this.doubleBufferRefCoords = (DoubleBuffer)coords.getROBuffer();
                    this.vertexType |= 2;
                    this.vertexType &= 0xFFFFFFFE;
                    break;
                }
            }
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (isLive) {
                this.processCoordsChanged(coords == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    J3DBuffer getCoordRefBuffer() {
        return this.coordRefBuffer;
    }

    void setCoordRefFloat(float[] coords) {
        boolean isLive;
        if (coords != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 1) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (3 * idx.maxCoordIndex >= coords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (coords.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.floatRefCoords = coords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = coords == null ? (this.vertexType &= 0xFFFFFFFE) : (this.vertexType |= 1);
        } else {
            this.setupMirrorVertexPointer(1);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (isLive) {
                this.processCoordsChanged(coords == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    float[] getCoordRefFloat() {
        return this.floatRefCoords;
    }

    void setCoordRefDouble(double[] coords) {
        boolean isLive;
        if (coords != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 2) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (3 * idx.maxCoordIndex >= coords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (coords.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.doubleRefCoords = coords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = coords == null ? (this.vertexType &= 0xFFFFFFFD) : (this.vertexType |= 2);
        } else {
            this.setupMirrorVertexPointer(2);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (isLive) {
                this.processCoordsChanged(coords == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    double[] getCoordRefDouble() {
        return this.doubleRefCoords;
    }

    void setCoordRef3f(Point3f[] coords) {
        boolean isLive;
        if (coords != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 4) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxCoordIndex >= coords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (coords.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.p3fRefCoords = coords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = coords == null ? (this.vertexType &= 0xFFFFFFFB) : (this.vertexType |= 4);
        } else {
            this.setupMirrorVertexPointer(4);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (isLive) {
                this.processCoordsChanged(coords == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3f[] getCoordRef3f() {
        return this.p3fRefCoords;
    }

    void setCoordRef3d(Point3d[] coords) {
        boolean isLive;
        if (coords != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 8) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxCoordIndex >= coords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (coords.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.p3dRefCoords = coords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = coords == null ? (this.vertexType &= 0xFFFFFFF7) : (this.vertexType |= 8);
        } else {
            this.setupMirrorVertexPointer(8);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (isLive) {
                this.processCoordsChanged(coords == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3d[] getCoordRef3d() {
        return this.p3dRefCoords;
    }

    void setColorRefFloat(float[] colors) {
        boolean isLive;
        if (colors != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 16) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * idx.maxColorIndex >= colors.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.floatRefColors = colors;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = colors == null ? (this.vertexType &= 0xFFFFFFEF) : (this.vertexType |= 0x10);
        } else {
            this.setupMirrorColorPointer(16, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getColorRefFloat() {
        return this.floatRefColors;
    }

    void setColorRefBuffer(J3DBuffer colors) {
        boolean isLive;
        if (colors != null) {
            switch (colors.bufferType) {
                case FLOAT: {
                    assert (((FloatBuffer)colors.getROBuffer()).isDirect());
                    break;
                }
                case BYTE: {
                    assert (((ByteBuffer)colors.getROBuffer()).isDirect());
                    break;
                }
                case NULL: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * idx.maxColorIndex >= colors.getROBuffer().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.getROBuffer().limit() < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.colorRefBuffer = colors;
        if (colors == null) {
            this.floatBufferRefColors = null;
            this.byteBufferRefColors = null;
        } else {
            switch (colors.bufferType) {
                case FLOAT: {
                    this.floatBufferRefColors = (FloatBuffer)colors.getROBuffer();
                    this.byteBufferRefColors = null;
                    break;
                }
                case BYTE: {
                    this.byteBufferRefColors = (ByteBuffer)colors.getROBuffer();
                    this.floatBufferRefColors = null;
                    break;
                }
            }
        }
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            if (colors == null) {
                this.vertexType &= 0xFFFFFFEF;
                this.vertexType &= 0xFFFFFFDF;
            } else {
                switch (colors.bufferType) {
                    case FLOAT: {
                        this.vertexType |= 0x10;
                        this.vertexType &= 0xFFFFFFDF;
                        break;
                    }
                    case BYTE: {
                        this.vertexType |= 0x20;
                        this.vertexType &= 0xFFFFFFEF;
                        break;
                    }
                }
            }
        } else {
            this.setupMirrorColorPointer(48, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getColorRefBuffer() {
        return this.colorRefBuffer;
    }

    void setColorRefByte(byte[] colors) {
        boolean isLive;
        if (colors != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 32) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * idx.maxColorIndex >= colors.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.byteRefColors = colors;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = colors == null ? (this.vertexType &= 0xFFFFFFDF) : (this.vertexType |= 0x20);
        } else {
            this.setupMirrorColorPointer(32, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    byte[] getColorRefByte() {
        return this.byteRefColors;
    }

    void setColorRef3f(Color3f[] colors) {
        boolean isLive;
        if (colors != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 64) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxColorIndex >= colors.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3fRefColors = colors;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = colors == null ? (this.vertexType &= 0xFFFFFFBF) : (this.vertexType |= 0x40);
        } else {
            this.setupMirrorColorPointer(64, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3f[] getColorRef3f() {
        return this.c3fRefColors;
    }

    void setColorRef4f(Color4f[] colors) {
        boolean isLive;
        if (colors != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 128) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxColorIndex >= colors.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4fRefColors = colors;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = colors == null ? (this.vertexType &= 0xFFFFFF7F) : (this.vertexType |= 0x80);
        } else {
            this.setupMirrorColorPointer(128, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4f[] getColorRef4f() {
        return this.c4fRefColors;
    }

    void setColorRef3b(Color3b[] colors) {
        boolean isLive;
        if (colors != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 256) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxColorIndex >= colors.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3bRefColors = colors;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = colors == null ? (this.vertexType &= 0xFFFFFEFF) : (this.vertexType |= 0x100);
        } else {
            this.setupMirrorColorPointer(256, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3b[] getColorRef3b() {
        return this.c3bRefColors;
    }

    void setColorRef4b(Color4b[] colors) {
        boolean isLive;
        if (colors != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 512) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxColorIndex >= colors.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (colors.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4bRefColors = colors;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = colors == null ? (this.vertexType &= 0xFFFFFDFF) : (this.vertexType |= 0x200);
        } else {
            this.setupMirrorColorPointer(512, false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4b[] getColorRef4b() {
        return this.c4bRefColors;
    }

    void setNormalRefFloat(float[] normals) {
        boolean isLive;
        if (normals != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 1024) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxNormalIndex * 3 >= normals.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (normals.length < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.floatRefNormals = normals;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = normals == null ? (this.vertexType &= 0xFFFFFBFF) : (this.vertexType |= 0x400);
        } else {
            this.setupMirrorNormalPointer(1024);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getNormalRefFloat() {
        return this.floatRefNormals;
    }

    void setNormalRefBuffer(J3DBuffer normals) {
        boolean isLive;
        FloatBuffer bufferImpl = null;
        if (normals != null) {
            if (normals.bufferType != J3DBuffer.Type.FLOAT) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            bufferImpl = (FloatBuffer)normals.getROBuffer();
            assert (bufferImpl.isDirect());
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxNormalIndex * 3 >= ((FloatBuffer)normals.getROBuffer()).limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (bufferImpl.limit() < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.normalRefBuffer = normals;
        if (normals == null) {
            this.vertexType &= 0xFFFFFBFF;
            this.floatBufferRefNormals = null;
        } else {
            this.vertexType |= 0x400;
            this.floatBufferRefNormals = bufferImpl;
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getNormalRefBuffer() {
        return this.normalRefBuffer;
    }

    void setNormalRef3f(Vector3f[] normals) {
        boolean isLive;
        if (normals != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 2048) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxNormalIndex >= normals.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (normals.length < this.initialNormalIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.v3fRefNormals = normals;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = normals == null ? (this.vertexType &= 0xFFFFF7FF) : (this.vertexType |= 0x800);
        } else {
            this.setupMirrorNormalPointer(2048);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    Vector3f[] getNormalRef3f() {
        return this.v3fRefNormals;
    }

    final int getColorStride() {
        return (this.vertexFormat & 8) != 0 ? 4 : 3;
    }

    final int getTexStride() {
        if ((this.vertexFormat & 0x20) != 0) {
            return 2;
        }
        if ((this.vertexFormat & 0x40) != 0) {
            return 3;
        }
        if ((this.vertexFormat & 0x400) != 0) {
            return 4;
        }
        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray121"));
    }

    void setTexCoordRefFloat(int texCoordSet, float[] texCoords) {
        boolean isLive;
        if (this.texCoordType != 0 && this.texCoordType != 4096) {
            if (texCoords != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoords != null) {
            int ts = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxTexCoordIndices[texCoordSet] * ts >= texCoords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoords.length < ts * (this.initialTexCoordIndex[texCoordSet] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoords[texCoordSet] = texCoords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 4096;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(texCoordSet, 4096);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getTexCoordRefFloat(int texCoordSet) {
        return (float[])this.refTexCoords[texCoordSet];
    }

    void setTexCoordRefBuffer(int texCoordSet, J3DBuffer texCoords) {
        boolean isLive;
        FloatBuffer bufferImpl = null;
        if (texCoords != null) {
            if (texCoords.bufferType != J3DBuffer.Type.FLOAT) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            bufferImpl = (FloatBuffer)texCoords.getROBuffer();
            int bufferSize = bufferImpl.limit();
            assert (bufferImpl.isDirect());
            int ts = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxTexCoordIndices[texCoordSet] * ts >= bufferSize) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (bufferSize < ts * (this.initialTexCoordIndex[texCoordSet] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoordsBuffer[texCoordSet] = texCoords;
        this.refTexCoords[texCoordSet] = texCoords == null ? null : bufferImpl;
        this.texCoordType = 4096;
        this.validateTexCoordPointerType();
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getTexCoordRefBuffer(int texCoordSet) {
        return this.refTexCoordsBuffer[texCoordSet];
    }

    void setTexCoordRef2f(int texCoordSet, TexCoord2f[] texCoords) {
        boolean isLive;
        if (this.texCoordType != 0 && this.texCoordType != 8192) {
            if (texCoords != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoords != null) {
            if ((this.vertexFormat & 0x20) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxTexCoordIndices[texCoordSet] >= texCoords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoords.length < this.initialTexCoordIndex[texCoordSet] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoords[texCoordSet] = texCoords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 8192;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(texCoordSet, 8192);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord2f[] getTexCoordRef2f(int texCoordSet) {
        if (this.refTexCoords != null && this.refTexCoords[texCoordSet] != null && this.refTexCoords[texCoordSet] instanceof TexCoord2f[]) {
            return (TexCoord2f[])this.refTexCoords[texCoordSet];
        }
        return null;
    }

    void setTexCoordRef3f(int texCoordSet, TexCoord3f[] texCoords) {
        boolean isLive;
        if (this.texCoordType != 0 && this.texCoordType != 16384) {
            if (texCoords != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoords != null) {
            if ((this.vertexFormat & 0x40) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxTexCoordIndices[texCoordSet] >= texCoords.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoords.length < this.initialTexCoordIndex[texCoordSet] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoords[texCoordSet] = texCoords;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 16384;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(texCoordSet, 16384);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord3f[] getTexCoordRef3f(int texCoordSet) {
        if (this.refTexCoords != null && this.refTexCoords[texCoordSet] != null && this.refTexCoords[texCoordSet] instanceof TexCoord3f[]) {
            return (TexCoord3f[])this.refTexCoords[texCoordSet];
        }
        return null;
    }

    void setVertexAttrRefFloat(int vertexAttrNum, float[] vertexAttrs) {
        boolean isLive;
        if (vertexAttrs != null) {
            int sz = this.vertexAttrSizes[vertexAttrNum];
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (sz * idx.maxVertexAttrIndices[vertexAttrNum] >= vertexAttrs.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                }
            } else if (vertexAttrs.length < sz * (this.initialVertexAttrIndex[vertexAttrNum] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.floatRefVertexAttrs[vertexAttrNum] = vertexAttrs;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexAttrType = 32768;
            this.validateVertexAttrPointerType();
        } else {
            this.setupMirrorVertexAttrPointer(vertexAttrNum, 32768);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getVertexAttrRefFloat(int vertexAttrNum) {
        return this.floatRefVertexAttrs[vertexAttrNum];
    }

    void setVertexAttrRefBuffer(int vertexAttrNum, J3DBuffer vertexAttrs) {
        boolean isLive;
        FloatBuffer bufferImpl = null;
        if (vertexAttrs != null) {
            if (vertexAttrs.bufferType != J3DBuffer.Type.FLOAT) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            bufferImpl = (FloatBuffer)vertexAttrs.getROBuffer();
            int bufferSize = bufferImpl.limit();
            assert (bufferImpl.isDirect());
            int sz = this.vertexAttrSizes[vertexAttrNum];
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (idx.maxVertexAttrIndices[vertexAttrNum] * sz >= bufferSize) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                }
            } else if (bufferSize < sz * (this.initialVertexAttrIndex[vertexAttrNum] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexAttrsRefBuffer[vertexAttrNum] = vertexAttrs;
        this.floatBufferRefVertexAttrs[vertexAttrNum] = vertexAttrs == null ? null : bufferImpl;
        this.vertexAttrType = 32768;
        this.validateVertexAttrPointerType();
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getVertexAttrRefBuffer(int vertexAttrNum) {
        return this.vertexAttrsRefBuffer[vertexAttrNum];
    }

    void setInterleavedVertices(float[] vertexData) {
        boolean isLive;
        if (vertexData != null) {
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (this.stride * idx.maxCoordIndex >= vertexData.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    for (int i = 0; i < this.texCoordSetCount; ++i) {
                        if (this.stride * idx.maxTexCoordIndices[i] < vertexData.length) continue;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * idx.maxColorIndex >= vertexData.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * idx.maxNormalIndex >= vertexData.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (vertexData.length < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.interLeavedVertexData = vertexData;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged(vertexData == null);
            this.sendDataChangedMessage(true);
        }
    }

    void setInterleavedVertexBuffer(J3DBuffer vertexData) {
        boolean isLive;
        FloatBuffer bufferImpl = null;
        if (vertexData != null) {
            if (vertexData.bufferType != J3DBuffer.Type.FLOAT) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            bufferImpl = (FloatBuffer)vertexData.getROBuffer();
            assert (bufferImpl.isDirect());
            int bufferSize = bufferImpl.limit();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained idx = (IndexedGeometryArrayRetained)this;
                if (this.stride * idx.maxCoordIndex >= bufferSize) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    for (int i = 0; i < this.texCoordSetCount; ++i) {
                        if (this.stride * idx.maxTexCoordIndices[i] < bufferSize) continue;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * idx.maxColorIndex >= bufferSize) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * idx.maxNormalIndex >= bufferSize) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (bufferSize < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.interleavedVertexBuffer = vertexData;
        this.interleavedFloatBufferImpl = vertexData == null ? null : bufferImpl;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged(vertexData == null);
            this.sendDataChangedMessage(true);
        }
    }

    float[] getInterleavedVertices() {
        return this.interLeavedVertexData;
    }

    J3DBuffer getInterleavedVertexBuffer() {
        return this.interleavedVertexBuffer;
    }

    void setValidVertexCount(int validVertexCount) {
        boolean isLive;
        boolean nullGeo = false;
        if (validVertexCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray110"));
        }
        if (this.initialVertexIndex + validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x100) != 0) {
            if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
                if (this.interleavedFloatBufferImpl.limit() < this.stride * (this.initialVertexIndex + validVertexCount)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else if (this.interLeavedVertexData != null) {
                if (this.interLeavedVertexData.length < this.stride * (this.initialVertexIndex + validVertexCount)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else {
                nullGeo = true;
            }
        } else if ((this.vertexFormat & 0x80) != 0) {
            int i;
            if (this.initialCoordIndex + validVertexCount > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
            }
            if (this.initialColorIndex + validVertexCount > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
            }
            if (this.initialNormalIndex + validVertexCount > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    if (this.initialTexCoordIndex[i] + validVertexCount <= this.vertexCount) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    if (this.initialVertexAttrIndex[i] + validVertexCount <= this.vertexCount) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray130"));
                }
            }
            if ((this.vertexType & 0xF) == 0) {
                nullGeo = true;
            }
            if ((this.vertexFormat & 0x800) != 0) {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + validVertexCount)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + validVertexCount)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (this.initialColorIndex + validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (this.initialColorIndex + validVertexCount))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (this.initialColorIndex + validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (this.initialColorIndex + validVertexCount))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                            FloatBuffer texBuffer = (FloatBuffer)this.refTexCoordsBuffer[i2].getROBuffer();
                            if (!((this.vertexFormat & 0x20) != 0 ? texBuffer.limit() < 2 * (this.initialTexCoordIndex[i2] + validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? texBuffer.limit() < 3 * (this.initialTexCoordIndex[i2] + validVertexCount) : (this.vertexFormat & 0x400) != 0 && texBuffer.limit() < 4 * (this.initialTexCoordIndex[i2] + validVertexCount)))) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatBufferRefNormals.limit() >= 3 * (this.initialNormalIndex + validVertexCount)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        for (i = 0; i < this.vertexAttrCount; ++i) {
                            int sz = this.vertexAttrSizes[i];
                            if (this.floatBufferRefVertexAttrs[i].limit() >= sz * (this.initialVertexAttrIndex[i] + validVertexCount)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
                        }
                        break;
                    }
                }
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords.length >= 3 * (this.initialCoordIndex + validVertexCount)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleRefCoords.length >= 3 * (this.initialCoordIndex + validVertexCount)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 4: {
                        if (this.p3fRefCoords.length >= this.initialCoordIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 8: {
                        if (this.p3dRefCoords.length >= this.initialCoordIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (this.initialColorIndex + validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (this.initialColorIndex + validVertexCount))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (this.initialColorIndex + validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (this.initialColorIndex + validVertexCount))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 64: {
                        if (this.c3fRefColors.length >= this.initialColorIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 128: {
                        if (this.c4fRefColors.length >= this.initialColorIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 256: {
                        if (this.c3bRefColors.length >= this.initialColorIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 512: {
                        if (this.c4bRefColors.length >= this.initialColorIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        for (i = 0; i < this.texCoordSetCount; ++i) {
                            if ((this.vertexFormat & 0x20) != 0) {
                                if (((float[])this.refTexCoords[i]).length >= 2 * (this.initialTexCoordIndex[i] + validVertexCount)) continue;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            if ((this.vertexFormat & 0x40) == 0) continue;
                            if (((float[])this.refTexCoords[i]).length < 3 * (this.initialTexCoordIndex[i] + validVertexCount)) {
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            if ((this.vertexFormat & 0x400) == 0 || ((float[])this.refTexCoords[i]).length >= 4 * (this.initialTexCoordIndex[i] + validVertexCount)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                    case 8192: {
                        for (i = 0; i < this.texCoordSetCount; ++i) {
                            if (((TexCoord2f[])this.refTexCoords[i]).length >= this.initialTexCoordIndex[i] + validVertexCount) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                    case 16384: {
                        for (i = 0; i < this.texCoordSetCount; ++i) {
                            if (((TexCoord3f[])this.refTexCoords[i]).length >= this.initialTexCoordIndex[i] + validVertexCount) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals.length >= 3 * (this.initialNormalIndex + validVertexCount)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                    case 2048: {
                        if (this.v3fRefNormals.length >= this.initialNormalIndex + validVertexCount) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        for (i = 0; i < this.vertexAttrCount; ++i) {
                            int sz = this.vertexAttrSizes[i];
                            if (this.floatRefVertexAttrs[i].length >= sz * (this.initialVertexAttrIndex[i] + validVertexCount)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
                        }
                        break;
                    }
                }
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.validVertexCount = validVertexCount;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged(nullGeo);
            this.sendDataChangedMessage(true);
        }
    }

    int getValidVertexCount() {
        return this.validVertexCount;
    }

    void setInitialVertexIndex(int initialVertexIndex) {
        boolean isLive;
        boolean nullGeo = false;
        if (initialVertexIndex + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
            if (this.interleavedFloatBufferImpl.limit() < this.stride * (initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else if (this.interLeavedVertexData != null) {
            if (this.interLeavedVertexData.length < this.stride * (initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else {
            nullGeo = (this.vertexFormat & 0x100) != 0;
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.initialVertexIndex = initialVertexIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged(nullGeo);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialVertexIndex() {
        return this.initialVertexIndex;
    }

    void setInitialCoordIndex(int initialCoordIndex) {
        boolean isLive;
        if (initialCoordIndex + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatBufferRefCoords.limit() >= initialCoordIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleBufferRefCoords.limit() >= initialCoordIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatRefCoords.length >= 3 * (initialCoordIndex + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleRefCoords.length >= 3 * (initialCoordIndex + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 4: {
                    if (this.p3fRefCoords.length >= initialCoordIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 8: {
                    if (this.p3dRefCoords.length >= initialCoordIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.initialCoordIndex = initialCoordIndex;
        this.dirtyFlag |= 1;
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.processCoordsChanged((this.vertexType & 0xF) == 0);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialCoordIndex() {
        return this.initialCoordIndex;
    }

    void setInitialColorIndex(int initialColorIndex) {
        boolean isLive;
        if (initialColorIndex + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (initialColorIndex + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (initialColorIndex + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (initialColorIndex + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (initialColorIndex + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        } else {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (initialColorIndex + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (initialColorIndex + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (initialColorIndex + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (initialColorIndex + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 64: {
                    if (this.c3fRefColors.length >= initialColorIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 128: {
                    if (this.c4fRefColors.length >= initialColorIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 256: {
                    if (this.c3bRefColors.length >= initialColorIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 512: {
                    if (this.c4bRefColors.length >= initialColorIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.initialColorIndex = initialColorIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
    }

    int getInitialColorIndex() {
        return this.initialColorIndex;
    }

    void setInitialNormalIndex(int initialNormalIndex) {
        boolean isLive;
        if (initialNormalIndex + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0xC00) == 1024 && this.floatBufferRefNormals.limit() < 3 * (initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        } else {
            switch (this.vertexType & 0xC00) {
                case 1024: {
                    if (this.floatRefNormals.length >= 3 * (initialNormalIndex + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
                case 2048: {
                    if (this.v3fRefNormals.length >= initialNormalIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.initialNormalIndex = initialNormalIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
    }

    int getInitialNormalIndex() {
        return this.initialNormalIndex;
    }

    void setInitialVertexAttrIndex(int vertexAttrNum, int initialVertexAttrIndex) {
        boolean isLive;
        if (initialVertexAttrIndex + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray130"));
        }
        int sz = this.vertexAttrSizes[vertexAttrNum];
        int minLength = sz * (initialVertexAttrIndex + this.validVertexCount);
        if ((this.vertexType & 0x8000) == 32768 && ((this.vertexFormat & 0x800) != 0 ? this.floatBufferRefVertexAttrs[vertexAttrNum].limit() < minLength : this.floatRefVertexAttrs[vertexAttrNum].length < minLength)) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.initialVertexAttrIndex[vertexAttrNum] = initialVertexAttrIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
    }

    int getInitialVertexAttrIndex(int vertexAttrNum) {
        return this.initialVertexAttrIndex[vertexAttrNum];
    }

    void setInitialTexCoordIndex(int texCoordSet, int initialTexCoordIndex) {
        boolean isLive;
        if (initialTexCoordIndex + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0x7000) == 4096) {
                FloatBuffer texBuffer = (FloatBuffer)this.refTexCoordsBuffer[texCoordSet].getROBuffer();
                if ((this.vertexFormat & 0x20) != 0 ? texBuffer.limit() < 2 * (initialTexCoordIndex + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? texBuffer.limit() < 3 * (initialTexCoordIndex + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && texBuffer.limit() < 4 * (initialTexCoordIndex + this.validVertexCount))) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        } else {
            switch (this.vertexType & 0x7000) {
                case 4096: {
                    if (!((this.vertexFormat & 0x20) != 0 ? ((float[])this.refTexCoords[texCoordSet]).length < 2 * (initialTexCoordIndex + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? ((float[])this.refTexCoords[texCoordSet]).length < 3 * (initialTexCoordIndex + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && ((float[])this.refTexCoords[texCoordSet]).length < 4 * (initialTexCoordIndex + this.validVertexCount)))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 8192: {
                    if (((TexCoord2f[])this.refTexCoords[texCoordSet]).length >= initialTexCoordIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 16384: {
                    if (((TexCoord3f[])this.refTexCoords[texCoordSet]).length >= initialTexCoordIndex + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.initialTexCoordIndex[texCoordSet] = initialTexCoordIndex;
        if (isLive) {
            this.geomLock.unLock();
        }
    }

    int getInitialTexCoordIndex(int texCoordSet) {
        return this.initialTexCoordIndex[texCoordSet];
    }

    int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    int getTexCoordSetMapLength() {
        if (this.texCoordSetMap != null) {
            return this.texCoordSetMap.length;
        }
        return 0;
    }

    void getTexCoordSetMap(int[] texCoordSetMap) {
        if (this.texCoordSetMap != null) {
            for (int i = 0; i < this.texCoordSetMap.length; ++i) {
                texCoordSetMap[i] = this.texCoordSetMap[i];
            }
        }
    }

    void freeDlistId() {
        if (this.dlistId != -1) {
            VirtualUniverse.mc.freeDisplayListId(this.dlistObj);
            this.dlistId = -1;
        }
    }

    void assignDlistId() {
        if (this.dlistId == -1) {
            this.dlistObj = VirtualUniverse.mc.getDisplayListId();
            this.dlistId = this.dlistObj;
        }
    }

    void addDlistUser(RenderBin renderBin, RenderAtomListInfo ra) {
        HashSet<RenderAtomListInfo> raSet;
        if (this.dlistUsers == null) {
            this.dlistUsers = new HashMap(2, 1.0f);
        }
        if ((raSet = this.dlistUsers.get(renderBin)) == null) {
            raSet = new HashSet();
            this.dlistUsers.put(renderBin, raSet);
        }
        raSet.add(ra);
    }

    void removeDlistUser(RenderBin renderBin, RenderAtomListInfo ra) {
        if (this.dlistUsers == null) {
            return;
        }
        HashSet<RenderAtomListInfo> raSet = this.dlistUsers.get(renderBin);
        if (raSet == null) {
            return;
        }
        raSet.remove(ra);
    }

    boolean isDlistUserSetEmpty(RenderBin renderBin) {
        if (this.dlistUsers == null) {
            return true;
        }
        HashSet<RenderAtomListInfo> raSet = this.dlistUsers.get(renderBin);
        if (raSet == null) {
            return true;
        }
        return raSet.isEmpty();
    }

    int numDlistUsers(RenderBin renderBin) {
        if (this.isDlistUserSetEmpty(renderBin)) {
            return 0;
        }
        HashSet<RenderAtomListInfo> raSet = this.dlistUsers.get(renderBin);
        return raSet.size();
    }

    void setDlistTimeStamp(int rdrBit, long timeStamp) {
        int index = this.getIndex(rdrBit);
        if (index >= this.timeStampPerDlist.length) {
            long[] newList = new long[index * 2];
            for (int i = 0; i < this.timeStampPerDlist.length; ++i) {
                newList[i] = this.timeStampPerDlist[i];
            }
            this.timeStampPerDlist = newList;
        }
        this.timeStampPerDlist[index] = timeStamp;
    }

    long getDlistTimeStamp(int rdrBit) {
        int index = this.getIndex(rdrBit);
        if (index >= this.timeStampPerDlist.length) {
            this.setDlistTimeStamp(rdrBit, 0L);
        }
        return this.timeStampPerDlist[index];
    }

    int getIndex(int bit) {
        int num = 0;
        while (bit > 0) {
            ++num;
            bit >>= 1;
        }
        return num;
    }

    boolean isWriteStatic() {
        return !this.source.getCapability(1) && !this.source.getCapability(3) && !this.source.getCapability(5) && !this.source.getCapability(7) && !this.source.getCapability(23) && !this.source.getCapability(20) && !this.source.getCapability(19);
    }

    void setCompiled(ArrayList curList) {
        int num = curList.size();
        int offset = 0;
        this.geoOffset = new int[num];
        this.compileVcount = new int[num];
        int vcount = 0;
        int vformat = 0;
        vcount = 0;
        this.isCompiled = true;
        if (num > 0) {
            this.source = ((SceneGraphObjectRetained)curList.get((int)0)).source;
        }
        for (int i = 0; i < num; ++i) {
            GeometryArrayRetained geo = (GeometryArrayRetained)curList.get(i);
            ((GeometryArray)geo.source).retained = this;
            this.compileVcount[i] = geo.getValidVertexCount();
            vcount += geo.getValidVertexCount();
            this.geoOffset[i] = offset;
            offset += geo.stride() * this.compileVcount[i];
            vformat = geo.getVertexFormat();
        }
        this.createGeometryArrayData(vcount, vformat);
        this.validVertexCount = vcount;
        this.initialVertexIndex = 0;
        this.mergeGeometryArrays(curList);
    }

    void mergeGeometryArrays(ArrayList list) {
        int curOffset = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 1;
        }
        for (int i = 0; i < list.size(); ++i) {
            GeometryArrayRetained geo = (GeometryArrayRetained)list.get(i);
            float[] curVertexData = geo.vertexData;
            int length = geo.validVertexCount * this.stride;
            int srcOffset = geo.initialVertexIndex * this.stride;
            System.arraycopy(curVertexData, srcOffset, this.vertexData, curOffset, length);
            curOffset += length;
            this.geoBounds.combine(geo.geoBounds);
        }
        this.geoBounds.getCenter(this.centroid);
    }

    boolean isMergeable() {
        if ((this.vertexFormat & 0x80) != 0) {
            return false;
        }
        if (!this.isStatic()) {
            return false;
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.texCoordSetCount > 1 || this.texCoordSetMap != null && this.texCoordSetMap.length > 1)) {
            return false;
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            return false;
        }
        return !this.source.getCapability(18);
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        if ((this.vertexFormat & 2) != 0) {
            compState.needNormalsTransform = true;
        }
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        if (this.geoBounds != null) {
            this.geoBounds.transform(xform.transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMorphUser(MorphRetained m) {
        if (this.morphUniverseList == null) {
            this.morphUniverseList = new ArrayList(1);
            this.morphUserLists = new ArrayList(1);
        }
        ArrayList<VirtualUniverse> arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            if (this.morphUniverseList.contains(m.universe)) {
                int index = this.morphUniverseList.indexOf(m.universe);
                this.morphUserLists.get(index).add(m);
            } else {
                this.morphUniverseList.add(m.universe);
                ArrayList<MorphRetained> morphList = new ArrayList<MorphRetained>(5);
                morphList.add(m);
                this.morphUserLists.add(morphList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMorphUser(MorphRetained m) {
        if (this.morphUniverseList == null) {
            return;
        }
        ArrayList<VirtualUniverse> arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            int index = this.morphUniverseList.indexOf(m.universe);
            ArrayList<MorphRetained> morphList = this.morphUserLists.get(index);
            morphList.remove(morphList.indexOf(m));
            if (morphList.size() == 0) {
                this.morphUserLists.remove(index);
                this.morphUniverseList.remove(index);
            }
        }
    }

    void initMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained) {
            this.mirrorGeometry = (this.vertexFormat & 0x200) == 0 ? ((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry() : null;
        }
        this.geomLock.unLock();
    }

    void updateMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained && this.mirrorGeometry != null) {
            this.mirrorGeometry = ((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry();
        }
        this.geomLock.unLock();
    }

    void getVertexData(int i, Point3d pnts) {
        if ((this.vertexFormat & 0x80) == 0) {
            int offset = this.stride * i + this.coordinateOffset;
            pnts.x = this.vertexData[offset];
            pnts.y = this.vertexData[offset + 1];
            pnts.z = this.vertexData[offset + 2];
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int offset = this.stride * i + this.coordinateOffset;
                pnts.x = this.interLeavedVertexData[offset];
                pnts.y = this.interLeavedVertexData[offset + 1];
                pnts.z = this.interLeavedVertexData[offset + 2];
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        int offset = i * 3;
                        pnts.x = this.floatRefCoords[offset];
                        pnts.y = this.floatRefCoords[offset + 1];
                        pnts.z = this.floatRefCoords[offset + 2];
                        break;
                    }
                    case 2: {
                        int offset = i * 3;
                        pnts.x = this.doubleRefCoords[offset];
                        pnts.y = this.doubleRefCoords[offset + 1];
                        pnts.z = this.doubleRefCoords[offset + 2];
                        break;
                    }
                    case 4: {
                        pnts.x = this.p3fRefCoords[i].x;
                        pnts.y = this.p3fRefCoords[i].y;
                        pnts.z = this.p3fRefCoords[i].z;
                        break;
                    }
                    case 8: {
                        pnts.x = this.p3dRefCoords[i].x;
                        pnts.y = this.p3dRefCoords[i].y;
                        pnts.z = this.p3dRefCoords[i].z;
                    }
                }
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int offset = this.stride * i + this.coordinateOffset;
            pnts.x = this.interleavedFloatBufferImpl.get(offset);
            pnts.y = this.interleavedFloatBufferImpl.get(offset + 1);
            pnts.z = this.interleavedFloatBufferImpl.get(offset + 2);
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    int offset = i * 3;
                    pnts.x = this.floatBufferRefCoords.get(offset);
                    pnts.y = this.floatBufferRefCoords.get(offset + 1);
                    pnts.z = this.floatBufferRefCoords.get(offset + 2);
                    break;
                }
                case 2: {
                    int offset = i * 3;
                    pnts.x = this.doubleBufferRefCoords.get(offset);
                    pnts.y = this.doubleBufferRefCoords.get(offset + 1);
                    pnts.z = this.doubleBufferRefCoords.get(offset + 2);
                }
            }
        }
    }

    void getCrossValue(Point3d p1, Point3d p2, Vector3d value) {
        value.x += p1.y * p2.z - p1.z * p2.y;
        value.y += p2.x * p1.z - p2.z * p1.x;
        value.z += p1.x * p2.y - p1.y * p2.x;
    }

    @Override
    boolean intersect(Transform3D thisLocalToVworld, Transform3D otherLocalToVworld, GeometryRetained geom) {
        Transform3D t3d = new Transform3D();
        boolean isIntersect = false;
        if (geom instanceof GeometryArrayRetained) {
            GeometryArrayRetained geomArray = (GeometryArrayRetained)geom;
            if (geomArray.validVertexCount >= this.validVertexCount) {
                t3d.invert(otherLocalToVworld);
                t3d.mul(thisLocalToVworld);
                isIntersect = this.intersect(t3d, geom);
            } else {
                t3d.invert(thisLocalToVworld);
                t3d.mul(otherLocalToVworld);
                isIntersect = geomArray.intersect(t3d, this);
            }
        } else {
            t3d.invert(thisLocalToVworld);
            t3d.mul(otherLocalToVworld);
            isIntersect = geom.intersect(t3d, this);
        }
        return isIntersect;
    }

    int getNumCoordCount() {
        int count = 0;
        if ((this.vertexFormat & 1) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                count = this.vertexCount;
                return count;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xF) {
                        case 1: {
                            count = this.floatRefCoords.length / 3;
                            break;
                        }
                        case 2: {
                            count = this.doubleRefCoords.length / 3;
                            break;
                        }
                        case 4: {
                            count = this.p3fRefCoords.length;
                            break;
                        }
                        case 8: {
                            count = this.p3dRefCoords.length;
                        }
                    }
                } else {
                    count = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        count = this.floatBufferRefCoords.limit() / 3;
                        break;
                    }
                    case 2: {
                        count = this.doubleBufferRefCoords.limit() / 3;
                    }
                }
            } else {
                count = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return count;
    }

    int getNumColorCount() {
        int count = 0;
        if ((this.vertexFormat & 4) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                count = this.vertexCount;
                return count;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x3F0) {
                        case 16: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                count = this.floatRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            count = this.floatRefColors.length / 4;
                            break;
                        }
                        case 32: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                count = this.byteRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            count = this.byteRefColors.length / 4;
                            break;
                        }
                        case 64: {
                            count = this.c3fRefColors.length;
                            break;
                        }
                        case 128: {
                            count = this.c4fRefColors.length;
                            break;
                        }
                        case 256: {
                            count = this.c3bRefColors.length;
                            break;
                        }
                        case 512: {
                            count = this.c4bRefColors.length;
                        }
                    }
                } else {
                    count = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            count = this.floatBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        count = this.floatBufferRefColors.limit() / 4;
                        break;
                    }
                    case 32: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            count = this.byteBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        count = this.byteBufferRefColors.limit() / 4;
                    }
                }
            } else {
                count = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return count;
    }

    int getNumNormalCount() {
        int count = 0;
        if ((this.vertexFormat & 2) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                count = this.vertexCount;
                return count;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xC00) {
                        case 1024: {
                            count = this.floatRefNormals.length / 3;
                            break;
                        }
                        case 2048: {
                            count = this.v3fRefNormals.length;
                        }
                    }
                } else {
                    count = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0xC00) == 1024) {
                    count = this.floatBufferRefNormals.limit() / 3;
                }
            } else {
                count = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return count;
    }

    int getNumTexCoordCount(int i) {
        int count = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                count = this.vertexCount;
                return count;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x7000) {
                        case 4096: {
                            if ((this.vertexFormat & 0x20) != 0) {
                                count = ((float[])this.refTexCoords[i]).length / 2;
                                break;
                            }
                            if ((this.vertexFormat & 0x40) != 0) {
                                count = ((float[])this.refTexCoords[i]).length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0x400) == 0) break;
                            count = ((float[])this.refTexCoords[i]).length / 4;
                            break;
                        }
                        case 8192: {
                            count = ((TexCoord2f[])this.refTexCoords[i]).length;
                            break;
                        }
                        case 16384: {
                            count = ((TexCoord3f[])this.refTexCoords[i]).length;
                        }
                    }
                } else {
                    count = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0x7000) == 4096) {
                    FloatBuffer texBuffer = (FloatBuffer)this.refTexCoordsBuffer[i].getROBuffer();
                    if ((this.vertexFormat & 0x20) != 0) {
                        count = texBuffer.limit() / 2;
                    } else if ((this.vertexFormat & 0x40) != 0) {
                        count = texBuffer.limit() / 3;
                    } else if ((this.vertexFormat & 0x400) != 0) {
                        count = texBuffer.limit() / 4;
                    }
                }
            } else {
                count = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return count;
    }

    void computeMinDistance(Point3d[] coordinates, Point3d center, Vector3d normal, double[] dist, Point3d iPnt) {
        if (coordinates.length == 1) {
            iPnt.x = coordinates[0].x;
            iPnt.y = coordinates[0].y;
            iPnt.z = coordinates[0].z;
            double x = iPnt.x - center.x;
            double y = iPnt.y - center.y;
            double z = iPnt.z - center.z;
            dist[0] = Math.sqrt(x * x + y * y + z * z);
            return;
        }
        if (coordinates.length == 2) {
            dist[0] = Math.sqrt(Utils.ptToSegSquare(center, coordinates[0], coordinates[1], iPnt));
            return;
        }
        double normalLen = 0.0;
        if (normal == null) {
            int j;
            Vector3d vec0 = new Vector3d();
            Vector3d vec1 = new Vector3d();
            normal = new Vector3d();
            int i = 0;
            while (i < coordinates.length - 1) {
                vec0.x = coordinates[i + 1].x - coordinates[i].x;
                vec0.y = coordinates[i + 1].y - coordinates[i].y;
                vec0.z = coordinates[i + 1].z - coordinates[i++].z;
                if (!(vec0.length() > 0.0)) continue;
            }
            for (j = i; j < coordinates.length - 1; ++j) {
                vec1.x = coordinates[j + 1].x - coordinates[j].x;
                vec1.y = coordinates[j + 1].y - coordinates[j].y;
                vec1.z = coordinates[j + 1].z - coordinates[j].z;
                if (vec1.length() > 0.0) break;
            }
            if (j == coordinates.length - 1) {
                normal = null;
            } else {
                normal.cross(vec0, vec1);
            }
        }
        if (normal != null && (normalLen = normal.length()) == 0.0) {
            normal = null;
        }
        if (coordinates.length == 3) {
            if (normal != null) {
                double d = -(normal.x * coordinates[0].x + normal.y * coordinates[0].y + normal.z * coordinates[0].z);
                dist[0] = (normal.x * center.x + normal.y * center.y + normal.z * center.z + d) / normalLen;
                iPnt.x = center.x - dist[0] * normal.x / normalLen;
                iPnt.y = center.y - dist[0] * normal.y / normalLen;
                iPnt.z = center.z - dist[0] * normal.z / normalLen;
                if (this.pointInTri(iPnt, coordinates[0], coordinates[1], coordinates[2], normal)) {
                    return;
                }
            }
            Point3d minPnt = new Point3d();
            dist[0] = Utils.ptToSegSquare(center, coordinates[0], coordinates[1], iPnt);
            double minDist = Utils.ptToSegSquare(center, coordinates[1], coordinates[2], minPnt);
            if (minDist < dist[0]) {
                dist[0] = minDist;
                iPnt.x = minPnt.x;
                iPnt.y = minPnt.y;
                iPnt.z = minPnt.z;
            }
            if ((minDist = Utils.ptToSegSquare(center, coordinates[2], coordinates[0], minPnt)) < dist[0]) {
                dist[0] = minDist;
                iPnt.x = minPnt.x;
                iPnt.y = minPnt.y;
                iPnt.z = minPnt.z;
            }
            dist[0] = Math.sqrt(dist[0]);
            return;
        }
        if (normal != null) {
            double d = -(normal.x * coordinates[0].x + normal.y * coordinates[0].y + normal.z * coordinates[0].z);
            dist[0] = (normal.x * center.x + normal.y * center.y + normal.z * center.z + d) / normalLen;
            iPnt.x = center.x - dist[0] * normal.x / normalLen;
            iPnt.y = center.y - dist[0] * normal.y / normalLen;
            iPnt.z = center.z - dist[0] * normal.z / normalLen;
            if (this.pointInTri(iPnt, coordinates[0], coordinates[1], coordinates[2], normal) || this.pointInTri(iPnt, coordinates[1], coordinates[2], coordinates[3], normal)) {
                return;
            }
        }
        Point3d minPnt = new Point3d();
        dist[0] = Utils.ptToSegSquare(center, coordinates[0], coordinates[1], iPnt);
        double minDist = Utils.ptToSegSquare(center, coordinates[1], coordinates[2], minPnt);
        if (minDist < dist[0]) {
            dist[0] = minDist;
            iPnt.x = minPnt.x;
            iPnt.y = minPnt.y;
            iPnt.z = minPnt.z;
        }
        if ((minDist = Utils.ptToSegSquare(center, coordinates[2], coordinates[3], minPnt)) < dist[0]) {
            dist[0] = minDist;
            iPnt.x = minPnt.x;
            iPnt.y = minPnt.y;
            iPnt.z = minPnt.z;
        }
        if ((minDist = Utils.ptToSegSquare(center, coordinates[3], coordinates[0], minPnt)) < dist[0]) {
            dist[0] = minDist;
            iPnt.x = minPnt.x;
            iPnt.y = minPnt.y;
            iPnt.z = minPnt.z;
        }
        dist[0] = Math.sqrt(dist[0]);
    }

    @Override
    void handleFrequencyChange(int bit) {
        int mask = 0;
        if ((this.vertexFormat & 0x80) == 0) {
            if (bit == 1 || (this.vertexFormat & 4) != 0 && bit == 3 || (this.vertexFormat & 2) != 0 && bit == 5 || (this.vertexFormat & 0x460) != 0 && bit == 7 || (this.vertexFormat & 0x1000) != 0 && bit == 23 || bit == 20) {
                mask = 1;
            }
        } else if (bit == 19) {
            mask = 1;
        }
        if (mask != 0) {
            this.setFrequencyChangeMask(bit, mask);
        }
    }

    int getTexCoordType() {
        return this.texCoordType;
    }

    int getVertexAttrType() {
        return this.vertexAttrType;
    }
}

