/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryStripArrayRetained;
import org.scijava.java3d.IndexedGeometryArrayRetained;
import org.scijava.java3d.IndexedLineStripArrayRetained;
import org.scijava.java3d.IndexedTriangleFanArrayRetained;
import org.scijava.java3d.IndexedTriangleStripArrayRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.LineStripArrayRetained;
import org.scijava.java3d.TriangleFanArrayRetained;
import org.scijava.java3d.TriangleStripArrayRetained;

abstract class IndexedGeometryStripArrayRetained
extends IndexedGeometryArrayRetained {
    int[] stripIndexCounts;
    int[] compileStripICOffset;
    int[] compileIndexLength;

    IndexedGeometryStripArrayRetained() {
    }

    void setStripIndexCounts(int[] stripIndexCounts) {
        boolean isLive;
        int i;
        int num = stripIndexCounts.length;
        int total = 0;
        for (i = 0; i < num; ++i) {
            total += stripIndexCounts[i];
            if (this instanceof IndexedLineStripArrayRetained) {
                if (stripIndexCounts[i] >= 2) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained1"));
            }
            if (this instanceof IndexedTriangleStripArrayRetained) {
                if (stripIndexCounts[i] >= 3) continue;
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArrayRetained1"));
            }
            if (!(this instanceof IndexedTriangleFanArrayRetained) || stripIndexCounts[i] >= 3) continue;
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained1"));
        }
        if (this.initialIndexIndex + total > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryStripArrayRetained0"));
        }
        int newCoordMax = 0;
        int newColorIndex = 0;
        int newNormalIndex = 0;
        int[] newTexCoordIndex = null;
        int[] newVertexAttrIndex = null;
        newCoordMax = this.computeMaxIndex(this.initialIndexIndex, total, this.indexCoord);
        this.doErrorCheck(newCoordMax);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                newColorIndex = this.computeMaxIndex(this.initialIndexIndex, total, this.indexColor);
                this.doColorCheck(newColorIndex);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                newTexCoordIndex = new int[this.texCoordSetCount];
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    newTexCoordIndex[i] = this.computeMaxIndex(this.initialIndexIndex, total, this.indexTexCoord[i]);
                    this.doTexCoordCheck(newTexCoordIndex[i], i);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                newVertexAttrIndex = new int[this.vertexAttrCount];
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    newVertexAttrIndex[i] = this.computeMaxIndex(this.initialIndexIndex, total, this.indexVertexAttr[i]);
                    this.doTexCoordCheck(newVertexAttrIndex[i], i);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                newNormalIndex = this.computeMaxIndex(this.initialIndexIndex, total, this.indexNormal);
                this.doNormalCheck(newNormalIndex);
            }
        }
        boolean bl = isLive = this.source != null && this.source.isLive();
        if (isLive) {
            this.geomLock.getLock();
        }
        this.validIndexCount = total;
        this.stripIndexCounts = new int[num];
        for (i = 0; i < num; ++i) {
            this.stripIndexCounts[i] = stripIndexCounts[i];
        }
        this.maxCoordIndex = newCoordMax;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = newColorIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = newTexCoordIndex[i];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = newVertexAttrIndex[i];
                }
            }
            this.maxNormalIndex = newNormalIndex;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (i = 0; i < this.texCoordSetCount; ++i) {
                    this.maxTexCoordIndices[i] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (i = 0; i < this.vertexAttrCount; ++i) {
                    this.maxVertexAttrIndices[i] = this.maxCoordIndex;
                }
            }
        }
        if (isLive) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && isLive) {
            this.sendDataChangedMessage(true);
        }
    }

    @Override
    GeometryArrayRetained cloneNonIndexedGeometry() {
        GeometryStripArrayRetained obj = null;
        switch (this.geoType) {
            case 14: {
                obj = new LineStripArrayRetained();
                break;
            }
            case 13: {
                obj = new TriangleFanArrayRetained();
                break;
            }
            case 12: {
                obj = new TriangleStripArrayRetained();
            }
        }
        obj.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
        obj.unIndexify(this);
        obj.setStripVertexCounts(this.stripIndexCounts);
        obj.cloneSourceArray = this;
        obj.source = this.source;
        return obj;
    }

    int getNumStrips() {
        return this.stripIndexCounts.length;
    }

    void getStripIndexCounts(int[] stripIndexCounts) {
        for (int i = stripIndexCounts.length - 1; i >= 0; --i) {
            stripIndexCounts[i] = this.stripIndexCounts[i];
        }
    }

    @Override
    void mergeGeometryArrays(ArrayList list) {
        int i;
        int numMerge = list.size();
        int numCount = 0;
        for (i = 0; i < numMerge; ++i) {
            IndexedGeometryStripArrayRetained geo = (IndexedGeometryStripArrayRetained)list.get(i);
            numCount += geo.stripIndexCounts.length;
        }
        this.stripIndexCounts = new int[numCount];
        this.compileIndexLength = new int[numCount];
        this.compileStripICOffset = new int[numMerge];
        int curICOffset = 0;
        for (i = 0; i < numMerge; ++i) {
            IndexedGeometryStripArrayRetained geo = (IndexedGeometryStripArrayRetained)list.get(i);
            this.compileStripICOffset[i] = curICOffset;
            this.compileIndexLength[i] = geo.stripIndexCounts.length;
            System.arraycopy(geo.stripIndexCounts, 0, this.stripIndexCounts, curICOffset, geo.stripIndexCounts.length);
            curICOffset += geo.stripIndexCounts.length;
        }
        super.mergeGeometryArrays(list);
    }

    int getNumStrips(int id) {
        return this.compileIndexLength[id];
    }

    void getStripIndexCounts(int id, int[] stripIndexCounts) {
        int count = this.compileIndexLength[id];
        int coffset = this.compileStripICOffset[id];
        for (int i = 0; i < count; ++i) {
            stripIndexCounts[i] = this.stripIndexCounts[coffset + 1];
        }
    }
}

