/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Bounds;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point4d;
import org.scijava.vecmath.Vector3d;

public final class PickRay
extends PickShape {
    Point3d origin;
    Vector3d direction;

    public PickRay() {
        this.origin = new Point3d();
        this.direction = new Vector3d();
    }

    public PickRay(Point3d origin, Vector3d direction) {
        this.origin = new Point3d(origin);
        this.direction = new Vector3d(direction);
    }

    public void set(Point3d origin, Vector3d direction) {
        this.origin.x = origin.x;
        this.origin.y = origin.y;
        this.origin.z = origin.z;
        this.direction.x = direction.x;
        this.direction.y = direction.y;
        this.direction.z = direction.z;
    }

    public void get(Point3d origin, Vector3d direction) {
        origin.x = this.origin.x;
        origin.y = this.origin.y;
        origin.z = this.origin.z;
        direction.x = this.direction.x;
        direction.y = this.direction.y;
        direction.z = this.direction.z;
    }

    @Override
    final boolean intersect(Bounds bounds, Point4d pickPos) {
        return bounds.intersect(this.origin, this.direction, pickPos);
    }

    @Override
    PickShape transform(Transform3D t3d) {
        Point3d end = new Point3d();
        PickRay newPR = new PickRay(this.origin, this.direction);
        end.x = this.origin.x + this.direction.x;
        end.y = this.origin.y + this.direction.y;
        end.z = this.origin.z + this.direction.z;
        t3d.transform(newPR.origin);
        t3d.transform(end);
        newPR.direction.x = end.x - newPR.origin.x;
        newPR.direction.y = end.y - newPR.origin.y;
        newPR.direction.z = end.z - newPR.origin.z;
        newPR.direction.normalize();
        return newPR;
    }

    @Override
    Point3d getStartPoint() {
        return this.origin;
    }

    @Override
    int getPickType() {
        return 1;
    }
}

