/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.NodeComponentRetained;
import org.scijava.java3d.ShaderId;

abstract class ShaderRetained
extends NodeComponentRetained {
    int shadingLanguage;
    int shaderType;
    ShaderData[] shaderData;
    boolean compileErrorOccurred = false;
    Object resourceLock = new Object();

    ShaderRetained() {
    }

    void initializeShader(int shadingLanguage, int shaderType) {
        this.shadingLanguage = shadingLanguage;
        this.shaderType = shaderType;
    }

    int getShadingLanguage() {
        return this.shadingLanguage;
    }

    int getShaderType() {
        return this.shaderType;
    }

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        super.setLive(inBackgroundGroup, refCount);
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        System.err.println("Shader.updateMirrorObject not implemented yet!");
    }

    @Override
    void handleFrequencyChange(int bit) {
        System.err.println("Shader.handleFrequencyChange not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createShaderData(int cvRdrIndex, long ctxTimeStamp) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.shaderData == null) {
                this.shaderData = new ShaderData[cvRdrIndex + 1];
            } else if (this.shaderData.length <= cvRdrIndex) {
                ShaderData[] tempSData = new ShaderData[cvRdrIndex + 1];
                System.arraycopy(this.shaderData, 0, tempSData, 0, this.shaderData.length);
                this.shaderData = tempSData;
            }
            if (this.shaderData[cvRdrIndex] == null) {
                this.shaderData[cvRdrIndex] = new ShaderData();
            } else if (this.shaderData[cvRdrIndex].getCtxTimeStamp() != ctxTimeStamp) {
                this.shaderData[cvRdrIndex].reset();
            }
            this.shaderData[cvRdrIndex].setCtxTimeStamp(ctxTimeStamp);
        }
    }

    class ShaderData {
        private long ctxTimeStamp;
        private ShaderId shaderId = null;
        private boolean compiled = false;

        ShaderData() {
        }

        void reset() {
            this.ctxTimeStamp = 0L;
            this.shaderId = null;
            this.compiled = false;
        }

        long getCtxTimeStamp() {
            return this.ctxTimeStamp;
        }

        void setCtxTimeStamp(long ctxTimeStamp) {
            this.ctxTimeStamp = ctxTimeStamp;
        }

        ShaderId getShaderId() {
            return this.shaderId;
        }

        void setShaderId(ShaderId shaderId) {
            this.shaderId = shaderId;
        }

        boolean isCompiled() {
            return this.compiled;
        }

        void setCompiled(boolean compiled) {
            this.compiled = compiled;
        }
    }
}

