/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.AuralAttributes;
import org.scijava.java3d.AuralAttributesRetained;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.BoundingLeafRetained;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.IllegalSceneGraphException;
import org.scijava.java3d.IllegalSharingException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.VirtualUniverse;

class SoundscapeRetained
extends LeafRetained {
    static final int ATTRIBUTES_CHANGED = 1;
    static final int BOUNDING_LEAF_CHANGED = 2;
    static final int APPLICATION_BOUNDS_CHANGED = 4;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    AuralAttributesRetained attributes = null;
    int isDirty = 65535;
    int targetThreads = 514;
    boolean isViewScoped = false;

    void dispatchMessage(int dirtyBit, Object argument) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = this.targetThreads;
        createMessage.type = 40;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(dirtyBit);
        createMessage.args[2] = new Integer(0);
        createMessage.args[3] = null;
        createMessage.args[4] = argument;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    SoundscapeRetained() {
        this.nodeType = 15;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void setApplicationBounds(Bounds region) {
        if (region != null) {
            this.applicationRegion = (Bounds)region.clone();
            if (this.staticTransform != null) {
                this.applicationRegion.transform(this.staticTransform.transform);
            }
        } else {
            this.applicationRegion = null;
        }
        this.updateTransformChange();
        this.isDirty |= 4;
        this.dispatchMessage(4, region);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    Bounds getApplicationBounds() {
        Bounds b = null;
        if (this.applicationRegion == null) {
            return null;
        }
        b = (Bounds)this.applicationRegion.clone();
        if (this.staticTransform != null) {
            Transform3D invTransform = this.staticTransform.getInvTransform();
            b.transform(invTransform);
        }
        return b;
    }

    void setApplicationBoundingLeaf(BoundingLeaf region) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        this.updateTransformChange();
        this.isDirty |= 2;
        this.dispatchMessage(2, region);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        if (this.boundingLeaf != null) {
            return (BoundingLeaf)this.boundingLeaf.source;
        }
        return null;
    }

    void setAuralAttributes(AuralAttributes attributes) {
        if (this.source.isLive()) {
            if (this.attributes != null) {
                this.attributes.clearLive(this.refCount);
            }
            if (attributes != null) {
                ((AuralAttributesRetained)attributes.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        if (this.attributes != null) {
            this.attributes.removeUser(this);
        }
        if (attributes != null) {
            this.attributes = (AuralAttributesRetained)attributes.retained;
            this.attributes.addUser(this);
        } else {
            this.attributes = null;
        }
        this.isDirty |= 1;
        this.dispatchMessage(1, attributes);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    AuralAttributes getAuralAttributes() {
        if (this.attributes != null) {
            return (AuralAttributes)this.attributes.source;
        }
        return null;
    }

    @Override
    synchronized void updateMirrorObject(Object[] objs) {
        Object trans = null;
        int component = (Integer)objs[1];
        if ((component & 2) != 0) {
            if (this.boundingLeaf != null) {
                this.transformedRegion = this.boundingLeaf.transformedRegion;
            } else if (this.applicationRegion != null) {
                this.transformedRegion = (Bounds)this.applicationRegion.clone();
                this.transformedRegion.transform(this.applicationRegion, this.getLastLocalToVworld());
            } else {
                this.transformedRegion = null;
            }
        } else if ((component & 4) != 0) {
            if (this.boundingLeaf == null) {
                this.transformedRegion = (Bounds)this.applicationRegion.clone();
                this.transformedRegion.transform(this.applicationRegion, this.getLastLocalToVworld());
            } else {
                this.transformedRegion = null;
            }
        }
    }

    @Override
    synchronized void updateTransformChange() {
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getLastLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void updateBoundingLeaf(long refTime) {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = this.applicationRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.applicationRegion, this.getLastLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    @Override
    void setLive(SetLiveState s) {
        super.doSetLive(s);
        if (this.attributes != null) {
            this.attributes.setLive(this.inBackgroundGroup, s.refCount);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 3);
            s.notifyThreads |= 0x2000;
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this);
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("SoundscapeRetained1"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("SoundscapeRetained0"));
        }
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 3);
        }
        this.switchState = s.switchStates.get(0);
        s.notifyThreads |= 0x202;
        super.markAsLive();
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (s.switchTargets != null && s.switchTargets[0] != null) {
            s.switchTargets[0].addNode(this, 3);
        }
        if (this.attributes != null) {
            this.attributes.clearLive(s.refCount);
        }
        if (s.transformTargets != null && s.transformTargets[0] != null) {
            s.transformTargets[0].addNode(this, 3);
            s.notifyThreads |= 0x2000;
        }
        if (s.viewScopedNodeList != null && s.viewLists != null) {
            s.viewScopedNodeList.add(this);
            s.scopedNodesViewList.add(s.viewLists.get(0));
        } else {
            s.nodeList.add(this);
        }
        s.notifyThreads |= 0x202;
    }

    void update(SoundscapeRetained ss) {
        this.applicationRegion = (Bounds)ss.applicationRegion.clone();
        this.attributes = ss.attributes;
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.applicationRegion != null) {
            this.applicationRegion.transform(xform.transform);
        }
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        leafList.add(this);
    }
}

