/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.Group;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Node;
import org.scijava.java3d.View;
import org.scijava.java3d.ViewSpecificGroupRetained;

public class ViewSpecificGroup
extends Group {
    public static final int ALLOW_VIEW_READ = 17;
    public static final int ALLOW_VIEW_WRITE = 18;
    private static final int[] readCapabilities = new int[]{17};

    public ViewSpecificGroup() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    void createRetained() {
        this.retained = new ViewSpecificGroupRetained();
        this.retained.setSource(this);
    }

    public void setView(View view, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup1"));
        }
        ((ViewSpecificGroupRetained)this.retained).setView(view, index);
    }

    public View getView(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup2"));
        }
        return ((ViewSpecificGroupRetained)this.retained).getView(index);
    }

    public void insertView(View view, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup1"));
        }
        ((ViewSpecificGroupRetained)this.retained).insertView(view, index);
    }

    public void removeView(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup1"));
        }
        ((ViewSpecificGroupRetained)this.retained).removeView(index);
    }

    public Enumeration<View> getAllViews() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup2"));
        }
        return ((ViewSpecificGroupRetained)this.retained).getAllViews();
    }

    public void addView(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup1"));
        }
        ((ViewSpecificGroupRetained)this.retained).addView(view);
    }

    public int numViews() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup2"));
        }
        return ((ViewSpecificGroupRetained)this.retained).numViews();
    }

    public int indexOfView(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup2"));
        }
        return ((ViewSpecificGroupRetained)this.retained).indexOfView(view);
    }

    public void removeView(View view) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup1"));
        }
        ((ViewSpecificGroupRetained)this.retained).removeView(view);
    }

    public void removeAllViews() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewSpecificGroup1"));
        }
        ((ViewSpecificGroupRetained)this.retained).removeAllViews();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ViewSpecificGroup vsg = new ViewSpecificGroup();
        vsg.duplicateNode(this, forceDuplicate);
        return vsg;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ViewSpecificGroupRetained attr = (ViewSpecificGroupRetained)originalNode.retained;
        ViewSpecificGroupRetained rt = (ViewSpecificGroupRetained)this.retained;
        Enumeration<View> e = attr.getAllViews();
        while (e.hasMoreElements()) {
            rt.addView(e.nextElement());
        }
    }
}

