/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.javadoc;

import java.io.IOException;
import java.net.URL;
import org.scijava.log.LogService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.DefaultSearchAction;
import org.scijava.search.SearchAction;
import org.scijava.search.SearchActionFactory;
import org.scijava.search.SearchResult;
import org.scijava.search.classes.ClassSearchResult;
import org.scijava.search.javadoc.JavadocService;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=SearchActionFactory.class, priority=-100.0)
public class JavadocSearchActionFactory
implements SearchActionFactory {
    @Parameter
    private LogService log;
    @Parameter
    private UIService uiService;
    @Parameter
    private PlatformService platformService;
    @Parameter
    private JavadocService javadocService;

    @Override
    public boolean supports(SearchResult result) {
        return result instanceof ClassSearchResult;
    }

    @Override
    public SearchAction create(SearchResult result) {
        return new DefaultSearchAction("Javadoc", () -> this.javadoc(result));
    }

    private void javadoc(SearchResult result) {
        String javadocURL = this.javadocURL(result);
        if (javadocURL == null) {
            this.uiService.showDialog("Could not discern javadoc URL for class: " + ((ClassSearchResult)result).clazz(), "Javadoc Search", DialogPrompt.MessageType.ERROR_MESSAGE);
            return;
        }
        try {
            this.platformService.open(new URL(javadocURL));
        }
        catch (IOException exc) {
            this.log.error(exc);
            this.uiService.showDialog("Error opening javadoc URL: " + javadocURL, "Javadoc Search", DialogPrompt.MessageType.ERROR_MESSAGE);
        }
    }

    private String javadocURL(SearchResult result) {
        return this.javadocService.url(((ClassSearchResult)result).clazz());
    }
}

