/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.web;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.web.WebSearchResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BISESearcher
implements Searcher {
    private final ArrayList<SearchResult> searchResults = new ArrayList();
    private String currentHeading;
    private String currentLink;
    private String currentContent;
    @Parameter
    private LogService log;

    @Override
    public String title() {
        return "BISE";
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        this.searchResults.clear();
        try {
            URL url = new URL("http://biii.eu/search?search_api_fulltext=" + URLEncoder.encode(text, "utf-8") + "&source=imagej");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(url.openStream());
            this.parse(doc.getDocumentElement());
            this.saveLastItem();
        }
        catch (IOException e) {
            this.log.debug(e);
        }
        catch (ParserConfigurationException e) {
            this.log.debug(e);
        }
        catch (SAXException e) {
            this.log.debug(e);
        }
        return this.searchResults;
    }

    private void parseHeading(Node node) {
        Node href;
        if (node.getTextContent() != null && node.getTextContent().trim().length() > 0) {
            this.currentHeading = node.getTextContent();
        }
        if (node.getAttributes() != null && (href = node.getAttributes().getNamedItem("href")) != null) {
            this.currentLink = "http://biii.eu" + href.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            this.parseHeading(childNode);
        }
    }

    private void parseContent(Node node) {
        if (node.getTextContent() != null) {
            this.currentContent = node.getTextContent();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            this.parse(childNode);
        }
    }

    private void saveLastItem() {
        if (this.currentHeading != null && this.currentHeading.length() > 0) {
            this.searchResults.add(new WebSearchResult(this.currentHeading, this.currentLink, this.currentContent));
        }
        this.currentHeading = "";
        this.currentLink = "";
        this.currentContent = "";
    }

    private void parse(Node node) {
        if (node.getNodeName().equals("div")) {
            Node item;
            Node node2 = item = node.getAttributes() == null ? null : node.getAttributes().getNamedItem("class");
            if (item != null && item.getNodeValue().equals("views-field views-field-title")) {
                if (this.currentHeading != null) {
                    this.saveLastItem();
                }
                this.parseHeading(node);
                return;
            }
            if (item != null && item.getNodeValue().equals("views-field views-field-search-api-excerpt")) {
                this.parseContent(node);
                return;
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            this.parse(childNode);
        }
    }
}

