/*
 * Decompiled with CFR 0.152.
 */
package process;

import fiji.stacks.Hyperstack_rearranger;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.plugin.Concatenator;
import ij.process.ImageProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.imageplus.ImagePlusContainer;
import mpicbg.imglib.container.imageplus.ImagePlusContainerFactory;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.exception.ImgLibException;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import net.imglib2.util.Util;
import plugin.Descriptor_based_series_registration;

public class OverlayFusion {
    public static boolean useSizeOfFirstImage = false;

    protected static <T extends RealType<T>> CompositeImage createOverlay(T targetType, ImagePlus imp1, ImagePlus imp2, InvertibleBoundable finalModel1, InvertibleBoundable finalModel2, int dimensionality, int interpolation) {
        ArrayList<ImagePlus> images = new ArrayList<ImagePlus>();
        images.add(imp1);
        images.add(imp2);
        int ntimepoints = Math.min(imp1.getNFrames(), imp2.getNFrames());
        ImagePlus[] cis = new ImagePlus[ntimepoints];
        ArrayList<InvertibleBoundable> models = new ArrayList<InvertibleBoundable>();
        for (int i = 0; i < ntimepoints; ++i) {
            models.add(finalModel1);
            models.add(finalModel2);
        }
        IJ.log((String)("Fusing with " + (interpolation == 0 ? "linear interpolation" : "nearest neighbor interpolation")));
        for (int tp = 1; tp <= ntimepoints; ++tp) {
            cis[tp - 1] = interpolation == 1 ? OverlayFusion.createOverlay(targetType, images, models, dimensionality, tp, (InterpolatorFactory<FloatType>)new NearestNeighborInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory())) : OverlayFusion.createOverlay(targetType, images, models, dimensionality, tp, (InterpolatorFactory<FloatType>)new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory()));
        }
        ImagePlus imp = new Concatenator().concatenateHyperstacks(cis, "Fused " + imp1.getShortTitle() + " & " + imp2.getShortTitle(), false);
        int numChannels = imp1.getNChannels() + imp2.getNChannels();
        int nSlices = cis[0].getNSlices();
        imp.setDimensions(numChannels, nSlices, ntimepoints);
        imp.setCalibration(imp1.getCalibration());
        return new CompositeImage(imp, 1);
    }

    public static <T extends RealType<T>> ImagePlus createReRegisteredSeries(T targetType, ImagePlus imp, ArrayList<InvertibleBoundable> models, int dimensionality, String directory, int interpolation) {
        int numImages = Descriptor_based_series_registration.oneModelPerChannel ? imp.getNChannels() : imp.getNFrames();
        int[] size = new int[dimensionality];
        float[] offset = new float[dimensionality];
        int[][] imgSizes = new int[numImages][dimensionality];
        for (int i = 0; i < numImages; ++i) {
            imgSizes[i][0] = imp.getWidth();
            imgSizes[i][1] = imp.getHeight();
            if (dimensionality != 3) continue;
            imgSizes[i][2] = imp.getNSlices();
        }
        OverlayFusion.estimateBounds(offset, size, imgSizes, models, dimensionality);
        IJ.log((String)("Size of output image=" + Util.printCoordinates((int[])size)));
        if (useSizeOfFirstImage) {
            for (int d = 0; d < dimensionality; ++d) {
                size[d] = imgSizes[0][d];
                offset[d] = 0.0f;
            }
        }
        ImageFactory f = new ImageFactory(targetType, (ContainerFactory)new ImagePlusContainerFactory());
        ImageStack stack = new ImageStack(size[0], size[1]);
        IJ.log((String)("Fusing with " + (interpolation == 0 ? "linear interpolation" : "nearest neighbor interpolation")));
        for (int t = 1; t <= imp.getNFrames(); ++t) {
            IJ.showProgress((int)t, (int)imp.getNFrames());
            for (int c = 1; c <= imp.getNChannels(); ++c) {
                Image out = f.createImage(size);
                InvertibleBoundable model = Descriptor_based_series_registration.oneModelPerChannel ? models.get(c - 1) : models.get(t - 1);
                if (interpolation == 1) {
                    OverlayFusion.fuseChannel(out, (Image<FloatType>)ImageJFunctions.convertFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t)), offset, (InvertibleCoordinateTransform)model, (InterpolatorFactory<FloatType>)new NearestNeighborInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory()));
                } else {
                    OverlayFusion.fuseChannel(out, (Image<FloatType>)ImageJFunctions.convertFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)t)), offset, (InvertibleCoordinateTransform)model, (InterpolatorFactory<FloatType>)new LinearInterpolatorFactory((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyValueFactory()));
                }
                try {
                    int z;
                    ImagePlus outImp = ((ImagePlusContainer)out.getContainer()).getImagePlus();
                    if (directory == null) {
                        for (z = 1; z <= out.getDimension(2); ++z) {
                            stack.addSlice(imp.getTitle(), outImp.getStack().getProcessor(z));
                        }
                        continue;
                    }
                    for (z = 1; z <= out.getDimension(2); ++z) {
                        ImagePlus tmp = new ImagePlus("img_t" + OverlayFusion.lz(t, numImages) + "_z" + OverlayFusion.lz(z, out.getDimension(2)) + "_c" + OverlayFusion.lz(c, imp.getNChannels()), outImp.getStack().getProcessor(z));
                        FileSaver fs = new FileSaver(tmp);
                        fs.saveAsTiff(new File(directory, tmp.getTitle()).getAbsolutePath());
                        tmp.close();
                    }
                    out.close();
                    outImp.close();
                    continue;
                }
                catch (ImgLibException e) {
                    IJ.log((String)("Output image has no ImageJ type: " + (Object)((Object)e)));
                }
            }
        }
        IJ.showProgress((double)1.0);
        if (directory != null) {
            return null;
        }
        ImagePlus result = new ImagePlus("registered " + imp.getTitle(), stack);
        if (dimensionality == 3) {
            result.setDimensions(size[2], imp.getNChannels(), imp.getNFrames());
            result = OverlayFusion.switchZCinXYCZT(result);
            return new CompositeImage(result, 1);
        }
        result.setDimensions(imp.getNChannels(), 1, imp.getNFrames());
        if (imp.getNChannels() > 1) {
            return new CompositeImage(result, 1);
        }
        return result;
    }

    private static final String lz(int num, int max) {
        String out = "" + num;
        String outMax = "" + max;
        while (out.length() < outMax.length()) {
            out = "0" + out;
        }
        return out;
    }

    public static <T extends RealType<T>> CompositeImage createOverlay(T targetType, ArrayList<ImagePlus> images, ArrayList<InvertibleBoundable> models, int dimensionality, int timepoint, InterpolatorFactory<FloatType> factory) {
        int numImages = images.size();
        int[] size = new int[dimensionality];
        float[] offset = new float[dimensionality];
        OverlayFusion.estimateBounds(offset, size, images, models, dimensionality);
        ImageFactory f = new ImageFactory(targetType, (ContainerFactory)new ImagePlusContainerFactory());
        ImageStack stack = new ImageStack(size[0], size[1]);
        int numChannels = 0;
        for (int i = 0; i < images.size(); ++i) {
            ImagePlus imp = images.get(i);
            for (int c = 1; c <= imp.getNChannels(); ++c) {
                Image out = f.createImage(size);
                OverlayFusion.fuseChannel(out, (Image<FloatType>)ImageJFunctions.convertFloat((ImagePlus)Hyperstack_rearranger.getImageChunk((ImagePlus)imp, (int)c, (int)timepoint)), offset, (InvertibleCoordinateTransform)models.get(i + (timepoint - 1) * numImages), factory);
                try {
                    ImagePlus outImp = ((ImagePlusContainer)out.getContainer()).getImagePlus();
                    for (int z = 1; z <= out.getDimension(2); ++z) {
                        stack.addSlice(imp.getTitle(), outImp.getStack().getProcessor(z));
                    }
                }
                catch (ImgLibException e) {
                    IJ.log((String)("Output image has no ImageJ type: " + (Object)((Object)e)));
                }
                ++numChannels;
            }
        }
        ImagePlus result = new ImagePlus("overlay " + images.get(0).getTitle() + " ... " + images.get(numImages - 1).getTitle(), stack);
        if (dimensionality == 3) {
            result.setDimensions(size[2], numChannels, 1);
            result = OverlayFusion.switchZCinXYCZT(result);
        } else {
            result.setDimensions(numChannels, 1, 1);
        }
        return new CompositeImage(result, 1);
    }

    public static void estimateBounds(float[] offset, int[] size, List<ImagePlus> images, ArrayList<InvertibleBoundable> models, int dimensionality) {
        int[][] imgSizes = new int[images.size()][dimensionality];
        for (int i = 0; i < images.size(); ++i) {
            imgSizes[i][0] = images.get(i).getWidth();
            imgSizes[i][1] = images.get(i).getHeight();
            if (dimensionality != 3) continue;
            imgSizes[i][2] = images.get(i).getNSlices();
        }
        OverlayFusion.estimateBounds(offset, size, imgSizes, models, dimensionality);
    }

    public static void estimateBounds(float[] offset, int[] size, int[][] imgSizes, ArrayList<InvertibleBoundable> models, int dimensionality) {
        int d;
        int i;
        int numImages = imgSizes.length;
        int numTimePoints = models.size() / numImages;
        double[][] max = new double[numImages * numTimePoints][];
        double[][] min = new double[numImages * numTimePoints][dimensionality];
        if (dimensionality == 2) {
            for (i = 0; i < numImages * numTimePoints; ++i) {
                max[i] = new double[]{imgSizes[i % numImages][0], imgSizes[i % numImages][1]};
            }
        } else {
            for (i = 0; i < numImages * numTimePoints; ++i) {
                max[i] = new double[]{imgSizes[i % numImages][0], imgSizes[i % numImages][1], imgSizes[i % numImages][2]};
            }
        }
        ArrayList<InvertibleBoundable> boundables = new ArrayList<InvertibleBoundable>();
        for (int i2 = 0; i2 < numImages * numTimePoints; ++i2) {
            InvertibleBoundable boundable = models.get(i2);
            boundables.add(boundable);
            boundable.estimateBounds(min[i2], max[i2]);
        }
        double[] minImg = new double[dimensionality];
        double[] maxImg = new double[dimensionality];
        for (d = 0; d < dimensionality; ++d) {
            maxImg[d] = Math.max(Math.max(max[0][d], max[1][d]), Math.max(min[0][d], min[1][d]));
            minImg[d] = Math.min(Math.min(max[0][d], max[1][d]), Math.min(min[0][d], min[1][d]));
            for (int i3 = 2; i3 < numImages * numTimePoints; ++i3) {
                maxImg[d] = Math.max(maxImg[d], Math.max(min[i3][d], max[i3][d]));
                minImg[d] = Math.min(minImg[d], Math.min(min[i3][d], max[i3][d]));
            }
        }
        for (d = 0; d < dimensionality; ++d) {
            size[d] = (int)Math.round(maxImg[d] - minImg[d]);
            offset[d] = (float)minImg[d];
        }
    }

    public static <T extends RealType<T>> void fuseChannel(final Image<T> output, final Image<FloatType> input, final float[] offset, final InvertibleCoordinateTransform transform, final InterpolatorFactory<FloatType> factory) {
        final int dims = output.getNumDimensions();
        long imageSize = output.getDimension(0);
        for (int d = 1; d < output.getNumDimensions(); ++d) {
            imageSize *= (long)output.getDimension(d);
        }
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)imageSize, (int)threads.length);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long startPos = myChunk.getStartPosition();
                    long loopSize = myChunk.getLoopSize();
                    LocalizableCursor out = output.createLocalizableCursor();
                    Interpolator in = input.createInterpolator(factory);
                    double[] tmp = new double[input.getNumDimensions()];
                    try {
                        out.fwd(startPos);
                        for (long j = 0L; j < loopSize; ++j) {
                            out.fwd();
                            for (int d = 0; d < dims; ++d) {
                                tmp[d] = (float)out.getPosition(d) + offset[d];
                            }
                            transform.applyInverseInPlace(tmp);
                            in.setPosition(tmp);
                            ((RealType)out.getType()).setReal(((FloatType)in.getType()).get());
                        }
                    }
                    catch (NoninvertibleModelException e) {
                        IJ.log((String)"Cannot invert model, qutting.");
                        return;
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static ImagePlus switchZCinXYCZT(ImagePlus imp) {
        int numChannels = imp.getNChannels();
        int numTimepoints = imp.getNFrames();
        int numZStacks = imp.getNSlices();
        String newTitle = imp.getTitle().startsWith("[XYZCT]") ? imp.getTitle().substring(8, imp.getTitle().length()) : "[XYZCT] " + imp.getTitle();
        if (numChannels == 1 && numZStacks == 1) {
            return imp;
        }
        if (numChannels == 1 || numZStacks == 1) {
            imp.setDimensions(numZStacks, numChannels, numTimepoints);
            imp.setTitle(newTitle);
            return imp;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int t = 1; t <= numTimepoints; ++t) {
            for (int c = 1; c <= numChannels; ++c) {
                for (int z = 1; z <= numZStacks; ++z) {
                    int index = imp.getStackIndex(c, z, t);
                    ImageProcessor ip = imp.getStack().getProcessor(index);
                    stack.addSlice(imp.getStack().getSliceLabel(index), ip);
                }
            }
        }
        ImagePlus result = new ImagePlus(newTitle, stack);
        result.setDimensions(numZStacks, numChannels, numTimepoints);
        result.getCalibration().pixelWidth = imp.getCalibration().pixelWidth;
        result.getCalibration().pixelHeight = imp.getCalibration().pixelHeight;
        result.getCalibration().pixelDepth = imp.getCalibration().pixelDepth;
        CompositeImage composite = new CompositeImage(result);
        return composite;
    }

    public static ImagePlus switchZTinXYCZT(ImagePlus imp) {
        int numChannels = imp.getNChannels();
        int numTimepoints = imp.getNFrames();
        int numZStacks = imp.getNSlices();
        String newTitle = imp.getTitle().startsWith("[XYCTZ]") ? imp.getTitle().substring(8, imp.getTitle().length()) : "[XYCTZ] " + imp.getTitle();
        if (numTimepoints == 1 && numZStacks == 1) {
            return imp;
        }
        if (numTimepoints == 1 || numZStacks == 1) {
            imp.setDimensions(numChannels, numTimepoints, numZStacks);
            imp.setTitle(newTitle);
            return imp;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int z = 1; z <= numZStacks; ++z) {
            for (int t = 1; t <= numTimepoints; ++t) {
                for (int c = 1; c <= numChannels; ++c) {
                    int index = imp.getStackIndex(c, z, t);
                    ImageProcessor ip = imp.getStack().getProcessor(index);
                    stack.addSlice(imp.getStack().getSliceLabel(index), ip);
                }
            }
        }
        ImagePlus result = new ImagePlus(newTitle, stack);
        result.setDimensions(numChannels, numTimepoints, numZStacks);
        result.getCalibration().pixelWidth = imp.getCalibration().pixelWidth;
        result.getCalibration().pixelHeight = imp.getCalibration().pixelHeight;
        result.getCalibration().pixelDepth = imp.getCalibration().pixelDepth;
        CompositeImage composite = new CompositeImage(result);
        return composite;
    }
}

