/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.integral;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.type.numeric.NumericType;

public class IntegralImage<R extends NumericType<R>, T extends NumericType<T>>
implements OutputAlgorithm<T> {
    protected final Image<R> img;
    protected final T type;
    protected Image<T> integral;
    protected final Converter<R, T> converter;

    public IntegralImage(Image<R> img, T type, Converter<R, T> converter) {
        this.img = img;
        this.type = type;
        this.converter = converter;
    }

    @Override
    public boolean process() {
        Thread[] threads;
        final int numDimensions = this.img.getNumDimensions();
        int[] integralSize = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            integralSize[d] = this.img.getDimension(d) + 1;
        }
        ImageFactory<T> imgFactory = new ImageFactory<T>(this.type, new ArrayContainerFactory());
        final Image<T> integral = imgFactory.createImage(integralSize);
        if (integral == null) {
            return false;
        }
        this.integral = integral;
        if (numDimensions > 1) {
            final int[] fakeSize = new int[numDimensions - 1];
            final int size = integralSize[0];
            for (int d = 1; d < numDimensions; ++d) {
                fakeSize[d - 1] = integralSize[d];
            }
            long imageSize = IntegralImage.getNumPixels(fakeSize);
            final AtomicInteger ai = new AtomicInteger(0);
            threads = SimpleMultiThreading.newThreads();
            final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, threads.length);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                        long loopSize = myChunk.getLoopSize();
                        ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                        int[] tmpIn = new int[numDimensions];
                        int[] tmpOut = new int[numDimensions];
                        int[] tmp = new int[numDimensions - 1];
                        LocalizableByDimCursor cursorIn = IntegralImage.this.img.createLocalizableByDimCursor();
                        LocalizableByDimCursor cursorOut = integral.createLocalizableByDimCursor();
                        NumericType tmpVar = (NumericType)integral.createType();
                        NumericType sum = (NumericType)integral.createType();
                        cursorDim.fwd(myChunk.getStartPosition());
                        block0: for (long j = 0L; j < loopSize; ++j) {
                            cursorDim.fwd();
                            cursorDim.getPosition(tmp);
                            tmpIn[0] = 0;
                            tmpOut[0] = 1;
                            for (int d = 1; d < numDimensions; ++d) {
                                tmpIn[d] = tmp[d - 1] - 1;
                                tmpOut[d] = tmp[d - 1];
                                if (tmpOut[d] == 0) continue block0;
                            }
                            cursorIn.setPosition(tmpIn);
                            cursorOut.setPosition(tmpOut);
                            IntegralImage.this.integrateLineDim0(IntegralImage.this.converter, cursorIn, cursorOut, sum, tmpVar, size);
                        }
                        cursorIn.close();
                        cursorOut.close();
                    }
                });
            }
        } else {
            NumericType tmpVar = (NumericType)integral.createType();
            NumericType sum = (NumericType)integral.createType();
            int size = integralSize[0];
            LocalizableByDimCursor<R> cursorIn = this.img.createLocalizableByDimCursor();
            LocalizableByDimCursor<T> cursorOut = integral.createLocalizableByDimCursor();
            cursorIn.setPosition(0, 0);
            cursorOut.setPosition(1, 0);
            this.converter.convert(cursorIn.getType(), sum);
            ((NumericType)cursorOut.getType()).set(sum);
            for (int i = 2; i < size; ++i) {
                cursorIn.fwd(0);
                cursorOut.fwd(0);
                this.converter.convert(cursorIn.getType(), tmpVar);
                sum.add(tmpVar);
                ((NumericType)cursorOut.getType()).set(sum);
            }
            cursorIn.close();
            cursorOut.close();
            return true;
        }
        SimpleMultiThreading.startAndJoin(threads);
        for (int d = 1; d < numDimensions; ++d) {
            final int dim = d;
            final int[] fakeSize = new int[numDimensions - 1];
            final int size = integralSize[d];
            int countDim = 0;
            for (int e = 0; e < numDimensions; ++e) {
                if (e == d) continue;
                fakeSize[countDim++] = integralSize[e];
            }
            long imageSize = IntegralImage.getNumPixels(fakeSize);
            final AtomicInteger ai = new AtomicInteger(0);
            Thread[] threads2 = SimpleMultiThreading.newThreads();
            final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, threads2.length);
            for (int ithread = 0; ithread < threads2.length; ++ithread) {
                threads2[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                        long loopSize = myChunk.getLoopSize();
                        ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                        int[] tmp2 = new int[numDimensions - 1];
                        int[] tmp = new int[numDimensions];
                        LocalizableByDimCursor cursor = integral.createLocalizableByDimCursor();
                        NumericType sum = (NumericType)integral.createType();
                        cursorDim.fwd(myChunk.getStartPosition());
                        for (long j = 0L; j < loopSize; ++j) {
                            cursorDim.fwd();
                            cursorDim.getPosition(tmp2);
                            tmp[dim] = 1;
                            int countDim = 0;
                            for (int e = 0; e < numDimensions; ++e) {
                                if (e == dim) continue;
                                tmp[e] = tmp2[countDim++];
                            }
                            cursor.setPosition(tmp);
                            IntegralImage.this.integrateLine(dim, cursor, sum, size);
                        }
                        cursor.close();
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads2);
        }
        return true;
    }

    public static final long getNumPixels(int[] size) {
        long num = size[0];
        for (int d = 1; d < size.length; ++d) {
            num *= (long)size[d];
        }
        return num;
    }

    protected void integrateLineDim0(Converter<R, T> converter, LocalizableByDimCursor<R> cursorIn, LocalizableByDimCursor<T> cursorOut, T sum, T tmpVar, int size) {
        converter.convert(cursorIn.getType(), sum);
        ((NumericType)cursorOut.getType()).set(sum);
        for (int i = 2; i < size; ++i) {
            cursorIn.fwd(0);
            cursorOut.fwd(0);
            converter.convert(cursorIn.getType(), tmpVar);
            sum.add(tmpVar);
            ((NumericType)cursorOut.getType()).set(sum);
        }
    }

    protected void integrateLine(int d, LocalizableByDimCursor<T> cursor, T sum, int size) {
        sum.set(cursor.getType());
        for (int i = 2; i < size; ++i) {
            cursor.fwd(d);
            sum.add((NumericType)((NumericType)cursor.getType()));
            ((NumericType)cursor.getType()).set(sum);
        }
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public Image<T> getResult() {
        return this.integral;
    }
}

