/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.peak;

import mpicbg.imglib.algorithm.peak.GaussianMultiDLM;
import mpicbg.imglib.algorithm.peak.LevenbergMarquardtSolver;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class GaussianPeakFitterND<T extends RealType<T>> {
    private static final String BASE_ERROR_MESSAGE = "GaussianPeakFitterND: ";
    private final Image<T> image;
    private final int ndims;
    private String errorMessage;

    public GaussianPeakFitterND(Image<T> image) {
        this.image = image;
        this.ndims = image.getNumDimensions();
    }

    public boolean checkInput() {
        if (null == this.image) {
            this.errorMessage = "GaussianPeakFitterND: Image is null.";
            return false;
        }
        return true;
    }

    public double[] process(Localizable point, double[] typical_sigma) {
        int[] pad_size = new int[this.ndims];
        for (int i = 0; i < this.ndims; ++i) {
            pad_size[i] = (int)Math.ceil(2.0 * typical_sigma[i]);
        }
        Observation data = this.gatherObservationData(point, pad_size);
        double[][] X = data.X;
        double[] I = data.I;
        double[] start_param = this.makeBestGuess(X, I);
        for (int j = 0; j < this.ndims; ++j) {
            if (!(start_param[j + this.ndims + 1] < 1.0 / (typical_sigma[j] * typical_sigma[j]))) continue;
            start_param[j + this.ndims + 1] = 1.0 / (typical_sigma[j] * typical_sigma[j]);
        }
        int maxiter = 300;
        double lambda = 0.001;
        double termepsilon = 0.1;
        double[] a = (double[])start_param.clone();
        try {
            LevenbergMarquardtSolver.solve(X, a, I, new GaussianMultiDLM(), lambda, termepsilon, maxiter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int j = 0; j < a.length; ++j) {
            if (!Double.isNaN(a[j])) continue;
            a[j] = start_param[j];
        }
        return a;
    }

    private final double[] makeBestGuess(double[][] X, double[] I) {
        int j;
        double[] start_param = new double[2 * this.ndims + 1];
        double[] X_sum = new double[this.ndims];
        for (int j2 = 0; j2 < this.ndims; ++j2) {
            X_sum[j2] = 0.0;
            for (int i = 0; i < X.length; ++i) {
                int n = j2;
                X_sum[n] = X_sum[n] + X[i][j2] * I[i];
            }
        }
        double I_sum = 0.0;
        double max_I = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < X.length; ++i) {
            I_sum += I[i];
            if (!(I[i] > max_I)) continue;
            max_I = I[i];
        }
        start_param[0] = max_I;
        for (j = 0; j < this.ndims; ++j) {
            start_param[j + 1] = X_sum[j] / I_sum;
        }
        for (j = 0; j < this.ndims; ++j) {
            double C = 0.0;
            for (int i = 0; i < X.length; ++i) {
                double dx = X[i][j] - start_param[j + 1];
                C += I[i] * dx * dx;
            }
            start_param[this.ndims + j + 1] = 1.0 / (C /= I_sum);
        }
        return start_param;
    }

    private final Observation gatherObservationData(Localizable point, int[] pad_size) {
        int n_pixels = 1;
        for (int i = 0; i < pad_size.length; ++i) {
            n_pixels *= 2 * pad_size[i] + 1;
        }
        double[][] tmp_X = new double[n_pixels][this.ndims];
        double[] tmp_I = new double[n_pixels];
        int index = 0;
        int[] offset = new int[this.ndims];
        int[] size = new int[this.ndims];
        for (int i = 0; i < offset.length; ++i) {
            offset[i] = point.getPosition(i) - pad_size[i];
            size[i] = 2 * pad_size[i] + 1;
        }
        RegionOfInterestCursor<T> cursor = this.image.createLocalizableByDimCursor().createRegionOfInterestCursor(offset, size);
        boolean outofbounds = false;
        int[] pos = cursor.createPositionArray();
        while (cursor.hasNext()) {
            int i;
            cursor.fwd();
            cursor.getPosition(pos);
            for (i = 0; i < this.ndims; ++i) {
                int n = i;
                pos[n] = pos[n] + offset[i];
                if (pos[i] >= 0 && pos[i] < this.image.getDimension(i)) continue;
                outofbounds = true;
                break;
            }
            if (outofbounds) {
                outofbounds = false;
                continue;
            }
            for (i = 0; i < this.ndims; ++i) {
                tmp_X[index][i] = pos[i];
            }
            tmp_I[index] = ((RealType)cursor.getType()).getRealDouble();
            ++index;
        }
        cursor.close();
        double[][] X = null;
        double[] I = null;
        if (index == n_pixels) {
            X = tmp_X;
            I = tmp_I;
        } else {
            X = new double[index][this.ndims];
            I = new double[index];
            System.arraycopy(tmp_X, 0, X, 0, index);
            System.arraycopy(tmp_I, 0, I, 0, index);
        }
        Observation obs = new Observation();
        obs.I = I;
        obs.X = X;
        return obs;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static class Observation {
        public double[] I;
        public double[][] X;

        private Observation() {
        }
    }
}

