/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.array;

import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.array.ArrayCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class Array<T extends Type<T>, A extends DataAccess>
extends DirectAccessContainerImpl<T, A> {
    protected final int[] step;
    final ArrayContainerFactory factory;
    final A data;

    public Array(ArrayContainerFactory factory, A data, int[] dim, int entitiesPerPixel) {
        super(factory, dim, entitiesPerPixel);
        this.step = Array.createAllocationSteps(dim);
        this.factory = factory;
        this.data = data;
    }

    @Override
    public A update(Cursor<?> c) {
        return this.data;
    }

    @Override
    public ArrayContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public ArrayCursor<T> createCursor(Image<T> image) {
        ArrayCursor<T> c = new ArrayCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public ArrayLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        ArrayLocalizableCursor<T> c = new ArrayLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public ArrayLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        ArrayLocalizablePlaneCursor<T> c = new ArrayLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public ArrayLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        ArrayLocalizableByDimCursor<T> c = new ArrayLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public ArrayLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        ArrayLocalizableByDimOutOfBoundsCursor<T> c = new ArrayLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsFactory);
        return c;
    }

    public static int[] createAllocationSteps(int[] dim) {
        int[] steps = new int[dim.length];
        Array.createAllocationSteps(dim, steps);
        return steps;
    }

    public static void createAllocationSteps(int[] dim, int[] steps) {
        steps[0] = 1;
        for (int d = 1; d < dim.length; ++d) {
            steps[d] = steps[d - 1] * dim[d - 1];
        }
    }

    public final int getPos(int[] l) {
        int i = l[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            i += l[d] * this.step[d];
        }
        return i;
    }

    @Override
    public void close() {
        this.data.close();
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            return this.getFactory().getClass().isInstance(container.getFactory());
        }
        return false;
    }
}

