/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import mpicbg.imglib.container.basictypecontainer.DoubleAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIODoubleArray
implements ArrayDataAccess<NIODoubleArray>,
DoubleAccess {
    protected DoubleBuffer data;

    public NIODoubleArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }

    public NIODoubleArray(double[] data) {
        DoubleBuffer bufferIn = DoubleBuffer.wrap(data);
        DoubleBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public double getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, double value) {
        this.data.put(index, value);
    }

    public double[] getCurrentStorageArray() {
        double[] outData = new double[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIODoubleArray createArray(int numEntities) {
        return new NIODoubleArray(numEntities);
    }
}

