/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.shapelist;

import java.awt.Shape;
import java.util.ArrayList;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerImpl;
import mpicbg.imglib.container.shapelist.ShapeListContainerFactory;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class ShapeList<T extends Type<T>>
extends ContainerImpl<T> {
    public final ShapeListContainerFactory factory;
    protected final ArrayList<ArrayList<Shape>> shapeLists;
    protected final ArrayList<ArrayList<T>> typeLists;
    protected final T background;

    public ShapeList(ShapeListContainerFactory factory, int[] dim, T background) {
        super(factory, dim);
        int d;
        this.factory = factory;
        int n = 1;
        for (d = 2; d < dim.length; ++d) {
            n *= dim[d];
        }
        this.shapeLists = new ArrayList(n);
        this.typeLists = new ArrayList(n);
        for (d = 0; d < n; ++d) {
            this.shapeLists.add(new ArrayList());
            this.typeLists.add(new ArrayList());
        }
        this.background = background;
    }

    public ShapeList(int[] dim, T background) {
        this(new ShapeListContainerFactory(), dim, background);
    }

    public T getBackground() {
        return this.background;
    }

    public synchronized void addShape(Shape shape, T type, int[] position) {
        int p = 0;
        if (position != null) {
            int f = 1;
            for (int d = 2; d < this.numDimensions; ++d) {
                p += f * position[d - 2];
                f *= this.dim[d];
            }
        }
        this.shapeLists.get(p).add(shape);
        this.typeLists.get(p).add(type);
    }

    public synchronized ArrayList<ArrayList<Shape>> getShapeLists() {
        ArrayList<ArrayList<Shape>> sl = new ArrayList<ArrayList<Shape>>();
        for (ArrayList<Shape> a : this.shapeLists) {
            sl.add(new ArrayList<Shape>(a));
        }
        return sl;
    }

    @Override
    public ShapeListContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public ShapeListLocalizableByDimCursor<T> createCursor(Image<T> image) {
        return this.createLocalizableByDimCursor((Image)image);
    }

    @Override
    public ShapeListLocalizableByDimCursor<T> createLocalizableCursor(Image<T> image) {
        return this.createLocalizableByDimCursor((Image)image);
    }

    @Override
    public ShapeListLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new ShapeListLocalizablePlaneCursor<T>(this, image);
    }

    @Override
    public ShapeListLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new ShapeListLocalizableByDimCursor<T>(this, image);
    }

    @Override
    public ShapeListLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        return new ShapeListLocalizableByDimOutOfBoundsCursor<T>(this, image, outOfBoundsFactory);
    }

    @Override
    public void close() {
    }

    protected T getShapeType(int x, int y, int p) {
        ArrayList<Shape> shapeList = this.shapeLists.get(p);
        for (int i = shapeList.size() - 1; i >= 0; --i) {
            if (!shapeList.get(i).contains(x, y)) continue;
            return (T)((Type)this.typeLists.get(p).get(i));
        }
        return this.background;
    }

    public T getShapeType(int[] position) {
        int p = 0;
        int f = 1;
        for (int d = 2; d < position.length; ++d) {
            p += f * position[d];
            f *= this.dim[d];
        }
        return this.getShapeType(position[0], position[1], p);
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            return this.getFactory().getClass().isInstance(container.getFactory());
        }
        return false;
    }
}

