/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.nearestneighbor;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator1D;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class NearestNeighborInterpolator1D<T extends Type<T>>
extends NearestNeighborInterpolator<T>
implements Interpolator1D<T> {
    float x = 0.0f;

    protected NearestNeighborInterpolator1D(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
    }

    @Override
    public Image<T> getImage() {
        return this.img;
    }

    @Override
    public void getPosition(float[] position) {
        position[0] = this.x;
    }

    @Override
    public float[] getPosition() {
        return new float[]{this.x};
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public void moveTo(float x) {
        this.x = x;
        int ix = Util.round(x);
        this.cursor.move(ix - this.cursor.getPosition(0), 0);
    }

    @Override
    public void moveTo(float[] position) {
        this.moveTo(position[0]);
    }

    @Override
    public void moveTo(double[] position) {
        this.moveTo((float)position[0]);
    }

    @Override
    public void moveRel(float x) {
        this.x += x;
        this.cursor.move(Util.round(this.x) - this.cursor.getPosition(0), 0);
    }

    @Override
    public void moveRel(float[] vector) {
        this.moveRel(vector[0]);
    }

    @Override
    public void moveRel(double[] vector) {
        this.moveRel((float)vector[0]);
    }

    @Override
    public void setPosition(float x) {
        this.x = x;
        this.cursor.setPosition(Util.round(x), 0);
    }

    @Override
    public void setPosition(float[] position) {
        this.setPosition(position[0]);
    }

    @Override
    public void setPosition(double[] position) {
        this.setPosition((float)position[0]);
    }

    @Override
    public float getX() {
        return this.x;
    }
}

