/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

class LabelingMapping<T extends Comparable<T>, N extends Number> {
    Constructor<N> constructor;
    N instance;
    protected Map<List<T>, InternedList<T, N>> internedLists = new HashMap<List<T>, InternedList<T, N>>();
    protected ArrayList<InternedList<T, N>> listsByIndex = new ArrayList();

    public LabelingMapping(N srcInstance) {
        this.instance = srcInstance;
        Class<?> c = srcInstance.getClass();
        try {
            this.constructor = c.getConstructor(String.class);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Number class cannot be constructed from a string");
        }
        List background = Collections.emptyList();
        this.intern(background);
    }

    public List<T> intern(List<T> src) {
        return this.internImpl(src);
    }

    private InternedList<T, N> internImpl(List<T> src) {
        InternedList<T, Object> interned;
        if (src instanceof InternedList) {
            interned = (InternedList<T, N>)src;
            if (interned.owner == this) {
                return interned;
            }
        }
        ArrayList<T> copy = new ArrayList<T>(src);
        Collections.sort(copy);
        interned = this.internedLists.get(copy);
        if (interned == null) {
            Number index;
            int intIndex = this.listsByIndex.size();
            try {
                index = (Number)this.constructor.newInstance(Integer.toString(intIndex));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new AssertionError((Object)e.getMessage());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new AssertionError((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new AssertionError((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                if (e.getTargetException() instanceof NumberFormatException) {
                    throw new AssertionError((Object)String.format("Too many labels (or types of multiply-labeled pixels): %d maximum", intIndex));
                }
                throw new AssertionError((Object)e.getMessage());
            }
            interned = new InternedList<T, Number>(src, index, this);
            this.listsByIndex.add(interned);
            this.internedLists.put(interned, interned);
        }
        return interned;
    }

    public List<T> intern(T[] src) {
        return this.intern(Arrays.asList(src));
    }

    public N indexOf(List<T> key) {
        InternedList<T, N> interned = this.internImpl(key);
        return interned.index;
    }

    public N indexOf(T[] key) {
        return this.indexOf(this.intern((Comparable[])key));
    }

    public List<T> listAtIndex(int index) {
        return this.listsByIndex.get(index);
    }

    public List<T> getLabels() {
        HashSet<Comparable> result = new HashSet<Comparable>();
        for (InternedList<T, N> instance : this.listsByIndex) {
            for (Comparable label : instance) {
                result.add(label);
            }
        }
        return new ArrayList(result);
    }

    private static class InternedList<T1 extends Comparable<T1>, N extends Number>
    implements List<T1> {
        private final List<T1> value;
        final N index;
        final LabelingMapping<T1, N> owner;

        public InternedList(List<T1> src, N index, LabelingMapping<T1, N> owner) {
            this.value = Collections.unmodifiableList(src);
            this.index = index;
            this.owner = owner;
        }

        @Override
        public int size() {
            return this.value.size();
        }

        @Override
        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.value.contains(o);
        }

        @Override
        public Iterator<T1> iterator() {
            return this.value.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.value.toArray();
        }

        @Override
        public boolean add(T1 e) {
            return this.value.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.value.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.value.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T1> c) {
            return this.value.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T1> c) {
            return this.value.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.value.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.value.retainAll(c);
        }

        @Override
        public void clear() {
            this.value.clear();
        }

        @Override
        public T1 get(int index) {
            return (T1)((Comparable)this.value.get(index));
        }

        @Override
        public T1 set(int index, T1 element) {
            return (T1)((Comparable)this.value.set(index, element));
        }

        @Override
        public void add(int index, T1 element) {
            this.value.add(index, element);
        }

        @Override
        public T1 remove(int index) {
            return (T1)((Comparable)this.value.remove(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.value.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.value.lastIndexOf(o);
        }

        @Override
        public ListIterator<T1> listIterator() {
            return this.value.listIterator();
        }

        @Override
        public ListIterator<T1> listIterator(int index) {
            return this.value.listIterator(index);
        }

        @Override
        public List<T1> subList(int fromIndex, int toIndex) {
            return this.value.subList(fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.value.toArray(a);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof InternedList) {
                InternedList iobj = (InternedList)obj;
                return this.value.equals(iobj.value);
            }
            return this.value.equals(obj);
        }
    }
}

