/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.complex;

import mpicbg.imglib.algorithm.Precision;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.complex.ComplexTypeImpl;

public class ComplexFloatType
extends ComplexTypeImpl<ComplexFloatType>
implements ComplexType<ComplexFloatType> {
    final DirectAccessContainer<ComplexFloatType, ? extends FloatAccess> storage;
    FloatAccess b;

    public ComplexFloatType(DirectAccessContainer<ComplexFloatType, ? extends FloatAccess> complexfloatStorage) {
        this.storage = complexfloatStorage;
    }

    public ComplexFloatType(float real, float complex) {
        this.storage = null;
        this.b = new FloatArray(2);
        this.set(real, complex);
    }

    public ComplexFloatType() {
        this(0.0f, 0.0f);
    }

    @Override
    public DirectAccessContainer<ComplexFloatType, ? extends FloatAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<ComplexFloatType, FloatAccess> container = storageFactory.createFloatInstance(dim, 2);
        ComplexFloatType linkedType = new ComplexFloatType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public ComplexFloatType duplicateTypeOnSameDirectAccessContainer() {
        return new ComplexFloatType(this.storage);
    }

    @Override
    public float getRealFloat() {
        return this.b.getValue(this.realI);
    }

    @Override
    public double getRealDouble() {
        return this.b.getValue(this.realI);
    }

    @Override
    public float getComplexFloat() {
        return this.b.getValue(this.complexI);
    }

    @Override
    public double getComplexDouble() {
        return this.b.getValue(this.complexI);
    }

    @Override
    public void setReal(float real) {
        this.b.setValue(this.realI, real);
    }

    @Override
    public void setReal(double real) {
        this.b.setValue(this.realI, (float)real);
    }

    @Override
    public void setComplex(float complex) {
        this.b.setValue(this.complexI, complex);
    }

    @Override
    public void setComplex(double complex) {
        this.b.setValue(this.complexI, (float)complex);
    }

    @Override
    public Precision.PrecisionReal getPreferredRealPrecision() {
        return Precision.PrecisionReal.Float;
    }

    public void set(float real, float complex) {
        this.b.setValue(this.realI, real);
        this.b.setValue(this.complexI, complex);
    }

    @Override
    public void add(ComplexFloatType c) {
        this.setReal(this.getRealFloat() + c.getRealFloat());
        this.setComplex(this.getComplexFloat() + c.getComplexFloat());
    }

    @Override
    public void div(ComplexFloatType c) {
        float a1 = this.getRealFloat();
        float b1 = this.getComplexFloat();
        float c1 = c.getRealFloat();
        float d1 = c.getComplexFloat();
        this.setReal((a1 * c1 + b1 * d1) / (c1 * c1 + d1 * d1));
        this.setComplex((b1 * c1 - a1 * d1) / (c1 * c1 + d1 * d1));
    }

    @Override
    public void mul(ComplexFloatType t) {
        float a = this.getRealFloat();
        float b = this.getComplexFloat();
        float c = t.getRealFloat();
        float d = t.getComplexFloat();
        this.setReal(a * c - b * d);
        this.setComplex(a * d + b * c);
    }

    @Override
    public void sub(ComplexFloatType c) {
        this.setReal(this.getRealFloat() - c.getRealFloat());
        this.setComplex(this.getComplexFloat() - c.getComplexFloat());
    }

    @Override
    public void complexConjugate() {
        this.setComplex(-this.getComplexFloat());
    }

    public void switchRealComplex() {
        float a = this.getRealFloat();
        this.setReal(this.getComplexFloat());
        this.setComplex(a);
    }

    @Override
    public void set(ComplexFloatType c) {
        this.setReal(c.getRealFloat());
        this.setComplex(c.getComplexFloat());
    }

    public ComplexFloatType[] createArray1D(int size1) {
        return new ComplexFloatType[size1];
    }

    public ComplexFloatType[][] createArray2D(int size1, int size2) {
        return new ComplexFloatType[size1][size2];
    }

    public ComplexFloatType[][][] createArray3D(int size1, int size2, int size3) {
        return new ComplexFloatType[size1][size2][size3];
    }

    @Override
    public ComplexFloatType createVariable() {
        return new ComplexFloatType(0.0f, 0.0f);
    }

    @Override
    public ComplexFloatType copy() {
        return new ComplexFloatType(this.getRealFloat(), this.getComplexFloat());
    }
}

