/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.LongAccess;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;
import mpicbg.imglib.util.Util;

public final class LongType
extends IntegerTypeImpl<LongType> {
    final DirectAccessContainer<LongType, ? extends LongAccess> storage;
    LongAccess b;

    public LongType(DirectAccessContainer<LongType, ? extends LongAccess> longStorage) {
        this.storage = longStorage;
    }

    public LongType(long value) {
        this.storage = null;
        this.b = new LongArray(1);
        this.set(value);
    }

    public LongType() {
        this(0L);
    }

    @Override
    public DirectAccessContainer<LongType, ? extends LongAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<LongType, LongAccess> container = storageFactory.createLongInstance(dim, 1);
        LongType linkedType = new LongType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public LongType duplicateTypeOnSameDirectAccessContainer() {
        return new LongType(this.storage);
    }

    public long get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(long f) {
        this.b.setValue(this.i, f);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public double getMaxValue() {
        return 9.223372036854776E18;
    }

    @Override
    public double getMinValue() {
        return -9.223372036854776E18;
    }

    @Override
    public void mul(float c) {
        this.set(Util.round((float)this.get() * c));
    }

    @Override
    public void mul(double c) {
        this.set(Util.round((double)this.get() * c));
    }

    @Override
    public void add(LongType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(LongType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(LongType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(LongType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public int compareTo(LongType c) {
        long b;
        long a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(LongType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        long a = this.get();
        this.set(++a);
    }

    @Override
    public void dec() {
        long a = this.get();
        this.set(--a);
    }

    public LongType[] createArray1D(int size1) {
        return new LongType[size1];
    }

    public LongType[][] createArray2D(int size1, int size2) {
        return new LongType[size1][size2];
    }

    public LongType[][][] createArray3D(int size1, int size2, int size3) {
        return new LongType[size1][size2][size3];
    }

    @Override
    public LongType createVariable() {
        return new LongType(0L);
    }

    @Override
    public LongType copy() {
        return new LongType(this.get());
    }
}

