/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;

public class Unsigned12BitType
extends IntegerTypeImpl<Unsigned12BitType> {
    final DirectAccessContainer<Unsigned12BitType, ? extends BitAccess> storage;
    int j1;
    int j2;
    int j3;
    int j4;
    int j5;
    int j6;
    int j7;
    int j8;
    int j9;
    int j10;
    int j11;
    int j12;
    BitAccess b;

    public Unsigned12BitType(DirectAccessContainer<Unsigned12BitType, ? extends BitAccess> bitStorage) {
        this.storage = bitStorage;
        this.updateIndex(0);
    }

    public Unsigned12BitType(short value) {
        this.storage = null;
        this.updateIndex(0);
        this.b = new BitArray(12);
        this.set(value);
    }

    public Unsigned12BitType() {
        this(0);
    }

    @Override
    public DirectAccessContainer<Unsigned12BitType, ? extends BitAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<Unsigned12BitType, BitAccess> container = storageFactory.createBitInstance(dim, 12);
        Unsigned12BitType linkedType = new Unsigned12BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public Unsigned12BitType duplicateTypeOnSameDirectAccessContainer() {
        return new Unsigned12BitType(this.storage);
    }

    public short get() {
        short value = 0;
        if (this.b.getValue(this.j1)) {
            value = (short)(value + 1);
        }
        if (this.b.getValue(this.j2)) {
            value = (short)(value + 2);
        }
        if (this.b.getValue(this.j3)) {
            value = (short)(value + 4);
        }
        if (this.b.getValue(this.j4)) {
            value = (short)(value + 8);
        }
        if (this.b.getValue(this.j5)) {
            value = (short)(value + 16);
        }
        if (this.b.getValue(this.j6)) {
            value = (short)(value + 32);
        }
        if (this.b.getValue(this.j7)) {
            value = (short)(value + 64);
        }
        if (this.b.getValue(this.j8)) {
            value = (short)(value + 128);
        }
        if (this.b.getValue(this.j9)) {
            value = (short)(value + 256);
        }
        if (this.b.getValue(this.j10)) {
            value = (short)(value + 512);
        }
        if (this.b.getValue(this.j11)) {
            value = (short)(value + 1024);
        }
        if (this.b.getValue(this.j12)) {
            value = (short)(value + 2048);
        }
        return value;
    }

    @Override
    public void set(short value) {
        this.b.setValue(this.j1, (value & 1) == 1);
        this.b.setValue(this.j2, (value & 2) == 2);
        this.b.setValue(this.j3, (value & 4) == 4);
        this.b.setValue(this.j4, (value & 8) == 8);
        this.b.setValue(this.j5, (value & 0x10) == 16);
        this.b.setValue(this.j6, (value & 0x20) == 32);
        this.b.setValue(this.j7, (value & 0x40) == 64);
        this.b.setValue(this.j8, (value & 0x80) == 128);
        this.b.setValue(this.j9, (value & 0x100) == 256);
        this.b.setValue(this.j10, (value & 0x200) == 512);
        this.b.setValue(this.j11, (value & 0x400) == 1024);
        this.b.setValue(this.j12, (value & 0x800) == 2048);
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set((short)f);
    }

    @Override
    public void setInteger(long f) {
        this.set((short)f);
    }

    @Override
    public double getMaxValue() {
        return 4095.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void updateIndex(int i) {
        this.i = i;
        this.j1 = i * 12;
        this.j2 = this.j1 + 1;
        this.j3 = this.j1 + 2;
        this.j4 = this.j1 + 3;
        this.j5 = this.j1 + 4;
        this.j6 = this.j1 + 5;
        this.j7 = this.j1 + 6;
        this.j8 = this.j1 + 7;
        this.j9 = this.j1 + 8;
        this.j10 = this.j1 + 9;
        this.j11 = this.j1 + 10;
        this.j12 = this.j1 + 11;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.j1 += 12;
        this.j2 += 12;
        this.j3 += 12;
        this.j4 += 12;
        this.j5 += 12;
        this.j6 += 12;
        this.j7 += 12;
        this.j8 += 12;
        this.j9 += 12;
        this.j10 += 12;
        this.j11 += 12;
        this.j12 += 12;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc12 = 12 * increment;
        this.j1 += inc12;
        this.j2 += inc12;
        this.j3 += inc12;
        this.j4 += inc12;
        this.j5 += inc12;
        this.j6 += inc12;
        this.j7 += inc12;
        this.j8 += inc12;
        this.j9 += inc12;
        this.j10 += inc12;
        this.j11 += inc12;
        this.j12 += inc12;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.j1 -= 12;
        this.j2 -= 12;
        this.j3 -= 12;
        this.j4 -= 12;
        this.j5 -= 12;
        this.j6 -= 12;
        this.j7 -= 12;
        this.j8 -= 12;
        this.j9 -= 12;
        this.j10 -= 12;
        this.j11 -= 12;
        this.j12 -= 12;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec12 = 12 * decrement;
        this.j1 -= dec12;
        this.j2 -= dec12;
        this.j3 -= dec12;
        this.j4 -= dec12;
        this.j5 -= dec12;
        this.j6 -= dec12;
        this.j7 -= dec12;
        this.j8 -= dec12;
        this.j9 -= dec12;
        this.j10 -= dec12;
        this.j11 -= dec12;
        this.j12 -= dec12;
    }

    public Unsigned12BitType[] createArray1D(int size1) {
        return new Unsigned12BitType[size1];
    }

    public Unsigned12BitType[][] createArray2D(int size1, int size2) {
        return new Unsigned12BitType[size1][size2];
    }

    public Unsigned12BitType[][][] createArray3D(int size1, int size2, int size3) {
        return new Unsigned12BitType[size1][size2][size3];
    }

    @Override
    public Unsigned12BitType createVariable() {
        return new Unsigned12BitType();
    }

    @Override
    public Unsigned12BitType copy() {
        return new Unsigned12BitType(this.get());
    }
}

