/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.fft.Bandpass;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class BandpassFilter<T extends RealType<T>>
extends Image<T> {
    public BandpassFilter(Image<T> img, int beginRadius, int endRadius) throws Exception {
        super(BandpassFilter.process(img, beginRadius, endRadius).getContainer(), img.createType(), "Bandpass");
    }

    public BandpassFilter(IFunction fn, int beginRadius, int endRadius) throws Exception {
        this(Compute.inDoubles(fn), beginRadius, endRadius);
    }

    private static final <T extends RealType<T>> Image<T> process(Image<T> img, int beginRadius, int endRadius) throws Exception {
        Bandpass<T> bp = new Bandpass<T>(img, beginRadius, endRadius);
        if (!bp.checkInput() || !bp.process()) {
            throw new Exception(bp.getClass().getSimpleName() + " failed: " + bp.getErrorMessage());
        }
        return bp.getResult();
    }
}

