/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;

public class WeakRefLoaderCache<K, V>
implements LoaderCache<K, V> {
    final ConcurrentHashMap<K, Entry> map = new ConcurrentHashMap();
    final ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public V getIfPresent(K key) {
        this.cleanUp();
        Entry entry = this.map.get(key);
        return entry == null ? null : (V)entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, CacheLoader<? super K, ? extends V> loader) throws ExecutionException {
        this.cleanUp();
        Entry entry = this.map.computeIfAbsent(key, k -> new Entry(k));
        Object value = entry.getValue();
        if (value == null) {
            Entry entry2 = entry;
            synchronized (entry2) {
                if (entry.loaded) {
                    value = entry.getValue();
                    if (value == null) {
                        entry.remove();
                        value = this.get(key, loader);
                    }
                } else {
                    try {
                        value = loader.get(key);
                        entry.setValue(value);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ExecutionException(e);
                    }
                    catch (Exception e) {
                        throw new ExecutionException(e);
                    }
                }
            }
        }
        return value;
    }

    @Override
    public void persist(K key) {
    }

    @Override
    public void persistIf(Predicate<K> condition) {
    }

    @Override
    public void persistAll() {
    }

    @Override
    public void invalidate(K key) {
        Entry entry = this.map.remove(key);
        if (entry != null) {
            CacheWeakReference ref = entry.ref;
            if (ref != null) {
                ref.clear();
            }
            entry.ref = null;
        }
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.map.forEachValue(parallelismThreshold, entry -> {
            if (condition.test(entry.key)) {
                entry.remove();
                CacheWeakReference ref = ((Entry)entry).ref;
                if (ref != null) {
                    ref.clear();
                }
                ((Entry)entry).ref = null;
            }
        });
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.map.forEachValue(parallelismThreshold, entry -> {
            entry.remove();
            CacheWeakReference ref = ((Entry)entry).ref;
            if (ref != null) {
                ref.clear();
            }
            ((Entry)entry).ref = null;
        });
    }

    public void cleanUp() {
        CacheWeakReference poll;
        while ((poll = (CacheWeakReference)this.queue.poll()) != null) {
            poll.entry.remove();
        }
    }

    final class Entry {
        final K key;
        private CacheWeakReference<V> ref;
        boolean loaded;

        public Entry(K key) {
            this.key = key;
            this.ref = new CacheWeakReference();
            this.loaded = false;
        }

        public V getValue() {
            return this.ref.get();
        }

        public void setValue(V value) {
            this.loaded = true;
            this.ref = new CacheWeakReference(value, WeakRefLoaderCache.this.queue, this);
        }

        public void remove() {
            WeakRefLoaderCache.this.map.remove(this.key, this);
        }
    }

    static final class CacheWeakReference<V>
    extends WeakReference<V> {
        private final Entry entry;

        public CacheWeakReference() {
            super(null);
            this.entry = null;
        }

        public CacheWeakReference(V referent, ReferenceQueue<V> remove, Entry entry) {
            super(referent, remove);
            this.entry = entry;
        }
    }
}

