/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.util;

import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.CacheRemover;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.LoaderRemoverCache;
import net.imglib2.cache.RemoverCache;
import net.imglib2.cache.UncheckedCache;
import net.imglib2.cache.util.CacheAsUncheckedCacheAdapter;
import net.imglib2.cache.util.CacheKeyAdapter;
import net.imglib2.cache.util.KeyBimap;
import net.imglib2.cache.util.LoaderCacheAsCacheAdapter;
import net.imglib2.cache.util.LoaderCacheKeyAdapter;
import net.imglib2.cache.util.LoaderRemoverCacheAsLoaderCacheAdapter;
import net.imglib2.cache.util.LoaderRemoverCacheKeyAdapter;
import net.imglib2.cache.util.RemoverCacheKeyAdapter;
import net.imglib2.cache.util.VolatileCacheAsUncheckedVolatileCacheAdapter;
import net.imglib2.cache.util.VolatileLoaderCacheAsVolatileCacheAdapter;
import net.imglib2.cache.volatiles.UncheckedVolatileCache;
import net.imglib2.cache.volatiles.VolatileCache;
import net.imglib2.cache.volatiles.VolatileCacheLoader;
import net.imglib2.cache.volatiles.VolatileLoaderCache;

public class Caches {
    public static <K, L, V> LoaderCache<K, V> mapKeys(LoaderCache<L, V> cache, KeyBimap<K, L> keymap) {
        return new LoaderCacheKeyAdapter(cache, keymap);
    }

    public static <K, L, V, D> LoaderRemoverCache<K, V, D> mapKeys(LoaderRemoverCache<L, V, D> cache, KeyBimap<K, L> keymap) {
        return new LoaderRemoverCacheKeyAdapter(cache, keymap);
    }

    public static <K, L, V> Cache<K, V> mapKeys(Cache<L, V> cache, KeyBimap<K, L> keymap) {
        return new CacheKeyAdapter(cache, keymap);
    }

    public static <K, L, V, D> RemoverCache<K, V, D> mapKeys(RemoverCache<L, V, D> cache, KeyBimap<K, L> keymap) {
        return new RemoverCacheKeyAdapter(cache, keymap);
    }

    public static <K, V> VolatileCache<K, V> withLoader(VolatileLoaderCache<K, V> cache, VolatileCacheLoader<K, V> loader) {
        return new VolatileLoaderCacheAsVolatileCacheAdapter<K, V>(cache, loader);
    }

    public static <K, V> Cache<K, V> withLoader(LoaderCache<K, V> cache, CacheLoader<K, V> loader) {
        return new LoaderCacheAsCacheAdapter<K, V>(cache, loader);
    }

    public static <K, V, D> LoaderCache<K, V> withRemover(LoaderRemoverCache<K, V, D> cache, CacheRemover<K, V, D> removalListener) {
        return new LoaderRemoverCacheAsLoaderCacheAdapter<K, V, D>(cache, removalListener);
    }

    public static <K, V> UncheckedCache<K, V> unchecked(Cache<K, V> cache) {
        return new CacheAsUncheckedCacheAdapter<K, V>(cache);
    }

    public static <K, V> UncheckedVolatileCache<K, V> unchecked(VolatileCache<K, V> cache) {
        return new VolatileCacheAsUncheckedVolatileCacheAdapter<K, V>(cache);
    }
}

