/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.ij.ExportSpimSequencePlugIn;
import bdv.ij.export.FusionResult;
import bdv.ij.export.SpimRegistrationSequence;
import bdv.ij.export.ViewSetupWrapper;
import bdv.ij.util.PluginHelper;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.MipmapInfo;
import bdv.img.hdf5.Partition;
import bdv.img.hdf5.Util;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import fiji.plugin.Bead_Registration;
import fiji.plugin.Multi_View_Fusion;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.io.TextFileAccess;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;
import spimopener.SPIMExperiment;

@Deprecated
@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Deprecated>Export Fused Sequence as XML/HDF5")
public class ExportSpimFusionPlugIn
implements Command {
    static double minValueStatic = 0.0;
    static double maxValueStatic = 65535.0;
    static boolean lastSetMipmapManual = false;
    static String lastSubsampling = "{1,1,1}, {2,2,2}, {4,4,4}";
    static String lastChunkSizes = "{32,32,32}, {16,16,16}, {8,8,8}";
    static boolean lastSplit = false;
    static int lastTimepointsPerPartition = 0;
    static int lastSetupsPerPartition = 0;
    static boolean lastDeflate = true;
    static String autoSubsampling = "{1,1,1}";
    static String autoChunkSizes = "{16,16,16}";
    public static String allChannels = "0, 1";

    public void run() {
        Parameters params;
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if ((params = this.getParameters()) == null) {
            return;
        }
        try {
            IJ.log((String)"starting export...");
            if (params.appendToExistingFile && params.seqFile.exists()) {
                ExportSpimFusionPlugIn.appendToExistingFile(params);
            } else {
                ExportSpimFusionPlugIn.saveAsNewFile(params);
            }
            IJ.showProgress((double)1.0);
            IJ.log((String)"done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void appendToExistingFile(Parameters params) throws SpimDataException, IOException {
        String basename;
        Object tp2;
        ProgressWriterIJ progress = new ProgressWriterIJ();
        XmlIoSpimDataMinimal spimDataIo = new XmlIoSpimDataMinimal();
        SpimRegistrationSequence spimseq = new SpimRegistrationSequence(params.conf);
        Map<Integer, AffineTransform3D> fusionTransforms = spimseq.getFusionTransforms(params.cropOffsetX, params.cropOffsetY, params.cropOffsetZ, params.scale);
        FusionResult fusionResult = FusionResult.create(spimseq, params.fusionDirectory, params.filenamePattern, params.numSlices, params.sliceValueMin, params.sliceValueMax, fusionTransforms);
        SequenceDescriptionMinimal fusionSeq = fusionResult.getSequenceDescription();
        ViewRegistrations fusionReg = fusionResult.getViewRegistrations();
        File existingDatasetXmlFile = params.seqFile;
        File baseDirectory = existingDatasetXmlFile.getParentFile();
        SpimDataMinimal existingSpimData = (SpimDataMinimal)spimDataIo.load(existingDatasetXmlFile.getAbsolutePath());
        SequenceDescriptionMinimal existingSequence = (SequenceDescriptionMinimal)existingSpimData.getSequenceDescription();
        ViewRegistrations existingRegistrations = existingSpimData.getViewRegistrations();
        Hdf5ImageLoader existingHdf5Loader = (Hdf5ImageLoader)existingSequence.getImgLoader();
        HashMap<Integer, Integer> timepointIdentityMap = new HashMap<Integer, Integer>();
        for (Object tp2 : existingSequence.getTimePoints().getTimePointsOrdered()) {
            timepointIdentityMap.put(tp2.getId(), tp2.getId());
        }
        HashMap<Integer, Integer> setupIdentityMap = new HashMap<Integer, Integer>();
        tp2 = existingSequence.getViewSetups().keySet().iterator();
        while (tp2.hasNext()) {
            int s = (Integer)tp2.next();
            setupIdentityMap.put(s, s);
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>(existingHdf5Loader.getPartitions());
        boolean notYetPartitioned = partitions.isEmpty();
        if (notYetPartitioned) {
            partitions.add(new Partition(existingHdf5Loader.getHdf5File().getAbsolutePath(), timepointIdentityMap, setupIdentityMap));
        }
        HashSet usedSetupIds = new HashSet(existingSequence.getViewSetups().keySet());
        HashMap<Integer, ViewSetupWrapper> fusionSetups = new HashMap<Integer, ViewSetupWrapper>();
        final HashMap<Integer, BasicSetupImgLoader> fusionSetupImgLoaders = new HashMap<Integer, BasicSetupImgLoader>();
        ArrayList<ViewRegistration> fusionRegistrations = new ArrayList<ViewRegistration>();
        for (BasicViewSetup s : fusionSeq.getViewSetupsOrdered()) {
            int fusionSetupId = 0;
            while (usedSetupIds.contains(fusionSetupId)) {
                ++fusionSetupId;
            }
            fusionSetups.put(fusionSetupId, new ViewSetupWrapper(fusionSetupId, (AbstractSequenceDescription<?, ?, ?>)fusionSeq, s));
            fusionSetupImgLoaders.put(fusionSetupId, fusionSeq.getImgLoader().getSetupImgLoader(fusionSetupId));
            usedSetupIds.add(fusionSetupId);
            int sourceSetupId = s.getId();
            for (TimePoint timepoint : fusionSeq.getTimePoints().getTimePointsOrdered()) {
                int timepointId = timepoint.getId();
                ViewRegistration r = (ViewRegistration)fusionReg.getViewRegistrations().get(new ViewId(timepointId, sourceSetupId));
                if (r == null) {
                    throw new RuntimeException("could not find ViewRegistration for timepoint " + timepointId + " in the fused sequence.");
                }
                fusionRegistrations.add(new ViewRegistration(timepointId, fusionSetupId, r.getModel()));
            }
        }
        BasicImgLoader wrappedFusionImgLoader = new BasicImgLoader(){

            public BasicSetupImgLoader<?> getSetupImgLoader(int setupId) {
                return (BasicSetupImgLoader)fusionSetupImgLoaders.get(setupId);
            }
        };
        fusionSeq = new SequenceDescriptionMinimal(fusionSeq.getTimePoints(), fusionSetups, wrappedFusionImgLoader, fusionSeq.getMissingViews());
        fusionReg = new ViewRegistrations(fusionRegistrations);
        ArrayList<Partition> newPartitions = new ArrayList<Partition>();
        String xmlFilename = params.seqFile.getAbsolutePath();
        String string = basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
        if (params.split) {
            List timepoints = fusionSeq.getTimePoints().getTimePointsOrdered();
            List setups = fusionSeq.getViewSetupsOrdered();
            for (Partition p : Partition.split((List)timepoints, (List)setups, (int)params.timepointsPerPartition, (int)params.setupsPerPartition, (String)basename)) {
                String baseFilename = p.getPath().substring(0, p.getPath().length() - 3);
                Iterator path = PluginHelper.createNewPartitionFile(baseFilename).getAbsolutePath();
                Partition partition = new Partition((String)((Object)path), p.getTimepointIdSequenceToPartition(), p.getSetupIdSequenceToPartition());
                newPartitions.add(partition);
                partitions.add(partition);
            }
        } else {
            String path = PluginHelper.createNewPartitionFile(basename).getAbsolutePath();
            HashMap<Integer, Integer> setupIdSequenceToPartition = new HashMap<Integer, Integer>();
            for (BasicViewSetup s : fusionSeq.getViewSetupsOrdered()) {
                setupIdSequenceToPartition.put(s.getId(), s.getId());
            }
            Partition partition = new Partition(path, timepointIdentityMap, setupIdSequenceToPartition);
            newPartitions.add(partition);
            partitions.add(partition);
        }
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(params.resolutions, params.subdivisions);
        for (BasicViewSetup setup : fusionSeq.getViewSetupsOrdered()) {
            perSetupExportMipmapInfo.put(setup.getId(), mipmapInfo);
        }
        File newHdf5PartitionLinkFile = notYetPartitioned ? PluginHelper.createNewPartitionFile(basename) : params.hdf5File;
        TimePoints aggregateTimePoints = fusionSeq.getTimePoints();
        HashMap<Integer, BasicViewSetup> aggregateSetups = new HashMap<Integer, BasicViewSetup>();
        for (BasicViewSetup s : existingSequence.getViewSetupsOrdered()) {
            aggregateSetups.put(s.getId(), s);
        }
        for (BasicViewSetup s : fusionSeq.getViewSetupsOrdered()) {
            aggregateSetups.put(s.getId(), s);
        }
        MissingViews aggregateMissingViews = existingSequence.getMissingViews();
        SequenceDescriptionMinimal aggregateSeq = new SequenceDescriptionMinimal(aggregateTimePoints, aggregateSetups, (BasicImgLoader)new Hdf5ImageLoader(newHdf5PartitionLinkFile, partitions, null, false), aggregateMissingViews);
        HashMap<Integer, ExportMipmapInfo> aggregateMipmapInfos = new HashMap<Integer, ExportMipmapInfo>(perSetupExportMipmapInfo);
        for (BasicViewSetup s : existingSequence.getViewSetupsOrdered()) {
            MipmapInfo info = existingHdf5Loader.getSetupImgLoader(s.getId()).getMipmapInfo();
            aggregateMipmapInfos.put(s.getId(), new ExportMipmapInfo(Util.castToInts((double[][])info.getResolutions()), info.getSubdivisions()));
        }
        ArrayList regs = new ArrayList();
        regs.addAll(existingSpimData.getViewRegistrations().getViewRegistrationsOrdered());
        regs.addAll(fusionReg.getViewRegistrationsOrdered());
        ViewRegistrations aggregateViewRegistrstions = new ViewRegistrations(regs);
        SpimDataMinimal aggregateSpimData = new SpimDataMinimal(baseDirectory, aggregateSeq, aggregateViewRegistrstions);
        double complete = 0.05;
        progress.setProgress(complete);
        double completionStep = (0.95 - complete) / (double)newPartitions.size();
        for (Partition partition : newPartitions) {
            SubTaskProgressWriter subtaskProgress = new SubTaskProgressWriter((ProgressWriter)progress, complete, complete + completionStep);
            int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
            WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)fusionSeq, perSetupExportMipmapInfo, (boolean)params.deflate, (Partition)partition, null, null, (int)numCellCreatorThreads, (ProgressWriter)subtaskProgress);
            complete += completionStep;
        }
        WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)aggregateSeq, aggregateMipmapInfos, partitions, (File)newHdf5PartitionLinkFile);
        progress.setProgress(1.0);
        spimDataIo.save((AbstractSpimData)new SpimDataMinimal(aggregateSpimData, (BasicImgLoader)new Hdf5ImageLoader(newHdf5PartitionLinkFile, partitions, null, false)), params.seqFile.getAbsolutePath());
    }

    public static void saveAsNewFile(Parameters params) throws SpimDataException {
        ArrayList partitions;
        ProgressWriterIJ progress = new ProgressWriterIJ();
        XmlIoSpimDataMinimal spimDataIo = new XmlIoSpimDataMinimal();
        SpimRegistrationSequence spimseq = new SpimRegistrationSequence(params.conf);
        Map<Integer, AffineTransform3D> fusionTransforms = spimseq.getFusionTransforms(params.cropOffsetX, params.cropOffsetY, params.cropOffsetZ, params.scale);
        FusionResult fusionResult = FusionResult.create(spimseq, params.fusionDirectory, params.filenamePattern, params.numSlices, params.sliceValueMin, params.sliceValueMax, fusionTransforms);
        SequenceDescriptionMinimal desc = fusionResult.getSequenceDescription();
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(params.resolutions, params.subdivisions);
        for (BasicViewSetup setup : desc.getViewSetupsOrdered()) {
            perSetupExportMipmapInfo.put(setup.getId(), mipmapInfo);
        }
        if (params.split) {
            String xmlFilename = params.seqFile.getAbsolutePath();
            String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
            List timepoints = desc.getTimePoints().getTimePointsOrdered();
            List setups = desc.getViewSetupsOrdered();
            partitions = Partition.split((List)timepoints, (List)setups, (int)params.timepointsPerPartition, (int)params.setupsPerPartition, (String)basename);
        } else {
            partitions = null;
        }
        int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
        if (params.split) {
            for (int i = 0; i < partitions.size(); ++i) {
                Partition partition = (Partition)partitions.get(i);
                SubTaskProgressWriter p = new SubTaskProgressWriter((ProgressWriter)progress, 0.0, 0.95 * (double)i / (double)partitions.size());
                WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)desc, perSetupExportMipmapInfo, (boolean)params.deflate, (Partition)partition, null, null, (int)numCellCreatorThreads, (ProgressWriter)p);
            }
            WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)desc, perSetupExportMipmapInfo, (ArrayList)partitions, (File)params.hdf5File);
        } else {
            WriteSequenceToHdf5.writeHdf5File((AbstractSequenceDescription)desc, perSetupExportMipmapInfo, (boolean)params.deflate, (File)params.hdf5File, null, null, (int)numCellCreatorThreads, (ProgressWriter)new SubTaskProgressWriter((ProgressWriter)progress, 0.0, 0.95));
        }
        Hdf5ImageLoader loader = new Hdf5ImageLoader(params.hdf5File, partitions, null, false);
        SequenceDescriptionMinimal sequenceDescription = new SequenceDescriptionMinimal(desc, (BasicImgLoader)loader);
        File basePath = params.seqFile.getParentFile();
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, sequenceDescription, fusionResult.getViewRegistrations());
        try {
            spimDataIo.save((AbstractSpimData)spimData, params.seqFile.getAbsolutePath());
            progress.setProgress(1.0);
        }
        catch (Exception e) {
            progress.err().println("Failed to write xml file " + params.seqFile);
            e.printStackTrace(progress.err());
        }
    }

    protected Parameters getParameters() {
        File seqFile;
        File parent;
        int c;
        int c2;
        int c3;
        ArrayList channels;
        TextField tfChannels;
        int channelChoice;
        GenericDialogPlus gd0 = new GenericDialogPlus("Export for BigDataViewer");
        gd0.addChoice("Select_channel type", ExportSpimSequencePlugIn.fusionType, ExportSpimSequencePlugIn.fusionType[Multi_View_Fusion.defaultFusionType]);
        gd0.showDialog();
        if (gd0.wasCanceled()) {
            return null;
        }
        Multi_View_Fusion.defaultFusionType = channelChoice = gd0.getNextChoiceIndex();
        final boolean multichannel = channelChoice == 1;
        GenericDialogPlus gd = new GenericDialogPlus("Export for BigDataViewer");
        gd.addDirectoryOrFileField("SPIM_data_directory", Bead_Registration.spimDataDirectory);
        final TextField tfSpimDataDirectory = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Pattern_of_SPIM files", Bead_Registration.fileNamePattern, 25);
        final TextField tfFilePattern = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Timepoints_to_process", Bead_Registration.timepoints);
        final TextField tfTimepoints = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Angles to process", Bead_Registration.angles);
        final TextField tfAngles = (TextField)gd.getStringFields().lastElement();
        if (multichannel) {
            gd.addStringField("Channels to process", allChannels);
            tfChannels = (TextField)gd.getStringFields().lastElement();
        } else {
            tfChannels = null;
        }
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                if (e instanceof TextEvent && e.getID() == 900 && e.getSource() == tfSpimDataDirectory) {
                    TextField tf = (TextField)e.getSource();
                    String spimDataDirectory = tf.getText();
                    File f = new File(spimDataDirectory);
                    if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
                        SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                        tfFilePattern.setEnabled(false);
                        String expTimepoints = "";
                        expTimepoints = exp.timepointStart == exp.timepointEnd ? "" + exp.timepointStart : "" + exp.timepointStart + "-" + exp.timepointEnd;
                        tfTimepoints.setText(expTimepoints);
                        String expAngles = "";
                        for (String angle : exp.angles) {
                            int a = Integer.parseInt(angle.substring(1, angle.length()));
                            if (!expAngles.equals("")) {
                                expAngles = expAngles + ",";
                            }
                            expAngles = expAngles + a;
                        }
                        tfAngles.setText(expAngles);
                        if (multichannel) {
                            String expChannels = "";
                            for (String channel : exp.channels) {
                                int c = Integer.parseInt(channel.substring(1, channel.length()));
                                if (!expChannels.equals("")) {
                                    expChannels = expChannels + ",";
                                }
                                expChannels = expChannels + c;
                            }
                            tfChannels.setText(expChannels);
                        }
                    } else {
                        tfFilePattern.setEnabled(true);
                    }
                }
                return true;
            }
        });
        File f = new File(tfSpimDataDirectory.getText());
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            tfFilePattern.setEnabled(false);
            if (multichannel) {
                SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                String expChannels = "";
                for (String channel : exp.channels) {
                    int c4 = Integer.parseInt(channel.substring(1, channel.length()));
                    if (!expChannels.equals("")) {
                        expChannels = expChannels + ",";
                    }
                    expChannels = expChannels + c4;
                }
                tfChannels.setText(expChannels);
            }
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        Bead_Registration.spimDataDirectory = gd.getNextString();
        Bead_Registration.fileNamePattern = gd.getNextString();
        Bead_Registration.timepoints = gd.getNextString();
        Bead_Registration.angles = gd.getNextString();
        int numChannels = 0;
        if (multichannel) {
            allChannels = gd.getNextString();
            try {
                channels = SPIMConfiguration.parseIntegerString((String)allChannels);
                numChannels = channels.size();
            }
            catch (ConfigurationParserException e) {
                IOFunctions.printErr((String)("Cannot understand/parse the channels: " + allChannels));
                return null;
            }
            if (numChannels < 1) {
                IOFunctions.printErr((String)("There are no channels given: " + allChannels));
                return null;
            }
        } else {
            numChannels = 1;
            channels = new ArrayList();
            channels.add(0);
        }
        final SPIMConfiguration conf = new SPIMConfiguration();
        conf.timepointPattern = Bead_Registration.timepoints;
        conf.anglePattern = Bead_Registration.angles;
        if (multichannel) {
            conf.channelPattern = allChannels;
            conf.channelsToRegister = allChannels;
            conf.channelsToFuse = allChannels;
        } else {
            conf.channelPattern = "";
            conf.channelsToRegister = "";
            conf.channelsToFuse = "";
        }
        conf.inputFilePattern = Bead_Registration.fileNamePattern;
        f = new File(Bead_Registration.spimDataDirectory);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            conf.spimExperiment = new SPIMExperiment(f.getAbsolutePath());
            conf.inputdirectory = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 4);
            System.out.println("inputdirectory : " + conf.inputdirectory);
        } else {
            conf.inputdirectory = Bead_Registration.spimDataDirectory;
        }
        conf.fuseOnly = true;
        if (!ExportSpimSequencePlugIn.init(conf)) {
            return null;
        }
        ArrayList timepoints = new ArrayList();
        int numChoices = 0;
        conf.zStretching = -1.0;
        for (c3 = 0; c3 < channels.size(); ++c3) {
            String[] entries;
            timepoints.add(new ArrayList());
            final String name = conf.file[0][c3][0][0].getName();
            File regDir = new File(conf.registrationFiledirectory);
            IOFunctions.println((String)("name: " + name));
            IOFunctions.println((String)("dir: " + regDir.getAbsolutePath()));
            if (!regDir.isDirectory()) {
                IOFunctions.println((String)(conf.registrationFiledirectory + " is not a directory. "));
                return null;
            }
            for (String e : entries = regDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File directory, String filename) {
                    return filename.contains(name) && filename.contains(".registration");
                }
            })) {
                IOFunctions.println((String)e);
            }
            for (String s : entries) {
                if (s.endsWith(".registration")) {
                    if (!((ArrayList)timepoints.get(c3)).contains(-1)) {
                        ((ArrayList)timepoints.get(c3)).add(-1);
                        ++numChoices;
                    }
                } else {
                    int timepoint = Integer.parseInt(s.substring(s.indexOf(".registration.to_") + 17, s.length()));
                    if (!((ArrayList)timepoints.get(c3)).contains(timepoint)) {
                        ((ArrayList)timepoints.get(c3)).add(timepoint);
                        ++numChoices;
                    }
                }
                if (!(conf.zStretching < 0.0)) continue;
                conf.zStretching = ExportSpimFusionPlugIn.loadZStretching(conf.registrationFiledirectory + s);
                conf.overrideImageZStretching = true;
                IOFunctions.println((String)("Z-stretching = " + conf.zStretching));
            }
        }
        if (numChoices == 0) {
            IOFunctions.println((String)"No registration files available.");
            return null;
        }
        for (c3 = 0; c3 < channels.size(); ++c3) {
            Iterator name = ((ArrayList)timepoints.get(c3)).iterator();
            while (name.hasNext()) {
                int i = (Integer)name.next();
                IOFunctions.println((String)(c3 + ": " + i));
            }
        }
        GenericDialogPlus gd2 = new GenericDialogPlus("Export for BigDataViewer");
        String[] choices = new String[numChoices];
        int[] suggest = new int[channels.size()];
        int firstSuggestion = -1;
        int index = 0;
        for (c2 = 0; c2 < channels.size(); ++c2) {
            ArrayList tps = (ArrayList)timepoints.get(c2);
            suggest[c2] = -1;
            for (int i = 0; i < tps.size(); ++i) {
                choices[index] = (Integer)tps.get(i) == -1 ? "Individual registration of channel " + channels.get(c2) : "Time-point registration (reference=" + tps.get(i) + ") of channel " + channels.get(c2);
                if (suggest[c2] < 1) {
                    suggest[c2] = index;
                    if (firstSuggestion < 1) {
                        firstSuggestion = index;
                    }
                }
                ++index;
            }
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            if (suggest[c2] != -1) continue;
            suggest[c2] = firstSuggestion;
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            gd2.addChoice("Registration for channel " + channels.get(c2), choices, choices[suggest[c2]]);
        }
        gd2.addMessage("");
        gd2.addDirectoryField("Fusion Output Directory", conf.outputdirectory, 25);
        final TextField tfDirectory = (TextField)gd2.getStringFields().lastElement();
        gd2.addMessage("");
        gd2.addMessage("Enter the crop values you used to create the fused data:");
        gd2.addNumericField("Downsample_output image n-times", (double)Multi_View_Fusion.outputImageScalingStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_x", (double)Multi_View_Fusion.cropOffsetXStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_y", (double)Multi_View_Fusion.cropOffsetYStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_z", (double)Multi_View_Fusion.cropOffsetZStatic, 0);
        gd2.addMessage("");
        gd2.addNumericField("min brightness value", minValueStatic, 0);
        gd2.addNumericField("max brightness value", maxValueStatic, 0);
        gd2.addMessage("");
        gd2.addCheckbox("manual mipmap setup", lastSetMipmapManual);
        final Checkbox cManualMipmap = (Checkbox)gd2.getCheckboxes().lastElement();
        gd2.addStringField("Subsampling factors", lastSubsampling, 25);
        final TextField tfSubsampling = (TextField)gd2.getStringFields().lastElement();
        gd2.addStringField("Hdf5 chunk sizes", lastChunkSizes, 25);
        final TextField tfChunkSizes = (TextField)gd2.getStringFields().lastElement();
        gd2.addMessage("");
        gd2.addCheckbox("split hdf5", lastSplit);
        final Checkbox cSplit = (Checkbox)gd2.getCheckboxes().lastElement();
        gd2.addNumericField("timepoints per partition", (double)lastTimepointsPerPartition, 0, 25, "");
        final TextField tfSplitTimepoints = (TextField)gd2.getNumericFields().lastElement();
        gd2.addNumericField("setups per partition", (double)lastSetupsPerPartition, 0, 25, "");
        final TextField tfSplitSetups = (TextField)gd2.getNumericFields().lastElement();
        gd2.addMessage("");
        gd2.addCheckbox("use deflate compression", lastDeflate);
        gd2.addMessage("");
        PluginHelper.addSaveAsFileField(gd2, "Export path", conf.inputdirectory + "export.xml", 25);
        gd2.addCheckbox("add to existing file", true);
        tfDirectory.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent t) {
                String fusionDirectory;
                if (t.getID() == 900 && ExportSpimFusionPlugIn.this.updateProposedMipmaps(fusionDirectory = tfDirectory.getText(), conf)) {
                    boolean useManual = cManualMipmap.getState();
                    tfSubsampling.setEnabled(useManual);
                    tfChunkSizes.setEnabled(useManual);
                    if (!useManual) {
                        tfSubsampling.setText(autoSubsampling);
                        tfChunkSizes.setText(autoChunkSizes);
                    }
                }
            }
        });
        cManualMipmap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean useManual = cManualMipmap.getState();
                tfSubsampling.setEnabled(useManual);
                tfChunkSizes.setEnabled(useManual);
                if (!useManual) {
                    tfSubsampling.setText(autoSubsampling);
                    tfChunkSizes.setText(autoChunkSizes);
                }
            }
        });
        this.updateProposedMipmaps(tfDirectory.getText(), conf);
        tfSubsampling.setEnabled(lastSetMipmapManual);
        tfChunkSizes.setEnabled(lastSetMipmapManual);
        if (!lastSetMipmapManual) {
            tfSubsampling.setText(autoSubsampling);
            tfChunkSizes.setText(autoChunkSizes);
        }
        cSplit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                boolean split = cSplit.getState();
                tfSplitTimepoints.setEnabled(split);
                tfSplitSetups.setEnabled(split);
            }
        });
        tfSplitTimepoints.setEnabled(lastSplit);
        tfSplitSetups.setEnabled(lastSplit);
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return null;
        }
        int[][] registrationAssignment = new int[channels.size()][2];
        for (int c5 = 0; c5 < channels.size(); ++c5) {
            int choice = gd2.getNextChoiceIndex();
            index = 0;
            for (int c22 = 0; c22 < channels.size(); ++c22) {
                ArrayList tps = (ArrayList)timepoints.get(c22);
                for (int i = 0; i < tps.size(); ++i) {
                    if (index == choice) {
                        registrationAssignment[c5][0] = (Integer)tps.get(i);
                        registrationAssignment[c5][1] = c22;
                    }
                    ++index;
                }
            }
        }
        int tp = registrationAssignment[0][0];
        for (c = 1; c < channels.size(); ++c) {
            if (tp == registrationAssignment[c][0]) continue;
            IOFunctions.println((String)"Inconsistent choice of reference timeseries, only same reference timepoints or individual registration are allowed.");
            return null;
        }
        conf.registrationAssignmentForFusion = new int[channels.size()];
        for (c = 0; c < channels.size(); ++c) {
            IOFunctions.println((String)("channel " + c + " takes it from channel " + registrationAssignment[c][1]));
            conf.registrationAssignmentForFusion[c] = registrationAssignment[c][1];
        }
        conf.timeLapseRegistration = tp >= 0;
        conf.referenceTimePoint = tp;
        IOFunctions.println((String)("tp " + tp));
        String fusionDirectory = gd2.getNextString();
        Pair<String, Integer> pair = ExportSpimFusionPlugIn.detectPatternAndNumSlices(new File(fusionDirectory), conf.timepoints[0]);
        if (pair == null) {
            IOFunctions.println((String)"Couldn't detect filename pattern");
            return null;
        }
        String filenamePattern = (String)pair.getA();
        int numSlices = (Integer)pair.getB();
        Multi_View_Fusion.outputImageScalingStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropOffsetXStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropOffsetYStatic = (int)Math.round(gd2.getNextNumber());
        Multi_View_Fusion.cropOffsetZStatic = (int)Math.round(gd2.getNextNumber());
        minValueStatic = gd2.getNextNumber();
        maxValueStatic = gd2.getNextNumber();
        lastSetMipmapManual = gd2.getNextBoolean();
        lastSubsampling = gd2.getNextString();
        lastChunkSizes = gd2.getNextString();
        int[][] resolutions = PluginHelper.parseResolutionsString(lastSubsampling);
        int[][] subdivisions = PluginHelper.parseResolutionsString(lastChunkSizes);
        if (resolutions.length == 0) {
            IOFunctions.println((String)("Cannot parse subsampling factors " + lastSubsampling));
            return null;
        }
        if (subdivisions.length == 0) {
            IOFunctions.println((String)("Cannot parse hdf5 chunk sizes " + lastChunkSizes));
            return null;
        }
        if (resolutions.length != subdivisions.length) {
            IOFunctions.println((String)"subsampling factors and hdf5 chunk sizes must have the same number of elements");
            return null;
        }
        lastSplit = gd2.getNextBoolean();
        lastTimepointsPerPartition = (int)gd2.getNextNumber();
        lastSetupsPerPartition = (int)gd2.getNextNumber();
        lastDeflate = gd2.getNextBoolean();
        String seqFilename = gd2.getNextString();
        if (!seqFilename.endsWith(".xml")) {
            seqFilename = seqFilename + ".xml";
        }
        if ((parent = (seqFile = new File(seqFilename)).getParentFile()) == null || !parent.exists() || !parent.isDirectory()) {
            IOFunctions.println((String)("Invalid export filename " + seqFilename));
            return null;
        }
        String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
        File hdf5File = new File(hdf5Filename);
        boolean appendToExistingFile = gd2.getNextBoolean();
        int cropOffsetX = Multi_View_Fusion.cropOffsetXStatic;
        int cropOffsetY = Multi_View_Fusion.cropOffsetYStatic;
        int cropOffsetZ = Multi_View_Fusion.cropOffsetZStatic;
        int scale = Multi_View_Fusion.outputImageScalingStatic;
        return new Parameters(conf, resolutions, subdivisions, cropOffsetX, cropOffsetY, cropOffsetZ, scale, fusionDirectory, filenamePattern, numSlices, minValueStatic, maxValueStatic, seqFile, hdf5File, appendToExistingFile, lastDeflate, lastSplit, lastTimepointsPerPartition, lastSetupsPerPartition);
    }

    protected boolean updateProposedMipmaps(String fusionDirectory, SPIMConfiguration conf) {
        Pair<String, Integer> pair = ExportSpimFusionPlugIn.detectPatternAndNumSlices(new File(fusionDirectory), conf.timepoints[0]);
        if (pair != null) {
            String filenamePattern = (String)pair.getA();
            int numSlices = (Integer)pair.getB();
            String fn = fusionDirectory + "/" + String.format(filenamePattern, conf.timepoints[0], conf.channels[0], 0);
            ImagePlus imp = new ImagePlus(fn);
            int width = imp.getWidth();
            int height = imp.getHeight();
            imp.close();
            FinalDimensions size = new FinalDimensions(new int[]{width, height, numSlices});
            FinalVoxelDimensions voxelSize = new FinalVoxelDimensions("px", new double[]{1.0, 1.0, 1.0});
            ExportMipmapInfo info = ProposeMipmaps.proposeMipmaps((BasicViewSetup)new BasicViewSetup(0, "", (Dimensions)size, (VoxelDimensions)voxelSize));
            autoSubsampling = ProposeMipmaps.getArrayString((int[][])info.getExportResolutions());
            autoChunkSizes = ProposeMipmaps.getArrayString((int[][])info.getSubdivisions());
            return true;
        }
        return false;
    }

    public static Pair<String, Integer> detectPatternAndNumSlices(File dir, int someTimepoint) {
        File subdir = new File(dir.getAbsolutePath() + "/" + someTimepoint);
        if (subdir.isDirectory()) {
            Pair<String, Integer> pair = ExportSpimFusionPlugIn.detectPatternAndNumSlices(subdir, someTimepoint);
            if (pair == null) {
                return null;
            }
            return new ValuePair((Object)("%1$d/" + (String)pair.getA()), pair.getB());
        }
        String zeros = "";
        for (int digits = 1; digits < 5; ++digits) {
            int tStart;
            String suffixDeconvolution;
            zeros = zeros + "0";
            final String suffixFusion = "_" + zeros + ".tif";
            File[] files = dir.listFiles(new FilenameFilter(suffixDeconvolution = "_z" + zeros + ".tif"){
                final /* synthetic */ String val$suffixDeconvolution;
                {
                    this.val$suffixDeconvolution = string2;
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(suffixFusion) || name.endsWith(this.val$suffixDeconvolution);
                }
            });
            if (files == null || files.length <= 0) continue;
            String name = files[0].getName();
            if (name.substring(tStart = name.indexOf("_t") + 2, tStart + 1).equals("l")) {
                ++tStart;
            }
            int tEnd = name.indexOf("_", tStart);
            int cStart = name.indexOf("_ch", tEnd) + 3;
            int cEnd = name.indexOf("_", cStart);
            String pattern = name.substring(0, tStart) + "%1$d" + name.substring(tEnd, cStart) + "%2$d" + name.substring(cEnd, name.length() - 4 - digits) + "%3$0" + digits + "d.tif";
            IOFunctions.println((String)("detected pattern = " + pattern));
            final String prefix = name.substring(0, name.length() - 4 - digits);
            File[] files2 = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
            int numSlices = files2.length;
            IOFunctions.println((String)("detected numSlices = " + numSlices));
            return new ValuePair((Object)pattern, (Object)new Integer(numSlices));
        }
        return null;
    }

    protected static double loadZStretching(String file) {
        BufferedReader in = TextFileAccess.openFileRead((String)file);
        double z = -1.0;
        try {
            while (in.ready()) {
                String line = in.readLine();
                if (!line.contains("z-scaling:")) continue;
                z = Double.parseDouble(line.substring(line.indexOf("ing") + 4, line.length()).trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return z;
    }

    public static void main(String[] args) {
        new ExportSpimFusionPlugIn().run();
    }

    public static class Parameters {
        final SPIMConfiguration conf;
        final int[][] resolutions;
        final int[][] subdivisions;
        final int cropOffsetX;
        final int cropOffsetY;
        final int cropOffsetZ;
        final int scale;
        final String fusionDirectory;
        final String filenamePattern;
        final int numSlices;
        final double sliceValueMin;
        final double sliceValueMax;
        final File seqFile;
        final File hdf5File;
        final boolean appendToExistingFile;
        final boolean deflate;
        final boolean split;
        final int timepointsPerPartition;
        final int setupsPerPartition;

        public Parameters(SPIMConfiguration conf, int[][] resolutions, int[][] subdivisions, int cropOffsetX, int cropOffsetY, int cropOffsetZ, int scale, String fusionDirectory, String filenamePattern, int numSlices, double sliceValueMin, double sliceValueMax, File seqFile, File hdf5File, boolean appendToExistingFile, boolean deflate, boolean split, int timepointsPerPartition, int setupsPerPartition) {
            this.conf = conf;
            this.resolutions = resolutions;
            this.subdivisions = subdivisions;
            this.cropOffsetX = cropOffsetX;
            this.cropOffsetY = cropOffsetY;
            this.cropOffsetZ = cropOffsetZ;
            this.scale = scale;
            this.fusionDirectory = fusionDirectory;
            this.filenamePattern = filenamePattern;
            this.numSlices = numSlices;
            this.sliceValueMin = sliceValueMin;
            this.sliceValueMax = sliceValueMax;
            this.seqFile = seqFile;
            this.hdf5File = hdf5File;
            this.appendToExistingFile = appendToExistingFile;
            this.deflate = deflate;
            this.split = split;
            this.timepointsPerPartition = timepointsPerPartition;
            this.setupsPerPartition = setupsPerPartition;
        }
    }
}

