/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export.tiles;

import bdv.ij.export.tiles.CellVoyagerDataExporter;
import ij.ImagePlus;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mpicbg.spim.data.legacy.LegacyBasicImgLoader;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class LegacyTileImgLoader
implements LegacyBasicImgLoader<UnsignedShortType> {
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"bts", (String)"http://www.yokogawa.co.jp/BTS/BTSSchema/1.0");
    private final File imageIndexFile;
    private Document document;
    private final List<CellVoyagerDataExporter.ChannelInfo> channelInfos;

    public LegacyTileImgLoader(File imageIndexFile, List<CellVoyagerDataExporter.ChannelInfo> channelInfos) {
        if (!imageIndexFile.exists()) {
            throw new IllegalArgumentException("The target file " + imageIndexFile + " does not exist.");
        }
        if (!imageIndexFile.isFile()) {
            throw new IllegalArgumentException("The target file " + imageIndexFile + " is not a file.");
        }
        this.imageIndexFile = imageIndexFile;
        this.channelInfos = channelInfos;
        SAXBuilder builder = new SAXBuilder();
        try {
            this.document = builder.build(imageIndexFile);
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException("The target file " + imageIndexFile + " is malformed:\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Trouble reading " + imageIndexFile + ":\n" + e.getMessage());
        }
        if (!this.document.getRootElement().getName().equals("ImageIndex")) {
            throw new IllegalArgumentException("The target file " + imageIndexFile + " is not a CellVoyager Image Index file.");
        }
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        int setupIndex = view.getViewSetupId();
        int viewTimePoint = view.getTimePointId() + 1;
        CellVoyagerDataExporter.ChannelInfo channelInfo = this.channelInfos.get(setupIndex);
        int viewChannel = channelInfo.channelNumber;
        TreeMap<Double, HashMap<Integer, String>> filenames = new TreeMap<Double, HashMap<Integer, String>>();
        Element root = this.document.getRootElement();
        for (Element element : root.getChildren("MeasurementRecord", NAMESPACE)) {
            boolean isMIP;
            int channel;
            double z;
            int timepoint;
            int field;
            try {
                field = element.getAttribute("FieldIndex", NAMESPACE).getIntValue();
                timepoint = element.getAttribute("TimePoint", NAMESPACE).getIntValue();
                z = element.getAttribute("Z", NAMESPACE).getDoubleValue();
                channel = element.getAttribute("Ch", NAMESPACE).getIntValue();
                isMIP = element.getAttribute("Mip", NAMESPACE).getBooleanValue();
            }
            catch (DataConversionException e) {
                System.err.println("Incorrect attribute formatting for " + element);
                continue;
            }
            if (isMIP || timepoint != viewTimePoint || channel != viewChannel) continue;
            String filename = element.getText();
            Double dz = z;
            HashMap<Integer, String> tilesAtZ = (HashMap<Integer, String>)filenames.get(dz);
            if (null == tilesAtZ) {
                tilesAtZ = new HashMap<Integer, String>();
                filenames.put(dz, tilesAtZ);
            }
            tilesAtZ.put(field, filename);
        }
        long[] dimensions = new long[]{channelInfo.width, channelInfo.height, channelInfo.nZSlices};
        ArrayImg stack = ArrayImgs.unsignedShorts((long[])dimensions);
        ArrayRandomAccess randomAccess = stack.randomAccess();
        Iterator iterator = filenames.values().iterator();
        for (int zindex = 0; zindex < filenames.size(); ++zindex) {
            Map tilesFilenames = (Map)iterator.next();
            for (Integer fieldNumber : tilesFilenames.keySet()) {
                int fieldIndex = fieldNumber - 1;
                String filename = (String)tilesFilenames.get(fieldNumber);
                filename = filename.replace('\\', File.separatorChar);
                long[] offset = channelInfo.offsets.get(fieldIndex);
                randomAccess.setPosition(zindex, 2);
                File filePath = new File(this.imageIndexFile.getParentFile(), filename);
                ImagePlus imp = new ImagePlus(filePath.getAbsolutePath());
                Img sliceImg = ImageJFunctions.wrapShort((ImagePlus)imp);
                Cursor cursor = sliceImg.cursor();
                while (cursor.hasNext()) {
                    cursor.fwd();
                    randomAccess.setPosition(offset[0] + cursor.getLongPosition(0), 0);
                    randomAccess.setPosition(offset[1] + cursor.getLongPosition(1), 1);
                    ((UnsignedShortType)randomAccess.get()).set((GenericShortType)cursor.get());
                }
            }
        }
        return stack;
    }

    public UnsignedShortType getImageType() {
        return new UnsignedShortType();
    }
}

