/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.Demodulation;
import FlowJ.FlowJException;
import FlowJ.FlowJFlow;
import bijnum.BIJmatrix;
import ij.IJ;
import ij.ImageStack;
import volume.GaborCos;
import volume.GaborSin;
import volume.Gaussian;
import volume.Kernel1D;
import volume.VolumeFloat;
import volume.VolumeIO;

public class FlowJFleet {
    private float[][] filter;
    private float[][][][] normal;
    private final boolean debug = false;
    private float residualThreshold;
    private float conditionLimit;
    private float sigmas;
    private float sigmat;
    private float tau;
    private float maxampFraction;
    private int width;
    private int height;
    private int depth;
    private float density;
    private float maxamp;
    private int edge;
    private int validNormals;
    private int failedTau;
    private int failedAmp;

    public String toString() {
        return "FJ s" + this.sigmas + " t" + this.sigmat + " tau" + this.tau + " maxamp" + this.maxampFraction * 100.0f + "% cond" + this.conditionLimit + " resid" + this.residualThreshold + " (" + IJ.d2s((double)(this.density * 100.0f), (int)2) + "%)";
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void filterAll(ImageStack stack, int center, float sigmat, float sigmas) throws FlowJException {
        this.width = stack.getWidth();
        this.height = stack.getHeight();
        this.depth = 5;
        this.maxamp = 0.0f;
        this.edge = 0;
        this.sigmas = sigmas;
        this.sigmat = sigmat;
        VolumeFloat v = new VolumeFloat(this.width, this.height, this.depth);
        Gaussian Gt = new Gaussian(sigmat);
        if (stack.getSize() < v.discreteSupport(Gt)) {
            FlowJException e = new FlowJException("Need at least " + v.discreteSupport(Gt) + " slices.");
            throw e;
        }
        if (center < v.discreteSupport(Gt) / 2) {
            FlowJException e = new FlowJException("Please select a slice over " + v.discreteSupport(Gt) / 2 + " and below " + (stack.getSize() + 1 - v.discreteSupport(Gt) / 2));
            throw e;
        }
        this.initFilters(sigmat, sigmas);
        Object pixels = null;
        Gaussian Gs = new Gaussian(sigmas);
        VolumeFloat DC = new VolumeFloat(this.width, this.height, this.depth);
        DC.convolvet(stack, center, Gt);
        DC.convolvey(v, Gs);
        DC.mul(0.001);
        this.edge = v.discreteSupport(Gs) / 2;
        for (int n = 0; n < this.filter.length; ++n) {
            IJ.showProgress((double)((float)n / (float)this.filter.length));
            GaborSin Gsx = new GaborSin(sigmas, this.filter[n][0]);
            GaborSin Gsy = new GaborSin(sigmas, this.filter[n][1]);
            GaborSin Gst = new GaborSin(sigmat, this.filter[n][2]);
            GaborCos Gcx = new GaborCos(sigmas, this.filter[n][0]);
            GaborCos Gcy = new GaborCos(sigmas, this.filter[n][1]);
            GaborCos Gct = new GaborCos(sigmat, this.filter[n][2]);
            VolumeFloat savex = new VolumeFloat(this.width, this.height, this.depth);
            VolumeFloat savett = new VolumeFloat(this.width, this.height, this.depth);
            VolumeIO vImag = new VolumeIO(this.width, this.height, this.depth);
            VolumeIO vReal = new VolumeIO(this.width, this.height, this.depth);
            v.convolvet(stack, center, Gct);
            savex.convolvex(v, Gcx);
            vImag.convolvey(savex, Gsy);
            vReal.convolvey(savex, Gcy);
            savex.convolvex(v, Gsx);
            v.convolvey(savex, Gcy);
            vImag.add(v);
            v.convolvey(savex, Gsy);
            vReal.sub(v);
            savett.convolvet(stack, center, Gst);
            savex.convolvex(savett, Gsx);
            v.convolvey(savex, Gsy);
            vImag.sub(v);
            v.convolvey(savex, Gcy);
            vReal.sub(v);
            savex.convolvex(savett, Gcx);
            v.convolvey(savex, Gcy);
            vImag.add(v);
            v.convolvey(savex, Gsy);
            vReal.sub(v);
            vReal.sub(DC);
            this.maxamp = this.maxAmplitude(vReal, vImag, n, this.maxamp);
            vReal.write("real" + IJ.d2s((double)n, (int)0) + ".v");
            vImag.write("imag" + IJ.d2s((double)n, (int)0) + ".v");
        }
    }

    private void initFilters(float sigmat, float sigmas) {
        float[][] tuning = new float[22][2];
        tuning[0][0] = 0.0f;
        tuning[0][1] = 0.0f;
        tuning[1][0] = 30.0f;
        tuning[1][1] = 0.0f;
        tuning[2][0] = 60.0f;
        tuning[2][1] = 0.0f;
        tuning[3][0] = 90.0f;
        tuning[3][1] = 0.0f;
        tuning[4][0] = 120.0f;
        tuning[4][1] = 0.0f;
        tuning[5][0] = 150.0f;
        tuning[5][1] = 0.0f;
        tuning[6][0] = 0.0f;
        tuning[6][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[7][0] = 36.0f;
        tuning[7][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[8][0] = 72.0f;
        tuning[8][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[9][0] = 108.0f;
        tuning[9][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[10][0] = 144.0f;
        tuning[10][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[11][0] = 180.0f;
        tuning[11][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[12][0] = 216.0f;
        tuning[12][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[13][0] = 252.0f;
        tuning[13][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[14][0] = 288.0f;
        tuning[14][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[15][0] = 324.0f;
        tuning[15][1] = 1.0f / (float)Math.sqrt(3.0);
        tuning[16][0] = 0.0f;
        tuning[16][1] = (float)Math.sqrt(3.0);
        tuning[17][0] = 60.0f;
        tuning[17][1] = (float)Math.sqrt(3.0);
        tuning[18][0] = 120.0f;
        tuning[18][1] = (float)Math.sqrt(3.0);
        tuning[19][0] = 180.0f;
        tuning[19][1] = (float)Math.sqrt(3.0);
        tuning[20][0] = 240.0f;
        tuning[20][1] = (float)Math.sqrt(3.0);
        tuning[21][0] = 300.0f;
        tuning[21][1] = (float)Math.sqrt(3.0);
        this.filter = new float[tuning.length][3];
        IJ.log((String)("Fleet: Gabor filters (sigmas=" + sigmas + ", sigmat=" + sigmat + ")"));
        float mu = 1.0f;
        float beta = 0.8f;
        float base = 2.0f;
        float b = (float)Math.pow(2.0, 0.8f);
        for (int n = 0; n < this.filter.length; ++n) {
            float theta = tuning[n][0];
            float speed = tuning[n][1];
            float wavelengths = (float)Math.PI * 2 * (b - 1.0f) * sigmas / (1.0f * (b + 1.0f));
            float lambdas = wavelengths * (float)Math.sqrt(speed * speed + 1.0f);
            float wavelengtht = (float)Math.PI * 2 * (b - 1.0f) * sigmat / (1.0f * (b + 1.0f));
            float lambdat = -wavelengtht * (float)Math.sqrt(speed * speed + 1.0f) / speed;
            if ((double)Math.abs(speed) <= 1.0E-6) {
                lambdat = Float.MAX_VALUE;
            }
            float k3 = (float)Math.PI * 2 / lambdat;
            float rho = (float)Math.PI * 2 / lambdas;
            float k1 = rho * (float)Math.sin((double)(theta * 2.0f) * Math.PI / 360.0);
            float k2 = -rho * (float)Math.cos((double)(theta * 2.0f) * Math.PI / 360.0);
            this.filter[n][0] = k1;
            this.filter[n][1] = -k2;
            this.filter[n][2] = k3;
        }
    }

    private float maxAmplitude(VolumeFloat vReal, VolumeFloat vImag, int n, float maxamp) {
        float filterMax = 0.0f;
        for (int y = 0; y < vReal.getHeight(); ++y) {
            for (int x = 0; x < vReal.getWidth(); ++x) {
                float amplitude;
                if (!vReal.valid(x, y) || !((amplitude = (float)Math.sqrt(vReal.v[2][y][x] * vReal.v[2][y][x] + vImag.v[2][y][x] * vImag.v[2][y][x])) > filterMax)) continue;
                filterMax = amplitude;
            }
        }
        return Math.max(filterMax, maxamp);
    }

    private float L2norm(float[] v, int length) {
        float sum = 0.0f;
        for (int i = 0; i < length; ++i) {
            sum += v[i] * v[i];
        }
        return (float)Math.sqrt(sum);
    }

    public void normals(float percent_maxamp, float tau) {
        this.maxampFraction = percent_maxamp;
        this.tau = tau;
        Object pixels = null;
        this.normal = new float[this.filter.length][this.height][this.width][2];
        float ampthresh = this.maxampFraction * this.maxamp;
        this.failedAmp = 0;
        this.failedTau = 0;
        this.validNormals = 0;
        IJ.log((String)("Fleet components: response > " + this.maxampFraction + "; frequency/amplitude < " + tau + "(tau)"));
        for (int n = 0; n < this.filter.length; ++n) {
            IJ.showProgress((double)((float)n / (float)this.filter.length));
            float beta = 0.8f;
            float base = 2.0f;
            float b = (float)Math.pow(2.0, 0.8f);
            float f0 = this.L2norm(this.filter[n], 3);
            float sigmak_tau_2 = (float)Math.pow(tau / ((b + 1.0f) / ((b - 1.0f) * f0)), 2.0);
            VolumeIO vReal = new VolumeIO("real" + IJ.d2s((double)n, (int)0) + ".v");
            vReal.delete("real" + IJ.d2s((double)n, (int)0) + ".v");
            VolumeIO vImag = new VolumeIO("imag" + IJ.d2s((double)n, (int)0) + ".v");
            vImag.delete("imag" + IJ.d2s((double)n, (int)0) + ".v");
            float[][][] phi = new float[this.height][this.width][3];
            this.Dphi(vReal, vImag, phi, sigmak_tau_2, ampthresh, n);
            this.computeNormal(phi, n);
        }
        IJ.log((String)("" + this.validNormals + " valid components (" + this.width * this.height * this.filter.length + ")"));
        IJ.log((String)("failed amplitude test " + this.failedAmp + ", failed amp/freq test " + this.failedTau));
    }

    private void convolveComplexx(float[] r, VolumeFloat vReal, VolumeFloat vImag, Kernel1D kReal, Kernel1D kImag, int x, int y, int t, float c) {
        r[1] = 0.0f;
        r[0] = 0.0f;
        if (kReal.halfwidth != kImag.halfwidth) {
            IJ.error((String)"kernel not correct");
            return;
        }
        for (int i = -kReal.halfwidth; i <= kReal.halfwidth; ++i) {
            r[0] = (float)((double)r[0] + (kReal.k[i + kReal.halfwidth] * (double)vReal.v[t][y][x + i] - kImag.k[i + kImag.halfwidth] * (double)vImag.v[t][y][x + i]));
            r[1] = (float)((double)r[1] + (kImag.k[i + kImag.halfwidth] * (double)vReal.v[t][y][x + i] + kReal.k[i + kReal.halfwidth] * (double)vImag.v[t][y][x + i]));
        }
        r[0] = r[0] - c * vImag.v[t][y][x];
        r[1] = r[1] + c * vReal.v[t][y][x];
    }

    private void convolveComplexy(float[] r, VolumeFloat vReal, VolumeFloat vImag, Kernel1D kReal, Kernel1D kImag, int x, int y, int t, float c) {
        r[1] = 0.0f;
        r[0] = 0.0f;
        if (kReal.halfwidth != kImag.halfwidth) {
            IJ.error((String)"kernel not correct");
            return;
        }
        for (int i = -kReal.halfwidth; i <= kReal.halfwidth; ++i) {
            r[0] = (float)((double)r[0] + (kReal.k[i + kReal.halfwidth] * (double)vReal.v[t][y + i][x] - kImag.k[i + kImag.halfwidth] * (double)vImag.v[t][y + i][x]));
            r[1] = (float)((double)r[1] + (kImag.k[i + kReal.halfwidth] * (double)vReal.v[t][y + i][x] + kReal.k[i + kImag.halfwidth] * (double)vImag.v[t][y + i][x]));
        }
        r[0] = r[0] - c * vImag.v[t][y][x];
        r[1] = r[1] + c * vReal.v[t][y][x];
    }

    private void convolveComplext(float[] r, VolumeFloat vReal, VolumeFloat vImag, Kernel1D kReal, Kernel1D kImag, int x, int y, int t, float c) {
        r[1] = 0.0f;
        r[0] = 0.0f;
        if (kReal.halfwidth != kImag.halfwidth) {
            IJ.error((String)"kernel not correct");
            return;
        }
        for (int i = -kReal.halfwidth; i <= kReal.halfwidth; ++i) {
            r[0] = (float)((double)r[0] + (kReal.k[i + kReal.halfwidth] * (double)vReal.v[t + i][y][x] - kImag.k[i + kImag.halfwidth] * (double)vImag.v[t + i][y][x]));
            r[1] = (float)((double)r[1] + (kImag.k[i + kReal.halfwidth] * (double)vReal.v[t + i][y][x] + kReal.k[i + kImag.halfwidth] * (double)vImag.v[t + i][y][x]));
        }
        r[0] = r[0] - c * vImag.v[t][y][x];
        r[1] = r[1] + c * vReal.v[t][y][x];
    }

    private void Dphi(VolumeFloat vReal, VolumeFloat vImag, float[][][] phi, float tau, float ampthresh, int n) {
        Demodulation demodRealx = new Demodulation(this.filter[n][0], true);
        Demodulation demodImagx = new Demodulation(this.filter[n][0], false);
        Demodulation demodRealy = new Demodulation(this.filter[n][1], true);
        Demodulation demodImagy = new Demodulation(this.filter[n][1], false);
        Demodulation demodRealt = new Demodulation(this.filter[n][2], true);
        Demodulation demodImagt = new Demodulation(this.filter[n][2], false);
        int valid = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                float ampSquare;
                float amp;
                phi[y][x][2] = 100.0f;
                phi[y][x][1] = 100.0f;
                phi[y][x][0] = 100.0f;
                if (!vReal.valid(x, y) || x < demodRealx.halfwidth || x >= this.width - demodRealx.halfwidth || y < demodRealy.halfwidth || y >= this.height - demodRealy.halfwidth || !((amp = (float)Math.sqrt(ampSquare = (float)Math.pow(vReal.v[2][y][x], 2.0) + (float)Math.pow(vImag.v[2][y][x], 2.0))) > 0.0f)) continue;
                float[] rx = new float[2];
                float[] ry = new float[2];
                float[] rt = new float[2];
                this.convolveComplexx(rx, vReal, vImag, demodRealx, demodImagx, x, y, this.depth / 2, this.filter[n][0]);
                this.convolveComplexy(ry, vReal, vImag, demodRealy, demodImagy, x, y, this.depth / 2, this.filter[n][1]);
                this.convolveComplext(rt, vReal, vImag, demodRealt, demodImagt, x, y, this.depth / 2, this.filter[n][2]);
                phi[y][x][0] = (vReal.v[this.depth / 2][y][x] * rx[1] - rx[0] * vImag.v[this.depth / 2][y][x]) / ampSquare;
                phi[y][x][1] = (vReal.v[this.depth / 2][y][x] * ry[1] - ry[0] * vImag.v[this.depth / 2][y][x]) / ampSquare;
                phi[y][x][2] = (vReal.v[this.depth / 2][y][x] * rt[1] - rt[0] * vImag.v[this.depth / 2][y][x]) / ampSquare;
                float[] dA = new float[]{(vReal.v[this.depth / 2][y][x] * rx[0] + vImag.v[this.depth / 2][y][x] * rx[1]) / ampSquare, (vReal.v[this.depth / 2][y][x] * ry[0] + vImag.v[this.depth / 2][y][x] * ry[1]) / ampSquare, (vReal.v[this.depth / 2][y][x] * rt[0] + vImag.v[this.depth / 2][y][x] * rt[1]) / ampSquare};
                float[] diff = new float[]{phi[y][x][0] - this.filter[n][0], phi[y][x][1] - this.filter[n][1], phi[y][x][2] - this.filter[n][2]};
                if (amp < ampthresh) {
                    phi[y][x][2] = 100.0f;
                    phi[y][x][1] = 100.0f;
                    phi[y][x][0] = 100.0f;
                    ++this.failedAmp;
                    continue;
                }
                if (Math.pow(this.L2norm(dA, 3), 2.0) + Math.pow(this.L2norm(diff, 3), 2.0) > (double)tau) {
                    phi[y][x][2] = 100.0f;
                    phi[y][x][1] = 100.0f;
                    phi[y][x][0] = 100.0f;
                    ++this.failedTau;
                    continue;
                }
                ++this.validNormals;
                ++valid;
            }
        }
    }

    private void computeNormal(float[][][] phi, int n) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (phi[y][x][0] == 100.0f && phi[y][x][1] == 100.0f && phi[y][x][2] == 100.0f) {
                    this.normal[n][y][x][1] = 100.0f;
                    this.normal[n][y][x][0] = 100.0f;
                    continue;
                }
                float denom = (float)Math.pow(phi[y][x][0], 2.0) + (float)Math.pow(phi[y][x][1], 2.0);
                this.normal[n][y][x][0] = -(phi[y][x][0] * phi[y][x][2]) / denom;
                this.normal[n][y][x][1] = -(-(phi[y][x][1] * phi[y][x][2]) / denom);
            }
        }
    }

    public void computeFull(FlowJFlow flow, float conditionLimit, float residualThreshold) {
        int no_wronginverse = 0;
        int no_notcomp = 0;
        int no_count = 0;
        int no_ill_conditioned = 0;
        int no_large_residuals = 0;
        int total = 0;
        int full = 0;
        this.conditionLimit = conditionLimit;
        this.residualThreshold = residualThreshold;
        IJ.log((String)("Fleet: full velocities cond nr < " + IJ.d2s((double)conditionLimit, (int)2) + "; residual < " + residualThreshold));
        System.gc();
        for (int y = 0; y < this.height; ++y) {
            IJ.showProgress((double)((float)y / (float)this.height));
            for (int x = 0; x < this.width; ++x) {
                flow.set(x, y, 0.0f, 0.0f, false);
                int count = 0;
                float[][] J = new float[this.filter.length * 5 * 5][6];
                float[] vn = new float[this.filter.length * 5 * 5];
                if (x > 2 && x < this.width - 2 && y > 2 && y < this.height - 2) {
                    for (int n = 0; n < this.filter.length; ++n) {
                        for (int m = -2; m <= 2; ++m) {
                            for (int l = -2; l <= 2; ++l) {
                                float size;
                                if (this.normal[n][y + m][x + l][0] == 100.0f || this.normal[n][y + m][x + l][1] == 100.0f || !((double)(size = this.L2norm(this.normal[n][y + m][x + l], 2)) > 1.0E-6)) continue;
                                float[] nv = new float[]{this.normal[n][y + m][x + l][0] / size, this.normal[n][y + m][x + l][1] / size};
                                J[count][0] = nv[0];
                                J[count][1] = nv[0] * (float)l;
                                J[count][2] = nv[0] * (float)m;
                                J[count][3] = nv[1];
                                J[count][4] = nv[1] * (float)l;
                                J[count][5] = nv[1] * (float)m;
                                vn[count++] = size;
                            }
                        }
                    }
                    ++total;
                } else {
                    ++no_notcomp;
                }
                if (count >= 6) {
                    float[] product = new float[count];
                    float[][][] v = new float[3][3][2];
                    float condnum = 0.0f;
                    boolean inversefailed = false;
                    try {
                        condnum = this.optimizeVelocity(count, 6, J, vn, v, product);
                    }
                    catch (Exception e) {
                        ++no_wronginverse;
                        inversefailed = true;
                        condnum = Float.MAX_VALUE;
                    }
                    if (condnum < conditionLimit) {
                        float[] difference = new float[count];
                        for (int i = 0; i < count; ++i) {
                            difference[i] = (float)Math.pow(vn[i] - product[i], 2.0);
                        }
                        float residual = this.L2norm(difference, count) / this.L2norm(vn, count);
                        if (residual < residualThreshold) {
                            flow.set(x, y, v[1][1][0], v[1][1][1], true);
                            ++full;
                            continue;
                        }
                        ++no_large_residuals;
                        continue;
                    }
                    ++no_ill_conditioned;
                    continue;
                }
                ++no_count;
            }
        }
        this.density = (float)full / (float)total;
        IJ.log((String)("Fleet failed computations:\non residual: " + no_large_residuals + "; ill conditioned: " + no_ill_conditioned + "; on too few valid normal velocities: " + no_count + "; invalid locations: " + no_notcomp));
        if (no_wronginverse > 0) {
            IJ.log((String)("Invalid pseudoinverse calculations: " + no_wronginverse));
        }
    }

    private float optimizeVelocity(int r, int n, float[][] J, float[] vn, float[][][] v, float[] product) {
        float[] alphabeta = new float[n];
        float[][] JI = new float[n][r];
        float condnum = BIJmatrix.pseudoinverse(JI, J, 0.0);
        if (condnum < Float.MAX_VALUE) {
            int j;
            int i;
            for (i = 0; i < n; ++i) {
                alphabeta[i] = 0.0f;
                for (j = 0; j < r; ++j) {
                    int n2 = i;
                    alphabeta[n2] = alphabeta[n2] + JI[i][j] * vn[j];
                }
            }
            for (i = 0; i < r; ++i) {
                product[i] = 0.0f;
                for (j = 0; j < n; ++j) {
                    int n3 = i;
                    product[n3] = product[n3] + J[i][j] * alphabeta[j];
                }
            }
            for (i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    v[i + 1][j + 1][0] = alphabeta[0] + alphabeta[1] * (float)j + alphabeta[2] * (float)i;
                    v[i + 1][j + 1][1] = alphabeta[3] + alphabeta[4] * (float)j + alphabeta[5] * (float)i;
                }
            }
        }
        return condnum;
    }

    private float[] mapAmplitude(float[] pixels, VolumeFloat vReal, VolumeFloat vImag, int n, float maxamp) {
        int col = n % 5;
        int row = n / 5;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int i = col * this.width + row * this.width * this.height * 5 + x + y * 5 * this.width;
                if (!vReal.valid(x, y)) continue;
                float amplitude = (float)Math.sqrt(vReal.v[2][y][x] * vReal.v[2][y][x] + vImag.v[2][y][x] * vImag.v[2][y][x]);
                pixels[i++] = amplitude;
            }
        }
        return pixels;
    }

    private float[] mapFloat(float[] pixels, VolumeFloat v, int n) {
        int col = n % 5;
        int row = n / 5;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int i = col * this.width + row * this.width * this.height * 5 + x + y * 5 * this.width;
                if (!v.valid(x, y)) continue;
                float value = v.v[2][y][x];
                pixels[i++] = value;
            }
        }
        return pixels;
    }
}

