/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;
import VolumeJ.VJPlane;
import VolumeJ.VJUserInterface;
import volume.Volume;

public class VJCell {
    public int ix = 0;
    public int iy = 0;
    public int iz = 0;
    private VJPlane[] vsface;
    private float[] planeShiftD;
    private int[] planeNormalAxis;
    private float kminbase;
    private float kdelta;
    private float jminbase;
    private float jdelta;
    private float iminbase;
    private float idelta;
    private float[] iinc;
    float[] jinc;
    float[] kinc;
    private static final float ERR = 1.0E-5f;
    private VJMatrix m;
    private VJMatrix mi;
    String s;

    public VJCell(VJMatrix m, VJMatrix mi) {
        this.m = m;
        this.mi = mi;
        this.precomputeFaces(m);
    }

    public void move(float ox, float oy, float oz) {
        this.ix = (int)(ox >= 0.0f ? ox + 1.0E-5f : ox - 1.0f - 1.0E-5f);
        this.iy = (int)(oy >= 0.0f ? oy + 1.0E-5f : oy - 1.0f - 1.0E-5f);
        this.iz = (int)(oz >= 0.0f ? oz + 1.0E-5f : oz - 1.0f - 1.0E-5f);
    }

    private void precomputeFaces(VJMatrix m) {
        try {
            int i;
            float[][] vsvertex = VJCell.transformVertices(m, VJCell.vertices(0, 0, 0));
            VJPlane[] allfaces = this.faces(vsvertex);
            this.iinc = new float[3];
            this.jinc = new float[3];
            this.kinc = new float[3];
            this.iinc[0] = vsvertex[1][0] - vsvertex[0][0];
            this.iinc[1] = vsvertex[2][0] - vsvertex[0][0];
            this.iinc[2] = vsvertex[4][0] - vsvertex[0][0];
            this.jinc[0] = vsvertex[1][1] - vsvertex[0][1];
            this.jinc[1] = vsvertex[2][1] - vsvertex[0][1];
            this.jinc[2] = vsvertex[4][1] - vsvertex[0][1];
            this.kinc[0] = vsvertex[1][2] - vsvertex[0][2];
            this.kinc[1] = vsvertex[2][2] - vsvertex[0][2];
            this.kinc[2] = vsvertex[4][2] - vsvertex[0][2];
            float[] kextents = VJCell.extents(vsvertex, 2);
            this.kminbase = kextents[0];
            this.kdelta = kextents[1] - this.kminbase;
            float[] jextents = VJCell.extents(vsvertex, 1);
            this.jminbase = jextents[0];
            this.jdelta = jextents[1] - this.jminbase;
            float[] iextents = VJCell.extents(vsvertex, 0);
            this.iminbase = iextents[0];
            this.idelta = iextents[1] - this.iminbase;
            float[] dD = new float[]{allfaces[1].getD() - allfaces[0].getD(), allfaces[3].getD() - allfaces[2].getD(), allfaces[5].getD() - allfaces[4].getD()};
            VJPlane[] vsfaceSorted = new VJPlane[3];
            float[] planeShiftDSorted = new float[3];
            int[] planeNormalAxisSorted = new int[3];
            if (Math.abs(allfaces[0].getC()) > Math.abs(allfaces[2].getC()) && Math.abs(allfaces[2].getC()) > Math.abs(allfaces[4].getC())) {
                vsfaceSorted[0] = allfaces[0];
                planeShiftDSorted[0] = dD[0];
                planeNormalAxisSorted[0] = 0;
                vsfaceSorted[1] = allfaces[2];
                planeShiftDSorted[1] = dD[1];
                planeNormalAxisSorted[1] = 1;
                vsfaceSorted[2] = allfaces[4];
                planeShiftDSorted[2] = dD[2];
                planeNormalAxisSorted[2] = 2;
            } else if (Math.abs(allfaces[0].getC()) > Math.abs(allfaces[2].getC()) && Math.abs(allfaces[2].getC()) < Math.abs(allfaces[4].getC())) {
                vsfaceSorted[0] = allfaces[4];
                planeShiftDSorted[0] = dD[2];
                planeNormalAxisSorted[0] = 2;
                vsfaceSorted[1] = allfaces[0];
                planeShiftDSorted[1] = dD[0];
                planeNormalAxisSorted[1] = 0;
                vsfaceSorted[2] = allfaces[2];
                planeShiftDSorted[2] = dD[1];
                planeNormalAxisSorted[2] = 1;
            } else {
                vsfaceSorted[0] = allfaces[4];
                planeShiftDSorted[0] = dD[2];
                planeNormalAxisSorted[0] = 2;
                vsfaceSorted[1] = allfaces[2];
                planeShiftDSorted[1] = dD[1];
                planeNormalAxisSorted[1] = 1;
                vsfaceSorted[2] = allfaces[0];
                planeShiftDSorted[2] = dD[0];
                planeNormalAxisSorted[2] = 0;
            }
            int n = 0;
            for (i = 0; i < vsfaceSorted.length; ++i) {
                if (vsfaceSorted[i].getC() == 0.0f) continue;
                ++n;
            }
            this.vsface = new VJPlane[n];
            this.planeShiftD = new float[n];
            this.planeNormalAxis = new int[n];
            int j = 0;
            for (i = 0; i < vsfaceSorted.length && j < n; ++i) {
                if (vsfaceSorted[i].getC() == 0.0f) continue;
                this.planeShiftD[j] = planeShiftDSorted[i];
                this.planeNormalAxis[j] = planeNormalAxisSorted[i];
                this.vsface[j++] = vsfaceSorted[i];
            }
        }
        catch (Exception e) {
            VJUserInterface.write("error: " + e);
        }
    }

    public float[] intersect(int i, int j, int kdummy) {
        float[] intersection = new float[2];
        int intersections = 0;
        int[] p = new int[]{this.ix, this.iy, this.iz};
        float kmin = this.kminbase + this.kinc[0] * (float)this.ix + this.kinc[1] * (float)this.iy + this.kinc[2] * (float)this.iz;
        float kmax = kmin + this.kdelta;
        for (int f = 0; f < this.vsface.length && intersections < 2; ++f) {
            boolean isNotSame;
            float ai = this.vsface[f].getA() * (float)i;
            float bj = this.vsface[f].getB() * (float)j;
            float c = this.vsface[f].getC();
            float d = this.vsface[f].getD() + (float)p[this.planeNormalAxis[f]] * this.planeShiftD[f];
            float k = -(ai + bj + d) / c;
            boolean isInside = this.between(k, kmin, kmax, 1.0E-5f);
            boolean bl = isNotSame = intersections > 0 && !this.between(k, intersection[0], intersection[0], 1.0E-5f) || intersections == 0;
            if (isInside && isNotSame) {
                intersection[intersections++] = k;
            }
            if (intersections >= 2) continue;
            k = -(ai + bj + (d += this.planeShiftD[f])) / c;
            isInside = this.between(k, kmin, kmax, 1.0E-5f);
            boolean bl2 = isNotSame = intersections > 0 && !this.between(k, intersection[0], intersection[0], 1.0E-5f) || intersections == 0;
            if (!isInside || !isNotSame) continue;
            intersection[intersections++] = k;
        }
        if (intersections == 2) {
            return intersection;
        }
        return null;
    }

    public float[] intersectTracing(int i, int j, int kdummy) {
        float[] intersection = new float[2];
        int intersections = 0;
        float imin = this.iminbase + this.iinc[0] * (float)this.ix + this.iinc[1] * (float)this.iy + this.iinc[2] * (float)this.iz;
        float imax = imin + this.idelta;
        this.s = "_____\n";
        if (!this.between(i, imin, imax, 1.0E-5f)) {
            this.s = "i not within cell: " + i + "," + j + " imin, imax " + imin + "," + imax + " iinc[] " + this.iinc[0] + "," + this.iinc[1] + "," + this.iinc[2] + " iminbase " + this.iminbase + " idelta " + this.idelta;
            return null;
        }
        float jmin = this.jminbase + this.jinc[0] * (float)this.ix + this.jinc[1] * (float)this.iy + this.jinc[2] * (float)this.iz;
        float jmax = jmin + this.jdelta;
        if (!this.between(j, jmin, jmax, 1.0E-5f)) {
            this.s = "j not within cell: " + i + "," + j + " jmin, jmax " + jmin + "," + jmax + " iinc[] " + this.iinc[0] + "," + this.iinc[1] + "," + this.iinc[2] + " iminbase " + this.iminbase + " idelta " + this.idelta;
            return null;
        }
        int[] p = new int[]{this.ix, this.iy, this.iz};
        float kmin = this.kminbase + this.kinc[0] * (float)this.ix + this.kinc[1] * (float)this.iy + this.kinc[2] * (float)this.iz;
        float kmax = kmin + this.kdelta;
        for (int f = 0; f < this.vsface.length && intersections < 2; ++f) {
            float[] vt;
            boolean isNotSame;
            float ai = this.vsface[f].getA() * (float)i;
            float bj = this.vsface[f].getB() * (float)j;
            float c = this.vsface[f].getC();
            float d = this.vsface[f].getD() + (float)p[this.planeNormalAxis[f]] * this.planeShiftD[f];
            float k = -(ai + bj + d) / c;
            boolean isInside = this.between(k, kmin, kmax, 1.0E-5f);
            boolean bl = isNotSame = intersections > 0 && !this.between(k, intersection[0], intersection[0], 1.0E-5f) || intersections == 0;
            if (isInside && isNotSame) {
                intersection[intersections++] = k;
                this.s = this.s + "\nIntersection found (" + intersections + "): k=" + k + " kmin,kmax: {" + kmin + "-" + kmax + "} ai,bj,c,d: " + ai + " " + bj + " " + c + " " + d + " ray: " + i + "," + j;
            } else {
                this.s = this.s + "\nFailed intersection (" + intersections + "): k=" + k + " not within cell " + this.ix + "," + this.iy + "," + this.iz + ", ray=" + i + "," + j + ", k=" + k + " {" + kmin + " - " + kmax + "} kinc[] " + this.kinc[0] + "," + this.kinc[1] + "," + this.kinc[2] + " kminbase " + this.kminbase + " kdelta " + this.kdelta;
                this.s = this.s + " f=" + f + " planeNormalAxis[f] " + this.planeNormalAxis[f] + ", p[planeNormalAxis[f]]=" + p[this.planeNormalAxis[f]] + " planeShiftD[f]=" + this.planeShiftD[f] + "\n";
                vt = this.m.inverse().mul(VJMatrix.newVector(i, j, k));
                this.s = this.s + "k=" + k + ", in object space: " + vt[0] + "," + vt[1] + "," + vt[2] + "\n";
                this.s = this.s + this.toStringFaces();
            }
            if (intersections >= 2) continue;
            k = -(ai + bj + (d += this.planeShiftD[f])) / c;
            isInside = this.between(k, kmin, kmax, 1.0E-5f);
            boolean bl2 = isNotSame = intersections > 0 && !this.between(k, intersection[0], intersection[0], 1.0E-5f) || intersections == 0;
            if (isInside && isNotSame) {
                intersection[intersections++] = k;
                this.s = this.s + "\nIntersection found (" + intersections + "): k=" + k + " kmin,kmax: {" + kmin + "-" + kmax + "} ai,bj,c,d: " + ai + " " + bj + " " + c + " " + d + " ray: " + i + "," + j;
                continue;
            }
            this.s = this.s + "\nFailed intersection (" + intersections + "): k=" + k + " not within cell " + this.ix + "," + this.iy + "," + this.iz + ", ray=" + i + "," + j + ", k=" + k + " {" + kmin + " - " + kmax + "} kinc[] " + this.kinc[0] + "," + this.kinc[1] + "," + this.kinc[2] + " kminbase " + this.kminbase + " kdelta " + this.kdelta;
            this.s = this.s + " f=" + f + " planeNormalAxis[f] " + this.planeNormalAxis[f] + ", p[planeNormalAxis[f]]=" + p[this.planeNormalAxis[f]] + " planeShiftD[f]=" + this.planeShiftD[f] + "\n";
            vt = this.m.inverse().mul(VJMatrix.newVector(i, j, k));
            this.s = this.s + "k=" + k + ", in object space: " + vt[0] + "," + vt[1] + "," + vt[2] + "\n";
            this.s = this.s + this.toStringFaces();
        }
        if (intersections == 1) {
            intersection[intersections++] = intersection[0];
        }
        if (intersections == 2) {
            return intersection;
        }
        return null;
    }

    public static float[][] transformVertices(VJMatrix m, float[][] vertex) {
        float[][] tvertex = new float[vertex.length][vertex[0].length];
        for (int i = 0; i < vertex.length; ++i) {
            tvertex[i] = m.mul(vertex[i]);
        }
        return tvertex;
    }

    public static float[][] vertices(int x, int y, int z) {
        float[][] vertex = new float[8][4];
        vertex[0][0] = x + 0;
        vertex[0][1] = y + 0;
        vertex[0][2] = z + 0;
        vertex[0][3] = 1.0f;
        vertex[1][0] = x + 1;
        vertex[1][1] = y + 0;
        vertex[1][2] = z + 0;
        vertex[1][3] = 1.0f;
        vertex[2][0] = x + 0;
        vertex[2][1] = y + 1;
        vertex[2][2] = z + 0;
        vertex[2][3] = 1.0f;
        vertex[3][0] = x + 1;
        vertex[3][1] = y + 1;
        vertex[3][2] = z + 0;
        vertex[3][3] = 1.0f;
        vertex[4][0] = x + 0;
        vertex[4][1] = y + 0;
        vertex[4][2] = z + 1;
        vertex[4][3] = 1.0f;
        vertex[5][0] = x + 1;
        vertex[5][1] = y + 0;
        vertex[5][2] = z + 1;
        vertex[5][3] = 1.0f;
        vertex[6][0] = x + 0;
        vertex[6][1] = y + 1;
        vertex[6][2] = z + 1;
        vertex[6][3] = 1.0f;
        vertex[7][0] = x + 1;
        vertex[7][1] = y + 1;
        vertex[7][2] = z + 1;
        vertex[7][3] = 1.0f;
        return vertex;
    }

    private VJPlane[] faces(float[][] vertex) {
        VJPlane[] face;
        face = new VJPlane[]{new VJPlane(vertex[0], vertex[2], vertex[4]), new VJPlane(face[0], vertex[1]), new VJPlane(vertex[0], vertex[1], vertex[4]), new VJPlane(face[2], vertex[2]), new VJPlane(vertex[0], vertex[1], vertex[2]), new VJPlane(face[4], vertex[4])};
        return face;
    }

    private static float[] extents(float[][] vertex, int dim) {
        float[] extents = new float[2];
        float[] minvertex = VJMatrix.getMin(vertex, dim);
        extents[0] = minvertex[dim];
        float[] maxvertex = VJMatrix.getMax(vertex, dim);
        extents[1] = maxvertex[dim];
        return extents;
    }

    public String toString() {
        String s = " cell " + this.ix + "," + this.iy + "," + this.iz;
        return s;
    }

    public String toStringFaces() {
        String s = "Cell face plane eqs in viewspace coordinates:\n";
        int[] p = new int[3];
        p[this.planeNormalAxis[0]] = this.ix;
        if (this.planeNormalAxis.length > 1) {
            p[this.planeNormalAxis[1]] = this.iy;
        }
        if (this.planeNormalAxis.length > 2) {
            p[this.planeNormalAxis[2]] = this.iz;
        }
        for (int f = 0; f < this.vsface.length; ++f) {
            float a = this.vsface[f].getA();
            float b = this.vsface[f].getB();
            float c = this.vsface[f].getC();
            float d = this.vsface[f].getD() + (float)p[this.planeNormalAxis[f]] * this.planeShiftD[f];
            s = s + "" + a + "x +" + b + "y +" + c + "z +" + d + " = 0\n";
            s = s + "" + a + "x +" + b + "y +" + c + "z +" + (d += this.planeShiftD[f]) + " = 0\n";
        }
        if (this.vsface.length < 3) {
            s = s + " remaining " + (3 - this.vsface.length) * 2 + " faces are parallel to viewing vector\n";
        }
        return s;
    }

    public String toStringVertices(float[][] vertex) {
        String s = "extents of this cell in chosen coordinate system:\n";
        for (int i = 0; i < vertex.length; ++i) {
            s = s + i + ": ";
            for (int j = 0; j < 3; ++j) {
                s = s + vertex[i][j] + ",";
            }
            s = s + " - ";
        }
        return s;
    }

    public String toString(Volume v) {
        String s = this.toString();
        s = s + "\nvertex voxels:\n";
        for (int y = 1; y >= 0; --y) {
            for (int z = 0; z < 2; ++z) {
                for (int x = 0; x < 2; ++x) {
                    Object o = v.get(this.ix + x, this.iy + y, this.iz + z);
                    s = s + o.toString();
                    s = s + " ";
                }
                s = s + "   ";
            }
            s = s + "\n";
        }
        return s;
    }

    private boolean between(float d, float dlower, float dupper, float epsilon) {
        return d >= dlower - epsilon && d <= dupper + epsilon;
    }
}

