/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;
import VolumeJ.VJRenderView;
import VolumeJ.VJRenderer;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;

public class VJRenderViewStereo
extends VJRenderView {
    public static final double stereoDifference = 5.0;

    public VJRenderViewStereo(VJRenderer renderer, double scale, double xrot, double yrot, double zrot, String message) {
        super(renderer, scale, xrot, yrot, zrot, message);
    }

    @Override
    public synchronized void run() {
        ImagePlus imp;
        this.computeTransformationMatrix();
        this.renderer.setTransformation(this.m, this.mLight);
        long start = System.currentTimeMillis();
        VJMatrix mry = new VJMatrix();
        mry.rotatey(-2.5);
        this.m.mul(mry);
        this.renderer.setTransformation(this.m);
        this.renderer.setMessage("stereo 1/2");
        int[] vp = this.renderer.defaultViewport();
        ImageProcessor ip = this.renderToImageProcessor();
        if (ip instanceof ImageProcessor) {
            imp = new ImagePlus(this.message + "(Left Eye)", ip);
            imp.show();
            IJ.wait((int)250);
        } else {
            IJ.showStatus((String)"");
        }
        mry = new VJMatrix();
        mry.rotatey(2.5);
        this.m.mul(mry);
        this.renderer.setTransformation(this.m);
        this.renderer.setMessage("stereo 2/2");
        this.renderer.setViewport(vp[0], vp[1]);
        ip = this.renderToImageProcessor();
        if (ip instanceof ImageProcessor) {
            imp = new ImagePlus(this.message + "(Right Eye)", ip);
            imp.show();
        } else {
            IJ.showStatus((String)"");
        }
        long elapsedTime = System.currentTimeMillis() - start;
        this.report(elapsedTime);
        IJ.showStatus((String)"gc...");
        System.gc();
        IJ.showStatus((String)"");
    }
}

