/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJClassifier;
import VolumeJ.VJClassifierLevoy;
import VolumeJ.VJInterpolator;
import VolumeJ.VJNearestNeighbor;
import VolumeJ.VJSurfacePlotShell;
import VolumeJ.VJTrilinear;
import VolumeJ.VJUserInterface;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import volume.VolumeShort;

public class VJSurfaceJ
extends VJUserInterface
implements ActionListener,
ClipboardOwner,
ItemListener,
KeyListener {
    protected static final String VERSION = "1.2";
    protected TextField sigmaField;
    protected Button renderSurfaceplot;
    protected static float sigma = 0.0f;

    public VJSurfaceJ() {
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow((Frame)((Object)this));
        instance = this;
        this.showDialog();
        this.setVisible(true);
        xrot = -50.0f;
        scale = 2.0f;
    }

    @Override
    public void showDialog() {
        this.initializing = true;
        this.setTitle("SurfaceJ 1.2");
        this.setLayout(new FlowLayout());
        Panel buttonsPlusData = new Panel();
        buttonsPlusData.setLayout(new GridLayout(0, 1));
        this.add(buttonsPlusData);
        Panel allParams = new Panel();
        allParams.setLayout(new FlowLayout());
        this.add(allParams);
        Panel buttons = new Panel();
        Label l = new Label("SurfaceJ: \u00a92000-2002 Michael Abramoff", 0);
        buttons.add(l);
        Label l1 = new Label("3-D Surface Plotting", 0);
        buttons.add(l1);
        buttons.setLayout(new GridLayout(0, 1));
        this.renderSurfaceplot = new Button("Render surface plot");
        this.renderSurfaceplot.addActionListener(this);
        buttons.add(this.renderSurfaceplot);
        this.renderStop = new Button("Stop rendering");
        this.renderStop.addActionListener(this);
        buttons.add(this.renderStop);
        this.renderStop.setEnabled(false);
        this.iList = this.getImageWindows();
        String[] stitles = this.getWindowNames(this.iList);
        if (this.iList.length > 0) {
            this.sourceChoice = this.createChoice(buttons, "Source image(s):", stitles, 0);
            this.sourceChoice.addItemListener(this);
        }
        buttonsPlusData.add(buttons);
        Panel params1 = new Panel();
        params1.setLayout(new GridLayout(0, 2));
        String[] sxyz = new String[]{"" + xrot, "" + yrot, "" + zrot};
        this.rotField = this.createXYZField(params1, "Rotate:(\u00ba)", sxyz, 1);
        this.scaleField = this.createTextField(params1, "Scale:", "" + scale, 1);
        if (this.iList.length > 0) {
            ImagePlus imp = WindowManager.getImage((int)this.iList[this.sourceChoice.getSelectedIndex()]);
            Calibration c = imp.getCalibration();
            aspectz = (float)(c.pixelDepth / c.pixelWidth);
        }
        String[] saspect = new String[]{"" + aspectx, "" + aspecty, "" + aspectz};
        this.aspectField = this.createXYZField(params1, "Aspect/:", saspect, 1);
        String[] sluts = new String[]{"spectrum LUT", "load custom"};
        this.lutChoice = this.createChoice(params1, "Index LUT type", sluts, 0);
        String[] sinterpolation = new String[]{"nearest neighbor", "trilinear"};
        this.interpolationChoice = this.createChoice(params1, "Interpolation:", sinterpolation, 1);
        this.cineNField = this.createTextField(params1, "Cine total rotation(\u00ba):", "360", 1);
        this.cineField = this.createTextField(params1, "Cine frame increment(\u00ba):", "10", 1);
        String[] sAxis = new String[]{"x", "y", "z"};
        this.axisChoice = this.createChoice(params1, "Cine rotation axis", sAxis, 1);
        this.sigmaField = this.createTextField(params1, "Gaussian smoothing:", "" + sigma, 1);
        allParams.add(params1);
        this.pack();
        GUI.center((Window)((Object)this));
        this.setVisible(true);
        this.initializing = false;
        this.activateButtons(this.iList.length);
    }

    @Override
    protected void perform(AWTEvent e) {
        if (this.initializing) {
            return;
        }
        aspectx = this.getFloatField(this.aspectField[0]);
        aspecty = this.getFloatField(this.aspectField[1]);
        aspectz = this.getFloatField(this.aspectField[2]);
        scale = this.getFloatField(this.scaleField);
        xrot = this.getFloatField(this.rotField[0]);
        yrot = this.getFloatField(this.rotField[1]);
        zrot = this.getFloatField(this.rotField[2]);
        sigma = this.getFloatField(this.sigmaField);
        boolean cineToDisk = this.backCheckbox instanceof Checkbox && this.backCheckbox.getState();
        ImagePlus imp = null;
        if (this.iList.length > 0) {
            imp = WindowManager.getImage((int)this.iList[this.sourceChoice.getSelectedIndex()]);
        }
        if (e.getSource() == this.renderSurfaceplot) {
            VJInterpolator interpolator = null;
            interpolator = this.interpolationChoice.getSelectedIndex() == 1 ? new VJTrilinear() : new VJNearestNeighbor();
            if (this.shader == null) {
                this.shader = this.resetShader(lightx, lighty, lightz, aspectx, aspecty, aspecty);
            }
            if (this.classifier == null) {
                this.classifier = this.resetClassifier(3, this.lutChoice.getSelectedIndex());
            }
            this.renderer = this.resetRenderer(interpolator, this.classifier, this.shader, 0, false, 0, 0, 0, false, 0, 0);
            if (this.renderer == null) {
                return;
            }
            VolumeShort vimages = null;
            if (!(imp.getProcessor() instanceof ByteProcessor)) {
                VJSurfaceJ.error("Currently only 8-bit stacks allowed.");
            } else {
                try {
                    vimages = new VolumeShort(imp.getStack());
                }
                catch (Exception exc) {
                    return;
                }
                this.rs = new VJSurfacePlotShell(this.renderer, scale, xrot, yrot, zrot, vimages, 0.0f, 255.0f, aspectz, sigma, "Rendering[" + number + "]");
            }
            this.renderStop.setEnabled(true);
            this.rs.start();
            VJUserInterface.write(this.rs.toString());
            ++number;
        } else if (e.getSource() == this.renderStop) {
            this.rs.kill();
            VJUserInterface.write("Rendering interrupted.");
        } else if (e.getSource() == this.lutChoice) {
            this.classifier = null;
        } else if (e.getSource() == this.sourceChoice) {
            this.v = null;
        } else if (e.getSource() == this.rotField[0] || e.getSource() == this.rotField[1] || e.getSource() == this.rotField[2]) {
            this.shader = null;
        } else if (e.getSource() == this.aspectField[0] || e.getSource() == this.aspectField[1] || e.getSource() == this.aspectField[2]) {
            this.v = null;
            this.shader = null;
        }
    }

    @Override
    protected VJClassifier resetClassifier(int index, int lutIndex) {
        VJClassifierLevoy classifier = new VJClassifierLevoy();
        classifier.setThreshold(128.0);
        classifier.setWidth(2.0);
        if (((VJClassifier)classifier).hasLUT() && lutIndex == 1) {
            this.getLUT(classifier, "");
        }
        return classifier;
    }

    @Override
    protected int[] getImageWindows() {
        int[] idList = WindowManager.getIDList();
        int[] iLongList = idList != null ? new int[idList.length] : new int[]{};
        int inx = 0;
        for (int i = 0; i < iLongList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)idList[i]);
            if (imp instanceof ImagePlus) {
                iLongList[i] = idList[i];
                ++inx;
                continue;
            }
            iLongList[i] = 0;
        }
        int[] iList = new int[inx];
        inx = 0;
        for (int i = 0; i < iLongList.length; ++i) {
            if (iLongList[i] == 0) continue;
            iList[inx++] = iLongList[i];
        }
        return iList;
    }

    @Override
    protected void activateButtons(int listLength) {
        ImagePlus imp = WindowManager.getCurrentImage();
        this.renderSurfaceplot.setEnabled(imp instanceof ImagePlus);
    }

    @Override
    public boolean getLUT(VJClassifier classifier, String path) {
        if (path.equals("")) {
            OpenDialog od = new OpenDialog("Open LUT...", path);
            if (od.getFileName() == null) {
                return false;
            }
            path = od.getDirectory() + od.getFileName();
        }
        IJ.showStatus((String)("Opening: " + path));
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        try {
            int size = this.readLUT(reds, greens, blues, path, false);
            if (size == 0) {
                this.readLUT(reds, greens, blues, path, true);
            }
        }
        catch (IOException e) {
            VJUserInterface.error(e.getMessage());
            return false;
        }
        if (classifier.setLUT(reds, greens, blues)) {
            VJUserInterface.write("Classifier LUT set to: " + path);
            return true;
        }
        IJ.error((String)"Cannot change LUT");
        return false;
    }

    private int readLUT(byte[] reds, byte[] greens, byte[] blues, String path, boolean raw) throws IOException {
        FileInputStream is = new FileInputStream(path);
        DataInputStream f = new DataInputStream(is);
        int nColors = 256;
        if (!raw) {
            int id = f.readInt();
            if (id != 1229147980) {
                return 0;
            }
            short version = f.readShort();
            nColors = f.readShort();
            short start = f.readShort();
            short end = f.readShort();
            long fill1 = f.readLong();
            long fill2 = f.readLong();
            int n = f.readInt();
        }
        f.read(reds, 0, nColors);
        f.read(greens, 0, nColors);
        f.read(blues, 0, nColors);
        if (nColors < 256 || nColors > 256) {
            throw new IOException("LUT not right number of colors: " + nColors);
        }
        f.close();
        return 256;
    }
}

