/*
 * Decompiled with CFR 0.152.
 */
package registration;

import bijnum.BIJmatrix;
import bijnum.BIJmi;
import numericalMethods.calculus.minimizing.nmPowell;
import registration.Register;
import registration.SearchMI;

public class RegisterMI
extends Register {
    protected float[] minmaxref;

    public RegisterMI() {
        this(null, 0, null);
    }

    public RegisterMI(float[] reference, int width) {
        this(reference, width, null);
    }

    public RegisterMI(float[] reference, int width, float[] mask) {
        this.reference = reference;
        this.mask = mask;
        this.minmaxref = BIJmatrix.minmax(reference);
    }

    @Override
    public float[] register(float[] a) {
        float[] minmaxim = BIJmatrix.minmax(a);
        float min = Math.min(minmaxim[0], this.minmaxref[0]);
        float max = Math.max(minmaxim[1], this.minmaxref[1]);
        float scale = BIJmi.getNiceScale(min, max);
        SearchMI function = new SearchMI(min, max, scale, this.reference, a, this.width);
        double[] p = new double[function.getDoubleArrayParameterLength()];
        p[0] = 0.0;
        p[1] = 0.0;
        p[2] = 0.0;
        function.setDoubleArrayParameter(p, 0);
        nmPowell.search(p, 0.01, function, function, 100, true);
        this.estimate = new float[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.estimate[i] = (float)p[i];
        }
        return this.estimate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.estimate.length; ++i) {
            sb.append(this.estimate[i]);
            sb.append("\t");
        }
        return sb.toString();
    }
}

