/*
 * Decompiled with CFR 0.152.
 */
package bvv.core;

import bvv.core.BigVolumeViewer;
import java.io.File;
import mpicbg.spim.data.SpimDataException;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Volume Rendering Tech Demo")
public class BigVolumeViewerCommand
implements Command {
    @Parameter(label="Select a BDV xml file", style="extensions:xml")
    private File xmlFile = new File("/Users/pietzsch/workspace/data/111010_weber_full.xml");
    @Parameter(label="Window width")
    private int windowWidth = 640;
    @Parameter(label="Window height")
    private int windowHeight = 480;
    @Parameter(label="Render width")
    private int renderWidth = 512;
    @Parameter(label="Render height")
    private int renderHeight = 512;
    @Parameter(label="Dither window size", choices={"none (always render full resolution)", "2x2", "3x3", "4x4", "5x5", "6x6", "7x7", "8x8"})
    private String dithering = "3x3";
    @Parameter(label="Number of dither samples", description="Pixels are interpolated from this many nearest neighbors when dithering. This is not very expensive, it's fine to turn it up to 8.", min="1", max="8", style="slider")
    private int numDitherSamples = 8;
    @Parameter(label="GPU cache tile size")
    private int cacheBlockSize = 32;
    @Parameter(label="GPU cache size (in MB)", description="The size of the GPU cache texture will match this as close as possible with the given tile size.")
    private int maxCacheSizeInMB = 300;
    @Parameter(label="Camera distance", description="Distance from camera to z=0 plane. In units of pixel width.")
    private double dCam = 2000.0;
    @Parameter(label="Clip distance", description="Visible depth away from z=0 in both directions. In units of pixel width. MUST BE SMALLER THAN CAMERA DISTANCE!")
    private double dClip = 1000.0;

    public void run() {
        int ditherWidth;
        String xmlFilename = this.xmlFile.getAbsolutePath();
        switch (this.dithering) {
            default: {
                ditherWidth = 1;
                break;
            }
            case "2x2": {
                ditherWidth = 2;
                break;
            }
            case "3x3": {
                ditherWidth = 3;
                break;
            }
            case "4x4": {
                ditherWidth = 4;
                break;
            }
            case "5x5": {
                ditherWidth = 5;
                break;
            }
            case "6x6": {
                ditherWidth = 6;
                break;
            }
            case "7x7": {
                ditherWidth = 7;
                break;
            }
            case "8x8": {
                ditherWidth = 8;
            }
        }
        try {
            BigVolumeViewer.run(xmlFilename, this.windowWidth, this.windowHeight, this.renderWidth, this.renderHeight, ditherWidth, this.numDitherSamples, this.cacheBlockSize, this.maxCacheSizeInMB, this.dCam, this.dClip);
        }
        catch (SpimDataException e) {
            throw new RuntimeException(e);
        }
    }
}

