/*
 * Decompiled with CFR 0.152.
 */
package bvv.core;

import bdv.TransformEventHandler;
import bdv.cache.CacheControl;
import bdv.ui.BdvDefaultCards;
import bdv.ui.CardPanel;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.splitpanel.SplitPanel;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.SourceAndConverter;
import bvv.core.BigVolumeViewer;
import bvv.core.VolumeViewerOptions;
import bvv.core.VolumeViewerPanel;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.MouseAndKeyHandler;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class VolumeViewerFrame
extends JFrame {
    private final VolumeViewerPanel viewer;
    private final CardPanel cards;
    private final SplitPanel splitPanel;
    private final InputActionBindings keybindings;
    private final TriggerBehaviourBindings triggerbindings;
    private final Behaviours transformBehaviours;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;

    public VolumeViewerFrame(List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cache, VolumeViewerOptions optional) {
        this(sources, numTimepoints, cache, new KeymapManager(BigVolumeViewer.configDir), new AppearanceManager(BigVolumeViewer.configDir), optional);
    }

    public VolumeViewerFrame(List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cacheControl, KeymapManager keymapManager, AppearanceManager appearanceManager, VolumeViewerOptions optional) {
        super("BigVolumeViewer");
        this.keymapManager = keymapManager;
        this.appearanceManager = appearanceManager;
        this.viewer = new VolumeViewerPanel(sources, numTimepoints, cacheControl, optional);
        this.keybindings = new InputActionBindings();
        this.triggerbindings = new TriggerBehaviourBindings();
        this.cards = new CardPanel();
        BdvDefaultCards.setup((CardPanel)this.cards, (AbstractViewerPanel)this.viewer, (ConverterSetups)this.viewer.getConverterSetups());
        this.splitPanel = new SplitPanel((AbstractViewerPanel)this.viewer, this.cards);
        this.getRootPane().setDoubleBuffered(true);
        this.add((Component)this.splitPanel, "Center");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VolumeViewerFrame.this.viewer.stop();
            }
        });
        SwingUtilities.replaceUIActionMap(this.getRootPane(), this.keybindings.getConcatenatedActionMap());
        SwingUtilities.replaceUIInputMap(this.getRootPane(), 1, this.keybindings.getConcatenatedInputMap());
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        mouseAndKeyHandler.setInputMap(this.triggerbindings.getConcatenatedInputTriggerMap());
        mouseAndKeyHandler.setBehaviourMap(this.triggerbindings.getConcatenatedBehaviourMap());
        mouseAndKeyHandler.setKeypressManager(optional.values.getKeyPressedManager(), this.viewer.getDisplay().getComponent());
        this.viewer.getDisplay().addHandler(mouseAndKeyHandler);
        this.transformBehaviours = new Behaviours((InputTriggerAdder.Factory)optional.values.getInputTriggerConfig(), new String[]{"bdv"});
        this.transformBehaviours.install(this.triggerbindings, "transform");
        TransformEventHandler tfHandler = this.viewer.getTransformEventHandler();
        tfHandler.install(this.transformBehaviours);
    }

    public VolumeViewerPanel getViewerPanel() {
        return this.viewer;
    }

    public CardPanel getCardPanel() {
        return this.cards;
    }

    public SplitPanel getSplitPanel() {
        return this.splitPanel;
    }

    public InputActionBindings getKeybindings() {
        return this.keybindings;
    }

    public TriggerBehaviourBindings getTriggerbindings() {
        return this.triggerbindings;
    }

    public Behaviours getTransformBehaviours() {
        return this.transformBehaviours;
    }

    public ConverterSetups getConverterSetups() {
        return this.viewer.getConverterSetups();
    }
}

