/*
 * Decompiled with CFR 0.152.
 */
package bvv.core;

import bdv.TransformEventHandler;
import bdv.TransformState;
import bdv.cache.CacheControl;
import bdv.tools.brightness.ConverterSetup;
import bdv.util.Prefs;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.DisplayMode;
import bdv.viewer.NavigationActions;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import bdv.viewer.VisibilityAndGrouping;
import bdv.viewer.animate.AbstractTransformAnimator;
import bdv.viewer.animate.MessageOverlayAnimator;
import bdv.viewer.animate.OverlayAnimator;
import bdv.viewer.animate.TextOverlayAnimator;
import bdv.viewer.overlay.MultiBoxOverlayRenderer;
import bdv.viewer.overlay.ScaleBarOverlayRenderer;
import bdv.viewer.overlay.SourceInfoOverlayRenderer;
import bdv.viewer.render.PainterThread;
import bdv.viewer.state.SourceGroup;
import bdv.viewer.state.ViewerState;
import bdv.viewer.state.XmlIoViewerState;
import bvv.core.InteractiveGLDisplayCanvas;
import bvv.core.VolumeViewerOptions;
import bvv.core.multires.SourceStacks;
import bvv.core.multires.Stack3D;
import bvv.core.offscreen.OffScreenFrameBuffer;
import bvv.core.offscreen.OffScreenFrameBufferWithDepth;
import bvv.core.render.RenderData;
import bvv.core.render.VolumeRenderer;
import bvv.core.util.MatrixMath;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.cache.iotiming.CacheIoTiming;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Element;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class VolumeViewerPanel
extends AbstractViewerPanel
implements OverlayRenderer,
PainterThread.Paintable,
ViewerStateChangeListener {
    protected final CacheControl cacheControl;
    private RenderScene renderScene;
    private final Repaint repaint = new Repaint();
    protected final OffScreenFrameBufferWithDepth sceneBuf;
    protected final OffScreenFrameBuffer offscreen;
    private final long[] iobudget = new long[]{100000000L, 10000000L};
    protected final int maxRenderMillis;
    protected final ViewerState state;
    private final ConverterSetups setups;
    protected final VolumeRenderer renderer;
    private final MultiBoxOverlayRenderer multiBoxOverlayRenderer;
    private final TransformEventHandler transformEventHandler;
    private final SourceInfoOverlayRenderer sourceInfoOverlayRenderer;
    private final ScaleBarOverlayRenderer scaleBarOverlayRenderer;
    protected final InteractiveGLDisplayCanvas<?> display;
    protected final JSlider sliderTime;
    private boolean blockSliderTimeEvents;
    protected ThreadGroup threadGroup;
    protected final PainterThread painterThread;
    protected final VisibilityAndGrouping visibilityAndGrouping;
    private final Listeners.List<TransformListener<AffineTransform3D>> transformListeners;
    private final Listeners.List<TransformListener<AffineTransform3D>> renderTransformListeners;
    protected final CopyOnWriteArrayList<TimePointListener> timePointListeners;
    protected AbstractTransformAnimator currentAnimator = null;
    protected final ArrayList<OverlayAnimator> overlayAnimators;
    protected final MessageOverlayAnimator msgOverlay;
    protected final VolumeViewerOptions.Values options;
    private final List<Stack3D<?>> renderStacks = new ArrayList();
    private final List<ConverterSetup> renderConverters = new ArrayList<ConverterSetup>();
    private final Matrix4f pv = new Matrix4f();
    private double dCam;
    private double dClipNear;
    private double dClipFar;
    private double screenWidth;
    private double screenHeight;
    private double maxAllowedStepInVoxels;
    private RenderData renderData;
    private final GLEventListener glEventListener = new GLEventListener(){

        public void init(GLAutoDrawable drawable) {
            GL3 gl = drawable.getGL().getGL3();
            VolumeViewerPanel.this.renderer.init(gl);
        }

        public void display(GLAutoDrawable drawable) {
            GL3 gl = drawable.getGL().getGL3();
            VolumeRenderer.RepaintType type = VolumeViewerPanel.this.repaint.getAndClear();
            if (type == VolumeRenderer.RepaintType.FULL) {
                VolumeViewerPanel.this.setRenderState();
                ((VolumeViewerPanel)VolumeViewerPanel.this).renderTransformListeners.list.forEach(l -> l.transformChanged((Object)VolumeViewerPanel.this.renderData.getRenderTransformWorldToScreen()));
            }
            if (type == VolumeRenderer.RepaintType.FULL || type == VolumeRenderer.RepaintType.SCENE) {
                VolumeViewerPanel.this.sceneBuf.bind(gl);
                gl.glEnable(2929);
                gl.glDepthFunc(513);
                if (VolumeViewerPanel.this.renderScene != null) {
                    VolumeViewerPanel.this.renderScene.render(gl, VolumeViewerPanel.this.renderData);
                }
                VolumeViewerPanel.this.sceneBuf.unbind(gl, false);
            }
            if (type == VolumeRenderer.RepaintType.FULL || type == VolumeRenderer.RepaintType.LOAD) {
                CacheIoTiming.getIoTimeBudget().reset(VolumeViewerPanel.this.iobudget);
                VolumeViewerPanel.this.cacheControl.prepareNextFrame();
            }
            VolumeViewerPanel.this.offscreen.bind(gl, false);
            gl.glDisable(2929);
            VolumeViewerPanel.this.sceneBuf.drawQuad(gl);
            VolumeRenderer.RepaintType rerender = VolumeViewerPanel.this.renderer.draw(gl, type, VolumeViewerPanel.this.sceneBuf, VolumeViewerPanel.this.renderStacks, VolumeViewerPanel.this.renderConverters, VolumeViewerPanel.this.pv, VolumeViewerPanel.this.maxRenderMillis, VolumeViewerPanel.this.maxAllowedStepInVoxels);
            VolumeViewerPanel.this.repaint.request(rerender);
            VolumeViewerPanel.this.offscreen.unbind(gl, false);
            VolumeViewerPanel.this.offscreen.drawQuad(gl);
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        }

        public void dispose(GLAutoDrawable drawable) {
        }
    };

    public void setRenderScene(RenderScene renderScene) {
        this.renderScene = renderScene;
    }

    public VolumeViewerPanel(List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cacheControl, VolumeViewerOptions optional) {
        super((LayoutManager)new BorderLayout(), false);
        int i;
        this.options = optional.values;
        boolean useGLJPanel = true;
        this.cacheControl = cacheControl;
        int numGroups = this.options.getNumSourceGroups();
        ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>(numGroups);
        for (i = 0; i < numGroups; ++i) {
            groups.add(new SourceGroup("group " + Integer.toString(i + 1)));
        }
        this.state = new ViewerState(sources, groups, numTimepoints);
        for (i = Math.min(numGroups, sources.size()) - 1; i >= 0; --i) {
            ((SourceGroup)this.state.getSourceGroups().get(i)).addSource(i);
        }
        if (!sources.isEmpty()) {
            this.state.setCurrentSource(0);
        }
        this.multiBoxOverlayRenderer = new MultiBoxOverlayRenderer();
        this.sourceInfoOverlayRenderer = new SourceInfoOverlayRenderer();
        this.scaleBarOverlayRenderer = new ScaleBarOverlayRenderer();
        this.setups = new ConverterSetups((bdv.viewer.ViewerState)this.state());
        this.setups.listeners().add(s -> this.requestRepaint());
        this.threadGroup = new ThreadGroup(this.toString());
        this.painterThread = new PainterThread(this.threadGroup, (PainterThread.Paintable)this);
        this.painterThread.setDaemon(true);
        this.transformEventHandler = this.options.getTransformEventHandlerFactory().create(TransformState.from(arg_0 -> ((SynchronizedViewerState)this.state()).getViewerTransform(arg_0), arg_0 -> ((SynchronizedViewerState)this.state()).setViewerTransform(arg_0)));
        int renderWidth = this.options.getRenderWidth();
        int renderHeight = this.options.getRenderHeight();
        this.sceneBuf = new OffScreenFrameBufferWithDepth(renderWidth, renderHeight, 32849);
        this.offscreen = new OffScreenFrameBuffer(renderWidth, renderHeight, 32849, false, true);
        this.maxRenderMillis = this.options.getMaxRenderMillis();
        this.renderer = new VolumeRenderer(renderWidth, renderHeight, this.options.getDitherWidth(), VolumeViewerPanel.getDitherStep(this.options.getDitherWidth()), this.options.getNumDitherSamples(), this.options.getCacheBlockSize(), this.options.getMaxCacheSizeInMB());
        this.dCam = this.options.getDCam();
        this.dClipNear = this.options.getDClipNear();
        this.dClipFar = this.options.getDClipFar();
        this.screenWidth = this.options.getWidth();
        this.screenHeight = this.options.getHeight();
        this.maxAllowedStepInVoxels = this.options.getMaxAllowedStepInVoxels();
        this.display = InteractiveGLDisplayCanvas.createGLJPanel(this.options.getWidth(), this.options.getHeight());
        this.display.setTransformEventHandler(this.transformEventHandler);
        this.display.addGLEventListener(this.glEventListener);
        this.display.overlays().add((Object)this);
        this.display.addHandler(this.mouseCoordinates);
        this.sliderTime = new JSlider(0, 0, numTimepoints - 1, 0);
        this.sliderTime.addChangeListener(e -> {
            if (!this.blockSliderTimeEvents) {
                this.setTimepoint(this.sliderTime.getValue());
            }
        });
        this.add((Component)this.display.getComponent(), "Center");
        if (numTimepoints > 1) {
            this.add(this.sliderTime, "South");
        }
        this.setFocusable(false);
        this.visibilityAndGrouping = new VisibilityAndGrouping(this.state);
        this.transformListeners = new Listeners.SynchronizedList(l -> l.transformChanged((Object)this.state().getViewerTransform()));
        this.renderTransformListeners = new Listeners.SynchronizedList(l -> {
            if (this.renderData != null) {
                l.transformChanged((Object)this.renderData.getRenderTransformWorldToScreen());
            }
        });
        this.timePointListeners = new CopyOnWriteArrayList();
        this.msgOverlay = this.options.getMsgOverlay();
        this.overlayAnimators = new ArrayList();
        this.overlayAnimators.add((OverlayAnimator)this.msgOverlay);
        this.overlayAnimators.add((OverlayAnimator)new TextOverlayAnimator("Press <F1> for help.", 3000L, TextOverlayAnimator.TextPosition.CENTER));
        ((Component)this.display.getComponent()).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VolumeViewerPanel.this.requestRepaint();
                ((Component)VolumeViewerPanel.this.display.getComponent()).removeComponentListener(this);
            }
        });
        this.state.getState().changeListeners().add((Object)this);
        this.painterThread.start();
    }

    @Deprecated
    public void addSource(SourceAndConverter<?> sourceAndConverter) {
        this.state().addSource(sourceAndConverter);
        this.state().setSourceActive(sourceAndConverter, true);
    }

    @Deprecated
    public void addSources(Collection<SourceAndConverter<?>> sourceAndConverter) {
        this.state().addSources(sourceAndConverter);
    }

    @Deprecated
    private SourceAndConverter<?> soc(Source<?> source) {
        for (SourceAndConverter soc : this.state().getSources()) {
            if (soc.getSpimSource() != source) continue;
            return soc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeSource(Source<?> source) {
        SynchronizedViewerState synchronizedViewerState = this.state();
        synchronized (synchronizedViewerState) {
            this.state().removeSource(this.soc(source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeSources(Collection<Source<?>> sources) {
        SynchronizedViewerState synchronizedViewerState = this.state();
        synchronized (synchronizedViewerState) {
            this.state().removeSources((Collection)sources.stream().map(this::soc).collect(Collectors.toList()));
        }
    }

    @Deprecated
    public void removeAllSources() {
        this.state().clearSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addGroup(SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state();
        synchronized (synchronizedViewerState) {
            this.state.addGroup(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeGroup(SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state();
        synchronized (synchronizedViewerState) {
            this.state.removeGroup(group);
        }
    }

    public void displayToGlobalCoordinates(double[] gPos) {
        assert (gPos.length >= 3);
        this.state().getViewerTransform().applyInverse(gPos, gPos);
    }

    public <P extends RealLocalizable & RealPositionable> void displayToGlobalCoordinates(P gPos) {
        assert (gPos.numDimensions() >= 3);
        this.state().getViewerTransform().applyInverse((RealPositionable)gPos, gPos);
    }

    public void displayToGlobalCoordinates(double x, double y, RealPositionable gPos) {
        assert (gPos.numDimensions() >= 3);
        RealPoint lPos = new RealPoint(3);
        lPos.setPosition(x, 0);
        lPos.setPosition(y, 1);
        this.state().getViewerTransform().applyInverse(gPos, (RealLocalizable)lPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint() {
        this.display.display();
        VolumeViewerPanel volumeViewerPanel = this;
        synchronized (volumeViewerPanel) {
            if (this.currentAnimator != null) {
                AffineTransform3D transform = this.currentAnimator.getCurrent(System.currentTimeMillis());
                this.state().setViewerTransform(transform);
                if (this.currentAnimator.isComplete()) {
                    this.currentAnimator = null;
                } else {
                    this.requestRepaint(VolumeRenderer.RepaintType.NONE);
                }
            }
        }
    }

    public void requestRepaint() {
        this.repaint.request(VolumeRenderer.RepaintType.FULL);
    }

    public void requestRepaint(VolumeRenderer.RepaintType type) {
        this.repaint.request(type);
    }

    protected void onMouseMoved() {
        if (Prefs.showTextOverlay()) {
            this.getDisplayComponent().repaint();
        }
    }

    public void drawOverlays(Graphics g) {
        boolean requiresRepaint = false;
        if (Prefs.showMultibox()) {
            this.multiBoxOverlayRenderer.setViewerState((bdv.viewer.ViewerState)this.state());
            this.multiBoxOverlayRenderer.updateVirtualScreenSize(this.display.getWidth(), this.display.getHeight());
            this.multiBoxOverlayRenderer.paint((Graphics2D)g);
            requiresRepaint = this.multiBoxOverlayRenderer.isHighlightInProgress();
        }
        if (Prefs.showTextOverlay()) {
            this.sourceInfoOverlayRenderer.setViewerState((bdv.viewer.ViewerState)this.state());
            this.sourceInfoOverlayRenderer.setSourceNameOverlayPosition(Prefs.sourceNameOverlayPosition());
            this.sourceInfoOverlayRenderer.paint((Graphics2D)g);
            RealPoint gPos = new RealPoint(3);
            this.getGlobalMouseCoordinates((RealPositionable)gPos);
            String mousePosGlobalString = String.format("(%6.1f,%6.1f,%6.1f)", gPos.getDoublePosition(0), gPos.getDoublePosition(1), gPos.getDoublePosition(2));
            g.setFont(new Font("Monospaced", 0, 12));
            g.setColor(Color.white);
            g.drawString(mousePosGlobalString, (int)g.getClipBounds().getWidth() - 170, 25);
        }
        if (Prefs.showScaleBar()) {
            this.scaleBarOverlayRenderer.setViewerState((bdv.viewer.ViewerState)this.state());
            this.scaleBarOverlayRenderer.paint((Graphics2D)g);
        }
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<OverlayAnimator> overlayAnimatorsToRemove = new ArrayList<OverlayAnimator>();
        for (OverlayAnimator animator : this.overlayAnimators) {
            animator.paint((Graphics2D)g, currentTimeMillis);
            requiresRepaint |= animator.requiresRepaint();
            if (!animator.isComplete()) continue;
            overlayAnimatorsToRemove.add(animator);
        }
        this.overlayAnimators.removeAll(overlayAnimatorsToRemove);
        if (requiresRepaint) {
            this.getDisplayComponent().repaint();
        }
    }

    public void viewerStateChanged(ViewerStateChange change) {
        switch (change) {
            case CURRENT_SOURCE_CHANGED: {
                this.multiBoxOverlayRenderer.highlight(this.state().getSources().indexOf(this.state().getCurrentSource()));
                this.getDisplayComponent().repaint();
                break;
            }
            case DISPLAY_MODE_CHANGED: {
                this.showMessage(this.state().getDisplayMode().getName());
                this.getDisplayComponent().repaint();
                break;
            }
            case GROUP_NAME_CHANGED: {
                this.getDisplayComponent().repaint();
                break;
            }
            case CURRENT_GROUP_CHANGED: {
                break;
            }
            case SOURCE_ACTIVITY_CHANGED: {
                break;
            }
            case GROUP_ACTIVITY_CHANGED: {
                break;
            }
            case VISIBILITY_CHANGED: {
                this.requestRepaint();
                break;
            }
            case NUM_TIMEPOINTS_CHANGED: {
                int numTimepoints = this.state().getNumTimepoints();
                int timepoint = Math.max(0, Math.min(this.state.getCurrentTimepoint(), numTimepoints - 1));
                SwingUtilities.invokeLater(() -> {
                    boolean sliderVisible = Arrays.asList(this.getComponents()).contains(this.sliderTime);
                    if (numTimepoints > 1 && !sliderVisible) {
                        this.add(this.sliderTime, "South");
                    } else if (numTimepoints == 1 && sliderVisible) {
                        this.remove(this.sliderTime);
                    }
                    this.sliderTime.setModel(new DefaultBoundedRangeModel(timepoint, 0, 0, numTimepoints - 1));
                    this.revalidate();
                });
                break;
            }
            case CURRENT_TIMEPOINT_CHANGED: {
                int timepoint = this.state().getCurrentTimepoint();
                SwingUtilities.invokeLater(() -> {
                    this.blockSliderTimeEvents = true;
                    if (this.sliderTime.getValue() != timepoint) {
                        this.sliderTime.setValue(timepoint);
                    }
                    this.blockSliderTimeEvents = false;
                });
                for (TimePointListener l2 : this.timePointListeners) {
                    l2.timePointChanged(timepoint);
                }
                this.requestRepaint();
                break;
            }
            case VIEWER_TRANSFORM_CHANGED: {
                AffineTransform3D transform = this.state().getViewerTransform();
                this.transformListeners.list.forEach(l -> l.transformChanged((Object)transform));
                this.requestRepaint();
            }
        }
    }

    public synchronized void setTransformAnimator(AbstractTransformAnimator animator) {
        this.currentAnimator = animator;
        this.currentAnimator.setTime(System.currentTimeMillis());
        this.requestRepaint();
    }

    public synchronized void setDisplayMode(DisplayMode displayMode) {
        this.state().setDisplayMode(displayMode);
    }

    @Deprecated
    public void setCurrentViewerTransform(AffineTransform3D viewerTransform) {
        this.state().setViewerTransform(viewerTransform);
    }

    public synchronized void setTimepoint(int timepoint) {
        this.state().setCurrentTimepoint(timepoint);
    }

    public synchronized void nextTimePoint() {
        NavigationActions.nextTimePoint((bdv.viewer.ViewerState)this.state());
    }

    public synchronized void previousTimePoint() {
        NavigationActions.previousTimePoint((bdv.viewer.ViewerState)this.state());
    }

    public void setNumTimepoints(int numTimepoints) {
        this.state().setNumTimepoints(numTimepoints);
    }

    @Deprecated
    public ViewerState getState() {
        return this.state.copy();
    }

    public SynchronizedViewerState state() {
        return this.state.getState();
    }

    public InteractiveGLDisplayCanvas<?> getDisplay() {
        return this.display;
    }

    public Component getDisplayComponent() {
        return this.display.getComponent();
    }

    public TransformEventHandler getTransformEventHandler() {
        return this.transformEventHandler;
    }

    public ConverterSetups getConverterSetups() {
        return this.setups;
    }

    public void showMessage(String msg) {
        this.msgOverlay.add(msg);
        this.getDisplayComponent().repaint();
    }

    public void addOverlayAnimator(OverlayAnimator animator) {
        this.overlayAnimators.add(animator);
        this.getDisplayComponent().repaint();
    }

    public Listeners<TransformListener<AffineTransform3D>> transformListeners() {
        return this.transformListeners;
    }

    public Listeners<TransformListener<AffineTransform3D>> renderTransformListeners() {
        return this.renderTransformListeners;
    }

    public void addTimePointListener(TimePointListener listener) {
        this.addTimePointListener(listener, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimePointListener(TimePointListener listener, int index) {
        CopyOnWriteArrayList<TimePointListener> copyOnWriteArrayList = this.timePointListeners;
        synchronized (copyOnWriteArrayList) {
            int s = this.timePointListeners.size();
            this.timePointListeners.add(index < 0 ? 0 : (index > s ? s : index), listener);
            listener.timePointChanged(this.state.getCurrentTimepoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimePointListener(TimePointListener listener) {
        CopyOnWriteArrayList<TimePointListener> copyOnWriteArrayList = this.timePointListeners;
        synchronized (copyOnWriteArrayList) {
            this.timePointListeners.remove(listener);
        }
    }

    private static int getDitherStep(int ditherWidth) {
        int[] ditherSteps = new int[]{0, 1, 3, 5, 9, 11, 19, 23, 29};
        if (ditherWidth >= ditherSteps.length) {
            throw new IllegalArgumentException("unsupported dither width");
        }
        return ditherSteps[ditherWidth];
    }

    public void setCamParams(double dCam, double dClip) {
        this.setCamParams(dCam, dClip, dClip);
    }

    public void setCamParams(double dCam, double dClipNear, double dClipFar) {
        this.dCam = dCam;
        this.dClipNear = dClipNear;
        this.dClipFar = dClipFar;
    }

    public void setMaxAllowedStepInVoxels(double maxAllowedStepInVoxels) {
        this.maxAllowedStepInVoxels = maxAllowedStepInVoxels;
    }

    public void setCanvasSize(int width, int height) {
        this.setScreenSize(width, height);
    }

    private void setScreenSize(double screenWidth, double screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRenderState() {
        SynchronizedViewerState state;
        SynchronizedViewerState synchronizedViewerState = state = this.state();
        synchronized (synchronizedViewerState) {
            int currentTimepoint = state.getCurrentTimepoint();
            Set visibleSources = state.getVisibleAndPresentSources();
            AffineTransform3D renderTransformWorldToScreen = state.getViewerTransform();
            Matrix4f view = MatrixMath.affine(renderTransformWorldToScreen, new Matrix4f());
            MatrixMath.screenPerspective(this.dCam, this.dClipNear, this.dClipFar, this.screenWidth, this.screenHeight, 0.0, this.pv).mul((Matrix4fc)view);
            this.renderStacks.clear();
            this.renderConverters.clear();
            for (SourceAndConverter source : visibleSources) {
                ConverterSetup converter = this.setups.getConverterSetup(source);
                if (source.asVolatile() != null) {
                    source = source.asVolatile();
                }
                Stack3D stack3D = SourceStacks.getStack3D(source.getSpimSource(), currentTimepoint);
                this.renderStacks.add(stack3D);
                this.renderConverters.add(converter);
            }
            this.renderData = new RenderData((Matrix4fc)this.pv, currentTimepoint, renderTransformWorldToScreen, this.dCam, this.dClipNear, this.dClipFar, this.screenWidth, this.screenHeight);
        }
    }

    public synchronized Element stateToXml() {
        return new XmlIoViewerState().toXml(this.state);
    }

    public synchronized void stateFromXml(Element parent) {
        XmlIoViewerState io = new XmlIoViewerState();
        io.restoreFromXml(parent.getChild(io.getTagName()), this.state);
    }

    @Deprecated
    public VisibilityAndGrouping getVisibilityAndGrouping() {
        return this.visibilityAndGrouping;
    }

    public VolumeViewerOptions.Values getOptionValues() {
        return this.options;
    }

    public InputTriggerConfig getInputTriggerConfig() {
        return this.options.getInputTriggerConfig();
    }

    public SourceInfoOverlayRenderer getSourceInfoOverlayRenderer() {
        return this.sourceInfoOverlayRenderer;
    }

    public void stop() {
        this.painterThread.interrupt();
        try {
            this.painterThread.join(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.state.kill();
    }

    private class Repaint {
        private VolumeRenderer.RepaintType type = VolumeRenderer.RepaintType.FULL;

        protected Repaint() {
        }

        protected synchronized void request(VolumeRenderer.RepaintType type) {
            if (this.type.ordinal() < type.ordinal()) {
                this.type = type;
                VolumeViewerPanel.this.painterThread.requestRepaint();
            }
        }

        protected synchronized VolumeRenderer.RepaintType getAndClear() {
            VolumeRenderer.RepaintType t = this.type;
            this.type = VolumeRenderer.RepaintType.NONE;
            return t;
        }
    }

    public static interface RenderScene {
        public void render(GL3 var1, RenderData var2);
    }
}

