/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.backend.jogl;

import bvv.core.backend.GpuContext;
import bvv.core.backend.SetUniforms;
import bvv.core.backend.StagingBuffer;
import bvv.core.backend.Texture;
import bvv.core.backend.Texture3D;
import bvv.core.backend.jogl.JoglSetUniforms;
import bvv.core.shadergen.Shader;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class JoglGpuContext
implements GpuContext {
    private static Map<GL3, JoglGpuContext> contexts = new HashMap<GL3, JoglGpuContext>();
    private final GL3 gl;
    private final Map<Shader, ShaderProgram> shaders = new WeakHashMap<Shader, ShaderProgram>();
    private final Map<StagingBuffer, Integer> pbos = new WeakHashMap<StagingBuffer, Integer>();
    private final Map<Texture, TexId> textures = new WeakHashMap<Texture, TexId>();

    @Override
    public void use(Shader shader) {
        ShaderProgram prog = this.getShaderProgram(shader);
        this.gl.glUseProgram(prog.program());
    }

    @Override
    public SetUniforms getUniformSetter(Shader shader) {
        ShaderProgram prog = this.getShaderProgram(shader);
        return new JoglSetUniforms((GL2ES2)this.gl, prog.program());
    }

    @Override
    public int bindStagingBuffer(StagingBuffer stagingBuffer) {
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(35055, tmp, 0);
        int restoreId = tmp[0];
        this.gl.glBindBuffer(35052, this.getPboId(stagingBuffer));
        return restoreId;
    }

    @Override
    public int bindStagingBufferId(int id) {
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(35055, tmp, 0);
        int restoreId = tmp[0];
        this.gl.glBindBuffer(35052, id);
        return restoreId;
    }

    @Override
    public int bindTexture(Texture texture) {
        TexId texId = this.getTextureId(texture);
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(texId.binding, tmp, 0);
        int restoreId = tmp[0];
        this.gl.glBindTexture(texId.target, texId.id);
        return restoreId;
    }

    @Override
    public void bindTexture(Texture texture, int unit) {
        TexId texId = this.getTextureId(texture);
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(34016, tmp, 0);
        int restoreActiveTextureId = tmp[0];
        this.gl.glActiveTexture(33984 + unit);
        this.gl.glGetIntegerv(texId.binding, tmp, 0);
        int restoreId = tmp[0];
        this.gl.glBindTexture(texId.target, texId.id);
    }

    @Override
    public int bindTextureId(int id, int numTexDimensions) {
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(JoglGpuContext.targetBinding(numTexDimensions), tmp, 0);
        int restoreId = tmp[0];
        this.gl.glBindTexture(JoglGpuContext.target(numTexDimensions), id);
        return restoreId;
    }

    @Override
    public Buffer map(StagingBuffer stagingBuffer) {
        int pboId = this.getPboId(stagingBuffer);
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(35055, tmp, 0);
        int restoreId = tmp[0];
        if (restoreId != pboId) {
            this.gl.glBindBuffer(35052, pboId);
        }
        this.gl.glBufferData(35052, (long)stagingBuffer.getSizeInBytes(), null, 35040);
        ByteBuffer buffer = this.gl.glMapBuffer(35052, 35001);
        if (restoreId != pboId) {
            this.gl.glBindBuffer(35052, restoreId);
        }
        return buffer;
    }

    @Override
    public void unmap(StagingBuffer stagingBuffer) {
        int pboId = this.getPboId(stagingBuffer);
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(35055, tmp, 0);
        int restoreId = tmp[0];
        if (restoreId != pboId) {
            this.gl.glBindBuffer(35052, pboId);
        }
        this.gl.glUnmapBuffer(35052);
        if (restoreId != pboId) {
            this.gl.glBindBuffer(35052, restoreId);
        }
    }

    @Override
    public void delete(Texture texture) {
        TexId texId = this.textures.remove(texture);
        if (texId != null) {
            this.gl.glDeleteTextures(1, new int[]{texId.id}, 0);
        }
    }

    @Override
    public void texSubImage3D(StagingBuffer stagingBuffer, Texture3D texture, int xoffset, int yoffset, int zoffset, int width, int height, int depth, long pixels_buffer_offset) {
        int pboId = this.getPboId(stagingBuffer);
        int textureId = this.getTextureId((Texture)texture).id;
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(35055, tmp, 0);
        int restorePboId = tmp[0];
        this.gl.glGetIntegerv(32874, tmp, 0);
        int restoreTextureId = tmp[0];
        if (restorePboId != pboId) {
            this.gl.glBindBuffer(35052, pboId);
        }
        if (restoreTextureId != textureId) {
            this.gl.glBindTexture(32879, textureId);
        }
        this.gl.glTexSubImage3D(32879, 0, xoffset, yoffset, zoffset, width, height, depth, JoglGpuContext.format(texture), JoglGpuContext.type(texture), pixels_buffer_offset);
        if (restorePboId != pboId) {
            this.gl.glBindBuffer(35052, restorePboId);
        }
        if (restoreTextureId != textureId) {
            this.gl.glBindTexture(32879, restoreTextureId);
        }
    }

    @Override
    public void texSubImage3D(Texture3D texture, int xoffset, int yoffset, int zoffset, int width, int height, int depth, Buffer pixels) {
        int textureId = this.getTextureId((Texture)texture).id;
        int[] tmp = new int[1];
        this.gl.glGetIntegerv(32874, tmp, 0);
        int restoreTextureId = tmp[0];
        if (restoreTextureId != textureId) {
            this.gl.glBindTexture(32879, textureId);
        }
        this.gl.glTexSubImage3D(32879, 0, xoffset, yoffset, zoffset, width, height, depth, JoglGpuContext.format(texture), JoglGpuContext.type(texture), pixels);
        if (restoreTextureId != textureId) {
            this.gl.glBindTexture(32879, restoreTextureId);
        }
    }

    public static JoglGpuContext get(GL3 gl) {
        return contexts.computeIfAbsent(gl, JoglGpuContext::new);
    }

    public int getPboIdHack(StagingBuffer stagingBuffer) {
        return this.pbos.get(stagingBuffer);
    }

    public int getTextureIdHack(Texture texture) {
        return this.textures.get((Object)texture).id;
    }

    public int getProgramIdHack(Shader shader) {
        return this.shaders.get(shader).program();
    }

    private JoglGpuContext(GL3 gl) {
        this.gl = gl;
    }

    private ShaderProgram getShaderProgram(Shader shader) {
        return this.shaders.computeIfAbsent(shader, s -> {
            ShaderCode vs = new ShaderCode(35633, 1, (CharSequence[][])new CharSequence[][]{{s.getVertexShaderCode()}});
            ShaderCode fs = new ShaderCode(35632, 1, (CharSequence[][])new CharSequence[][]{{s.getFragmentShaderCode()}});
            vs.defaultShaderCustomization((GL2ES2)this.gl, true, false);
            fs.defaultShaderCustomization((GL2ES2)this.gl, true, false);
            ShaderProgram prog = new ShaderProgram();
            prog.add(vs);
            prog.add(fs);
            prog.link((GL2ES2)this.gl, System.err);
            vs.destroy((GL2ES2)this.gl);
            fs.destroy((GL2ES2)this.gl);
            return prog;
        });
    }

    private int getPboId(StagingBuffer stagingBuffer) {
        return this.pbos.computeIfAbsent(stagingBuffer, o -> {
            int[] tmp = new int[1];
            this.gl.glGenBuffers(1, tmp, 0);
            return tmp[0];
        });
    }

    private TexId getTextureId(Texture texture) {
        return this.textures.computeIfAbsent(texture, tex -> {
            int[] tmp = new int[1];
            this.gl.glGenTextures(1, tmp, 0);
            int id = tmp[0];
            int target = JoglGpuContext.target(tex);
            this.gl.glGetIntegerv(JoglGpuContext.targetBinding(tex), tmp, 0);
            int restoreId = tmp[0];
            this.gl.glBindTexture(target, id);
            this.gl.glTexStorage3D(target, 1, JoglGpuContext.internalFormat(tex), tex.texWidth(), tex.texHeight(), tex.texDepth());
            this.gl.glTexParameteri(target, 10241, JoglGpuContext.minFilter(tex));
            this.gl.glTexParameteri(target, 10240, JoglGpuContext.magFilter(tex));
            this.gl.glTexParameteri(target, 10242, JoglGpuContext.wrap(tex));
            if (tex.texDims() > 1) {
                this.gl.glTexParameteri(target, 10243, JoglGpuContext.wrap(tex));
            }
            if (tex.texDims() > 2) {
                this.gl.glTexParameteri(target, 32882, JoglGpuContext.wrap(tex));
            }
            if (tex.texWrap() == Texture.Wrap.CLAMP_TO_BORDER_ZERO) {
                this.gl.glTexParameterfv(target, 4100, new float[4], 1);
            }
            this.gl.glBindTexture(target, restoreId);
            return new TexId(id, target, JoglGpuContext.targetBinding(texture));
        });
    }

    public void registerTexture(Texture texture, int id) {
        this.textures.computeIfAbsent(texture, tex -> {
            int[] tmp = new int[1];
            int target = JoglGpuContext.target(tex);
            this.gl.glGetIntegerv(JoglGpuContext.targetBinding(tex), tmp, 0);
            int restoreId = tmp[0];
            this.gl.glBindTexture(target, id);
            this.gl.glTexParameteri(target, 10241, JoglGpuContext.minFilter(tex));
            this.gl.glTexParameteri(target, 10240, JoglGpuContext.magFilter(tex));
            this.gl.glTexParameteri(target, 10242, JoglGpuContext.wrap(tex));
            if (tex.texDims() > 1) {
                this.gl.glTexParameteri(target, 10243, JoglGpuContext.wrap(tex));
            }
            if (tex.texDims() > 2) {
                this.gl.glTexParameteri(target, 32882, JoglGpuContext.wrap(tex));
            }
            this.gl.glBindTexture(target, restoreId);
            return new TexId(id, target, JoglGpuContext.targetBinding(texture));
        });
    }

    private static int target(Texture texture) {
        return JoglGpuContext.target(texture.texDims());
    }

    private static int target(int numTexDimensions) {
        switch (numTexDimensions) {
            case 1: {
                return 3552;
            }
            case 2: {
                return 3553;
            }
            case 3: {
                return 32879;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int targetBinding(Texture texture) {
        return JoglGpuContext.targetBinding(texture.texDims());
    }

    private static int targetBinding(int numTexDimensions) {
        switch (numTexDimensions) {
            case 1: {
                return 32872;
            }
            case 2: {
                return 32873;
            }
            case 3: {
                return 32874;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int internalFormat(Texture texture) {
        switch (texture.texInternalFormat()) {
            case R8: {
                return 33321;
            }
            case R16: {
                return 33322;
            }
            case RGBA8: {
                return 32856;
            }
            case RGBA8UI: {
                return 36220;
            }
            case R32F: {
                return 33326;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int format(Texture texture) {
        switch (texture.texInternalFormat()) {
            case R8: {
                return 6403;
            }
            case R16: {
                return 6403;
            }
            case RGBA8: {
                return 6408;
            }
            case RGBA8UI: {
                return 36249;
            }
            case R32F: {
                return 6403;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int type(Texture texture) {
        switch (texture.texInternalFormat()) {
            case R8: {
                return 5121;
            }
            case R16: {
                return 5123;
            }
            case RGBA8: {
                return 5121;
            }
            case RGBA8UI: {
                return 5121;
            }
            case R32F: {
                return 5126;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int magFilter(Texture texture) {
        switch (texture.texMagFilter()) {
            case NEAREST: {
                return 9728;
            }
            case LINEAR: {
                return 9729;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int minFilter(Texture texture) {
        switch (texture.texMinFilter()) {
            case NEAREST: {
                return 9728;
            }
            case LINEAR: {
                return 9729;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int wrap(Texture texture) {
        switch (texture.texWrap()) {
            case CLAMP_TO_EDGE: {
                return 33071;
            }
            case CLAMP_TO_BORDER_ZERO: {
                return 33069;
            }
            case REPEAT: {
                return 10497;
            }
        }
        throw new IllegalArgumentException();
    }

    private static class TexId {
        int id;
        int target;
        int binding;

        TexId(int id, int target, int binding) {
            this.id = id;
            this.target = target;
            this.binding = binding;
        }
    }
}

