/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blockmath;

import bvv.core.blockmath.RequiredBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;

public class RequiredBlocks {
    private final int n;
    private final ArrayList<int[]> gridPositions;
    private final ArrayList<RequiredBlock> blocks;
    private final int[] min;
    private final int[] max;

    public RequiredBlocks(int numDimensions) {
        this.n = numDimensions;
        this.gridPositions = new ArrayList();
        this.blocks = new ArrayList();
        this.min = new int[this.n];
        this.max = new int[this.n];
        Arrays.fill(this.min, Integer.MAX_VALUE);
        Arrays.fill(this.max, Integer.MIN_VALUE);
    }

    public void add(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = Math.min(this.min[d], pos[d]);
            this.max[d] = Math.max(this.max[d], pos[d]);
        }
        this.gridPositions.add(pos);
        this.blocks.add(new RequiredBlock(pos, -1));
    }

    public void add(Localizable pos) {
        int[] p = new int[this.n];
        pos.localize(p);
        this.add(p);
    }

    public List<int[]> getGridPositions() {
        return this.gridPositions;
    }

    public List<RequiredBlock> getBlocks() {
        return this.blocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequiredBlocks( ");
        sb.append(String.format("(%d, %d, %d) .. (%d, %d, %d) ", this.min[0], this.min[1], this.min[2], this.max[0], this.max[1], this.max[2]));
        sb.append("size = ");
        sb.append(this.gridPositions.size());
        return sb.toString();
    }

    public int[] getMin() {
        return this.min;
    }

    public int[] getMax() {
        return this.max;
    }
}

