/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blocks;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public class ByteUtils {
    private static final Unsafe UNSAFE;
    private static final long BUFFER_ADDRESS_OFFSET;
    private static final long BYTE_ARRAY_OFFSET;
    private static final long SHORT_ARRAY_OFFSET;

    public static long addressOf(Buffer buffer) {
        return UNSAFE.getLong(buffer, BUFFER_ADDRESS_OFFSET);
    }

    public static void copyShorts(short[] src, long dst, long sox, long csx) {
        UNSAFE.copyMemory(src, SHORT_ARRAY_OFFSET + 2L * sox, null, dst, 2L * csx);
    }

    public static void setShorts(short src, long dst, long csx) {
        int i = 0;
        while ((long)i < csx) {
            UNSAFE.putShort(dst + (long)(2 * i), src);
            ++i;
        }
    }

    public static void setBytes(byte src, long dst, long csx) {
        UNSAFE.setMemory(dst, csx, src);
    }

    static {
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
            };
            UNSAFE = AccessController.doPrivileged(action);
            Field bufferAddressField = Buffer.class.getDeclaredField("address");
            BUFFER_ADDRESS_OFFSET = UNSAFE.objectFieldOffset(bufferAddressField);
            BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            SHORT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static interface Address {
        public long getAddress();
    }
}

