/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.cache;

import bvv.core.cache.FillTask;
import bvv.core.cache.ImageBlockKey;
import bvv.core.cache.TextureCache;
import bvv.core.cache.UploadBuffer;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public class DefaultFillTask
implements FillTask {
    final ImageBlockKey<?> key;
    final Predicate<UploadBuffer> fill;
    final BooleanSupplier containsData;

    public DefaultFillTask(ImageBlockKey<?> key, Predicate<UploadBuffer> fill, BooleanSupplier containsData) {
        this.key = key;
        this.fill = fill;
        this.containsData = containsData;
    }

    @Override
    public ImageBlockKey<?> getKey() {
        return this.key;
    }

    @Override
    public boolean containsData() {
        return this.containsData.getAsBoolean();
    }

    @Override
    public void fill(UploadBuffer buffer) {
        boolean complete = this.fill.test(buffer);
        buffer.setContentState(complete ? TextureCache.ContentState.COMPLETE : TextureCache.ContentState.INCOMPLETE);
    }
}

