/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.cache;

import bvv.core.backend.Texture;
import bvv.core.backend.Texture3D;
import bvv.core.blocks.ByteUtils;
import bvv.core.cache.CacheSpec;
import bvv.core.cache.DefaultFillTask;
import bvv.core.cache.FillTask;
import bvv.core.cache.ImageBlockKey;
import bvv.core.cache.UploadBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.util.Intervals;

public class TextureCache
implements Texture3D {
    private final int texWidth;
    private final int texHeight;
    private final int texDepth;
    private final int[] dimensions;
    private final CacheSpec spec;
    private final Tile[] tiles;
    private final ArrayList<Tile> lruOrdered = new ArrayList();
    private final int numUnblockedTiles;
    private final Map<ImageBlockKey<?>, Tile> tilemap = new ConcurrentHashMap();
    private static final AtomicInteger timestampGen = new AtomicInteger();
    private boolean blockedTileInitialized = false;
    private static final Comparator<Tile> lruComparator = new Comparator<Tile>(){

        @Override
        public int compare(Tile t1, Tile t2) {
            int dlru = t1.lru - t2.lru;
            if (dlru != 0) {
                return dlru;
            }
            int dx = t1.x - t2.x;
            if (dx != 0) {
                return dx;
            }
            int dy = t1.y - t2.y;
            if (dy != 0) {
                return dy;
            }
            int dz = t1.z - t2.z;
            return dz;
        }
    };

    public TextureCache(int[] dimensions, CacheSpec spec) {
        assert (dimensions.length == 3);
        this.dimensions = dimensions;
        this.spec = spec;
        int[] tileDimensions = spec.paddedBlockSize();
        this.texWidth = dimensions[0] * tileDimensions[0];
        this.texHeight = dimensions[1] * tileDimensions[1];
        this.texDepth = dimensions[2] * tileDimensions[2];
        int len = (int)Intervals.numElements((int[])dimensions);
        this.tiles = new Tile[len];
        int i = 0;
        for (int x = 0; x < dimensions[0]; ++x) {
            for (int y = 0; y < dimensions[1]; ++y) {
                for (int z = 0; z < dimensions[2]; ++z) {
                    this.tiles[i++] = new Tile(x, y, z);
                }
            }
        }
        for (i = 1; i < len; ++i) {
            this.lruOrdered.add(this.tiles[i]);
        }
        this.numUnblockedTiles = len - 1;
    }

    public CacheSpec spec() {
        return this.spec;
    }

    public int getMaxNumTiles() {
        return this.numUnblockedTiles;
    }

    public Tile get(ImageBlockKey<?> key) {
        return this.tilemap.get(key);
    }

    public int nextTimestamp() {
        return timestampGen.incrementAndGet();
    }

    StagedTasks stage(Collection<? extends FillTask> tasks) {
        int mark = timestampGen.incrementAndGet();
        ArrayList<TileFillTask> tileFillTasks = new ArrayList<TileFillTask>(tasks.size());
        this.initializeBlockedTiles(tileFillTasks);
        ArrayList<TileFillTask> update = new ArrayList<TileFillTask>();
        int newsize = 0;
        for (FillTask fillTask : tasks) {
            Tile tile = this.tilemap.get(fillTask.getKey());
            if (tile == null) {
                tileFillTasks.add(new TileFillTask(fillTask));
                ++newsize;
                continue;
            }
            if (tile.state != ContentState.INCOMPLETE) continue;
            update.add(new TileFillTask(fillTask, tile));
            tile.lru = mark;
        }
        tileFillTasks.addAll(update);
        List<Tile> fillTiles = this.assignFillTiles(newsize, mark);
        return new StagedTasks(tileFillTasks, fillTiles);
    }

    private void initializeBlockedTiles(ArrayList<TileFillTask> tileFillTasks) {
        if (this.blockedTileInitialized) {
            return;
        }
        this.blockedTileInitialized = true;
        Tile oobTile = this.tiles[0];
        Object dummyImage = new Object();
        ImageBlockKey<Object> oobDummyKey = new ImageBlockKey<Object>(dummyImage, new int[]{0, 0, 0});
        int elementsPerTile = (int)Intervals.numElements((int[])this.spec.paddedBlockSize());
        tileFillTasks.add(new TileFillTask(new DefaultFillTask(oobDummyKey, buf -> {
            ByteUtils.setShorts((short)0, buf.getAddress(), elementsPerTile);
            return true;
        }, () -> true), oobTile));
    }

    private List<Tile> assignFillTiles(int size, int currentTimestamp) {
        if (size == 0) {
            return Collections.emptyList();
        }
        this.lruOrdered.sort(lruComparator);
        if (size > this.numUnblockedTiles || this.lruOrdered.get((int)(size - 1)).lru == currentTimestamp) {
            throw new IllegalArgumentException("Requested blocks don't fit into TextureCache.");
        }
        return this.lruOrdered.subList(0, size);
    }

    void assign(Tile tile, ImageBlockKey<?> key, ContentState state) {
        if (!key.equals(tile.content)) {
            if (tile.content != null) {
                this.tilemap.remove(tile.content);
            }
            this.tilemap.put(key, tile);
        }
        tile.content = key;
        tile.state = state;
    }

    public static int[] findSuitableGridSize(CacheSpec cacheSpec, int maxMemoryInMB) {
        long numVoxels = (long)maxMemoryInMB * 1024L * 1024L / (long)cacheSpec.format().getBytesPerElement();
        double sideLength = Math.pow(numVoxels, 0.3333333333333333);
        int[] gridSize = new int[3];
        for (int d = 0; d < 3; ++d) {
            gridSize[d] = (int)(sideLength / (double)cacheSpec.paddedBlockSize()[d]);
        }
        return gridSize;
    }

    @Override
    public Texture.InternalFormat texInternalFormat() {
        return this.spec.format();
    }

    @Override
    public int texWidth() {
        return this.texWidth;
    }

    @Override
    public int texHeight() {
        return this.texHeight;
    }

    @Override
    public int texDepth() {
        return this.texDepth;
    }

    @Override
    public Texture.MinFilter texMinFilter() {
        return Texture.MinFilter.LINEAR;
    }

    @Override
    public Texture.MagFilter texMagFilter() {
        return Texture.MagFilter.LINEAR;
    }

    @Override
    public Texture.Wrap texWrap() {
        return Texture.Wrap.CLAMP_TO_EDGE;
    }

    static class StagedTasks {
        final List<TileFillTask> tasks;
        final List<Tile> reusableTiles;

        public StagedTasks(List<TileFillTask> tasks, List<Tile> reusableTiles) {
            this.tasks = tasks;
            this.reusableTiles = reusableTiles;
        }
    }

    static class TileFillTask
    implements FillTask {
        private final FillTask task;
        private Tile tile;

        public TileFillTask(FillTask task, Tile tile) {
            this.task = task;
            this.tile = tile;
        }

        public TileFillTask(FillTask task) {
            this(task, null);
        }

        @Override
        public ImageBlockKey<?> getKey() {
            return this.task.getKey();
        }

        @Override
        public boolean containsData() {
            return this.task.containsData();
        }

        @Override
        public void fill(UploadBuffer buffer) {
            this.task.fill(buffer);
        }

        Tile getTile() {
            return this.tile;
        }

        void setTile(Tile tile) {
            this.tile = tile;
        }
    }

    public static class Tile {
        final int x;
        final int y;
        final int z;
        ImageBlockKey<?> content;
        ContentState state;
        int lru;

        Tile(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.state = ContentState.INCOMPLETE;
            this.lru = -1;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int z() {
            return this.z;
        }

        public ContentState state() {
            return this.state;
        }

        public void useAtTimestamp(int timestamp) {
            this.lru = timestamp;
        }
    }

    public static enum ContentState {
        INCOMPLETE,
        COMPLETE;

    }
}

